'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_certified_docs.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:12:28 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : Load certified documents and verify the certificate
'*
'*******************************************************************************
'**
' #1 tLoadCertifiedFile ' Load certified documents and verify the certificate
'**
'\******************************************************************************

testcase tLoadCertifiedFile( cBuildID as string )

    '///<H1>Load certified documents and verify the certificate</H1>
    '///This test loads a document which has been signed with a digital 
    '///signature (dummy certificate) and verifies, that the certificate
    '///remains with the document through looking at the "digital signatures"
    '///dialog.
    '///<ul>

    ' Build the path to the file we want to work with 
    dim cFile as string
        cFile = gTesttoolpath & "framework\security\input\DigitalSignature"
        cFile = cFile & hGetSuffix( cBuildId )
        cFile = convertpath( cFile )
        printlog( "Using file: " & cFile )

    ' Variable to store boolean returncodes from functions
    dim brc as boolean
        brc = true

    ' the number of certificates attached to the current document        
    dim iCertCount as integer

    '///<li>Load a file that has been signed with a certificate</li> 
    printlog( "Load the file" )
    brc = hLoadFile( cFile )
    brc = hHandleActivesOnLoad( 0 , 2 )
    
    ' in case the file did not get loaded, handle the problem by aborting the test
    if ( not brc ) then
        warnlog( "The requested file could not be loaded, aborting test" )
        goto endsub
    endif
 
    brc = hOpenDigitalSignaturesDialog() 

    ' If the menuitem should not be available, clicking it will fail. In 
    ' this case we must assume that the file has been loaded but the certificate
    ' does not exist. So we close the document and abort the test here.
    if ( not brc ) then
        warnlog( "The requested menuitem is not available, the test ends" )
        call hCloseDocument()
        goto endsub
    endif
    
    sleep( 2 )
    
    ' second line of defense: If something was opened but this is not the
    ' digital signatures dialog, we abort as well.
    ' If no mozill a profile exists, we don't have the means to verify
    ' certificates, so the test aborts here as well. We get a messagebox then.
    Kontext "DigitalSignature"
    if ( DigitalSignature.exists() )  then
        printlog( "The digital signatures dialog is open, good." )
    else
        Kontext "active"
        if ( active.exists() ) then
            qaerrorlog( "#i48252# Mozilla profile missing?: " & active.getText() )
            active.OK()
        else
            warnlog( "The current dialog is not <Digital Signatures>. Aborting" )
        endif
        call hCloseDocument()
        goto endsub
    endif
    
    '///<li>Verify that exactly one certificate exists</li>
    ' If we have zero or more than one certificate, this is probably a bug
    ' introduced by the test maintainer. However, we warn but the test can
    ' continue
     qaerrorlog( "#i48253# Cannot access EditBrowseBox -> no verification here" )
'    Kontext "DigitalSignature"
'    printlog( CertificateList.getText() )
    
    
'    iCertCount = CertificateList.getItemCount()
'    select case iCertCount
'    case 0 : warnlog( "There is no certificate listed although the office " & _
'                      "thinks there should be one" )
'    case 1 : printlog( "There is one certificate. good" )
'    case else: warnlog( "Some unexpected number of certificates has been found" )
'    end select
    
    '///<li>Close the dialog with OK</li>
    printlog( "Close the dialog with OK" )
    Kontext "DigitalSignature"
    DigitalSignature.OK()
    
    '///<li>Close the document</li>
    printlog( "Close the document" )
    call hCloseDocument()
    
endcase

