'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_recommend_password.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:13:05 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Password settings in Tools/Options
'*
'*******************************************************************************
'**
' #1 tRecommendPassword ' Recommend password protection when saving
'**
'\******************************************************************************

testcase tRecommendPassword( filetypeID as string )

    '///<H1>Recommend password protection when saving</H1>
    '///<p>This test verifies that the global option to recommend password
    '/// protection is transported to the file-save dialog. Before saving
    '/// password protection will be unchecked in order to verify that the
    '/// global option overrides the individual setting.</p>

    dim workfile as string
        workfile = "password" & hGetSuffix( filetypeID )
        printlog( " * Name of workfile: " & workfile )
                                                                                                                               
    dim workpath as string
        workpath = convertpath( gOfficePath & "user\work\" )
        printlog( " * Save file to....: " & workpath )

    dim rc as integer

    '///<ul>
    '///<li>Open a new document</li>
    printlog( "Open a new document" )
    call hNewDocument()

    '///<li>change the content (document modified status)</li>
    printlog( "Change the document" )
    call hChangeDoc()

    '///<li>Open File-Save-dialog</li>
    printlog( "Open filesave" )
    FileSave
    sleep( 2 )
    
    kontext "SpeichernDlg"

    '///<li>Verify that 'Save with password' is enabled</li>
    printlog( "Verify that the password-checkbox is enabled" )
    if ( passwort.isenabled() ) then
        printlog( " * Password checkbox is enabled. Good." )

        if ( passwort.ischecked() ) then
            printlog( " * Password checkbox is checked. Good." )
            rc = 0
        else
            warnlog( "Password checkbox is not checked, the option " & _
                     "has not been transported from tools/options " & _
                     "to the dialog -> bug" )
            rc = 1
        endif
    else
        warnlog( "#i36663# Password checkbox is disabled" )
        rc = 2
    endif

    if ( rc = 0 ) then

        AutomatischeDateinamensErweiterung.uncheck()
                                                                                                                               
        '///<li>name the file and select filter</li>
        printlog( "Name the file" )
        Dateiname.settext( workpath & workfile )
  
        '///<li>uncheck password-protection</li>
        printlog( "Uncheck password-protection" )
        passwort.uncheck()
        sleep( 1 )

        '///<li>save the file</li>
        printlog( "Save the file" )
        Speichern.click()
        sleep( 2 )
                       
        '///<li>handle possoble overwrite-warning</li>                                                                                                        
        Kontext "active"
        if ( active.exists() ) then
            printlog( " - handle overwrite warning (if any)" )
            active.yes()
            sleep( 1 )
        endif
  
        '///<li>handle unexpected password-dialog</li>
        Kontext "passwordDlg"
        if ( passwordDlg.exists() ) then
            warnlog( "Password dialog comes up, this is not expected at this " & _
                     "point. Trying to handle the error gracefully" )
            Password.settext( workfile )
            PasswordConfirm.settext( workfile )
            sleep( 1 )
            PasswordDlg.ok()
        else
            printlog( " * No password dialog is displayed. Good." )
        endif
        sleep( 2 )

        '///<li>Delete the workfile</li>
        hDeleteFile( workpath & workfile )

    endif

    '///<li>close the document</li>
    printlog( "Close the current document" )
    call hCloseDocument()
    
    '///</ul>

endcase
