'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_documentconverter.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2005/12/20 14:25:02 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update test for documentconverter
'*
'*******************************************************************************
'**
' #1 tUpdtDocumentConverter ' Update test for documentconverter
'**
'\******************************************************************************

testcase tUpdtDocumentConverter

    '///<H1>Update test for documentconverter</H1>
    '///<ul>
    dim irc as integer
    dim brc as boolean
    dim iDialog as integer
    dim iDocumentType as integer
    dim iWait as integer
    dim sKeys as string
    dim sSourcePathWriter as string
        sSourcePathWriter = gTesttoolpath & "framework\update\input\docconverter\"
        sSourcePathWriter = convertpath( sSourcePathWriter )
    dim sTargetFile as string
    
    '///+<li>Open the wizard</li>
    irc = hOpenWizardWithMenu( "DOCCONV" )
    if ( irc <> 0 ) then
        warnlog( "Unable to open requested wizard, aborting test" )
        goto endsub
    endif
    
    sTargetFile = hGetWorkPath() & "docconv1" & hGetSuffix( "current" )
    hDeleteFile( sTargetFile )
    
    '///+<li>Page 1 - select all four documenttypes</li>
    Kontext "DocumentConverter"
    printlog( "Page 1" )
    Call DialogTest ( DocumentConverter )
    
    spreadsheet.check()
    textdoc.check()
    drawing.check()
    master.check()
    
    
    ' as we selected all documenttypes, the settings page for each
    ' documenttype has to pop up
    '///+<li>Check all file-open dialogs for all doctypes (4 pages)</li>
    for iDocumentType = 1 to 4
    
        ContinueButton.click()
        
        Kontext "DocumentConverter"
        if ( template.isVisible() ) then
            printlog( "Page " & 1 + iDocumentType & " is visible" )
        else
            warnlog( "Cannot access page 2, aborting test" )
            hFinishWizard()
            goto endsub
        endif
        
        for iDialog = 1 to 4 
        
            select case iDialog
            case 1 : ImportFormTemplatesSearch.click()
            case 2 : SaveToTemplatesSearch.Click()
            case 3 : ImportFormDocumentSearch.Click()
            case 4 : SaveToDocumentSearch.Click()
            end select
            
            Kontext "OeffnenDLG"
            Call Dialogtest (OeffnenDlg)
            OeffnenDLG.Cancel()
            
            '///+<li>Set a source-path for documents</li>
            Kontext "DocumentConverter"
            ImportFormDocument.setText( sSourcePathWriter )
            
        next iDialog
        
    next iDocumentType
    
    '///+<li>Summary page</li>
    Kontext "DocumentConverter"
    ContinueButton.click()
    
    Kontext "DocumentConverter"
    if ( summary.isVisible() ) then
        printlog( "Page 6 is visible" )
    else
        warnlog( "Page 6 - Summary Page is missing" )
    endif
    
    '///+<li>Review the log / check that it is opened (Writer-Doc)</li>
    Kontext "DocumentConverter"
    ContinueButton.click()

    Kontext "DocumentConverter"
    printlog( "Page 7" )
    sleep( 20 )
    
    sKeys = hGetAccel( "DocumentConverter_ShowLog" )
    qaerrorlog( "#i54265# Show Logfile button has no HID, using accelerator instead" )
    DocumentConverter.TypeKeys( sKeys )
    
    sleep( 5 )
    
    brc = hCheckDocCount( 2 , false )
    if ( brc ) then
        brc = hDestroyDocument()
    else
        warnlog( "Expected Result-Document is not open" )
    endif
    
    '///+<li>Shutdown the test, cleanup etc.</li>
    hDeleteFile( sTargetFile )
    
    '///</ul>

endcase

