'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_faxwizard.inc,v $
'*
'*  $Revision: 1.21 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/30 10:21:23 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Fax Wizard
'*
'*******************************************************************************
'**
' #1 tUpdtFaxWizard ' Fax Wizard
'**
'\******************************************************************************

testcase tUpdtFaxWizard

    '///<h1>Update test for the Fax Wizard</h1>
    '///<ul>

    dim iErr as integer
    dim brc as boolean
    
    dim cTemplateName as string
    dim cTemplatePath as string    
    
    ' Build the filename we want to save the template as.
    cTemplateName = "FWK-testtool-faxtemplate.ott"
    cTemplatePath = gOfficePath & "user\template\" & cTemplateName
    cTemplatePath = convertpath( cTemplatePath )   
    
    '///+<li>open the faxwizard using the menu, page design opens</li>
    iErr = hOpenWizardWithMenu( "FAX" )
    if ( iErr = 1 ) then
        warnlog( "#i46909# Wizard crashes/does not open" )
        goto endsub
    endif

    '///+<li>Page 1</li>
    kontext "AutopilotFax"    
    call dialogtest( AutopilotFax )
    hClickNextButton()

    '///+<li>Page 2</li>
    kontext "AutopilotFax"    
    call dialogtest( AutopilotFax )
    hClickNextButton()

    '///+<li>Page 3</li>
    kontext "AutopilotFax"    
    call dialogtest( AutopilotFax )
    hClickNextButton()

    '///+<li>Page 4</li>
    kontext "AutopilotFax"    
    call dialogtest( AutopilotFax )
    hClickNextButton()
    
    '///+<li>Page 5</li>
    kontext "AutopilotFax"
    call dialogtest( AutopilotFax )
    
    '///+<li>Name the template for further usage</li>
    printlog( "Name the template for further usage" )
    TemplateName.setText( cTemplateName )
    
    '///+<li>Save it (Click SaveAS-button)</li>
    hSetTemplateSavePath( cTemplatePath )
    
    '///+<li>click the 'finish' button</li>
    hFinishWizard( 1 )
    sleep( 5 )
   
    '///+<li>close the document</li>     
    brc = hDestroyDocument()
    if ( not brc ) then
        qaerrorlog( "#i59233# The wizard does not display the new template" )
    endif   
    
    '///+<li>Delete the new template</li>
    printlog( "Delete the user-template: " & cTemplatePath )
    hDeleteFile( cTemplatePath )
    
    '///</ul>
    
endcase
