'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_scriptnames.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : Joerg.Skottke@Sun.Com
'*
'*  short description : Verify names of macros and scripts
'*
'*******************************************************************************
'**
' #1 tUpdtScriptNames ' Verify names of macros and scripts
'**
'\******************************************************************************

testcase tUpdtScriptNames

    '///<H1>Update test for macro- and scriptnames</H1>
    '///<ul>

    dim cFile as string
    dim cFileIn as string
    dim cFileOut as string

    dim aItemList( 200 ) as string
    dim aRefList( 200 ) as string

    dim brc as boolean
    dim iCurrentDialog as integer


    '///+<li>Create the name for the reference file, open script organizer</li>
    '///<ol>
    for iCurrentDialog = 1 to 4

        printlog( "" )
        printlog( "Open the Script/Macro organizer" )
        select case iCurrentDialog
        '///+<li>JavaScript Organizer</li>
        case 1 : brc = hOpenScriptOrganizer( 1 )
                 cFile = "javascript_" & iSprache & ".txt"
                 printlog( "Java Script Organizer" )
        '///+<li>Beanshell Organizer</li>
        case 2 : brc = hOpenScriptOrganizer( 2 )
                 cFile = "beanshell_" & iSprache & ".txt"
                 printlog( "Beanshell Script Organizer" )
        '///+<li>Basic Organizer</li>
        case 3 : brc = hOpenBasicOrganizerFromDoc()
                 cFile = "basic_" & iSprache & ".txt"
                 printlog( "Basic Organizer" )
        '///+<li>Run Macro dialog</li>
        case 4 : brc = hOpenRunMacroDialog()
                 cFile = "runmacro_" & iSprache & ".txt" 
                 printlog( "Run Macro dialog" )
        end select
        '///</ol>

        '///+<li>Verify that the script/macro organizer is open</li>
        printlog( "Verify that the dialog is open, else quit" )
        if ( not brc ) then
            warnlog( "Could not open organizer: " & iCurrentDialog )
            exit for
        endif
 
        '///+<li>Get the names of all entries the treelistbox</li>
        printlog( "Get the names of all scripts from the organizer" )
        select case iCurrentDialog
        case 1 : hWaitForTreeList( ScriptTreeList, "ScriptOrganizer", 3 )
    		     hExpandAllNodes( ScriptTreeList ) 
    		     hSelectTopNode( ScriptTreeList )
                 hGetVisibleNodeNames( ScriptTreeList , aItemList() )
                 ScriptOrganizer.cancel()
        case 2 : hWaitForTreeList( ScriptTreeList, "ScriptOrganizer", 3 )
    		     hExpandAllNodes( ScriptTreeList ) 
    		     hSelectTopNode( ScriptTreeList )
                 hGetVisibleNodeNames( ScriptTreeList , aItemList() )
                 ScriptOrganizer.cancel()
        case 3 : Kontext "Makro"
                 hExpandAllNodes( MakroAus )
                 hSelectTopNode( MakroAus )
                 hGetVisibleNodeNames( MakroAus , aItemList() ) 
                 Makro.cancel()
        case 4 : hWaitForTreeList( LibraryTreeList, "ScriptSelector", 3 )
                 hExpandAllNodes( LibraryTreeList )
                 hSelectTopNode( LibraryTreeList )
                 hGetVisibleNodeNames( LibraryTreeList , aItemList() )
                 ScriptSelector.cancel()
        end select

        '///+<li>Add path to filename for both input and output</li>
        printlog( "Build the names of the workfiles: In and Out" )
        cFileIn  = gTesttoolPath & "framework\update\input\scripts\" & cFile
        cFileIn  = convertpath( cFileIn )
        cFileOut = hGetWorkPath() & cFile    
        
        '///+<li>Delete local reference file if it exists</li>
        hDeleteFile( cFileOut )

        '///+<li>Compare the names from the UI with a reference list</li>
        hManageComparisionList( cFileIn, cFileOut, aItemList() )
        
    next iCurrentDialog
    '///</ul>

endcase

