'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_standardbar4.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : invisible items on the standardbar
'*
'*******************************************************************************
'**
' #1 tStandardBar_4 ' invisible items on the standardbar
'**
'\******************************************************************************

testcase tStandardBar_4

    '///<h1>Update test to activate hidden items on StandardBar</h1>
    '///<ul>
    dim brc as boolean
   
    '///+<li>reset the Standardbar to defaults. The toolbar should be docked</li>
    call StandardbarResetNow()
    
    '///<li>Check the number of items for the standarbar using the list in customize toolbars (30)</li>
    hStandardbarItemGetCount()
    
    '///+<li>Load URL: check absence, toggle it, check presence, remove it</li>
    hStandardbarLoadUrl()
    
    '///+<li>New from Template: check absence, toggle it, use it, remove it</li>
    hStandardbarNewDialog()
    
    '///+<li>Save As: check absence, toggle it, use it, remove it</li>
    hStandardbarSaveAs()
    
    '///+<li>Close the document</li>
    brc = hDestroyDocument()
    '///</ul>

        
endcase

'*******************************************************************************

function hStandardbarItemGetCount()

    '///<h3>Update test: Get the number of items in the StandardBar</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    dim iCounter as integer

    '///+<li>open a new writer document</li>
    gApplication = "Writer"
    hCreateDocument()
    
    printlog "Count all items and activate the hidden items:"

    '///+<li>check the number of entries ( must be 30 )</li>
    printlog " - count all items at the Standardbar"

    '///+<li>open the context menu on the Standardbar</li>
    Kontext "Standardbar"
    Standardbar.OpenContextmenu()

    '///+<li>select the 1. entry</li>
    hMenuselectNr( 1 )
    sleep (1)

    '///+<li>count all entries ( there must be 30 entries )</li>
    iCounter = 0
    iCounter = hMenuItemGetCount()
   
    if ( iCounter <> 30 ) then
        warnlog( "Expected: 30 entries at the Standardbar, found: " & iCounter )
    endif

    '///+<li>close the context menu</li>
    hMenuClose()
    sleep (1)
    '///</ul>
    
end function

'*******************************************************************************

function hToggleToolbarItem( iMenuPos as integer )

    '///<h3>Update test: Toggle an icon on the Standardbar (on/off)</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Position of the item in the menu (integer)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    
    dim iItemsInMenu as integer

    '///+<li>Open the context menu of the standard bar</li>
    Kontext "Standardbar"
    Standardbar.OpenContextmenu()
    
    '///+<li>Retrieve the number of items in the menu</li>
    iItemsInMenu = hMenuItemGetCount()
    
    ' in case the toolbar does not fit into the window we have more items
    ' (those that are invisible will be listed as context menu entries),
    ' the menuitem (invisible items) is placed at position nItems - 2
    '///+<li>Take the number of items -2, select the entry</li>
    hMenuselectNr( iItemsInMenu - 2 )
    sleep( 1 )
    
    '///+<li>Select the provided menu position</li>
    hMenuselectNr( iMenuPos )        
    sleep( 1 )
    '///</ul>

end function

'*******************************************************************************

function hStandardbarLoadUrl() as boolean

    '///<h3>Update test: Access the url-entryfield</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    ' this function tries to write to the url-EntryField. This should fail,
    ' because the item is not visible. Then the item should be enabled,
    ' written to and disabled again (no use of reset toolbar here, this is
    ' done in another testcase
    
    dim iItemMenuPos as integer
    iItemMenuPos = 1
    
    printlog( "Load URL" )

    '///+<li>Write to URL-Filed (fails: Entryfiled is not visible)</li>
    try
        Kontext "Standardbar"
        URLEingabe.settext( "Should not work" )
        warnlog( "The Load URL EntryField is visible and active" )
    catch
        printlog( " - The Load URL EntryField is not visible. Good." )
    endcatch
    
    '///+<li>add the control to the standardbar</li>
    printlog( " - activate load URL" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    
    '///+<li>verify its existence by entering some text</li>
    try
        URLEingabe.settext( "Should work" )
        printlog( " - The Load URL REntryFiled is visible and active. Good." )
    catch
        warnlog( "Could not write to 'load url' control" )
    endcatch
        
    '///+<li>remove the control from the standardbar</li>
    printlog( " - deactivate load URL" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    
    '///+<li>try to modify non existing object, failure expected</li>
    try
        Kontext "Standardbar"
        URLEingabe.settext( "Should not work" )
        warnlog( "The Load URL EntryField is visible and active" )
    catch 
        printlog( " - The Load URL EntryField is not visible. Good." )
    endcatch
    '///</ul>
    
end function

'*******************************************************************************

function hStandardbarNewDialog()
    
    '///<h3>Update test: New from Template via StandardBar</h3>
    '///<i>Starting point: Plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    dim iItemMenuPos as integer
    iItemMenuPos = 3

    printlog( "New from Template" )

    '///+<li>Click on &quot;New from Template&quot;-button (fails, it is not visible)</li>
    try
        NeuDialog.Click()
        sleep( 3 )
        warnlog( "The 'New from Template'-button should not be visible by default." )
    catch
        printlog( " - the control is not present or active." )
    endcatch
    
    '///+<li>add the control to the standardbar</li>
    printlog( " - activate New from Template button" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"

    '///+<li>click the button</li>
    NeuDialog.click()    
    
    '///+<li>handle possible dialogs (there should never be one)</li>
    kontext "Active"
    if ( active.exists() ) then
        warnlog( "Unexpected active" )
        printlog( active.gettext() )
        try
            printlog( "Closing dialog" )
            active.ok()
        catch
        endcatch
    endif

    '///+<li>close the templates and samples dialog</li>
    printlog( " - close templates and samples (cancel)" )
    Kontext "TemplateAndDocuments"
    if ( TemplateAndDocuments.Exists( 5 ) ) then
        TemplateAndDocuments.cancel()
    else
        warnlog( "The 'Template and Documents'-dialog was not activated" )
    endif
   
    '///+<li>finally remove the button from the toolbar</li>
    printlog( " - deactivate New from Template button" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    '///</ul>
    
end function

'*******************************************************************************

function hStandardbarSaveAs()

    '///<h3>Update test: SaveAs button on StandardBar</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>


    dim bBreakOnError as boolean
    dim iItemMenuPos as integer
    iItemMenuPos = 6


    printlog( "Save As" )


    '///+<li>Click on SaveAs (fails, item is not visible)</li>
    try
        SpeichernAls.Click()
        sleep( 3 )
        warnlog( "#i46363# (?)The 'SaveAs'-button should be invisible but is displayed" )
        sleep( 2 )
        kontext "SpeichernDlg"
        SpeichernDlg.cancel()
        bBreakOnError = true
    catch
        printlog( " - the control is not present or active." )
        bBreakOnError = false
    endcatch
    
    if ( not bBreakOnError ) then
    
        '///+<li>Add the control to the standardbar</li>
        printlog( " - activate 'Save As' button" )
        hToggleToolbarItem( iItemMenuPos )
        Kontext "Standardbar"

        '///+<li>Click the button</li>
        SpeichernAls.click()    
    
        '///+<li>Close the save-as dialog</li>
        printlog( " - close Save As (cancel)" )
        Kontext "SpeichernDlg"
        if ( SpeichernDlg.Exists( 5 ) ) then
            SpeichernDlg.cancel()
        else
            warnlog( "The 'Save As'-dialog was not activated" )
        endif
        
    endif
   
    '///+<li>Remove the button from the toolbar</li>
    printlog( " - deactivate 'Save as' button" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    '///</ul>
    
end function    
