'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_clipexport3.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:20:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description : Procedures for the Clipboard-Export-Test
'*
'*******************************************************************
'*
' #1 Get_Position_Size_Attributes
' #1 Get_Colour_Attributes
' #1 Check_Position_Size_Attributes
' #1 Check_Colors_Borders_Attributes
' #1 SetKontextApplication
' #1 New_Draw
' #1 New_Impress
' #1 New_Calc
' #1 New_Writer
' #1 Choose_Toapplication
'*
'\*******************************************************************

Sub Get_Position_Size_Attributes
Printlog "Get_Position_Size_Attributes Starts"

'/// Bring up the attributes for the object we just created ///'
   FormatPositionAndSize

'/// Get and save the attributes ///'
   sleep 1
   Kontext
   active.SetPage TabPositionAndSize
   sleep 1

'/// Position-values ///'
   Kontext "TabPositionAndSize"

' /// Size-values ///'
   PositionWidth = Width.GetText
   PositionHeight = Height.GetText

   if KeepRatio.IsChecked then SetText.PositionKeepRatio = "TRUE"
   if ProtectPosition.IsChecked then SetText.PositionProtectPosition = "TRUE"
   if ProtectSize.IsChecked then SetText.PositionProtectSize = "TRUE"
      sleep 1

'/// Switch back to tabpage 'Position' to avoid problems later ///'
   Kontext "TabPositionAndSize"
   Kontext
   Active.setpage TabPositionAndSize
   Kontext "TabPositionAndSize"

'/// Close dialog TabPositionAndSize with 'OK' ///'
   TabPositionAndSize.OK
sleep 1
SetKontextApplication
sleep 3
Printlog "Get_Position_Size_Attributes Ends"
end sub


sub Get_Colour_Attributes
printlog "Get_Colour_Attributes Starts"

'/// Open Format-Area and get the values considering colors and borders ///'
   FormatArea
      Kontext "TabArea"
      Kontext
      Active.setpage TabArea
      Kontext "TabArea"


' /// Area ///'
FillOptions.Select 2
if FillOptions.GetSelIndex <> 2 then Errorlog "Couldnt click on 'Color' in FormatArea"
   AreaColourListValue = ColourList.GetSelText
   printlog "AreaColourListValue = " + AreaColourListValue
sleep 1

'/// Gradient ///'
FillOptions.Select 3
if FillOptions.GetSelIndex <> 3 then Errorlog "Couldnt click on .Gradient. in FormatArea"

   AreaGradientListValue = GradientList.GetSelText    'AreaGradientValue = "TRUE"
   If Automatic.IsVisible then
      If Automatic.IsChecked then AreaAutomaticValue = "TRUE"
   Else
      If Increments.IsVisible then
         AreaIncrementsValue = Increments.GetText
      End if
   End if

'/// Hatching ///'
FillOptions.Select 4
if FillOptions.GetSelIndex <> 4 then Errorlog "Couldnt click on 'Hatching' in FormatArea"

   AreaHatchingListValue = HatchingList.GetSelText 'Then  = "TRUE"  ' lista
   If BackgroundColour.IsVisible then
      If BackgroundColour.IsChecked then
         AreaBackgroundColourValue = BackgroundColour.GetText
      End if
   End if
   If BackgroundColourList.IsVisible then
      AreaBackgroundColourListValue = BackgroundColourList.GetSelText
   End if

'/// Increments ///'
FillOptions.Select 5
if FillOptions.GetSelIndex <> 5 then Errorlog "Couldnt click on 'Hatching' in FormatArea"

      AreaBitmapListValue = BitmapList.GetSelText

   If Original.IsChecked then
      AreaOriginalListValue = "TRUE"
   Else
      If Relative.IsChecked then
         AreaRelativeValue = "TRUE"
         AreaWidthValue = Width.GetText
         AreaHeightValue = Height.GetText
      Else
         AreaWidthValue = Width.GetText
         AreaHeightValue = Height.GetText
      End if
   End if

   If Tile.IsChecked then AreaTileValue = "TRUE"
   If Stretch.IsChecked then AreaStretchValue = "TRUE"
   If Row.IsChecked then
      AreaRowValue = "TRUE"
      AreaOffsetValue = Offset.GetText
   End if
   If Column.IsChecked then
      AreaColumnValue = "TRUE"
      AreaOffsetValue = Offset.GetText
   End if

sleep 1


'/// Shadow ///'
   Kontext "TabArea"
   Kontext
   Active.setpage TabSchatten
   Kontext "TabSchatten"

   If Anzeigen.IsChecked then
      ShadowUseShadowsValue = "TRUE"
      ShadowDistanceValue = Entfernung.GetText
      ShadowColorValue = Farbe.GetText
      ShadowTransparencyValue = Transparenz.GetText
   end if

sleep 1


'/// Transparency ///'
   Kontext
      Active.SetPage TabTransparenz
   Kontext "TabTransparenz"
if KeineTransparenz.IsEnabled = FALSE then
   Errorlog "Couldnt check 'No transparency' in Area - Transparency'"
else
   KeineTransparenz.Check
end if

   If KeineTransparenz.IsChecked then LineareTransparenz.Check
   If LineareTransparenz.IsChecked then
      TransparencyTransparencyValue = MFLinTransparenz.GetText
   End if


'/// Gradient ///'
Transparenzverlauf.Check
   If Transparenzverlauf.IsChecked then
      TransparencyGradientType = TransparenzverlaufTyp.GetItemText
      TransparencyMFZentrumX = MFZentrumX.GetText
      TransparencyMFZentrumY = MFZentrumY.GetText
      TransparencyMFWinkel = MFWinkel.GetText
      TransparencyMFRand = MFRand.GetText
      TransparencyMFStartwert = MFStartwert.GetText
      TransparencyMFEndwert = MFEndwert.GetText
   End if

sleep 1


'/// Colors ///'
   Kontext
      Active.setpage TabFarben
   Kontext "TabFarben"

   ColorName = FarbName.GetText
   ColorColor = Farbe.GetItemText
   ColorModel = Farbmodell.GetSelText
   printlog "The colormodel is: " + ColorModel
   If ColorModel = "RGB" then
      ColorR = R.GetText
      ColorG = G.GetText
      ColorB = B.GetText
   Else
      ColorC = C.GetText
      ColorM = M.GetText
      ColorY = Y.GetText
      ColorK = K.GetText
   End if


'/// TabFarbverlaeufe ///'
   Kontext
   Active.setpage TabFarbverlaeufe
   Kontext "TabFarbverlaeufe"

GradientsType = Typ.GetItemText
GradientsCenterX = ZentrumX.GetText
GradientsCenterZ = ZentrumY.GetText
GradientsAngle = Winkel.GetText
GradientsBorder = Rand.GetText
GradientsFromColor = Von.GetItemText
GradientsFromValue = VonWert.GetText
GradientsToColor = Bis.GetItemText
GradientsToValue = BisWert.GetText


'/// Hatching ///'
   Kontext
   Active.setpage TabSchraffuren
   Kontext "TabSchraffuren"

HatchingDistance = Abstand.GetText
HatchingAngle = Winkel.GetText
'Definition
HatchingLineType = Linientyp.GetSelText
HatchingLineColor = Linienfarbe.GetSelText
HatchingLineTable = Tabelle.GetItemText


'/// TabBitmap ///'
   Kontext
   Active.setpage TabBitmap
   Kontext "TabBitmap"

BitmapForeground = Vordergrund.GetSelText
BitmapBackground = Hintergrund.GetSelText
BitmapTable = Tabelle.GetSelText

   Kontext
      Active.setpage TabArea
   Kontext "TabArea"
   TabArea.Cancel
printlog "Get_Colour_Attributes ends"
end sub


sub Check_Position_Size_Attributes
printlog "Check_Position_Size_Attributes Starts"

'/// Paste object with EditPaste ///'
sleep 1
   EditPaste
sleep 3

'/// Bring up the attributes for the object we just created ///'
FormatPositionAndSize

'/// Get and save the attributes ///'
   sleep 1
     if gApplication = "WRITER" then
        Kontext "TabPositionAndSizeWriter"
        Kontext
      active.SetPage TabPositionAndSizeWriter
      Kontext
      active.SetPage TabPositionAndSizeWriter
      Kontext "TabPositionAndSizeWriter"
     sleep 1

   '/// Position-values ///'

   '/// Size-values ///'
     If PositionWidth <> Width.GetText then Warnlog "PositionWidth is: " + Width.GetText + " should be: " + PositionWidth
     If PositionHeight <> Height.GetText then Warnlog "PositionHeight is: " + Height.GetText + " should be: " + PositionHeight

     If PositionKeepRatio = "TRUE" then
        If KeepRatio.IsChecked = "FALSE" then Warnlog "KeepRatio isnt checked"
     End if

     If PositionProtectPosition = "TRUE" then
        If ProtectPosition.IsChecked = "FALSE" then Warnlog "ProtectPosition isnt checked"
     End if

     If PositionProtectSize = "TRUE" then
        If ProtectSize.IsChecked = "FALSE" then Warnlog "ProtectPosition isnt checked"
     End if
      sleep 1

   '/// Switch back to tabpage 'Position' to avoid problems later ///'
     Kontext "TabPositionAndSizeWriter"
       Kontext
          Active.setpage TabPositionAndSizeWriter
          Kontext "TabPositionAndSizeWriter"

'/// Close dialog TabPositionAndSize with 'OK' ///'
      TabPositionAndSizeWriter.OK

     else
      Kontext
      active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
     sleep 1

   '/// Position-values ///'

   '/// Size-values ///'
     If PositionWidth <> Width.GetText then Warnlog "PositionWidth is: " + Width.GetText + " should be: " + PositionWidth
     If PositionHeight <> Height.GetText then Warnlog "PositionHeight is: " + Height.GetText + " should be: " + PositionHeight

     If PositionKeepRatio = "TRUE" then
        If KeepRatio.IsChecked = "FALSE" then Warnlog "KeepRatio isnt checked"
     End if

     If PositionProtectPosition = "TRUE" then
        If ProtectPosition.IsChecked = "FALSE" then Warnlog "ProtectPosition isnt checked"
     End if

     If PositionProtectSize = "TRUE" then
        If ProtectSize.IsChecked = "FALSE" then Warnlog "ProtectPosition isnt checked"
     End if
      sleep 1

   '/// Switch back to tabpage 'Position' to avoid problems later ///'
     Kontext "TabPositionAndSize"
       Kontext
          Active.setpage TabPositionAndSize
          Kontext "TabPositionAndSize"

'/// Close dialog TabPositionAndSize with 'OK' ///'
      TabPositionAndSize.OK
     endif

SetKontextApplication
sleep 3
printlog "Check_Position_Size_Attributes Ends"
end sub

sub Check_Colors_Borders_Attributes
printlog "Check_Colors_Borders_Attributes Starts"

'/// Open Format-Area and get the values considering colors and borders ///'
FormatArea

   Kontext "TabArea"
   Kontext
   Active.setpage TabArea
   Kontext "TabArea"

' /// Area ///'
FillOptions.Select 2
if FillOptions.GetSelIndex <> 2 then Errorlog "Couldnt click on 'Color' in FormatArea"

      If AreaColourListValue <> ColourList.GetSelText then
         WarnLog "Area ColourList doesn't have the right Colour selected."
         printlog "AreaColourListValue = " + AreaColourListValue + " should be = " + ColourList.GetSelText
      end if

sleep 1

'/// Gradient ///'
FillOptions.Select 3
if FillOptions.GetSelIndex <> 3 then Errorlog "Couldnt click on 'Gradient.' in FormatArea"

      If AreaGradientListValue <> GradientList.GetSelText then WarnLog "Area GradientList has changed it's value."
      If Automatic.IsVisible then
         If AreaAutomaticValue = "TRUE" then
            If Automatic.IsChecked then
               Printlog "Area Automatic Value is correct"
            Else
               WarnLog "Area Automatic Value wasnt checked. It should have been."
            End if
         End if
      Else
         If Increments.IsVisible then
            If AreaIncrementsValue <> Increments.GetText then WarnLog "Area Increments has changed."
         End if
      End if

'/// Hatching ///'
FillOptions.Select 4
if FillOptions.GetSelIndex <> 4 then Errorlog "Couldnt click on 'Hatching' in FormatArea"

   If AreaHatchingListValue <> HatchingList.GetSelText then Errorlog "Area HatchingList has changed it's value."
   If BackgroundColour.IsVisible then
      If BackgroundColour.IsChecked then
         If AreaBackgroundColourValue <> BackgroundColour.GetText then Errorlog "Area Background Color has changed it's value."
      end if
   end if
   If BackgroundColourList.IsVisible then
      If AreaBackgroundColourListValue <> BackgroundColourList.GetSelText then Errorlog "Area Background ColourList has changed it's value."
   End if

'/// Increments ///'
FillOptions.Select 5
if FillOptions.GetSelIndex <> 5 then Errorlog "Couldnt click on 'Color' in FormatArea"

   If BitmapList.IsVisible then
      If AreaBitmapListValue <> BitmapList.GetSelText then Errorlog "Area Bitmap List has changed it's value."
   else
      Errorlog "No Area-Bitmap-List visible!"
   end if
   If Original.IsChecked = "TRUE" then
      If AreaOriginalListValue <> "TRUE" then Errorlog "Original List has changed it's value."
   Else
      If Relative.IsChecked = "TRUE" then
         If AreaRelativeValue <> "TRUE" then Errorlog "Area Relative has changed it's value." = "TRUE"
         If AreaWidthValue <> Width.GetText then Errorlog "AreaWidthValue has changed."
         If AreaHeightValue <> Height.GetText then Errorlog "AreaHeightValue has changed."
      Else
         If AreaWidthValue <> Width.GetText then Errorlog "AreaWidthValue has changed."
         If AreaHeightValue <> Height.GetText then Errorlog "AreaHeightValue has changed."
      End if
   End if

   If Tile.IsChecked then
      If AreaTileValue <> "TRUE" then Errorlog "AreaTileValue has changed."
   End if

   If Stretch.IsChecked then
      If AreaStretchValue <> "TRUE" then Errorlog "AreaStretchValue has changed."
   End if

   If Row.IsChecked then
      If AreaRowValue <> "TRUE" then Errorlog "AreRowValue has changed."
      If AreaOffsetValue <> Offset.GetText then Errorlog "AreaOffsetValue has changed."
   End if

   If Column.IsChecked then
      If AreaColumnValue <> "TRUE" then Errorlog "AreaColumnValue has changed."
      If AreaOffsetValue <> Offset.GetText then Errorlog "AreaOffsetValue has changed."
   End if

sleep 1

'/// Tabpage: Shadow ///'
   Kontext "TabArea"
   Kontext
   Active.setpage TabSchatten
   Kontext "TabSchatten"

If Anzeigen.IsChecked then
   ShadowUseShadowsValue = "TRUE"
   ShadowDistanceValue = Entfernung.GetText
   ShadowColorValue = Farbe.GetText
   ShadowTransparencyValue = Transparenz.GetText
end if

sleep 1

'/// Tab-page: Transparency ///'
    Kontext
       Active.SetPage TabTransparenz
    Kontext "TabTransparenz"

       if KeineTransparenz.IsEnabled = FALSE then
          Errorlog "Couldnt check 'No transparency' in Area - Transparency'"
       else
          KeineTransparenz.Check
       end if

    If KeineTransparenz.IsChecked then LineareTransparenz.Check
    If LineareTransparenz.IsChecked then
       TransparencyTransparencyValue = MFLinTransparenz.GetText
    end if

'/// Gradient ///'
Transparenzverlauf.Check
   If Transparenzverlauf.IsChecked then
      TransparencyGradientType = TransparenzverlaufTyp.GetItemText
      TransparencyMFZentrumX = MFZentrumX.GetText
      TransparencyMFZentrumY = MFZentrumY.GetText
      TransparencyMFWinkel = MFWinkel.GetText
      TransparencyMFRand = MFRand.GetText
      TransparencyMFStartwert = MFStartwert.GetText
      TransparencyMFEndwert = MFEndwert.GetText
   end if

sleep 1

'/// Colors ///'
    Kontext
       Active.setpage TabFarben
    Kontext "TabFarben"
       ColorName = FarbName.GetText
       ColorColor = Farbe.GetItemText
       ColorModel = Farbmodell.GetSelText
    printlog ColorModel
       If ColorModel = "RGB" then
          ColorR = R.GetText
          ColorG = G.GetText
          ColorB = B.GetText
       Else
          ColorC = C.GetText
          ColorM = M.GetText
          ColorY = Y.GetText
          ColorK = K.GetText
       End if

'/// Tab-Page: Colors ///'
   Kontext
      Active.setpage TabFarbverlaeufe
   Kontext "TabFarbverlaeufe"

GradientsType = Typ.GetItemText
GradientsCenterX = ZentrumX.GetText
GradientsCenterZ = ZentrumY.GetText
GradientsAngle = Winkel.GetText
GradientsBorder = Rand.GetText
GradientsFromColor = Von.GetItemText
GradientsFromValue = VonWert.GetText
GradientsToColor = Bis.GetItemText
GradientsToValue = BisWert.GetText

'/// Hatching ///'
   Kontext
      Active.setpage TabSchraffuren
   Kontext "TabSchraffuren"

HatchingDistance = Abstand.GetText
HatchingAngle = Winkel.GetText
'Definition
HatchingLineType = Linientyp.GetSelText
HatchingLineColor = Linienfarbe.GetSelText
HatchingLineTable = Tabelle.GetItemText

'/// TabBitmap ///'
   Kontext
      Active.setpage TabBitmap
   Kontext "TabBitmap"

BitmapForeground = Vordergrund.GetSelText
BitmapBackground = Hintergrund.GetSelText
BitmapTable = Tabelle.GetSelText

'/// Close the TabArea-window ///'
   Kontext
      Active.setpage TabArea
   Kontext "TabArea"
      TabArea.Cancel

'/// Set kontext to the application ///'
   SetKontextApplication

printlog "Check_Colors_Borders_Attributes Ends"

Printlog "End of one application"

end Sub              '/// Here ends the Sub "Check_Colors_Borders_Attributes" ///'

'---- Set the Kontext to the current Application ----'

sub SetKontextApplication
sleep 1
   Select Case gApplication
      Case "DRAW"
         Kontext "DocumentDraw"
'         Printlog "gApplication / Kontext is now: DocumentDraw"
         sleep 1
      Case "IMPRESS"
         Kontext "DocumentImpress"
'         Printlog "gApplication / Kontext is now is now: DocumentImpress"
         sleep 1
      Case "WRITER"
         Kontext "DocumentWriter"
'         Printlog "gApplication / Kontext is now is now: DocumentWriter"
         sleep 1
      Case "CALC"
         Kontext "DocumentCalc"
'         Printlog "gApplication / Kontext is now is now: DocumentCalc"
         sleep 1
   end select
sleep 1
end sub

'---- Part with "create new windows" ----'

sub New_Draw
     printlog "Copied object from application: " + FromApp2  '/// Since the first application is Draw by default, we'll skip that one. ///'
     gApplication = "DRAW"
     ToApp = "DRAW"
     printlog "to app has changed to: " + gApplication
     Call hNewDocument
     SetKontextApplication
end sub

sub New_Impress
     printlog "Copied object from application: " + FromApp2
     gApplication = "IMPRESS"
     ToApp = "IMPRESS"
     printlog "to app has changed to: " + gApplication
     Call hNewDocument
     SetKontextApplication
end sub

sub New_Calc
     printlog "Copied object from application: " + FromApp2
     gApplication = "CALC"
     ToApp = "CALC"
     printlog "to app has changed to: " + gApplication
     Call hNewDocument
     SetKontextApplication
end sub

sub New_Writer
     printlog "Copied object from application: " + FromApp2
     gApplication = "WRITER"
     ToApp = "WRITER"
     printlog "to app has changed to: " + gApplication
     Call hNewDocument
     SetKontextApplication
end sub



sub Choose_Toapplication

'/// Close the application / switch to the next ///'
For ToAppCounter = 1 to 4				   '/// Writer not included due to bug: 116372 ///'

   Select case ToAppCounter
        case "1"   :   Call hCloseDocument
                       printlog "to app: " + gApplication  '/// Since the first applicatoin is Draw by default, we'll skip that one. ///'
                       ToApp = "DRAW"
        case "2"   :   Call hCloseDocument
                       gApplication = "IMPRESS"
                       printlog "to app: " + gApplication
                       ToApp = "IMPRESS"
        case "3"   :   Call hCloseDocument
                       gApplication = "CALC"
                       printlog "to app: " + gApplication
                       ToApp = "CALC"
        case "4"   :   Call hCloseDocument
                       gApplication = "WRITER"
                       printlog "to app: " + gApplication
                       ToApp = "WRITER"
        case else  :   exit sub
   End select
next ToAppCounter
'/// Open second application ///'
    Call hNewDocument
SetKontextApplication
end sub

