'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_german_spell_check2.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:20:15 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Spellcheck for some new German words II
'*
'************************************************************************
'*
' #1 tGermanSpellCheck_11
' #1 tGermanSpellCheck_12
' #1 tGermanSpellCheck_13
' #1 tGermanSpellCheck_14
' #1 tGermanSpellCheck_15
' #1 tGermanSpellCheck_16
' #1 tGermanSpellCheck_17
' #1 tGermanSpellCheck_18
' #1 tGermanSpellCheck_19
' #1 tGermanSpellCheck_20
'*
'\***********************************************************************

sub w_german_spell_check_2

'///   This case is based on -- "
'///   http://staroffice-doc.germany.sun.com:8080/Teams/QA/Test_Plans/Writer/tools
'///      --- new_german_spelling.vor
   printLog Chr(13) + "- Tools/Spellcheck/check for some new German words"
      Call tGermanSpellCheck_11        'Tools/Spellcheck/check  for some new German words Page 11
      Call tGermanSpellCheck_12        'Tools/Spellcheck/check  for some new German words Page 12
      Call tGermanSpellCheck_13        'Tools/Spellcheck/check  for some new German words Page 13
      Call tGermanSpellCheck_14        'Tools/Spellcheck/check  for some new German words Page 14
      Call tGermanSpellCheck_15        'Tools/Spellcheck/check  for some new German words Page 15
      Call tGermanSpellCheck_16        'Tools/Spellcheck/check  for some new German words Page 16
      Call tGermanSpellCheck_17        'Tools/Spellcheck/check  for some new German words Page 17
      Call tGermanSpellCheck_18        'Tools/Spellcheck/check  for some new German words Page 18
      Call tGermanSpellCheck_19        'Tools/Spellcheck/check  for some new German words Page 19
      Call tGermanSpellCheck_20        'Tools/Spellcheck/check  for some new German words Page 20
end sub

' *******************************************************************

testcase tGermanSpellCheck_11

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling11.stw"
  
  aCheckedWord = Array( _
                        "heißbegehrt" , "heißgeliebt" , "heißumkämpft" , "helleuchtend" , _
                        "hellicht" , "hellila" , "hellodernd" , "heransein" , _
                        "heraussein" , "herbstlichgelb" , "Heringsfaß" , "hersein" , _
                        "herumsein" , "heruntersein" , "Herzas" , "herzlichste" , _
                        "abend" , "mittag" , "nacht" , "Hexenschuß" , _
                        "hierbleiben" , "hierlassen" , "hiersein" , "hierzulande" , _
                        "High-Fidelity" , "High-Fidelity" , "High-Society" , "High-Society" , _
                        "hilfesuchend" , "hinaussein" , "hineingeheimnißt" , "hinsein" , _
                        "hintereinanderfahren" , "hintereinandergehen" , "hintereinanderschalten" , "hinterhersein" , _
                        "hinübersein" , "hißt" , "Hochgenuß" , "Hochschulabschluß" , _
                        "höchste" , "hofhalten" , "Hohe" , "hohnlachen" , _
                        "holzverarbeitende" , "Hosteß" , "Hot dog" , "Hot dog" , _
                        "hundert" , "Hunderte" , "Hunderte" , "Hungers" , _
                        "hurra" , "Ihr" , "allgemeinen" , "besonderen" , _
                        "Imbiß" , "Imbißstand" , "Imbißstand" , "einzelnen" , _
                        "nachhinein" , "Impfpaß" , "imstande" , "übrigen" , _
                        "voraus" , _
                        )

  aCorrectWord = Array( _
                        "heiß begehrt" , "heiß geliebt" , "heiß umkämpft" , "hell leuchtend" , _
                        "helllicht" , "helllila" , "hell lodernd" , "heran sein" , _
                        "heraus sein" , "herbstlich gelb" , "Heringsfass" , "her sein" , _
                        "herum sein" , "herunter sein" , "Herzass" , "Herzlichste" , _
                        "Abend" , "Mittag" , "Nacht" , "Hexenschuss" , _
                        "hier bleiben" , "hier lassen" , "hier sein" , "hier zu Lande" , _
                        "Highfidelity" , "High Fidelity" , "Highsociety" , "High Society" , _
                        "Hilfe suchend" , "hinaus sein" , "hineingeheimnisst" , "hin sein" , _
                        "hintereinander fahren" , "hintereinander gehen" , "hintereinander schalten" , "hinterher sein" , _
                        "hinüber sein" , "hisst" , "Hochgenuss" , "Hochschulabschluss" , _
                        "Höchste" , "Hof halten" , "hohe" , "Hohn lachen" , _
                        "Holz verarbeitende" , "Hostess" , "Hotdog" , "Hot Dog" , _
                        "Hundert" , "hunderte" , "hunderte" , "hungers" , _
                        "Hurra" , "ihr" , "Allgemeinen" , "Besonderen" , _
                        "Imbiss" , "Imbissstand" , "Imbiss-Stand" , "Einzelnen" , _
                        "Nachhinein" , "Impfpass" , "im Stande" , "Übrigen" , _
                        "Voraus" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words -- Page 11"
  '/// Tools/Spellcheck/check  for some new German words -- Page 11
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_12

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling12.stw"
  
  aCheckedWord = Array( _
                       "vorhinein" , "betreff" , "bezug" , "Indizes" , _
                       "Indizienprozeß" , "ineinanderfließen" , "ineinandergreifen" , "inessentiell" , _
                       "Informationsfluß" , "in Frage" , "in Frage" , "innesein" , _
                       "insektenfressende" , "instand" , "instand" , "I-Punkt" , _
                       "irgend etwas" , "irgend jemand" , "I-Tüpfelchen" , "ja" , _
                       "Jagdschloß" , "Jäheit" , "Jahresabschluß" , "2jährig" , _
                       "2jähriger" , "Jaß" , "du jaßt" , "Jauchefaß" , _
                       "jedesmal" , "Job-sharing" , "Joghurt" , "Joint-venture" , _
                       "Joint-venture" , "Judaskuß" , "Julierpaß" , "Jumbo-Jet" , _
                       "alt" , "Kabelanschluß" , "Kabinettsbeschluß" , "Kaffee-Ernte" , _
                       "Kaffee-Ersatz" , "Kalligraphie" , "kalorienbewußt" , "kaltlächelnd" , _
                       "Kameraverschluß" , "Kammacher" , "Kammacher" , "Kämmaschine" , _
                       "Kämmaschine" , "Kammuschel" , "Kammuschel" , "Känguruh" , _
                       "Kanonenschuß" , "Kapselriß" , "Karamel" , "karamelisieren" , _
                       "2karäter" , "2karätig" , "Karoas" , "Kartographie" , _
                       "Kaßler" , "Katarrh" , "kegelschieben" , _
                       )

                        
  aCorrectWord = Array( _
                       "Vorhinein" , "Betreff" , "Bezug" , "Indices" , _
                       "Indizienprozess" , "ineinander fließen" ,"ineinander greifen" ,"inessenziell" , _
                       "Informationsfluss" , "infrage" , "infrage" , "inne sein" , _
                       "Insekten fressende" ,"in Stand" , "in Stand" , "i-Punkt" , _
                       "irgendetwas" , "irgendjemand" , "i-Tüpfelchen" , "Ja" , _
                       "Jagdschloss" , "Jähheit" , "Jahresabschluss" , "2-jährig" , _
                       "2-Jähriger" , "Jass" , "du jasst" , "Jauchefass" , _
                       "jedes Mal" , "Jobsharing" , "Jogurt" , "Jointventure" , _
                       "Joint Venture" , "Judaskuss" , "Julierpass" , "Jumbojet" , _
                       "Alt" , "Kabelanschluss" , "Kabinettsbeschluss" ,"Kaffeeernte" , _
                       "Kaffeeersatz" , "Kalligra" , "kalorien", "kalt lächelnd" , _
                       "Kameraverschluss" , "Kammmacher" , "Kamm-Macher" , "Kämmmaschine" , _
                       "Kämm-Maschine" , "Kammmuschel" , "Kamm-Muschel" , "Känguru" , _
                       "Kanonenschuss" , "Kapselriss" , "Karamell" , "karamellisieren" , _
                       "2-Karäter" , "2-karätig" , "Karoass" , "Kartografie" , _
                       "Kassler" , "Katarr" , "Kegel schieben" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 12"
  '/// Tools/Spellcheck/check  for some new German words - page 12
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_13

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
    
  sFileName = "new_german_spelling13.stw"

  aCheckedWord = Array( _
                        "Kellergeschoß" , "kennenlernen" , "Kennummer" , "Kennummer" , _
                        "Keplerschen" , "Keplerschen" , "keß" , "Keßheit" , _
                        "Ketchup" , "Kickdown" , "Kick-off" , "Statt" , _
                        "Kindesmißhandlung" , "Kißchen" , "klaren" , "klardenkend" , _
                        "klarsehen" , "klarwerden" , "Klassenbewußtsein" , "Klassenhaß" , _
                        "klatschnaß" , "Klausenpaß" , "klebenbleiben" , "Klee-Einsaat" , _
                        "Klee-Ernte" , "kleinste" , "kleinen" , "groß" , _
                        "klein" , "kleingedruckt" , "kleinschneiden" , "klein schreiben" , _
                        "Klemmappe" , "Klemmappe" , "Klettverschluß" , "klitschnaß" , _
                        "klügste" , "knapphalten" , "Knockout" , "kochendheiß" , _
                        "kohleführende" , "Kolanuß" , "Kollektivbewußtsein" , "Kolophonium" , _
                        "Koloß" , "Kombinationsschloß" , "Kommiß" , "Kommißbrot" , _
                        "Kommißstiefel" , "Kommißstiefel" , "Kommuniqué" , "Kompaß" , _
                        "kompreß" , "Kompromiß" , "kompromißbereit" , "kompromißlos" , _
                        "Kompromißlösung" , "Komteß" , "Konferenzbeschluß" , "Kongreß" , _
                        "Kongreßhalle" , "Kongreßsaal" , "Kongreßsaal" , "Kongreßstadt" , _
                        "Kongreßstadt" , _
                       )
                        
  aCorrectWord = Array( _
                        "Kellergeschoss" , "kennen lernen" , "Kennnummer" , "Kenn-Nummer" , _
                        "keplerschen" , "Kepler'schen" , "kess" , "Kessheit" , _
                        "Ketschup" , "Kick-down" , "Kickoff" , "statt" , _
                        "Kindesmisshandlung" , "Kisschen" , "Klaren" , "klar denkend" , _
                        "klar sehen" , "klar werden" , "Klassenbewusstsein" , "Klassenhass" , _
                        "klatschnass" , "Klausenpass" , "kleben bleiben" , "Kleeeinsaat" , _
                        "Kleeernte" , "Kleinste" , "Kleinen" , "Groß" , _
                        "Klein" , "klein gedruckt" , "klein schneiden" , "kleinschreiben" , _
                        "Klemmmappe" , "Klemm-Mappe" , "Klettverschluss" , "klitschnass" , _
                        "Klügste" , "knapp halten" , "Knock-out" , "kochend heiß" , _
                        "Kohle führende" , "Kolanuss" , "Kollektivbewusstsein" , "Kolofonium" , _
                        "Koloss" , "Kombinationsschloss" , "Kommiss" , "Kommissbrot" , _
                        "Kommissstiefel" , "Kommiss-Stiefel" , "Kommunikee" , "Kompass" , _
                        "kompress" , "Kompromiss" , "kompromissbereit" , "kompromisslos" , _
                        "Kompromisslösung" , "Komtess" , "Konferenzbeschluss" , "Kongress" , _
                        "Kongresshalle" , "Kongresssaal" , "Kongress-Saal" , "Kongressstadt" , _
                        "Kongress-Stadt" ,  _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 13"
  '/// Tools/Spellcheck/check  for some new German words - page 13
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_14

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling14.stw"
  
  aCheckedWord = Array( _
                        "Königsschloß" , "Kontrabaß" , "Kontrollampe" , "Kontrollampe" , _
                        "Kontrolliste" , "Kontrolliste" , "Kopfnuß" , "Kopfschuß" , _
                        "kopfstehen" , "Koppelschloß" , "krank schreiben" , "kraß" , _
                        "Kraßheit" , "krebserregende" , "Kreiselkompaß" , "Kreppapier" , _
                        "Kreppapier" , "Kreuzas" , "kriegführenden" , "Kriminalprozeß" , _
                        "Kristallüster" , "Kristallüster" , "kroß" , "krummnehmen" , _
                        "Schlußakte" , "Kunststoffolie" , "Kunststoffolie" , "Küraß" , _
                        "kürzeren" , "kürzertreten" , "kurzgebraten" , "kurzhalten" , _
                        "Kurzpaß" , "Kurzschluß" , "kurztreten" , "Kuß" , _
                        "Küßchen" , "kußecht" , "Kußhand" , "küßt" , _
                        "Küstenschiffahrt" , "Kwaß" , "Ladenschluß" , "La-Fontaineschen" , _
                        "La-Fontaineschen" , "Lamé" , "Lamellenverschluß" , "langen" , _
                        "breiten" , "langgestreckt" , "länglichrund" , "langstengelig" , _
                        "langziehen" , "linguae" , "läßlich" , "läßt" , _
                        "Lasten" , "Lattenschuß" , "laubtragende" , "laufenden" , _
                        "laufenlassen" , "Laufpaß" , "Layout" , "Lebensgenuß" , _
                        )
                        
  aCorrectWord = Array( _
                       "Königsschloss" , "Kontrabass" , "Kontrolllampe" , "Kontroll-Lampe" , _
                       "Kontrollliste" , "Kontroll-Liste" , "Kopfnuss" , "Kopfschuss" , _
                       "Kopf stehen" , "Koppelschloss" , "krankschreiben" , "krass" , _
                       "Krassheit" , "Krebs erregende" , "Kreiselkompass" , "Krepppapier" , _
                       "Krepp-Papier" , "Kreuzass" , "Krieg führenden" , "Kriminalprozess" , _
                       "Kristalllüster" , "Kristall-Lüster" , "kross" , "krumm nehmen" , _
                       "Schlussakte" , "Kunststofffolie" , "Kunststoff-Folie" , "Kürass" , _
                       "Kürzeren" , "kürzer treten" , "kurz gebraten" , "kurz halten" , _
                       "Kurzpass" , "Kurzschluss" , "kurz treten" , "Kuss" , _
                       "Küsschen" , "kussecht" , "Kusshand" , "küsst" , _
                       "Küstenschifffahrt" , "Kwass" , "Ladenschluss" , "la-fontaineschen" , _
                       "la-Fontaine'schen" , "Lamee" , "Lamellenverschluss" , "Langen" , _
                       "Breiten" , "lang gestreckt" , "länglich rund" , "langstängelig" , _
                       "lang ziehen" , "Linguae" , "lässlich" , "lässt" , _
                       "zulasten" , "Lattenschuss" , "Laub tragende" , "Laufenden" , _
                       "laufen lassen" , "Laufpass" , "Lay-out" , "Lebensgenuss" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 14" 
  '/// Tools/Spellcheck/check  for some new German words - page 14
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_15

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling15.stw"
  
  aCheckedWord = Array( _
                        "Lebensgenuß" , "Leberabszeß" , "lederverarbeitende" , "leerstehend" , _
                        "leichenblaß" , "leichtes" , "leichtentzündlich" , "leichtfallen" , _
                        "leichtmachen" , "leichtnehmen" , "leichtverderblich" , "leichtverständlich" , _
                        "leid" , "Lenkradschloß" , "Lernprozeß" , "letzte" , _
                        "letzter" , "letzte" , "letzte" , "letzteres" , _
                        "letztenmal" , "leuchtendblau" , "Lichtmeß" , "liebste" , _
                        "liebenlernen" , "liebgewinnen" , "liebhaben" , "liegenbleiben" , _
                        "liegenlassen" , "Live-Mitschnitt" , "Lizentiat" , "Lorbaß" , _
                        "Löß" , "Lößboden" , "Lößschicht" , "Lötschenpaß" , _
                        "Love-Story" , "Luftschiffahrt" , "Luftschloß" , "Magistratsbeschluß" , _
                        "2mal" , "Malaise" , "Marschkompaß" , "maschineschreiben" , _
                        "maßhalten" , "Matrizes" , "Maulkorberlaß" , "Megaphon" , _
                        "Mehrheitsbeschluß" , "Meldeschluß" , "Meniskusriß" , "menschenmögliche" , _
                        "Mesner" , "Meßband" , "meßbar" , "Meßbecher" , _
                        "Meßbuch" , "Meßdaten" , "Meßdiener" , "Meßfühler" , _
                        "Meßgewand" , "Meßinstrument" , _
                        )
                        
  aCorrectWord = Array( _
                       "Lebensgenuss" , "Leberabszess" , "Leder verarbeitende" , "leer stehend" , _
                       "leichenblass" , "Leichtes" , "leicht entzündlich" , "leicht fallen" , _
                       "leicht machen" , "leicht nehmen" , "leicht verderblich" , "leicht verständlich" , _
                       "Leid" , "Lenkradschloss" , "Lernprozess" , "Letzte" , _
                       "Letzter" , "Letzte" , "Letzte" , "Letzteres" , _
                       "letzten Mal" , "leuchtend blau" , "Lichtmess" , "Liebste" , _
                       "lieben lernen" , "lieb gewinnen" , "lieb haben" , "liegen bleiben" , _
                       "liegen lassen" , "Livemitschnitt" , "Lizenziat" , "Lorbass" , _
                       "Löss" , "Lössboden" , "Lössschicht" , "Lötschenpass" , _
                       "Lovestory" , "Luftschifffahrt" , "Luftschloss" , "Magistratsbeschluss" , _
                       "2-mal" , "Maläse" , "Marschkompass" , "Maschine schreiben" , _
                       "Maß halten" , "Matrices" , "Maulkorberlass" , "Megafon" , _
                       "Mehrheitsbeschluss" , "Meldeschluss" , "Meniskusriss" , "Menschenmögliche" , _
                       "Messner" , "Messband" , "messbar" , "Messbecher" , _
                       "Messbuch" , "Messdaten" , "Messdiener" , "Messfühler" , _
                       "Messgewand" , "Messinstrument" , _
                       )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 15" 
  '/// Tools/Spellcheck/check  for some new German words - page 15
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_16

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling16.stw"
  
  aCheckedWord = Array( _
                       "Meßopfer" , "Meßstab" , "Meßstab" , "Meßtischblatt" , _
                       "Metallguß" , "Metallegierung" , "Metallegierung" , "metallverarbeitende" , _
                       "Midlife-crisis" , "Midlife-crisis" , "Milchgebiß" , "millionenmal" , _
                       "Milzriß" , "mindesten" , "mißachten" , "Mißbildung" , _
                       "mißbilligen" , "Mißbrauch" , "Mißerfolg" , "Mißernte" , _
                       "mißfallen" , "Mißfallenskundgebung" , "Mißgeburt" , "Mißgeschick" , _
                       "mißglücken" , "Mißgunst" , "mißgünstig" , "Mißklang" , _
                       "Mißkredit" , "mißlich" , "mißlingen" , "mißmutig" , _
                       "mißraten" , "Mißstand" , "Mißtrauen" , "mißtrauisch" , _
                       "Mißverständnis" , "Mißwirtschaft" , "mit Hilfe" , "mittag" , _
                       "Mixed Pickles" , "modebewußt" , "mögliche" , "möglichstes" , _
                       "3monatig" , "3monatlich" , "Monographie" , "Mop" , _
                       "Mordprozeß" , "abend" , "mittag" , "nacht" , _
                       "morgen" , "Moto-Cross" , "Mückenschiß" , "Mulläppchen" , _
                       "Mulläppchen" , "Multiple-choice-Verfahren" , "Multiple-choice-Verfahren" , "Muskatnuß" , _
                       "Muskelriß" , "muß" , "mußt" , "müßte" , _
                       "müßtest" , _
                       )

  aCorrectWord = Array( _
                       "Messopfer" , "Messstab" , "Mess-Stab" , "Messtischblatt" , _
                       "Metallguss" , "Metalllegierung" , "Metall-Legierung" , "Metall verarbeitende" , _
                       "Midlifecrisis" , "Midlife-Crisis" , "Milchgebiss" , "Millionen Mal" , _
                       "Milzriss" , "Mindesten" , "missachten" , "Missbildung" , _
                       "missbilligen" , "Missbrauch" , "Misserfolg" , "Missernte" , _
                       "missfallen" , "Missfallenskundgebung" , "Missgeburt" , "Missgeschick" , _
                       "missglücken" , "Missgunst" , "missgünstig" , "Missklang" , _
                       "Misskredit" , "misslich" , "misslingen" , "missmutig" , _
                       "missraten" , "Missstand" , "Misstrauen" , "misstrauisch" , _
                       "Missverständnis" , "Misswirtschaft" , "mithilfe" , "Mittag" , _
                       "Mixedpickles" , "modebewusst" , "Mögliche" , "Möglichstes" , _
                       "3-monatig" , "3-monatlich" , "Monografie" , "Mopp" , _
                       "Mordprozess" , "Abend" , "Mittag" , "Nacht" , _
                       "Morgen" , "Motocross" , "Mückenschiss" , "Mullläppchen" , _
                       "Mull-Läppchen" , "Multiplechoiceverfahren" , "Multiple-Choice-Verfahren" , "Muskatnuss" , _
                       "Muskelriss" , "muss" , "musst" , "müsste" , _
                       "müsstest" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words -- Page 16"
  '/// Tools/Spellcheck/check  for some new German words -- Page 16
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_17

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling17.stw"
  
  aCheckedWord = Array( _
                        "Mußheirat" , "müßiggehen" , "Musterprozeß" , "Myrrhe" , _
                        "nachfolgendes" , "nach Hause" , "nachhinein" , "Nachlaß" , _
                        "Nachlaßverwalter" , "nachmittag" , "Nachschuß" , "nächste" , _
                        "nächstes" , "nachstehenden" , "nacht" , "nahebringen" , _
                        "nahelegen" , "naheliegen" , "naheliegend" , "näheren" , _
                        "näherliegen" , "nahestehen" , "nahestehend" , "Narziß" , _
                        "Narzißmus" , "narzißtisch" , "naß" , "naßforsch" , _
                        "naßgeschwitzt" , "naßkalt" , "Naßrasur" , "Naßschnee" , _
                        "Naßschnee" , "nationalbewußt" , "Nationaldreß" , "Nebelschlußleuchte" , _
                        "Nebenanschluß" , "nebeneinandersitzen" , "nebeneinanderstehen" , "nebeneinanderstellen" , _
                        "Nebenfluß" , "nebenstehenden" , "Necessaire" , "Negligé" , _
                        "nein sagen" , "Netzanschluß" , "neue" , "neues" , _
                        "neueröffnet" , "New Yorker" , "nichtrostend" , "Nichtseßhafte" , _
                        "nichtssagend" , "No-future-Generation" , "notleidende" , "Null" , _
                        "Null" , "Nullage" , "Nullage" , "Nulleiter" , _
                        "Nulleiter" , "Nullösung" , "Nullösung" , _
                        )
                        
  aCorrectWord = Array( _
                       "Mussheirat" , "müßig gehen" , "Musterprozess" , "Myrre" , _
                       "Nachfolgendes" , "nachhause" , "Nachhinein" , "Nachlass" , _
                       "Nachlassverwalter" , "Nachmittag" , "Nachschuss" , "Nächste" , _
                       "Nächstes" , "Nachstehenden" , "Nacht" , "nahe bringen" , _
                       "nahe legen" , "nahe liegen" , "nahe liegend" , "Näheren" , _
                       "näher liegen" , "nahe stehen" , "nahe stehend" , "Narziss" , _
                       "Narzissmus" , "narzisstisch" , "nass" , "nassforsch" , _
                       "nass geschwitzt" , "nasskalt" , "Nassrasur" , "Nassschnee" , _
                       "Nass-Schnee" , "nationalbewusst" , "Nationaldress" , "Nebelschlussleuchte" , _
                       "Nebenanschluss" , "nebeneinander sitzen" , "nebeneinander stehen" , "nebeneinander stellen" , _
                       "Nebenfluss" , "Nebenstehenden" , "Nessessär" , "Negligee" , _
                       "Nein sagen" , "Netzanschluss" , "Neue" , "Neues" , _
                       "neu eröffnet" , "New-Yorker" , "nicht rostend" , "Nichtsesshafte" , _
                       "nichts sagend" , "No-Future-Generation" , "Not leidende" , "null" , _
                       "null" , "Nulllage" , "Null-Lage" , "Nullleiter" , _
                       "Null-Leiter" , "Nulllösung" , "Null-Lösung" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 17"
  '/// Tools/Spellcheck/check  for some new German words - page 17
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_18

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
    
  sFileName = "new_german_spelling18.stw"

  aCheckedWord = Array( _
                       "numerieren" , "Numerierung" , "Nuß" , "Nüßchen" , _
                       "Nußknacker" , "Nußschale" , "Nußschale" , "Nußschinken" , _
                       "Nußschinken" , "Nußschokolade" , "Nußschokolade" , "Nußstrudel" , _
                       "Nußstrudel" , "Nußtorte" , "O-beinig" , "obenerwähnt" , _
                       "obenstehend" , "Obergeschoß" , "offenbleiben" , "offenlassen" , _
                       "offenstehen" , "O-förmig" , "öfteren" , "Ölmeßstab" , _
                       "Ordonnanz" , "Orthographie" , "Panther" , "papierverarbeitende" , _
                       "Pappmaché" , "parallellaufend" , "parallelschalten" , "Paranuß" , _
                       "Parlamentsbeschluß" , "Parnaß" , "Parteikongreß" , "Parteitagsbeschluß" , _
                       "Paß" , "Paßbild" , "passé" , "Paßform" , _
                       "Paßgang" , "paßgerecht" , "Paßkontrolle" , "Paßstelle" , _
                       "Paßstelle" , "Paßstraße" , "Paßstraße" , "Paßwort" , _
                       "Patentverschluß" , "patschnaß" , "Perkussionsschloß" , "Personenschiffahrt" , _
                       "Petitionsausschuß" , "Pfeffernuß" , "Pferdegebiß" , "pflichtbewußt" , _
                       "Pflichtbewußtsein" , "Pfostenschuß" , "Pikas" , "Pimpernuß" , _
                       "pißt" , "Pistolenschuß" , "pitschnaß" , "Platitüde" , _
                       "Platitüde" , _
                      )
                        
  aCorrectWord = Array( _
                       "nummerieren" , "Nummerierung" , "Nuss" , "Nüsschen" , _
                       "Nussknacker" , "Nussschale" , "Nuss-Schale" , "Nussschinken" , _
                       "Nuss-Schinken" , "Nussschokolade" , "Nuss-Schokolade" , "Nussstrudel" , _
                       "Nuss-Strudel" , "Nusstorte" , "o-beinig" , "oben erwähnt" , _
                       "oben stehend" , "Obergeschoss" , "offen bleiben" , "offen lassen" , _
                       "offen stehen" , "o-förmig" , "Öfteren" , "Ölmessstab" , _
                       "Ordonanz" , "Orthografie" , "Panter" , "Papier verarbeitende" , _
                       "Pappmaschee" , "parallel laufend" , "parallel schalten" , "Paranuss" , _
                       "Parlamentsbeschluss" , "Parnass" , "Parteikongress" , "Parteitagsbeschluss" , _
                       "Pass" , "Passbild" , "passee" , "Passform" , _
                       "Passgang" , "passgerecht" , "Passkontrolle" , "Passstelle" , _
                       "Pass-Stelle" , "Passstraße" , "Pass-Straße" , "Passwort" , _
                       "Patentverschluss" , "patschnass" , "Perkussionsschloss" , "Personenschifffahrt" , _
                       "Petitionsausschuss" , "Pfeffernuss" , "Pferdegebiss" , "pflichtbewusst" , _
                       "Pflichtbewusstsein" , "Pfostenschuss" , "Pikass" , "Pimpernuss" , _
                       "pisst" , "Pistolenschuss" , "pitschnass" , "Plattitüde" , _
                       "Platitude" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 18"
  '/// Tools/Spellcheck/check  for some new German words - page 18
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument

endcase

' *******************************************************************

testcase tGermanSpellCheck_19

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling19.stw"
  
  aCheckedWord = Array( _
                        "Playback" , "plazieren" , "pleite" , "polyphon" , _
                        "Pornographie" , "Portemonnaie" , "Potemkinsche" , "Potemkinsche" , _
                        "potentiell" , "potthäßlich" , "Poussierstengel" , "präferentiell" , _
                        "praßt" , "preisbewußt" , "Preisnachlaß" , "Preßform" , _
                        "Preßluftbohrer" , "Preßsack" , "Preßsack" , "Preßschlag" , _
                        "Preßschlag" , "Preßspan" , "Preßspan" , "preßt" , _
                        "Preßwehe" , "Prinzeßbohne" , "privatversichert" , "probefahren" , _
                        "Problembewußtsein" , "Produktionsprozeß" , "Profeß" , "Programmusik" , _
                        "Programmusik" , "Progreß" , "Prozeß" , "Prozeßkosten" , _
                        "Prozeßbevollmächtigte" , "prozeßführend" , "Prozeßkosten" , "Prozeßrechner" , _
                        "pudelnaß" , "Pulverfaß" , "pußlig" , "Quadrophonie" , _
                        "qualitätsbewußt" , "Quartalsabschluß" , "Quellfluß" , "Quentchen" , _
                        "Querpaß" , "Quickstep" , "radfahren" , "Radikalenerlaß" , _
                        "radschlagen" , "Rammaschine" , "Rammaschine" , "zu Rande" , _
                        "Rassenhaß" , "raßle" , "zu Rate" , "Räterußland" , _
                        "Ratsbeschluß" , "Ratschluß" , "Rauchfaß" , _
                        )
                       
  aCorrectWord = Array( _
                        "Play-back" , "platzieren" , "Pleite" , "polyfon" , _
                        "Pornografie" , "Portmonee" , "potemkinsche" , "Potemkin'sche" , _
                        "potenziell" , "potthässlich" , "Poussierstängel" , "präferenziell" , _
                        "prasst" , "preisbewusst" , "Preisnachlass" , "Pressform" , _
                        "Pressluftbohrer" , "Presssack" , "Press-Sack" , "Pressschlag" , _
                        "Press-Schlag" , "Pressspan" , "Press-Span" , "presst" , _
                        "Presswehe" , "Prinzessbohne" , "privat versichert" , "Probe fahren" , _
                        "Problembewusstsein" , "Produktionsprozess" , "Profess" , "Programmmusik" , _
                        "Programm-Musik" , "Progress" , "Prozess" , "Prozesskosten" , _
                        "Prozessbevollmächtigte" , "prozessführend" , "Prozesskosten" , "Prozessrechner" , _
                        "pudelnass" , "Pulverfass" , "pusslig" , "Quadrofonie" , _
                        "qualitätsbewusst" , "Quartalsabschluss" , "Quellfluss" , "Quäntchen" , _
                        "Querpass" , "Quickstepp" , "Rad fahren" , "Radikalenerlass" , _
                        "Rad schlagen" , "Rammmaschine" , "Ramm-Maschine" , "zurande" , _
                        "Rassenhass" , "rassle" , "zurate" , "Räterussland" , _
                        "Ratsbeschluss" , "Ratschluss" , "Rauchfass" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 19" 
  '/// Tools/Spellcheck/check  for some new German words - page 19
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_20

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling20.stw"
  
  aCheckedWord = Array( _
                        "rauh" , "rauhbeinig" , "Rauhfasertapete" , "Rauhfrost" , _
                        "Rauhhaardackel" , "Rauhnächte" , "Rauhputz" , "Rauhreif" , _
                        "Rausschmiß" , "recht" , "recht" , "recht" , _
                        "recht" , "Rechtens" , "Rechtsbewußtsein" , "Redaktionsschluß" , _
                        "Regenguß" , "regennaß" , "Regreß" , "Regreßanspruch" , _
                        "Regreßpflicht" , "regreßpflichtig" , "reichgeschmückt" , "reichverziert" , _
                        "Reifungsprozeß" , "Reisepaß" , "Reißverschluß" , "Reißverschlußsystem" , _
                        "Reißverschlußsystem" , "Reschenpaß" , "Rettungsschuß" , "Rezeß" , _
                        "Großschiffahrtsweg" , "richtige" , "richtigliegen" , "richtigstellen" , _
                        "Riß" , "rißfest" , "Roheit" , "Rolladen" , _
                        "Rolladen" , "Rommé" , "rosigweiß" , "Roß" , _
                        "Roßbreiten" , "Roßhaarmatratze" , "Roßkastanie" , "Roßkur" , _
                        "Rößl" , "Roßtäuscherei" , "rote" , "rotgestreift" , _
                        "rotglühend" , "rötlichbraun" , "Rubensschen" , "Rubensschen" , _
                        "Rückfluß" , "Rückpaß" , "Rückschluß" , "rückwärtsgewandt" , _
                        "Ruhegenuß" , "ruhenlassen" , "ruhigstellen" , _
                        )
                        
  aCorrectWord = Array( _
                        "rau" , "raubeinig" , "Raufasertapete" , "Raufrost" , _
                        "Rauhaardackel" , "Raunächte" , "Rauputz" , "Raureif" , _
                        "Rausschmiss" , "Recht" , "Recht" , "Recht" , _
                        "Recht" , "rechtens" , "Rechtsbewusstsein" , "Redaktionsschluss" , _
                        "Regenguss" , "regennass" , "Regress" , "Regressanspruch" , _
                        "Regresspflicht" , "regresspflichtig" , "reich geschmückt" , "reich verziert" , _
                        "Reifungsprozess" , "Reisepass" , "Reißverschluss" , "Reißverschlusssystem" , _
                        "Reißverschluss-System" , "Reschenpass" , "Rettungsschuss" , "Rezess" , _
                        "Großschifffahrtsweg" , "Richtige" , "richtig liegen" , "richtig stellen" , _
                        "Riss" , "rissfest" , "Rohheit" , "Rollladen" , _
                        "Roll-Laden" , "Rommee" , "rosig weiß" , "Ross" , _
                        "Rossbreiten" , "Rosshaarmatratze" , "Rosskastanie" , "Rosskur" , _
                        "Rössl" , "Rosstäuscherei" , "Rote" , "rot gestreift" , _
                        "rot glühend" , "rötlich braun" , "rubensschen" , "Rubens'schen" , _
                        "Rückfluss" , "Rückpass" , "Rückschluss" , "rückwärts gewandt" , _
                        "Ruhegenuss" , "ruhen lassen" , "ruhig stellen" , _
                       )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 20" 
  '/// Tools/Spellcheck/check  for some new German words - page 20
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************
