'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_213_.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:26:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_213_

    Call WriterToDrawText
    Call WriterToDrawField
    Call WriterToDrawTable
    Call WriterToDrawFrame
    Call WriterToDrawDrawingObject
    Call WriterToDrawGraphicLinked
    Call WriterToDrawGraphicEmbedded
    Call WriterToDrawOLEObject
    Call WriterToDrawControl

end sub

' ---------------------------------------------------------------------------------

testcase WriterToDrawText
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("text") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Text' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_text.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_text.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_text.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Text' failed !"
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawField
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("field") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_field.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_field.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_field.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Field' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawTable
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  if wSetClipboardtestDefaults("table") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_table.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_table.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_table.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Table' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawFrame
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Frame' ///
  '///+ Copy selected frame ///
  if wSetClipboardtestDefaults("frame") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"frame")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_frame.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_frame.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_frame.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Frame' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawDrawingObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Drawing Object' ///
  '///+ Copy selected Drawing Object ///
  if wSetClipboardtestDefaults("draw") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_draw.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_draw.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_draw.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Drawing Object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawGraphicLinked
   EnableQaErrors = true
   gApplication = "WRITER"
   '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
   '///+ Jump to beginning of document ///
   '///+ Select 'Linked Graphic' ///
   '///+ Copy selected Linked Graphic ///
   if wSetClipboardtestDefaults("graphicL") = True then
      gApplication = "DRAW"
      '///+ Open new document ///
      Call hNewDocument
      '///+ Edit / Paste Special ///
      Sleep 2
      try
         EditPasteSpecial
      catch
         QAErrorLog "Check why linked graphic fails !"
         Call hCloseDocument
         wait 500
         Call hCloseDocument
         goto endsub
      endcatch
      Wait 500
      '/// Paste 'Linked Graphic' in all available clipboard formats ///
      Kontext "InhaltEinfuegen"
      if InhaltEinfuegen.Exists then
         Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
         '///+ Write Clipboard format under pasted content ///
         Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_graphic1.sxd")
         '///+ Save document as "..\user\work\writer_to_draw_graphic1.sxd" ///
         Wait 500
         Call hCloseDocument
         '///+ Close saved document ///
         wait 500
         Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_graphic1.sxd",true)
         '///+ Reopen saved document ///
         Wait 500
         Call hCloseDocument
         '///+ Close saved document ///
      else
         Warnlog "Dialog 'Paste Special' is not up!"
         Call hCloseDocument
         goto endsub
      endif
   else
      Warnlog "Writer To Draw -> 'Linked Graphic' failed !"
   endif
   '/// Close active document ///
   Call hCloseDocument
   EnableQaErrors = false
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawGraphicEmbedded
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Embedded Graphic' ///
  '///+ Copy selected Embedded Graphic ///
  if wSetClipboardtestDefaults("graphicE") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Embedded Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicE")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_graphic2.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_graphic2.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_graphic2.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Embedded Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawOLEObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'OLE Object' ///
  '///+ Copy selected OLE Object ///
  if wSetClipboardtestDefaults("ole") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'OLE object' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ole")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_ole.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_ole.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_ole.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'OLE object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToDrawControl
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Control' ///
  '///+ Copy selected Control ///
  if wSetClipboardtestDefaults("control") = True then
    gApplication = "DRAW"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_draw_control.sxd")
     '///+ Save document as "..\user\work\writer_to_draw_control.sxd" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_draw_control.sxd",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Draw -> 'Control' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase
