'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_105b_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:27:30 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_105b_
   printLog Chr(13) + "---------   Level 1 - Menu / Format for Graphic/FloatingFrame/Frame/Chart   ----------"

' Grafik ( jo-link.jpg )
   Call tFormatGraphic
   Call tFormatWrapGraphic

' Rahmen
   Call tFormatFrame
   Call tFormatWrapFrame

' Chart
   Call tFormatObjectChart
   Call tFormatWrapChart

end sub


'**********************************************************************************
testcase tFormatGraphic
  Dim Vergleich1$, Vergleich2$
  PrintLog "- Format / Graphic"
   '/// Open New writerdocument ///
   Call hNewDocument
   Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
   '/// Insert a graphic in writerdocument ///
  PrintLog "   - modify formats"
   '/// Format / Graphic ///
   FormatGraphics
   Kontext
   '/// Select Tabpage Type ///
   active.SetPage TabType
   Kontext "TabType"
   Width.SetText "5"
   Height.SetText "4"
   '/// Set values for width and height ///
   Vergleich1$ = Width.GetText
   Vergleich2$ = Height.GetText
   Kontext
   active.SetPage TabZusaetze
   Kontext "TabZusaetze"
   ObjektName.SetText "Dies soll ein Br sein"
   AlternativText.SetText "Dies ist immer noch ein Br"
   Kontext
   active.SetPage TabUmlauf
   '/// Select Tabpage Wrap and check wrap through ///
   Kontext "TabUmlauf"
   Durchlauf.Check

   Kontext
   active.SetPage TabUmlauf
   Kontext "TabUmlauf"
   ImHintergrund.Check
   '/// Check 'In background' ///
   Kontext
   active.SetPage TabGrafik
   '/// Select Tabpage Graphics and check 'Horizontally' ///
   Kontext "TabGrafik"
   Horizontal.Check
   Kontext
   '/// Select Tabpage Crop///
   active.SetPage TabZuschneiden
   Kontext "TabZuschneiden"
   '/// Check 'Keep image size' ///
   GroesseBeibehalten.Check
   Links.SetText "1"
   Rechts.SetText "1"
   '/// Enter '1' for Left and Right ///
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      Oben.SetText "-0.2"
      Unten.SetText "-0.2"
   else
      Oben.SetText "-0,2"
      Unten.SetText "-0,2"
   end if
   TabZuschneiden.OK
   Sleep 1
   '/// Close and reopen dialog ///

  PrintLog "   - check formats"
   '/// Check previously changed formats ///
   FormatGraphics
   Kontext
   active.SetPage TabType
   Kontext "TabType"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      if Width.GetText <> Vergleich1$ AND Width.GetText <> "5,01" then Warnlog "Width is not "+ Vergleich1$ +" but "+ Width.GetText
      if Height.GetText <> Vergleich2$ then Warnlog "Height is not "+ Vergleich2$ + " but "+ Height.GetText
   else
      if Width.GetText <> "5,00" + mUnit AND Width.GetText <> "5,01" + mUnit then Warnlog "Width is not 5,00" + mUnit + " but "+ Width.GetText
      if Height.GetText <> "4,00" + mUnit then Warnlog "Height is not 4,00" + mUnit + " but "+ Height.GetText
   end if
   Kontext
   active.SetPage TabZusaetze
   Kontext "TabZusaetze"
   if ObjektName.GetText <> "Dies soll ein Br sein" then Warnlog "Name of graphic is wrong"
   if AlternativText.GetText <> "Dies ist immer noch ein Br" then Warnlog "Alternative name of graphic is wrong"
   Kontext
   active.SetPage TabUmlauf
   Kontext "TabUmlauf"
   if ImHintergrund.IsEnabled then
      if NOT ImHintergrund.IsChecked then Warnlog "On wrap background is not checked"
   else
      Warnlog "Wrap through is not selected"
   end if
   Kontext
   active.SetPage TabGrafik
   Kontext "TabGrafik"
   if NOT Horizontal.IsChecked then Warnlog "Graphic is not horizontally flipped"
   Kontext
   active.SetPage TabZuschneiden
   Kontext "TabZuschneiden"
   if iSystemSprache = 01 or iSystemSprache = 07 or iSystemSprache = 48 then
      if Links.GetText <> "1.00" + mUnit then Warnlog "The Value for 'Left' on 'Crop' is not 1.00" + mUnit + " but " + Links.GetText
      if Rechts.GetText <> "1.00" + mUnit then Warnlog "The value for 'Right' on 'Crop' is not 1.00" + mUnit + " but " + Rechts.GetText
    if iSystemSprache = 48 then
      if Oben.GetText <> "-0.20" + mUnit then Warnlog "The Value for 'Top' on 'Crop' is not -.20" + mUnit + " but " + Oben.GetText
      if Unten.GetText <> "-0.20" + mUnit then Warnlog "The Value for 'Bottom' on 'Crop' is not -.20" + mUnit + " but " + Unten.GetText
    else
      if Oben.GetText <> "-0.20" + mUnit then Warnlog "The Value for 'Top' on 'Crop' is not -.20" + mUnit + " but " + Oben.GetText
      if Unten.GetText <> "-0.20" + mUnit then Warnlog "The Value for 'Bottom' on 'Crop' is not -.20" + mUnit + " but " + Unten.GetText
    endif
   else
      if Links.GetText <> "1,00" + mUnit then Warnlog "The Value for 'Left' on 'Crop' is not 1,00" + mUnit + " but " + Links.GetText
      if Rechts.GetText <> "1,00" + mUnit then Warnlog "The value for 'Right' on 'Crop' is not 1,00" + mUnit + " but " + Rechts.GetText
      if Oben.GetText <> "-0,20" + mUnit then Warnlog "The Value for 'Top' on 'Crop' is not -0,20" + mUnit + " but " + Oben.GetText
      if Unten.GetText <> "-0,20" + mUnit then Warnlog "The Value for 'Bottom' on 'Crop' is not -0,20" + mUnit + " but " + Unten.GetText
   end if
   TabZuschneiden.OK
   '/// Close document ///
   Call hCloseDocument
endcase
'**********************************************************************************
testcase tFormatWrapGraphic
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert the autotext 'Dummy text' ///
   Call wBlindtextEinfuegen
   Call wDokSchreiben "<Up>", 10
   Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
   '/// Insert a graphic ///

  printlog "- Graphic with anchor to paragraph"
   '/// Anchor graphic to paragraph ///
   FormatAnchorToParagraph
   wait 500
  printlog "  - all Wrap methods with Contour"
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   '/// Format /Wrap / Contour should be enabled with Page wrap ///
   try
    FormatWrapContour
    wait 500
   catch
    Warnlog "Format Wrap Contour doesn't work!"
   endcatch
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   '/// Select all wrap methods succesively ///
   try
    FormatWrapContour
    wait 500
    Warnlog "Format Wrap Contour should be disabled!"
   catch
   endcatch
   wait 500
   FormatWrapInBackground
   wait 500

  printlog "  - all Wrap methods with 1. Paragraph"
   '/// all Wrap methods with 1. Paragraph ///
   FormatWrapFirstParagraph
   wait 500
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   wait 500
   FormatWrapInBackground
   wait 500

  printlog "  - all Wrap methods with 1. Paragraph and contour"
   '/// all Wrap methods with 1. Paragraph and contour ///
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   wait 500
   try
    FormatWrapContour
    wait 500
   catch
    Warnlog "Format Wrap Contour doesn't work!"
   endcatch
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   wait 500
   FormatWrapInBackground
   wait 500

  printlog "- Graphic anchored as character"
   '/// Anchor graphic as character ///
   FormatAnchorAsCharacter
   wait 500
   try
     FormatWrapContour
     Warnlog "On anchor to character, wrap has to be disabled, but it isn't"
   catch
   endcatch

  printlog "- Graphic with anchor to page"
   '/// Anchor graphic to page ///
   FormatAnchorToPage
   wait 500
  printlog "  - all Wrap methods with Contour"
   '/// select all wrap methods successively ///
   try
    FormatWrapContour
    wait 500
    Warnlog "Format Wrap Contour should be disabled!"
   catch
   endcatch
   FormatWrapPageWrap
   wait 500
  try
   FormatWrapNoWrap
  catch
   Warnlog "'No Wrap' bon anchor to page doesn't work!"
  endcatch
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
  try
   FormatWrapThrough
  catch
   Warnlog "'Wrap through' on anchor to page doesn't work!"
  endcatch

   wait 500
   FormatWrapInBackground
   wait 500
   try
      FormatWrapFirstParagraph
      Warnlog "On anchor to page, Wrap to paragraph has to be disabled"
   catch
   endcatch
   '/// Close document ///

   Call hCloseDocument
endcase

'**********************************************************************************

testcase tFormatFrame
 Dim w1 : Dim w2 : Dim w3 : Dim w4 : Dim w5
  PrintLog "- Format / Frame"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a frame ///
   Call hEinfuegenRahmen

  PrintLog "   - modify formats"
   '/// Select Format / Frame and change properties ///
   FormatFrame
  Kontext
   '/// Select Tabpage Type and change height and width ///
  active.SetPage TabType
  Kontext "TabType"
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      Width.SetText "10.33"
      Height.SetText "5.27"
   else
      Width.SetText "10,33"
      Height.SetText "5,27"
   end if
   w1 = Width.GetText
   w2 = Height.GetText
   '/// Check Anchor to page ///
   AnchorAtPage.Check
   '/// Change position: Horizontal to 'Right' and to 'Paragraph area' ///
   Horizontal.Select 2
   HorizontalTo.Select 1
   '/// at Vertical select 'top' ///
   Vertical.Select 1
  Kontext
   '/// Select Tabpage Options ///
  active.SetPage TabZusaetze
  Kontext "TabZusaetze"
   '/// Insert a frame name ///
   ObjektName.SetText "Dies soll ein Rahmen sein"
   '/// Check 'Protect Contents' and 'Protect size' ///
   InhaltSchuetzen.Check
   GroesseSchuetzen.Check
   '/// Select Tabpage 'Wrap' ///
  Kontext
  active.SetPage TabUmlauf
  Kontext "TabUmlauf"
   '/// Check 'Left'///
   Links.Check
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemsprache = 07 then
      AbstaendeLinks.SetText "2.00"
   else
      AbstaendeLinks.SetText "2,00"
   end if
   '/// modify values for 'Spacing left' ///
   AbstaendeLinks.More
   AbstaendeLinks.Less
   w5 = AbstaendeRechts.GetText
   w3 = AbstaendeLinks.GetText
   '/// Select Tabpage Background and modify Backgound color ///
  Kontext
  active.SetPage TabHintergrund
  Kontext "TabHintergrund"
   HintergrundFarbe.TypeKeys "<Up Right>", 4
  Kontext
   '/// Select Tabpage 'Columns' ///
  Active.SetPage TabSpalten
  Kontext "TabSpalten"
   '/// Change value for number of columns to 3 ///
   Anzahl.More 2
   '/// Uncheck 'AutoWidth' ///
   wait 5000
   try
    AutomBreite.Uncheck
   catch
    Warnlog "Checkbox 'Auto Width' is disabled though number of columns > 3"
   endcatch
   '/// modify values for Width and Spacing ///
   Art.Select 5
   Hoehe.Less 7
   w4 = Hoehe.GetText
   TabSpalten.OK
   '/// Close and reopen dialog ///

   Call wDocSetContext
   '/// check properties ///
   PrintLog "   - check formats"
  try
    FormatFrame
  Kontext
   active.SetPage TabType
  Kontext "TabType"
   if Width.GetText <> w1 then Warnlog "Width is wrong. Not " + w1 + " but " + Width.GetText
   if Height.GetText <> w2 then Warnlog "Height is wrong. Not  " + w2 + " but " + Height.GetText
   if Not AnchorAtPage.IsChecked then Warnlog "Anchor at page not selected "
   if Horizontal.GetSelIndex <> 2 then Warnlog "Horizontal entry is not 2 but " + Horizontal.GetSelIndex
   if HorizontalTo.GetSelIndex <>  1 then Warnlog "Wrong entry in 'Horizontal by'. Not 1 but " + HorizontalZu.GetSelIndex
   if Vertical.GetSelIndex <> 1 then Warnlog "Vertical entry not 1 selected, but " + Vertikal.GetSelIndex
   Kontext
   active.SetPage TabZusaetze
  Kontext "TabZusaetze"
   if ObjektName.GetText <> "Dies soll ein Rahmen sein" then warnlog "Name is wrong"
   if NOT InhaltSchuetzen.IsChecked then Warnlog "Protect contents is not checked anymore!"
   if NOT GroesseSchuetzen.IsChecked then Warnlog "Protect size is not checked anymore!"
   Kontext
   active.SetPage TabUmlauf
  Kontext "TabUmlauf"
   if NOT Links.IsChecked then Warnlog "Wrap left is not checked anymore!"
   if ErsterAbsatz.IsEnabled then warnlog "Though frame is ancored to page, the first paragraph is not enabled!"
   if AbstaendeLinks.GetText <> w3 then Warnlog "BUG 48907: Spacing left is not " + w3 + " but " + AbstaendeLinks.GetText
   if AbstaendeRechts.GetText <> w5 then Warnlog "Spacing right is not " + w5 + " but " + AbstaendeRechts.GetText
  Kontext
  Active.SetPage TabSpalten
  Kontext "TabSpalten"
   if Anzahl.GetText <> "3" then Warnlog "Number of columns is not 3 but " + Anzahl.GetText
   if AutomBreite.IsChecked then Warnlog "AutoWidth is checked again"
   if Art.GetSelIndex <> 5 then Warnlog "Selected entry in Seperator line is not 5 but " + Art.GetSelIndex
   if Hoehe.GetText <> w4 then Warnlog "Height of columns is not " + w4 + " but " + Hoehe.GetText
   TabSpalten.Cancel
  catch
   Warnlog "- Attributes could not be checked !(Menue entry disabled) "
  endcatch


   '/// Close document ///
   Call hCloseDocument
endcase

'**********************************************************************************

testcase tFormatWrapFrame
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert autotext 'Dummy text' ///
   Call wBlindtextEinfuegen
   Call wDokSchreiben "<Up>", 10
   '/// Insert a frame ///
   Call hEinfuegenRahmen

  printlog "- Frame anchored to paragraph"
   '/// Anchor frame to paragraph ///
   FormatAnchorToParagraph
   wait 500
  printlog "  - all Wrap methods with 1. Paragraph"
   '/// Select all wrap methods successively ///
   FormatWrapFirstParagraph
   wait 500
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   wait 500
   FormatWrapInBackground
   wait 500

  printlog "- Frame anchored to paragraph"
   '/// Anchor frame to paragraph ///
   FormatAnchorToCharacter
   wait 500
   try
      FormatWrapNoWrap
   catch
      'Warnlog "On anchor to paragraph, wrap should be active"
   endcatch

  printlog "- Frame anchored to page"
   '/// Anchor frame to page and select all wrap methods successively ///
   FormatAnchorToPage
   wait 500
   FormatWrapPageWrap
   wait 500
  printlog "  - all Wrap methods"
  try
   FormatWrapNoWrap
  catch
   Warnlog "'No wrap' with anchor to page not available!"
  endcatch
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
  try
   FormatWrapThrough
  catch
   Warnlog "'Wrap through' with anchor to page not available!"
  endcatch

   wait 500
   FormatWrapInBackground
   wait 500

   try
      FormatWrapFirstParagraph
      Warnlog "Wrap to paragraph should not be active if object is anchored to page"
   catch
   endcatch

   '/// Close document ///
   Call hCloseDocument
endcase

'**********************************************************************************
testcase tFormatObjectChart
 Dim w1 : Dim w2 : Dim w3
  PrintLog "- Format / Object with a chart"
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert a chart ///
   Call hEinfuegenChart

   '/// Open options and uncheck 'Direct Cursor' ///
   ToolsOptions
   Call hToolsOptions("TextDocument","FormattingAids")
   If Zonen_Cursor.IsChecked then Zonen_Cursor.Uncheck
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Call wDocSetContext

  PrintLog "   - modify formats"
   '/// Open properties of chart with Format / Object ///
   FormatFrame
  Kontext
   '/// Select Tabpage Type ///
  active.SetPage TabType
  Kontext "TabType"
   '/// Change values for width and height ///
   Width.SetText "2,37"
   Height.SetText "5,27"
   w1 = Width.GetText
   w2 = Height.GetText
   '/// Check anchor to character ///
   AnchorAtCharacter.Check
   '/// modify values for Position Horizontal ///
   Horizontal.Select 3
   HorizontalTo.Select 2
   Vertical.Select 2
   VerticalTo.Select 3
  Kontext
   '/// Select Tabpage Options ///
  active.SetPage TabZusaetze
  Kontext "TabZusaetze"
   '/// Insert a object name ///
   ObjektName.SetText "Ein Chart ein Chart, jajaj"
   '/// Check 'Protect Contents' and 'Protect position' ///
   InhaltSchuetzen.Check
   PositionSchuetzen.Check
   '/// Uncheck 'Print' ///
   Drucken.Uncheck
  Kontext
   '/// Select Tabpage 'Wrap' ///
  active.SetPage TabUmlauf
  Kontext "TabUmlauf"
   '/// Select Parallel for Settings ///
   Parallel.Check
   '/// Modify values for spacing and options ///
   Kontur.Check
   NurAussen.Check
   AbstaendeUnten.More 5
   w3 = AbstaendeUnten.GetText
  Kontext
   '/// Select Tabpage 'Backgound' and modify color ///
  active.SetPage TabHintergrund
  Kontext "TabHintergrund"
   HintergrundFarbe.TypeKeys "<Down>", 2
   TabHintergrund.OK
   '/// Close and reopen dialog///

  Call wDocSetContext
  PrintLog "   - check formats"
 try
   FormatFrame
   Kontext
   active.SetPage TabType
   '/// Check previous made settings ///
  Kontext "TabType"
   if Width.GetText <> w1 then Warnlog "Width is wrong. Not " + w1 + " but " + Width.GetText
   if Height.GetText <> w2 then Warnlog "Height is wrong. Not " + w2 + " but " + Height.GetText
   if Not AnchorAtCharacter.IsChecked then Warnlog "Anchor at character is not checked!"
   if Horizontal.GetSelIndex <> 3 then Warnlog "Wrong Horizontal entry selected. Not 3 but " + Horizontal.GetSelIndex
   if HorizontalTo.GetSelIndex <>  2 then Warnlog "Wrong Horizontal by entry selected. Not 2 but " + HorizontalZu.GetSelIndex
   if Vertical.GetSelIndex <> 2 then Warnlog "Wrong Vertical entry selected. Not 2 but " + Vertikal.GetSelIndex
   if VerticalTo.GetSelIndex <> 3 then Warnlog "Vertikal by is not 3 but " + Vertikal.GetSelIndex
   Kontext
   active.SetPage TabZusaetze
  Kontext "TabZusaetze"
   if ObjektName.GetText <> "Ein Chart ein Chart, jajaj" then warnlog "Name is wrong!"
   if NOT InhaltSchuetzen.IsChecked then Warnlog "Protect Contents is not checked anymore!"
   if NOT PositionSchuetzen.IsChecked then Warnlog "Protect size is not checked anymore"
   if Drucken.IsChecked then Warnlog "Print is checked again"
   Kontext
   active.SetPage TabUmlauf
  Kontext "TabUmlauf"
   if NOT Parallel.IsChecked then Warnlog "Parallel is not checked."
   if NOT Kontur.IsChecked then Warnlog "Contour is not checked."
   if NOT NurAussen.IsChecked then Warnlog "Contour 'Only Outside' is not checked"
   if AbstaendeUnten.GetText <> w3 then Warnlog "Left Spacing is not " + w3 + " but " + AbstaendeLinks.GetText
   TabUmlauf.Cancel
  catch
    Warnlog "- Unable to edit object!"
  endcatch

   Call wDocSetContext
   ToolsOptions
   Call hToolsOptions("TextDocument","FormattingAids")
   '/// Recheck Direct cursor in options ///
   Zonen_Cursor.Check
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   '/// Close document ///
   Call hCloseDocument
endcase
'**********************************************************************************
testcase tFormatWrapChart
   '/// New writerdocument ///
   Call hNewDocument
   '/// Insert Autotext 'Dummy text' ///
   Call wBlindtextEinfuegen
   Call wDokSchreiben "<Up>", 10
   '/// Insert a chart ///
   Call hEinfuegenChart

  printlog "- Chart anchored to paragraph"
   '/// Anchor chart to paragraph ///
   FormatAnchorToParagraph
   wait 500
  printlog "  - all Wrap methods with Contour"
   '/// all wrap methods ///
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   wait 500
   try
    FormatWrapContour
    wait 500
   catch
    Warnlog "Format Wrap Contour doesn't work!"
   endcatch
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   wait 500
   try
    FormatWrapContour
    Warnlog "Format Wrap Contour is enabled!"
    wait 500
   catch
   endcatch
   FormatWrapInBackground
   wait 500

  printlog "  - all Wrap methods with 1. Paragraph"
   FormatWrapFirstParagraph
   wait 500
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   wait 500
   FormatWrapInBackground
   wait 500

  printlog "  - all Wrap methods with 1. Paragraph and contour"
   FormatWrapNoWrap
   wait 500
   FormatWrapPageWrap
   try
    FormatWrapContour
    wait 500
   catch
    Warnlog "Format Wrap Contour doesn't work!"
   endcatch
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
   FormatWrapThrough
   wait 500
   try
    FormatWrapContour
    wait 500
    Warnlog "Format Wrap Contour is ensabled!"
   catch
   endcatch
   FormatWrapInBackground
   wait 500

  printlog "- Chart anchored to character"
   '/// Anchor chart to character ///
   FormatAnchorToCharacter
   wait 500
  printlog "- Chart anchored to page"
   '/// Anchor chart to page ///
   FormatAnchorToPage
   wait 500
   try
    FormatWrapNoWrap
   catch
    Warnlog "'No Wrap' on object anchored to page doesn't work!"
   endcatch
   wait 500
   FormatWrapPageWrap
   wait 500
   FormatWrapOptimalPageWrap
   wait 500
  try
   FormatWrapThrough
  catch
   Warnlog "'Wrap through' doesn't wor when object is anchored to page!"
  endcatch
   wait 500
   FormatWrapInBackground
   wait 500
   try
      FormatWrapFirstParagraph
      Warnlog "When object is anchored to page, Wrap to paragraph has to be inactive!"
   catch
   endcatch

   Sleep 1
   '/// Close document ///
   Call hCloseDocument
endcase

