'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_205_.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: hde $ $Date: 2005/11/08 14:03:43 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Testing Number and Bullets
'*
'\***********************************************************************

sub w_205_
	
    Call tNumberingBullets_1
    'Call tNumberingBullets_2  ' should be fixed by me (HDE)
    Call tFormatNumberingBullets
    Call tFormatNumberingPosition
    Call tFormatNumberingOptions
    Call tFormatNumberingAll

end sub

testcase tNumberingBullets_1
	
    printlog "Turn several selected paragraphs into numbered list"
	'/// Open a new text document
    Call hNewDocument()
    '/// Insert 3 times dummy text
    Call wBlindTextEinfuegen()
    Call wBlindTextEinfuegen()
    Call wBlindTextEinfuegen()
    '/// Select all inserted text 
    Call wDokSchreiben "<shift mod1 home>"

    '/// Choose 'Numbering' on 'Objectbar'
    Kontext "TextObjectbar"
    try
        Numerierung.Click
	catch
      	warnlog "Objectbar is not accessible for numbering bullets"
	endcatch
    '/// Check if numbering has been created
    if (hIsNumberingBullets () <> True) then
        Warnlog " - Seems numbering has not been created"
    else
      	printlog " - Numbering has been created"
	endif

    '/// Turn numbereing off via Toolbar
    Printlog "Turn Numbering off"
    OL_Writer_Numerierung
    '/// Check if numbering has been turned off
    if (hIsNumberingBullets () <> False) then
        warnlog " - Seems numbering is still available"
    else
        printlog " - Numbering has been turned off"
    endif

    Printlog "'/// Restart counting via Format->Paragraph->Numbering ///"
    Call hFormatParagraphNumbering ("",1,-1)
    if (hIsNumberingBullets () <> True) then
      	Warnlog "Seems numbering has not been created"
    else
      printlog "Numbering has been created"
    endif

    Printlog "'/// +O+ restart numbering enable///"
    ' checked 'restart numbering' on tabpage toggles icon at Objectbar
    Kontext "NumObjectbar"
    if Not NumObjectBar.Exists then Call hToolbarSelect ( "BULLETSANDNUMBERING", true )
    
    ' Button in objectbar has to be checked
    if NeuStarten.GetState(2) <> 1 then
        warnlog "Button 'Restart Numbering' not pressed!"
        NeuStarten.Click
        sleep (1)
        if NeuStarten.GetState(2) <> 1 then
            warnlog "doesn't work"
        else
            printlog "     --- worked :-)"
        endif
    else
        ' Undo 'restart numbering'
        Printlog "'                          disable"
        NeuStarten.Click
        sleep (1)
        if NeuStarten.GetState(2) <> 0 then
            warnlog "doesn't work "
        else
            printlog "     --- worked :-)"
        endif
    endif
    
    Call hCloseDocument

endcase

'------------------------------------------------------------------------------

testcase tNumberingBullets_2
  dim aLevel(255,2) as integer ' has to be initialisied !!!!
  dim sTempSearch as string ' is used for hFindInDocument
  dim sTemp as string
  dim i as integer ' loopcounter
  dim x as integer ' loopcounter
  dim y as integer ' loopcounter
  aLevel(0,0) = 10 ' size of array

  Call hNewDocument()
'left right------------------------------------------------------------------------------
   ' now insert some text, to find & check if movved up/down

'-----------------------------------------
'------------START 1-10 TEST--------------
'-----------------------------------------
'------INIT-----------------------------------
'-----------------------------------------
' move it into init function sometime...TBO
  for i=1 to 10
     aLevel(i,1) = 1 ' horizontlevel
     aLevel(i,2) = i ' imagine a list as vertical order
  next i

'-----------------------------------------
  printlog "--------------------"
   Call hLeisteUmschalten(1)
   Numerierung.Click
   Call wDokSchreiben "1<return>"

      FormatNumberingBullets
      Kontext
      Active.SetPage TabOptionenNumerierung
      Kontext "TabOptionenNumerierung"
   '---------------------------------------------
   ' ++ has to move into style !!!
   '---------------------------------------------
   'since the level is now chekcable easylie: set format to check
   ' call Format::NumberingBullets::Ooptions
   ' select level '1-10' set numbering to '1,2,3, ...' Before & After '-'
      Ebene.Select 11 '1-10
      Numerierung.Select 1            ' 1,2,3, ...
      Davor.SetText "-"
      Dahinter.SetText "-"
      Zeichenvorlage.Select 1
      Vollstaendig.ToMax
      BeginnBei.ToMin ' -> start at 0 !!!! TBO: did i realy want that ??? ;-)
      try
      BeginnBei.More
      catch ' not quite shure!
      endcatch
   '---------------------------------------------
      TabOptionenNumerierung.Ok

   for i = 2 to 7         ' insert in 'one column'
       Call wDokSchreiben str(i)+"<home><delete><end><return>" ' :-)))) ' delete space from str()
   next i
   Call wDokSchreiben "<mod1 home>"  ' go to line #1

   Call hLevelPrint(aLevel())
   Call wDokSchreiben "<mod1 home>"  ' go to line #1

'for everything are y
' s/o for every x
' existing/whiletyping/block
  Printlog "'/// +++ move entries ///"
' FIRST move all entries, then sort & check
  Printlog "'/// +O+ with Objectbar ///"
'*NumObjectbar     TB_SW_NUM_TOOLBOX
'   Kontext "NumObjectbar"
'=========================================
  Printlog "'/// +S+ with Shortcuts ///"
  Printlog "'///     -S- single entry left/right ///"
'  wDokSchreiben "<shift tab>"
   for x = 0 to 2                      ' 1...3
      for y = 1 to (x mod 3)
         Call wDokSchreiben "<tab>"
         Call hLevelChange(aLevel(),x+1,+1,0,FALSE)
      next y
      Call wDokSchreiben "<down><home>"
   next x
  Printlog "'///     -O- single entry left/right ///"

   for x = 3 to 5                      ' 4...6
      Kontext "NumObjectbar"
      for y = 1 to (x mod 3)
'         sleep (1)
      Kontext "NumObjectbar"
         try
'         sleep (1)
            Hinunterstufen.Click  '       FN_NUM_BULLET_DOWN
         catch
            printlog "+++++catching "+x +" "+y
         endcatch
         hLevelChange(aLevel(),x+1,+1,0,FALSE)
      next y
      wDokSchreiben "<down><home>"
   next x
  Printlog "'///     -S- new single entry left/right ///"
  ' there is a autoindent feature :-)
   Call wDokSchreiben "7"                     ' 7
   Call wDokSchreiben "<return>"
   for x = 7 to 8                        ' 8...9
      Call wDokSchreiben "<tab>"
      Call wDokSchreiben str(x+1)+"<home><delete><end>"
      Call hLevelChange(aLevel(),x+1,+1,0,FALSE)  ' ALMOST, AUTOINDENT :-(
      Call wDokSchreiben "<home><end>" ' deselect
      Call wDokSchreiben "<return>"
   next x
   Call wDokSchreiben "<up>"  ' going to right line!
   Call hLevelChange(aLevel(),9,+1,0,FALSE)  ' ALMOST, AUTOINDENT :-(
   Call wDokSchreiben "<down>"
   Call wDokSchreiben "10" ' has to move left 3 times     '10
   Call hLevelChange(aLevel(),10,+2,0,FALSE)  ' what*s that for?
   Call wDokSchreiben "<home>"
   for x = 1 to 2
      Call wDokSchreiben "<shift tab>"
      Call hLevelChange(aLevel(),10,-1,0,FALSE)  ' what*s that for? :-) move to LEFT !!!
   next x

   Call hLevelPrint(aLevel())
'print "check errorlog & compare to real life ;-)"

' this is extensible ?! as much as you like; every left/right w/o sublevel; if big enough!
'------------------------------------------------------------------
'------------created paragraphs 1-10 ------------------------------
'------------------------------------------------------------------
  Printlog "'///     -O- single entry with sublevels left/right ///"

   Call hFindInDocument "7"

' it seems, som eslots get ignored or so....

   for i = 1 to 3
      Kontext "NumObjectbar"
      try
       HinunterstufenMitUnterpunkten.Click '  FN_NUM_BULLET_OUTLINE_DOWN
      catch
       Call hLeisteUmschalten(2)
       HinunterstufenMitUnterpunkten.Click
      endcatch
      Call hLevelChange(aLevel(),7,+1,0,TRUE)
   next i

  Printlog "'///     -O- single entry with sublevels up/down ///"
   for i = 1 to 3
      Kontext "NumObjectbar"
      try
       HochschiebenMitUnterpunkten.Click '  FN_NUM_BULLET_OUTLINE_MOVEUP
      catch
       Call hLeisteUmschalten(2)
       HochschiebenMitUnterpunkten.Click
      endcatch
      Call hLevelChange(aLevel(),7,0,-1,TRUE)
   next i
   Call wDokSchreiben "<up>"
   for i = 1 to 3
      Kontext "NumObjectbar"
      try
       HinunterschiebenMitUnterpunkten.Click
      catch
       Call hLeisteUmschalten(2)
       HochschiebenMitUnterpunkten.Click
      endcatch
      Call hLevelChange(aLevel(),3,0,+1,TRUE)

   next i
   Call hLevelPrint(aLevel())

' #######################################
'#--------------------------------------#
'#| ok, here is where i'm working now! |#
'#--------------------------------------#
'#######################################

  Printlog "'///     -S- single entry up/down (works with EVERY writer paragraph) ///"
  ' but here the hole line should be moved
'wDokSchreiben "<mod1 Down>"
   Call hFindInDocument "9"
   for i = 1 to 3
      Call wDokSchreiben "<mod1 Up>"
      Call hLevelChange(aLevel(),9,0,+1,TRUE)
   next i
   Call hLevelPrint(aLevel())
  Printlog "'///     -O- single entry up/down ///"
   Call hFindInDocument "8"
   for i = 1 to 3
      Kontext "NumObjectbar"
      Hochschieben     '      FN_NUM_BULLET_MOVEUP
      Call hLevelChange(aLevel(),8,0,-1,TRUE)
   next i
   Call hLevelPrint(aLevel())

 Printlog "'/// now let's put it to the right place again :-) ///"
'-----------------------------------------------------------------
  Printlog "'///     -S- single entry left/right ///"
   Call hFindInDocument "6"
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   hLevelChange(aLevel(),6,-1,0,TRUE)
   ' CHECK !OK
   wDokSchreiben "<shift tab>"
   hLevelChange(aLevel(),6,-1,0,TRUE)
   ' CHECK OK!
  Printlog "'///     -O- single entry left/right ///"
   hFindInDocument "3"
   Kontext "NumObjectbar"
   Hinunterstufen     '    FN_NUM_BULLET_DOWN
   hLevelChange(aLevel(),3,-1,0,TRUE)
   ' CHECK !OK
   Kontext "NumObjectbar"
   Hinunterstufen     '    FN_NUM_BULLET_DOWN
   hLevelChange(aLevel(),3,-1,0,TRUE)
   ' CHECK OK!
'------------------------------------------------------------------
  Printlog "'///     -O- single entry with sublevels left/right ///"
   hFindInDocument "8"
   for i = 1 to 3
      Kontext "NumObjectbar"
      HinunterstufenMitUnterpunkten '  FN_NUM_BULLET_OUTLINE_DOWN
      hLevelChange(aLevel(),8,-1,0,TRUE)
   next i
   ' CHECK !OK
   Kontext "NumObjectbar"
   HinunterstufenMitUnterpunkten  ' FN_NUM_BULLET_OUTLINE_DOWN
   hLevelChange(aLevel(),8,-1,0,TRUE)
   ' CHECK OK!
  Printlog "'///     -O- single entry with sublevels up/down ///"
   hFindInDocument "8"
   for i = 1 to 4
      Kontext "NumObjectbar"
      HinunterschiebenMitUnterpunkten '  FN_NUM_BULLET_OUTLINE_MOVEDOWN
      hLevelChange(aLevel(),8,0,+1,TRUE)
   next i
  Printlog "'///     -S- single entry up/down (works with EVERY writer paragraph) ///"
   hFindInDocument "7"
   for i = 1 to 2
      wDokSchreiben "<mod1 Down>"
      hLevelChange(aLevel(),7,-1,0,TRUE)
   next i
  Printlog "'///     -O- single entry up/down ///"
   Kontext "NumObjectbar"
   Hinunterschieben   '    FN_NUM_BULLET_MOVEDOWN
'----------------------------------------------------
   hFindInDocument "2"
   ' CHECK !OK
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK OK!
   hFindInDocument "5"
   ' CHECK !OK
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK OK!
   hFindInDocument "7"
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   Call wDokSchreiben "<shift tab>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK !OK
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK OK!
   hFindInDocument "8"
   ' CHECK !OK
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK OK!
   hFindInDocument "7"
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK !OK
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift tab>"
   ' CHECK OK!
'----------------------------------------------------
' Nette idee :-) array, das fuer jede zeile die einrueckung und zeile verwaltet (muessen alle positiv sein)
   Call wDokSchreiben "<mod1 home>"
   for i = 1 to 10
      x = val (hLevelContent())
      if x <> i then warnlog "Wrong is: "+x+"should: "+i
      Call wDokSchreiben "<down>"
   next i

   hLevelPrint(aLevel())

   for x = 0 to 9
      Call wDokSchreiben "<tab>"
      Call wDokSchreiben (str(x+1)+"<home><delete><end>")
      Call wDokSchreiben "<return>"
   next x

  Printlog "'///     -S- block of entry left/right ///"
'------------------------------------------------------------------------------
' ???????? If not hol÷e row is marked up to the beginning, the hole line is copied
'   BUT if not marked to the end, the end isn't copied ??????????????????
' Special case try at end !!!
'------------------------------------------------------------------------------
   ' some more BUT
   ' start OR end has to be at BEGINNING of line
'up down------------------------------------------------------------------------------
  Printlog "'///     --- block of entry up/down ///"
  Printlog "'///         ... block boundary not end/beginning of entry ///"
   Call wDokSchreiben "<home><right>"
   Call wDokSchreiben "<shift down>"
   Call wDokSchreiben "<shift right><shift right>"
  Printlog "'///         ... block boundary whole lines ///"
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift down>"
   Call wDokSchreiben "<shift end>"
'------------------------------------------------------------------------------
  Printlog "'/// +S+ copy block via clippboard ///"
'------------------------------------------------------------------------------
  Printlog "'/// +S+ insert unnumbered paragraph ///"
   Call wDokSchreiben "<backspace>" ' at beginning of new line; number disappears
  Printlog "'/// +O+ insert unnumbered paragraph ///"
'------------------------------------------------------------------------------
  Printlog "'/// +O+ delete entries ///"
  Printlog "'///     ... selection of numbered blocks ///"
   Call wDokSchreiben "<home>"
   Call wDokSchreiben "<shift down>"
   Call wDokSchreiben "<delete>"
  Printlog "'///     ... single entry at next line with del at end of line ///"
   Call wDokSchreiben "<end>"
   Call wDokSchreiben "<delete>" '-> just linefeed and number disappears; text is added to current line
'------------------------------------------------------------------------------
  Printlog "'/// +++  stop numbering ///"
  Printlog "'///      -O- numbering :-)  ///"
  Printlog "'///      -O- text :-)  ///"
   Kontext "NumObjectbar"
'NumerierungAufzaehlung   FN_NUMBER_BULLETS
'ExtrasNumerierungAufzaehlung/FormatNumberingBullets/FormatNumerierungAufzaehlung/OL_Numerierung_NumerierungAufzaehlung   FN_NUMBER_BULLETS
   'Kontext "TextObjectbar"
   'Numerierung.Click
  Printlog "'///      -S- :-)  ///"
   Call wDokSchreiben "<end>"
   Call wDokSchreiben "<return>"
   Call wDokSchreiben "<return>"

   Call hCloseDocument ()
endcase


'--------------------------------------------------
testcase tFormatNumberingBullets
	Dim i as Integer :
	PrintLog "- Format / Numbering and Bullets"
	
	'/// New document ///
	Call hNewDocument
	
	printlog "  - All bullet entries"
	'/// Insert all bullet entries ///
	for i=1 to 8
		FormatNumberingBullets
		Kontext
		Active.SetPage TabBullet
		Kontext "TabBullet"
		Auswahl.TypeKeys "<Right>", i
		TabBullet.OK
		Call wDokSchreiben "Bullet <Return><Return>"
	next i
	
	printlog "  - All Numbering entries"
	'/// Insert all numbering entries ///
	for i=1 to 8
		FormatNumberingBullets
		Kontext
		Active.SetPage TabNumerierungsart
		Kontext "TabNumerierungsart"
		Auswahl.TypeKeys "<Right>", i
		TabNumerierungsart.OK
		Call wDokSchreiben "Nummerierungsart <Return><Return>"
		Sleep 1
	next i
	
	printlog "  - All entries in Level"
	'/// Insert all level entries ///
	for i=1 to 8
		FormatNumberingBullets
		Kontext
		Active.SetPage TabGliederung
		Kontext "TabGliederung"
		Auswahl.TypeKeys "<Right>", i
		TabGliederung.OK
		Call wDokSchreiben "Gliederung <Return><Return>"
		Sleep 1
	next i
	
	printlog "  - All entries in graphic"
	'/// Insert all graphic entries ///
	for i=1 to 29
		FormatNumberingBullets
		Kontext
		Active.SetPage TabGrafiken
		Kontext "TabGrafiken"
		wait 500
		Auswahl.TypeKeys "<Right>", i
		TabGrafiken.OK
		Call wDokSchreiben "Grafik <Return><Return>"
		Sleep 1
	next i
	
	printlog "  - Save document and reload"
	'/// Save document, close and reopen previous saved document ///
	Call hSpeichernUnterKill ( gOfficePath + "user\work\format4." & WriterFilterExtension(0) )
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hDateiOeffnen ( gOfficePath + "user\work\format4." & WriterFilterExtension(0) )
	Sleep 2
	'/// Close document ///
	Call hCloseDocument
endcase

'--------------------------------------------------
testcase tFormatNumberingPosition
    Dim V1 : Dim V2 :  Dim V3 : Dim V4 :  Dim V5 : Dim V6 :  Dim V7 : Dim V8 : Dim V9 : Dim V10
    Dim V11 : Dim V12 :  Dim V13 : Dim V14 :  Dim V15 : Dim V16

    printlog "  - adjust position of Numbering"
    '/// New document ///
    Call hNewDocument
    '/// Select Format / Numbering Bullets and adjust position for each level ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Ebene.Select 1
    Ausrichtung.Select 2         ' Zentriert
    if Relativ.IsEnabled then Warnlog "Relativ is enabled with level1!"
    AbstandTextRand.More 5
    V1 = AbstandTextRand.GetText
    Einrueckung.More 1
    V2 = Einrueckung.GetText
    Ebene.Select 3
    Ausrichtung.Select 3         ' Rechts
    Relativ.Check
    AbstandTextRand.Less 5
    V3 = AbstandTextRand.GetText
    AbstandTextNumerierung.More 2
    V4 = AbstandTextNumerierung.GetText
    Ebene.Select 4
    Ausrichtung.Select 1         ' Links
    Relativ.Check
    V5 = AbstandTextRand.GetText
    V6 = AbstandTextNumerierung.GetText
    V7 = Einrueckung.GetText
    Ebene.Select 6
    Ausrichtung.Select 3         ' Rechts
    Relativ.Check
    AbstandTextRand.More 4
    V8 = AbstandTextRand.GetText
    AbstandTextNumerierung.Less 3
    V9 = AbstandTextNumerierung.GetText
    Einrueckung.Less 3
    V10 = Einrueckung.GetText
    Ebene.Select 9
    Ausrichtung.Select 1
    Relativ.Check
    AbstandTextRand.Less 2
    V11 = AbstandTextRand.GetText
    AbstandTextNumerierung.More 2
    V12 = AbstandTextNumerierung.GetText
    Einrueckung.More 3
    V13 = Einrueckung.GetText
    Ebene.Select 10
    Ausrichtung.Select 3
    Relativ.Check
    AbstandTextRand.More 4
    V14 = AbstandTextRand.GetText
    AbstandTextNumerierung.Less 3
    V15 = AbstandTextNumerierung.GetText
    Einrueckung.Less 3
    V16 = Einrueckung.GetText
    TabPositionNumerierung.OK

    printlog "  - write down numbering"
    '/// write down the numbering ///
    Call wDokSchreiben "Nummerierung 1. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 2. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 3. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 4. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 5. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 6. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 7. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 8. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 9. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung  10. Ebene<Return>"
    Call wDokSchreiben "<Tab>Immer noch 10. Ebene<Return>"
    Call wDokSchreiben "<Return><Return>Ende der Nummerierung"
    Call wDokSchreiben "<Up>", 5

    printlog "  - check numbering-position"
    '/// reopen Format / NumberingBullets and check settings made ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Ebene.Select 1
    if Ausrichtung.GetSelIndex <> 2 then Warnlog "#i38904#Level 1: Wrong alignment:  Should = 2   Ist = "+ Ausrichtung.GetSelIndex
    if V1 <> AbstandTextRand.GetText then Warnlog "Level 1: Wrong Text <-> Rand:  Should = "+ V1+ "  Is = "+ AbstandTextRand.GetText
    if V2 <> Einrueckung.GetText then Warnlog "Level 1: Wrong indent:  Should = "+ V2+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 3
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 3!"
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 3: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V3 <> AbstandTextRand.GetText then Warnlog "Level 3: Wrong Text <-> Spacing to text:  Should = "+ V3+ "  Is = "+ AbstandTextRand.GetText
    if V4 <> AbstandTextNumerierung.GetText then Warnlog "Level 3: Wrong indent:  Should = "+ V4+ "  Is = "+ AbstandTextNumerierung.GetText
    Ebene.Select 4
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 4!"
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 4: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V5 <> AbstandTextRand.GetText then Warnlog "Level 4: Wrong Text <-> Spacing to text:  Should = "+ V5+ "  Is = "+ AbstandTextRand.GetText
    if V6 <> AbstandTextNumerierung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V6+ "  Is = "+ AbstandTextNumerierung.GetText
    if V7 <> Einrueckung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V7+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 6
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 6!"
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 6: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V8 <> AbstandTextRand.GetText then Warnlog "Level 6: Wrong Text <-> Spacing to text:  Should = "+ V8+ "  Is = "+ AbstandTextRand.GetText
    if V9 <> AbstandTextNumerierung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V9+ "  Is = "+ AbstandTextNumerierung.GetText
    if V10 <> Einrueckung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V10+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 9
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 9!"
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 9: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V11 <> AbstandTextRand.GetText then Warnlog "Level 9: Wrong Text <-> Spacing to text:  Should = "+ V11+ "  Is = "+ AbstandTextRand.GetText
    if V12 <> AbstandTextNumerierung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V12+ "  Is = "+ AbstandTextNumerierung.GetText
    if V13 <> Einrueckung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V13+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 10
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 10!"
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 10: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V14 <> AbstandTextRand.GetText then Warnlog "Level 10: Wrong Text <-> Spacing to text:  Should = "+ V14+ "  Is = "+ AbstandTextRand.GetText
    if V15 <> AbstandTextNumerierung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V15+ "  Is = "+ AbstandTextNumerierung.GetText
    if V16 <> Einrueckung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V16+ "  Is = "+ Einrueckung.GetText
    TabPositionNumerierung.Ok

    printlog "  - check previous saved numbering"
    '/// save document, close it and reload previous saved document ///
    Sleep 1
    Call hSpeichernUnterKill ( gOfficePath + "user\work\tFormatNumberingPosition." & WriterFilterExtension(0) )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\tFormatNumberingPosition." & WriterFilterExtension(0) )

    '/// check settings on Format / NumberingBullets ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Ebene.Select 1
    
    if Ausrichtung.GetSelIndex <> 2 then Warnlog "#i38904#Level 1: Wrong alignment:  Should = 2   Ist = "+ Ausrichtung.GetSelIndex
    if V1 <> AbstandTextRand.GetText then Warnlog "Level 1: Wrong Text <-> Rand:  Should = "+ V1+ "  Is = "+ AbstandTextRand.GetText
    if V2 <> Einrueckung.GetText then Warnlog "Level 1: Wrong indent:  Should = "+ V2+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 3
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 3: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V3 <> AbstandTextRand.GetText then Warnlog "Level 3: Wrong Text <-> Spacing to text:  Should = "+ V3+ "  Is = "+ AbstandTextRand.GetText
    if V4 <> AbstandTextNumerierung.GetText then Warnlog "Level 3: Wrong indent:  Should = "+ V4+ "  Is = "+ AbstandTextNumerierung.GetText
    Ebene.Select 4
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 4: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V5 <> AbstandTextRand.GetText then Warnlog "Level 4: Wrong Text <-> Spacing to text:  Should = "+ V5+ "  Is = "+ AbstandTextRand.GetText
    if V6 <> AbstandTextNumerierung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V6+ "  Is = "+ AbstandTextNumerierung.GetText
    if V7 <> Einrueckung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V7+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 6
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 6: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V8 <> AbstandTextRand.GetText then Warnlog "Level 6: Wrong Text <-> Spacing to text:  Should = "+ V8+ "  Is = "+ AbstandTextRand.GetText
    if V9 <> AbstandTextNumerierung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V9+ "  Is = "+ AbstandTextNumerierung.GetText
    if V10 <> Einrueckung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V10+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 9
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 9: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V11 <> AbstandTextRand.GetText then Warnlog "Level 9: Wrong Text <-> Spacing to text:  Should = "+ V11+ "  Is = "+ AbstandTextRand.GetText
    if V12 <> AbstandTextNumerierung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V12+ "  Is = "+ AbstandTextNumerierung.GetText
    if V13 <> Einrueckung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V13+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 10
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 10: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V14 <> AbstandTextRand.GetText then Warnlog "Level 10: Wrong Text <-> Spacing to text:  Should = "+ V14+ "  Is = "+ AbstandTextRand.GetText
    if V15 <> AbstandTextNumerierung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V15+ "  Is = "+ AbstandTextNumerierung.GetText
    if V16 <> Einrueckung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V16+ "  Is = "+ Einrueckung.GetText
    TabPositionNumerierung.Cancel
    Sleep 1
    '/// Close document ///
    Call hCloseDocument
endcase

'--------------------------------------------------

testcase tFormatNumberingOptions
    Dim V1 : Dim V2 : Dim V3 : Dim V4 : Dim V5 : Dim V6 : Dim V7 : Dim V8 : Dim V9 : Dim V10
    Dim i as integer

    printlog "  - adjust numbering properties"
    '/// New document ///
    Call hNewDocument
    '/// Select Format / Numbering Bullets and adjust properties for each level ///
    FormatNumberingBullets

    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"

    Ebene.Select 1
    Numerierung.Select 11           ' Keine
    Davor.SetText "Vorher "
    Dahinter.SetText "sp�ter "

    Ebene.Select 3
    Numerierung.Select 2            ' A,B,C,...
    Davor.SetText "��� "
    Dahinter.SetText "��� "
    Zeichenvorlage.Select 2
    V9 = Zeichenvorlage.GetSelText
    Vollstaendig.Less 1
    V1 = Vollstaendig.GetText
    BeginnBei.More 4
    V2 = BeginnBei.GetText

    Ebene.Select 5
    Numerierung.Select 8            ' Bullets
    if Davor.IsVisible then Warnlog "'Before' is visible on Bullet-Options"
    if Dahinter.IsVisible then Warnlog "'After' is visible on Bullet-Options"
    Zeichenvorlage.Select 1

    Ebene.Select 7
    Numerierung.Select 9            ' Grafik
    if Davor.IsVisible then Warnlog "'Before' is visible on Graphic-Options"
    if Dahinter.IsVisible then Warnlog "'After' is visible on Graphic-Options"
    Auswahl.Click
    Call hMenuSelectNr (1)
    Kontext "OeffnenDlg"
    Dateiname.Settext Convertpath(gtesttoolpath + "writer\input\grafik\bullet.gif")
    Oeffnen.Click
    wait 500
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif

    Kontext "TabOptionenNumerierung"
    Breite.More 4
    V3 = Breite.GetText
    Hoehe.More 3
    V4 = Hoehe.GetText
    Ausrichtung.Select 4

    Ebene.Select 9
    Numerierung.Select 1            ' 1,2,3,...
    Zeichenvorlage.Select 3
    V10 = Zeichenvorlage.GetSelText

    Ebene.Select 10
    Numerierung.Select 3            ' a,b,c,...
    V5 = Davor.GetText
    V6 = Dahinter.GetText
    Vollstaendig.More 9
    V7 = Vollstaendig.GetText
    BeginnBei.More 3
    V8 = BeginnBei.GetText
    TabOptionenNumerierung.OK

    printlog "  - write down numbering"
    '/// write down numbering ///
    Call wDokSchreiben "Hallo 1. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 2. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 3. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 4. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 5. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 6. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 7. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 8. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 9. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 10. Ebene<Return>"
    Call wDokSchreiben "<Tab>Immer noch 10. Ebene<Return>"
    Call wDokSchreiben "<Return><Return>Ende der Numerierung"
    Call wDokSchreiben "<Up>", 5

    FormatNumberingBullets
    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Ebene.Select 1
    if Numerierung.GetSelIndex <> 11 then Warnlog "Level 1: Wrong Numbering type : Should 11     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "Vorher " then Warnlog "Level 1: Wrong Text in 'After': Should 'Vorher '    Is " + Davor.GetText
    if Dahinter.GetText <> "sp�ter " then Warnlog "Level 1: Wrong Text in 'Before': Should 'sp�ter '    Is " + Dahinter.GetText
    Ebene.Select 3
    if Numerierung.GetSelIndex <> 2 then Warnlog "Level 3: Wrong Numbering type : Should 2     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'Before': Should '��� '    Is " + Davor.GetText
    if Dahinter.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'After': Should '��� '    Is " + Dahinter.GetText
    if Zeichenvorlage.GetSelText <> V9 then Warnlog "Level 3: Wrong Character Style: Should " + V9 + "    Is " + Zeichenvorlage.GetSelText
    if V1 <> Vollstaendig.GetText then Warnlog "Level 3: 'Show Sublevels' Is wrong: Should " + V1 + "   Is: " + Vollstaendig.GetText
    if V2 <> BeginnBei.GetText then Warnlog "Level 3: 'Start at'  Is wrong: Should " + V2 + "   Is: " + BeginnBei.GetText
    Ebene.Select 5
    if Numerierung.GetSelIndex <> 8 then Warnlog "Level 5: Wrong Numbering type : Should 8     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelIndex <> 1 then Warnlog "Level 5: Wrong Character Style: Should 1    Is " + Zeichenvorlage.GetSelIndex
    Ebene.Select 7
    if Numerierung.GetSelIndex <> 9 then
        Warnlog "Level 7: Wrong Numbering type : Should 9     Is " + Numerierung.GetSelIndex
    else
        if V3 <> Breite.GetText then Warnlog "Level 7: Wrong graphic width: Should " + V3 + "   Is: " + Breite.GetText
        if V4 <> Hoehe.GetText then Warnlog "Level 7: Wrong graphic height: Should " + V4 + "   Is: " + Hoehe.GetText
        if Ausrichtung.GetSelIndex <> 4 then Warnlog "Level 7: Alignment Is not 4 but " + Ausrichtung.GetSelIndex
    endif
    Ebene.Select 9
    if Numerierung.GetSelIndex <> 1 then Warnlog "Level 9: Wrong Numbering type : Should 1     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelText <> V10 then Warnlog "Level 9: Wrong Character Style: Should " + V10 +"    Is " + Zeichenvorlage.GetSelText
    Ebene.Select 10
    if Numerierung.GetSelIndex <> 3 then Warnlog "Level 10: Wrong Numbering type : Should 3     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> V5 then Warnlog "Level 10: Wrong Text in 'Before': Should "+ V5 + "    Is " + Davor.GetText
    if Dahinter.GetText <> V6 then Warnlog "Level 10: Wrong Text in 'After': Should "+ V6 + "    Is " + Dahinter.GetText
    if V7 <> Vollstaendig.GetText then Warnlog "Level 10: 'Show Sublevels' Is wrong: Should " + V7 + "   Is: " + Vollstaendig.GetText
    if V8 <> BeginnBei.GetText then Warnlog "Level 10: 'Start at'  Is wrong: Should " + V8 + "   Is: " + BeginnBei.GetText
    TabOptionenNumerierung.Cancel

    printlog "  - check previous saved numbering"
    '/// save document, close it and reload previous saved document ///
    Call hSpeichernUnterKill ( gOfficePath + "user\work\format6." & WriterFilterExtension(0) )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\format6." & WriterFilterExtension(0) )
    For i = 1 to 15
        Call wDokSchreiben "<Up>"
        Wait 500
    next i
    Call wDokSchreiben "<Home>"

    '/// check settings in Format / Numbering Bullets ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Ebene.Select 1
    if Numerierung.GetSelIndex <> 11 then Warnlog "Level 1: Wrong Numbering type : Should 11     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "Vorher " then Warnlog "Level 1: Wrong Text in 'After': Should 'Vorher '    Is " + Davor.GetText
    if Dahinter.GetText <> "sp�ter " then Warnlog "Level 1: Wrong Text in 'Before': Should 'sp�ter '    Is " + Dahinter.GetText
    Ebene.Select 3
    if Numerierung.GetSelIndex <> 2 then Warnlog "Level 3: Wrong Numbering type : Should 2     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'Before': Should '��� '    Is " + Davor.GetText
    if Dahinter.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'After': Should '��� '    Is " + Dahinter.GetText
    if Zeichenvorlage.GetSelText <> V9 then Warnlog "Level 3: Wrong Character Style: Should " + V9 + "    Is " + Zeichenvorlage.GetSelText
    if V1 <> Vollstaendig.GetText then Warnlog "Level 3: 'Show Sublevels' Is wrong: Should " + V1 + "   Is: " + Vollstaendig.GetText
    if V2 <> BeginnBei.GetText then Warnlog "Level 3: 'Start at'  Is wrong: Should " + V2 + "   Is: " + BeginnBei.GetText
    Ebene.Select 5
    if Numerierung.GetSelIndex <> 8 then Warnlog "Level 5: Wrong Numbering type : Should 8     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelIndex <> 1 then Warnlog "Level 5: Wrong Character Style: Should 1    Is " + Zeichenvorlage.GetSelIndex
    Ebene.Select 7
    if Numerierung.GetSelIndex <> 9 then
        Warnlog "Level 7: Wrong Numbering type : Should 9     Is " + Numerierung.GetSelIndex
    else
        if V3 <> Breite.GetText then Warnlog "Level 7: Wrong graphic width: Should " + V3 + "   Is: " + Breite.GetText
        if V4 <> Hoehe.GetText then Warnlog "Level 7: Wrong graphic height: Should " + V4 + "   Is: " + Hoehe.GetText
        if Ausrichtung.GetSelIndex <> 4 then Warnlog "Level 7: Alignment Is not 4 but " + Ausrichtung.GetSelIndex
    endif
    Ebene.Select 9
    if Numerierung.GetSelIndex <> 1 then Warnlog "Level 9: Wrong Numbering type : Should 1     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelText <> V10 then Warnlog "Level 9: Wrong Character Style: Should " + V10 +"    Is " + Zeichenvorlage.GetSelText
    Ebene.Select 10
    if Numerierung.GetSelIndex <> 3 then Warnlog "Level 10: Wrong Numbering type : Should 3     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> V5 then Warnlog "Level 10: Wrong Text in 'Before': Should "+ V5 + "    Is " + Davor.GetText
    if Dahinter.GetText <> V6 then Warnlog "Level 10: Wrong Text in 'After': Should "+ V6 + "    Is " + Dahinter.GetText
    if V7 <> Vollstaendig.GetText then Warnlog "Level 10: 'Show Sublevels' Is wrong: Should " + V7 + "   Is: " + Vollstaendig.GetText
    if V8 <> BeginnBei.GetText then Warnlog "Level 10: 'Start at'  Is wrong: Should " + V8 + "   Is: " + BeginnBei.GetText
    TabOptionenNumerierung.Cancel

    '/// Close document ///
    Call hCloseDocument
endcase

'--------------------------------------------------
testcase tFormatNumberingAll
	Dim i as Integer
	Dim Wert( 20 ) as Integer
	printlog "- Format / Numbering -Bullets in detail"
	printlog "  - adjust different Numbering and check the properties"
	'/// New document ///
	Call hNewDocument
	'/// Select Format / NumberingBullets and adjust different numbering ///
	FormatNumberingBullets
	
	Kontext
	Active.SetPage TabBullet
	Kontext "TabBullet"
	Sleep 1
	Auswahl.TypeKeys "<Right><Down>"
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 1 select a bullet ///
	Ebene.Select 1                                               ' 1. Ebene ein Bullet einstellen
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 2 select a numbering ///
	Ebene.Select 2                                               ' 2. Ebene eine Numerierungsart einstellen
	
	Kontext
	Active.SetPage TabNumerierungsart
	Kontext "TabNumerierungsart"
	Sleep 1
	Auswahl.TypeKeys "<Down>", 2
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 3 select a numbering ///
	Ebene.Select 3                                               ' 3. Ebene eine Numerierungsart einstellen
	
	Kontext
	Active.SetPage TabNumerierungsart
	Kontext "TabNumerierungsart"
	Sleep 1
	Auswahl.TypeKeys "<Down><Right>", 2
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 4 select a graphic ///
	Ebene.Select 4                                               ' 4. Ebene eine Grafik einstellen
	
	Kontext
	Active.SetPage TabGrafiken
	Kontext "TabGrafiken"
	Sleep 1
	Auswahl.TypeKeys "<Right>"
															' 5. und 6. Ebene werden nicht besonders eingestellt
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 7 select a graphic ///
	Ebene.Select 7                                               ' 7. Ebene eine Grafik einstellen
	
	Kontext
	Active.SetPage TabGrafiken
	Kontext "TabGrafiken"
	Sleep 1
	Auswahl.TypeKeys "<Right><Down>"
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 8 select a graphic ///
	Ebene.Select 8                                               ' 8. Ebene eine Grafik einstellen
	
	Kontext
	Active.SetPage TabGrafiken
	Kontext "TabGrafiken"
	Sleep 1
	Auswahl.TypeKeys "<Right>", 5
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 9 select a bullet ///
	Ebene.Select 9                                               ' 9. Ebene ein Bullet einstellen
	
	Kontext
	Active.SetPage TabBullet
	Kontext "TabBullet"
	Sleep 1
	Auswahl.TypeKeys "<Down>"
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 10 select a numbering ///
	Ebene.Select 10                                              ' 10. Ebene eine Numerierungsart einstellen
	
	Kontext
	Active.SetPage TabNumerierungsart
	Kontext "TabNumerierungsart"
	Sleep 1
	Auswahl.TypeKeys "<Right>", 2
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	
	for i=1 to 10
		Ebene.Select i
		Wert (i) = Numerierung.GetSelIndex
	next i
	'/// check settings made ///
	
	if Wert(1)  <> 8 then Warnlog "Selected entry => 1. Level Is not Bullets (8. Entry) but entry " + Wert(1)
	if Wert(2)  <> 2 then Warnlog "Selected entry => 2. Level Is not Numbering 1 but entry " + Wert(2)
	if Wert(3)  <> 3 then Warnlog "Selected entry => 3. Level Is not Numbering 2 but entry " + Wert(3)
	if Wert(4)  <> 9 then Warnlog "Selected entry => 4. Level Is not Graphic (9. Entry) but entry " + Wert(4)
	if Wert(5)  <> 8 then Warnlog "Selected entry => 5. Level Is not Bullets (8. Entry) but entry " + Wert(5)
	if Wert(6)  <> 8 then Warnlog "Selected entry => 6. Level Is not Bullets (8. Entry) but entry " + Wert(6)
	if Wert(7)  <> 9 then Warnlog "Selected entry => 7. Level Is not Graphic (9. Entry) but entry " + Wert(7)
	if Wert(8)  <> 9 then Warnlog "Selected entry => 8. Level Is not Graphic (9. Entry) but entry " + Wert(8)
	if Wert(9)  <> 8 then Warnlog "Selected entry => 9. Level Is not Bullets (8. Entry) but entry " + Wert(9)
	if Wert(10) <> 1 then Warnlog "Selected entry => 10. Level Is not Numbering 1 but entry " + Wert(10)
	
	TabOptionenNumerierung.OK
	
	printlog "  - create numbering and check them"
	'/// create numbering and check it ///
	Call wDokSchreiben "Hallo 1. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 2. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 3. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 4. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 5. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 6. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 7. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 8. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 9. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 10. Ebene<Return>"
	Call wDokSchreiben "<Tab>Immer noch 10. Ebene<Return>"
	Call wDokSchreiben "<Return><Return>Ende der Numerierung"
	Call wDokSchreiben "<Up>", 5
	
	FormatNumberingBullets
	'/// reopen dialog and check settings ///
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	for i=1 to 10
		Ebene.Select i
		if Numerierung.GetSelIndex <> Wert(i) then 
			Warnlog "After creating: => Level " + i + " has not numbering " + Wert (i) + " but " + Numerierung.GetSelIndex
		endif
	next i
	TabOptionenNumerierung.Cancel
	
	printlog "  - check previous saved numbering"
	'/// save document, close and reload previous saved document ///
	Sleep 2
	Call hSpeichernUnterKill ( gOfficePath + "user\work\format7." & WriterFilterExtension(0) )
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hDateiOeffnen ( gOfficePath + "user\work\format7." & WriterFilterExtension(0) )
	Sleep 2
	FormatNumberingBullets
	'/// reopen Format / NumberingBullets and check saved settings ///
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	for i=1 to 10
		Ebene.Select i
		if Numerierung.GetSelIndex <> Wert(i) then Warnlog "After saving: => Level " + i + " has not Numbering " + Wert (i) + " but " + Numerierung.GetSelIndex
	next i
	TabOptionenNumerierung.Cancel
	
	'/// close document ///
	Call hCloseDocument
endcase
