'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_section_tools.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsi $ $Date: 2006/01/18 14:40:56 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'************************************************************************
'*
' #1 fInsertSection
' #1 fInsertBookmark
' #1 fInsertFootnote
' #1 fInsertEndnote
' #1 fInsertTable
' #1 fCloseNavigator
' #1 fCheckDirectCursor
' #1 fMultiSelection
' #1 ConvertBacklashToSlash
' #1 CheckAsianLanguageSupport
'*
'\***********************************************************************


'******************************************************
'* insert a section with name SectionName            **
'******************************************************
function fInsertSection(SectionName as string)
   InsertSection
   wait 500
   Kontext
   Active.Setpage TabBereiche
   Kontext "TabBereiche"
   Bereichsliste.Settext SectionName
   TabBereiche.OK
   wait 500
end function

'******************************************************
'* insert a bookmark with name                       **
'******************************************************
function fInsertBookmark(BookmarkName as string)

    InsertBookmark
    Kontext
    Kontext "TextmarkeEinfuegen"
    Textmarken.SetText BookmarkName
    TextmarkeEinfuegen.OK

end function


'******************************************************
'*    insert a footnote                              **
'******************************************************
function fInsertFootnote(Numbering as string , ConTentInCharater as String)

   InsertFootnote
   Kontext "FussnoteEinfuegen"

   ' check footnote
   Fussnote.Check

   Select Case Numbering
    Case "automatic" : Automatisch.Check
    Case "character" : Zeichen.Check
                       ZeichenText.SetText ConTentInCharater
    Case else : Warnlog "Maybe new options! :-)"
                Automatisch.Check
   end select

   FussnoteEinfuegen.OK

end function


'******************************************************
'* insert a endnote                                  **
'******************************************************
function fInsertEndnote(Numbering as string , ConTentInCharater as String)

   InsertFootnote
   Kontext "FussnoteEinfuegen"

   ' check endnote
   Endnote.Check

   Select Case Numbering
    Case "automatic" : Automatisch.Check
    Case "character" : Zeichen.Check
                       ZeichenText.SetText ConTentInCharater
    Case else : Warnlog "Maybe new options! :-)"
                Automatisch.Check
   end select

   FussnoteEinfuegen.OK

end function


'******************************************************
'* insert a table with name TableName                **
'* Column is table's column's number                 **
'* Row    is table's row   's number                 **
'******************************************************
function fInsertTable(TableName as string, ColumnNumber as string, RowNumber as string)

   InsertTableWriter
   Sleep 1
   Kontext "TabelleEinfuegenWriter"
   TabellenName.SetText TableName

   Spalten.SetText ColumnNumber
   Zeilen.SetText  RowNumber

   TabelleEinfuegenWriter.OK

end function

'*******************************************************
'* Close Navigator                                    **
'*******************************************************
function fCloseNavigator

   Kontext
   Kontext "Navigator"
   try
    Navigator.Close
   catch
    Warnlog "Could not close Navigator!"
   endcatch

end function

'*******************************************************
'*  Open options and check 'Direct-Cursor' in options **
'*******************************************************
function fCheckDirectCursor

    ToolsOptions
    Call hToolsOptions("TextDocument","FormattingAids")
    Zonen_Cursor.Check
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

end function


'*********************************************************
'*  This function is evaluated multisection             **
'*  selectString is the selected string in the text     **
'*  There must be more than 2 selectStrings in the text **
'*********************************************************
function fMultiSelection(selectedString as String)

   Kontext
   EditSearchAndReplace
   Kontext "FindAndReplace"

   SearchFor.SetText selectedString
   SearchAll.Click
   Sleep 1

   FindAndReplace.Close

end function

'--------------------------------------------------------

function ConvertBacklashToSlash ( sDatei$ ) as String
   Dim s1$ : Dim s2$ : Dim s3$
   Dim i as Integer

   s1$ = sDatei$

  'convert all \ to /
      do
         i = InStr( s1$, "\" )
         if i = 0 then exit do
         s2$ = Left( s1$ , i-1 )
         s1$ = Mid( s1$ , i+1 )
         s3$ = s3$ + s2$ + "/"
      loop until s1$=""
      s1$ = s3$ + s1$

   ConvertBacklashToSlash = s1$

end function

'----------------------------------------------------------

function CheckCTLSupport( sSupport as String )  as String

'/// This function will check Complex text Layout (CTL) Support on/off based on the parameter

   ToolsOptions
   Call hToolsOptions("LANGUAGESETTINGS","LANGUAGES")

    if sSupport = "On" then
       ComplexScriptEnabled.Check
    else
       ComplexScriptEnabled.UnCheck
    end if
    Sleep 1

    Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

end function

'--------------------------------------------------

