'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_204a_.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: hde $ $Date: 2006/01/09 12:53:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test the table functionality in Writer
'*
'\***********************************************************************

sub w_204a_

    Call sTableName
    Call sTableAlignment
    Call sTableMergeCell
    Call TableSplit_copy_heading
    Call TableSplit_custom_heading
    Call TableSplit_custom_heading_apply_style
    Call TableSplit_no_heading
    Call sTableMerge
    Call sTablePagebreak
    Call sTableBorder
    Call sTableIndent
    Call sTableSort

end sub

' ----------------------------------------------------------------------

testcase sTableName
    dim temp(10) as string
    Call hNewDocument

    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Garfield"
    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="7")  ' insert table

    printlog "'///  Format table via Format->Table ///"
    Printlog "'///      change tablename ///"
    TableTableProperties                ' get into existing table
    Sleep (2)
    Kontext "TabelleEinfuegenWriter"
    sleep (2)
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"

    '  0. right table ?? ///'
    if (TabellenName.GetText <> temp (1) ) then warnlog " --- wrong table? schould be : "+temp (1)+ ", is : "+TabellenName.GetText

    '///  1. try: space included ///'
    temp (1) = "Gar field"
    try
        TabellenName.SetText temp (1)
    catch
        printlog " - couldn't insert : " + temp (1)
    endcatch
    if (TabellenName.GetText = temp (1) ) then warnlog " --- ups, could insert smth. with space? : "+TabellenName.GetText

    '///  2. try: dot included ///'
    temp (1) = "Gar.field"
    try
        TabellenName.SetText temp (1)
    catch
        printlog " - couldn't insert : "+temp (1)
    endcatch
    if (TabellenName.GetText = temp (1) ) then warnlog " --- ups, could insert smth. with dot? : "+TabellenName.GetText

    TabTabelle.cancel
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTableAlignment
    dim temp(10) as string
    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer
    dim sBug as string

    Call hNewDocument
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Garfield"
    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="7")  ' insert table

    '   ' get text to init some constances for this test
    '   temp(2) = NachOben.GetText '----------------------------------------------------
    ' initialisation of some constantzen for this test  '------------------------------
    PAGEWIDTH = hGetPageWidth()
    printlog "--- Pagewidth is: " + PAGEWIDTH
    'MEASUNIT =  GetMeasUnit (temp(2))
    'DECSEP = GetDecimalSeperator(temp(2))

    Printlog "'///     set alignment of table ///"
    TableTableProperties
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    Printlog "'///      Left ///"
    Links.check
    sleep (1)
    if ((Breite.IsWritable AND NachRechts.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (LiberalMeasurement(PAGEWIDTH ,(StrToDouble (Breite.GetText) + StrToDouble (NachRechts.GetText))) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachRechts.GetText))+" should: "+PAGEWIDTH
    NachRechts.SetText "2"
    sleep (1)
    temp(1) = NachRechts.GetText
    TabTabelle.OK
    TableTableProperties
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    if (Links.Ischecked <> TRUE) then warnlog "links state changed"
    if ((Breite.IsWritable AND NachRechts.IsWritable) <> TRUE) then warnlog "edit field not active"
    if (temp(1) <> NachRechts.GetText) then warnlog "value changed"
    if (LiberalMeasurement(PAGEWIDTH ,(StrToDouble (Breite.GetText) + StrToDouble (NachRechts.GetText))) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachRechts.GetText))+" should: "+PAGEWIDTH
    '--------------------------------
    NachRechts.SetText "0"
    sleep (1)
    Printlog "'///       FromLeft ///"
    VonLinks.check
    sleep (1)
    if ((Breite.IsWritable AND NachLinks.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + StrToDouble(NachLinks.GetText)) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText))+" should: "+PAGEWIDTH
    NachLinks.SetText "2"
    sleep (1)
    temp(1) = NachLinks.GetText
    TabTabelle.OK
    sleep 1
    TableTableProperties
    Kontext "TabelleEinfuegenWriter"
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    if (VonLinks.Ischecked <> TRUE) then warnlog "VonLinks state changed"
    'sBug = NachLinks.GetText
    if ((Breite.IsEnabled AND NachLinks.IsEnabled) <> TRUE) then warnlog "edit field not active "
    'if (NachLinks.IsWritable <> TRUE) then warnlog "edit field not active "
    'if sBug <> NachLinks.GetText then warnlog "TESTOOL BUG; is writable loescht feld "
    if (temp(1) <> NachLinks.GetText) then warnlog "value changed"+" should: "+temp(1)+" is:  "+ NachLinks.GetText
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + StrToDouble(NachLinks.GetText)) <> TRUE) then warnlog "measurement value error  "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText))+" should: "+PAGEWIDTH
    '--------------------------------
    NachLinks.SetText "0"
    Printlog "'///     Right ///"
    rechts.check
    sleep (1)
    if ((Breite.IsWritable AND NachLinks.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + StrToDouble(NachLinks.GetText)) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText))+" should: "+PAGEWIDTH
    NachLinks.SetText "2"
    sleep (1)
    temp(1) = NachLinks.GetText
    TabTabelle.OK
    TableTableProperties
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    if (rechts.Ischecked <> TRUE) then warnlog "rechts state changed"
    if ((Breite.IsWritable AND NachLinks.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (temp(1) <> NachLinks.GetText) then warnlog "value changed"
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + StrToDouble(NachLinks.GetText)) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText))+" should: "+PAGEWIDTH
    '--------------------------------
    NachLinks.SetText "0"
    Printlog "'///      center ///"
    Zentriert.check
    sleep (1)
    if ((Breite.IsWritable AND NachLinks.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + (2 * StrToDouble (NachLinks.GetText))) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText))+" should: "+PAGEWIDTH
    NachLinks.SetText "2"
    sleep (1)
    temp(1) = NachLinks.GetText
    TabTabelle.OK
    TableTableProperties
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    if (Zentriert.Ischecked <> TRUE) then warnlog "state changed"
    if ((Breite.IsWritable AND NachLinks.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (temp(1) <> NachLinks.GetText) then warnlog "value changed"
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + (2 * StrToDouble (NachLinks.GetText))) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText))+" should: "+PAGEWIDTH
    '--------------------------------
    NachLinks.SetText "0"
    Printlog "'///     manual ///"
    Manuell.check
    sleep (1)
    if ((Breite.IsWritable AND NachLinks.IsWritable AND NachRechts.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText) + StrToDouble (NachRechts.GetText)) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText)+ StrToDouble (NachRechts.GetText))+" should: "+PAGEWIDTH
    NachLinks.SetText "2"
    NachRechts.SetText "2"
    sleep (1)
    temp(1) = NachLinks.GetText
    temp(2) = NachRechts.GetText
    TabTabelle.OK
    TableTableProperties
    Kontext
    Active.SetPage TabTabelle
    Kontext "TabTabelle"
    if (Manuell.Ischecked <> TRUE) then warnlog "state changed"
    if ((Breite.IsWritable AND NachLinks.IsWritable) <> TRUE) then warnlog "edit field not active "
    if (temp(1) <> NachLinks.GetText) then warnlog "value changed"
    if (temp(2) <> NachRechts.GetText) then warnlog "value changed"
    if (LiberalMeasurement(PAGEWIDTH ,StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText) + StrToDouble (NachRechts.GetText)) <> TRUE) then warnlog "measurement value error "+ "is: "+(StrToDouble (Breite.GetText) + StrToDouble (NachLinks.GetText)+ StrToDouble (NachRechts.GetText))+" should: "+PAGEWIDTH
    '--------------------------------
    NachLinks.SetText "0"
    NachRechts.SetText "0"
    TabTabelle.OK
    Printlog "'///    <font color=#FF0000>TODO TBO automatical ---------- MISSING yet </FONT> ///"
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTablePagebreak
    Dim temp(10) as string

    Call hNewDocument
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Garfield"
    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="7")  ' insert table

    Printlog "'///     Check TextFlow: pagebreak ///"

    InsertFieldsPagenumbers          ' get pagenumber & leave it for next calculation
    Call wDokSchreiben "<shift home>"
    ToolsCalculate
    temp(1) = val(GetClipboardText)

    TableTableProperties
    Kontext "TabelleEinfuegenWriter"
    Kontext
    Active.SetPage TabTextFlusstabelle
    Kontext "TabTextFlusstabelle"
    Umbruch.Check
    if ((Seite.IsChecked AND Davor.IsChecked) <> TRUE) then
        printlog "--- defaultvalue changed..."
        Seite.Check
        Davor.Check
    endif
    TabTextFlusstabelle.OK

    ToolsUpdateUpdateAll             ' update field & get pagenumber & clear
    Call wDokSchreiben "<shift end>"
    ToolsCalculate
    temp(2) = val(GetClipboardText)
    if ((val(temp(1))+1) <> temp(2)) then
        warnlog "--- Table didn't move, that's not good "+ "from: "+val(temp(1))+" to: "+ temp(2) +" 1+1= "+(val(temp(1))+1)
    else
        printlog "    works , moved, ok!"
    endif

    Call wDokSchreiben "<mod1 end><mod1 end><return>"

    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTableMergeCell
    dim temp(10) as string

    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer

    Call hNewDocument

    ' set marks to find
    Call wDokSchreiben "<mod1 end><mod1 end>"
    Call wDokSchreiben "OdieNULL<return>"
    Call wDokSchreiben "OdieStart<return>"
    Call wDokSchreiben "OdieEnd<return>"
    Call wDokSchreiben "OdieNULL<return><up><up>"

    temp (1) = "Garfield"
    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="7")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    Call wDokSchreiben "<up><up>"

    temp (1) = "OdieTable"
    Call TBOhTabelleEinfuegen (temp (1) ,0,0,1,1,"10",tHeight:="10")  ' insert table

    Printlog chr(13)+"'///      Edit Table ///"
    Printlog "'///       merging of cells & undo ///"
    temp (2) = hGetTableName()
    if (temp(2) <> temp(1)) then warnlog " --- wrong table? schould be : "+temp (1)+ ", is : "+temp(2)

    Printlog " - merging of cells"
    ac=0   ' ActionCount
    fc=100 ' FieldCount
    Call wDokSchreiben "<down><shift right>"     ' 2 horizontal (0,1) & (1,1) (x,y)
    FormatCellMerge : inc ac : dec fc '   FormatZelleVerbinden
    Call wDokSchreiben "<down><shift down>"      ' 2 vertical (1,2) & (1,3)
    FormatCellMerge : inc ac : dec fc
    Call wDokSchreiben "<down><up><shift down><shift up>"      ' merge again
    'Warnlog "Merge cells will crash when only one cell is selected (#i33394)"
    FormatCellMerge

    ' go to top of table, move to end & count
    Call wDokSchreiben "<mod1 home>"
    for i=1 to fc
        Call wDokSchreiben "<right>"
    next i
    Call wDokSchreiben "<shift end>" ' right after/outside the table ->
    EditCopy
    if (GetClipboardText <> "OdieEnd") then
        warnlog "This is not the end of the table!!! where the h*** am i??? "
        printlog "------TBO: could it be this is called at wrong position ??"
        printlog "   found: " + GetClipboardText
    endif
    ' undo & check where we are
    for i=1 to ac
        EditUndo
    next i

    sleep (3)
    temp (2) = hGetTableName()
    if (temp(2) <> temp(1)) then warnlog " --- wrong table? schould be : "+temp (1)+ ", is : "+temp(2)
    EditUndo ' go one step further
    EditUndo ' go one step further
    Call wDokSchreiben "<up><shift end>"
    EditCopy
    temp(2) = GetClipboardText
    Call wDokSchreiben "<down><shift home>"
    EditCopy
    temp(3) = GetClipboardText
    if ((temp(2) <> "OdieStart") AND (temp(3) <> "OdieEnd")) then
        warnlog "there is smth. wrong with the undo stuff !!! is:"+temp(3) +" and:"+temp(2)+" should:OdieEnd OdieStart"
    endif
    EditRedo ' and back again
    Call wDokSchreiben "<mod1 end>" ' go to end of doc
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTableBorder
    dim temp(10) as string
    temp(1) = "bloed"

    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer
    Call hNewDocument

    ' set marks to find
    Call wDokSchreiben "<mod1 end><mod1 end>"
    Call wDokSchreiben "OdieNULL<return>"
    Call wDokSchreiben "OdieStart<return>"
    Call wDokSchreiben "OdieEnd<return>"
    Call wDokSchreiben "OdieNULL<return><up><up>"

    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="7")  ' insert table

    Printlog "'///       set border & undo ///"
    ' assign border to whole table
    Call wDokSchreiben "<shift mod1 end>"
    TableTableProperties                ' get into existing table
    Sleep (1)
    Kontext "TabelleEinfuegenWriter"
    sleep (1)
    Kontext
    if active.exists (5) then
        Active.SetPage TabUmrandung
        Sleep (1)
        Kontext "TabUmrandung"
        Sleep (1)
        Vorgaben.Typekeys "<end>" ' set border
        StilFarbe.Select StilFarbe.GetItemCount

        'links.IsWriteable 'si checkable, but not now!...
        Position.TypeKeys "<home><right><right><right>" ' 3. from the left
        if (groesse.IsEnabled <> TRUE) then warnlog "position of shadow is not changeable "
        SchattenFarbe.Select SchattenFarbe.GetItemCount - 1
    else
        TableTableProperties                ' get into existing table
        Kontext "TabelleEinfuegenWriter"
        sleep (1)
        Kontext
        warnlog  "2.trie"
        if active.exists (5) then
            Active.SetPage TabUmrandung
            Sleep (1)
            Kontext "TabUmrandung"
            Sleep (1)
            Vorgaben.Typekeys "<end>" ' set border
            StilFarbe.Select StilFarbe.GetItemCount

            'links.IsWriteable 'si checkable, but not now!...
            Position.TypeKeys "<home><right><right><right>" ' 3. from the left
            if (groesse.IsEnabled <> TRUE) then warnlog "position of shadow is not changeable "
            SchattenFarbe.Select SchattenFarbe.GetItemCount - 1
        else
            warnlog "baeh!"
        endif
    endif
    Kontext
    Active.SetPage TabHintergrund
    Sleep (1)
    Kontext "TabHintergrund"
    Sleep (1)
    Hintergrundfarbe.TypeKeys "<home><down><right><down><right><down><right><down><right>"
    TabHintergrund.OK
    ' just an idea of checking this type of control
    i=0
    TableTableProperties                ' get into existing table
    Sleep (1)
    Kontext "TabelleEinfuegenWriter"
    sleep (1)
    Kontext
    Active.SetPage TabUmrandung
    Sleep (1)
    Kontext "TabUmrandung"
    Sleep (1)
    while (groesse.IsEnabled)
        Position.TypeKeys "<left>"
        inc i
    wend
    TabUmrandung.cancel
    if (i <> 3) then warnlog "wrong shadow selected should be 3, was: "+i

    ' undo & check where we are ///'
    EditUndo
    temp (2) = hGetTableName()
    if (temp(2) <> temp(1)) then warnlog " --- wrong table? schould be : "+temp (1)+ ", is : "+temp(2)
    EditUndo ' go one step further
    Call wDokSchreiben "<up><shift end>"
    EditCopy
    temp(2) = GetClipboardText
    Call wDokSchreiben "<down><shift home>"
    EditCopy
    temp(3) = GetClipboardText
    if ((temp(2) <> "OdieStart") AND (temp(3) <> "OdieEnd")) then
        warnlog "there is smth. wrong with the undo stuff !!!"
        print "whats wrong with the undo stuff"
    endif
    EditRedo ' and back again
    Call wDokSchreiben "<up><mod1 home>" ' now we are in (0,0)
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTableIndent
    dim temp(10) as string
    dim ac, fc as integer

    Call hNewDocument
    ' set marks to find
    Call wDokSchreiben "OdieNULL<return>"
    Call wDokSchreiben "OdieStart<return>"
    Call wDokSchreiben "OdieEnd<return>"
    Call wDokSchreiben "OdieNULL<return><up><up>"

    temp (1) = "Garfield"
    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="7")  ' insert table

    Printlog "'///    tab, paragraph indent & UNDO ///"

    ac=0   ' ActionCount
    fc=100 ' FieldCount
    ' : inc ac : dec fc
    FormatParagraph
    Kontext
    Active.SetPage TabTabulator
    Sleep (1)
    Kontext "TabTabulator"
    Sleep (1)
    Position.SetText "1"
    TypZentriert.Check
    Fuellzeichen5.Check
    FuellzeichenZeichen.SetText "%"
    Neu.Click
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    Vonlinks.SetText "-1"
    VonRechts.SetText "-1"
    TabEinzuegeUndAbstaende.OK


    Printlog "'///     text attributes ///"
    Call wDokSchreiben "John"  : inc ac
    Call wDokSchreiben "<shift home>"
    FormatCharacter
    Kontext
    Active.SetPage TabFontEffects
    Sleep (1)
    Kontext "TabFontEffects"
    Sleep (1)
    FontColor.Select FontColor.GetItemCount - 1
    Kontext
    Active.SetPage TabFontPosition
    Sleep (1)
    Kontext "TabFontPosition"
    Sleep (1)
    Super.Check
    n90Degree.Check
    TabFontPosition.OK

    EditUndo
    EditUndo

    Printlog "'///      cell protection ///"
    Call wDokSchreiben "<down><shift down><shift right>"
    FormatCellProtect
    Call wDokSchreiben "x"
    Kontext
    if (Active.Exists <> TRUE) then
        Call wDokSchreiben "<Left><Right><Shift End>"
        try
            EditCopy
        catch
        endcatch
        if GetClipboardtext = "OdieNULL" then
            QAErrorLog "Cursor jumps out of table when protecting cell!"
            Call hCloseDocument
            goto endsub
        else
            QAErrorLog "#110549#Protection of cell does not work correct!"
            Call hCloseDocument
            goto endsub
        endif
        ' If protection fails, reselect table with Navigator!
        Call wNavigatorAuswahl(2,1)
    else
        Active.OK
        EditUndo
        Call wDokSchreiben "x"
        Kontext
        if (Active.Exists = TRUE) then
            Warnlog "ReProtection of table does not work!" + Active.GetText
            active.OK
        endif

        EditUndo
        EditUndo
        'Printlog "undoCheck is here"
        temp (2) = hGetTableName()
        if (temp(2) <> temp(1)) then warnlog " --- wrong table? schould be : "+temp (1)+ ", is : "+temp(2)
        EditUndo ' go one step further
        Call wDokSchreiben "<up><shift end>"
        EditCopy
        temp(2) = GetClipboardText
        Call wDokSchreiben "<down><shift home>"
        EditCopy
        temp(3) = GetClipboardText
        if ((temp(2) <> "OdieStart") AND (temp(3) <> "OdieEnd")) then
            warnlog "there is smth. wrong with the undo stuff !!! is: "+temp(2)+" should: OdieStart; is: "+temp(3)+" should: OdieEnd;"
        endif
        EditRedo ' and back again
        Call wDokSchreiben "<up><mod1 home>" ' now we are in (0,0)
    endif

    Printlog "'///      Set graphic in table as background ///"
    try
        TableTableProperties
    catch
        Warnlog "Dialog 'Insert Table' not up!"
        Call hCloseDocument
        goto endsub
    endcatch

    try
        Kontext
        Active.SetPage TabHintergrund
        Sleep (1)
        Kontext "TabHintergrund"
        Sleep (1)
        Fuer.Select(2) ' Zeile
        Als.Select(2)  ' Grafik
        Durchsuchen.Click
        Kontext "GrafikEinfuegenDlg"
        Dateiname.SetText convertPath(gTesttoolPath +"writer\level1\input\options\ga000907.gif")
        Oeffnen.Click
        Kontext "TabHintergrund"
        TabHintergrund.OK

        FormatColumnWidthWriter ' thre is a bigger test in the option test
        Kontext "SpaltenBreite"
        Spalte.SetText "2"
        Breite.SetText "2"
        SpaltenBreite.OK
        FormatRowHeight
        Kontext "ZellenHoehe"
        Hoehe.SetText "2"
        ZellenHoehe.OK
        EditUndo
        EditUndo

        EditUndo

        ' Printlog "undoCheck is here"
        sleep (3)
        temp (2) = hGetTableName()
        if (temp(2) <> temp(1)) then warnlog " --- wrong table? schould be : "+temp (1)+ ", is : "+temp(2)
        EditUndo ' go one step further
        Call wDokSchreiben "<up><shift end>"
        EditCopy
        temp(2) = GetClipboardText
        Call wDokSchreiben "<down><shift home>"
        EditCopy
        temp(3) = GetClipboardText
        if ((temp(2) <> "OdieStart") AND (temp(3) <> "OdieEnd")) then
            warnlog "there is smth. wrong with the undo stuff !!! is: "+temp(2)+" should: OdieStart; is: "+temp(3)+" should: OdieEnd;"
        endif
        EditRedo ' and back again
        Call wDokSchreiben "<mod1 end>" ' go to end of doc
    catch
        Warnlog "Dialog 'Insert Table' not up!"
    endcatch
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTableSort
    dim temp(10) as string
    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer

    Call hNewDocument
    '   Kontext "DocumentWriter"
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Sort"
    Call TBOhTabelleEinfuegen (temp (1) ,0,1,0,1,"10",tHeight:="10")  ' insert table

    fc = 99
    randomize()
    for i=1 to fc
        Call wDokSchreiben str(rnd()) + "<right>"
    next i
    Call wDokSchreiben "<shift mod1 home>"
    ToolsSort '-----------------------------------------------------------11111111111111111
    Kontext "Sortieren"
    Spalten.Check  'direction 1
    for i = 1 to Schluesseltyp1.GetItemCount
        Schluesseltyp1.select i
        printlog "possible values for sorting :" + Schluesseltyp1.Getseltext
    next i
    Sortieren.OK
    Kontext
    if active.exists (5) then printlog "active1: "+active.gettext
    Call wDokSchreiben "<shift mod1 end>",2
    try
        ToolsSort '-----------------------------------------------------------22222222222222222
    catch
        printlog "WorkAround only seen on linux, can't select immediately, cursor movement needed "
        Call wDokSchreiben "<right><left>"
        Call wDokSchreiben "<shift mod1 end>",2
        ToolsSort
    endcatch
    Kontext
    if active.exists (5) then
        printlog "active2: "+active.gettext
        active.ok
    endif
    Kontext "Sortieren"
    Zeilen.Check
    Sortieren.OK
    Kontext
    if active.exists (5) then
        printlog "active3: "+active.gettext
        active.ok
    endif

    'Schluessel1
    'Spalte1
    'Schluesseltyp1
    'Aufsteigend1
    'Absteigend1
    '
    'Schluessel2
    'Spalte2
    'Schluesseltyp2
    'Aufsteigend2
    'Absteigend2
    '
    'Schluessel3
    'Spalte3
    'Schluesseltyp3
    'Aufsteigend3
    'Absteigend3
    '
    'Tabulator
    'Zeichen
    'Zeichentext
    'Sonderzeichen
    'Sprache
    'ExakterVergleich
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase TableSplit_copy_heading
    printlog "'/// Splitting Tables & UNDO ///"
    printlog "'///     check 'copy heading' ///"
    dim temp(10) as string
    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer

    Call hNewDocument
    ' Kontext "DocumentWriter"
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Split"
    Call TBOhTabelleEinfuegen (temp (1) ,1,1,0,1,"10",tHeight:="10")  ' insert table

    Printlog "'/// Splitting Tables & UNDO ///"
    Printlog "'///     check 'copy heading' ///"
    temp(2) = "Jon"
    Call wDokSchreiben temp(2)+"<down>"
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    UeberschriftKopieren.Check      '<------------- this is the key
    TabelleAuftrennen.OK
    ' check where am i
    temp (6) = hGetTableName ()
    if (temp(6) <> (sLocaleDetail(12)+"1")) then warnlog "Split table didn't work! is: "+temp(6)+"; should: "+(sLocaleDetail(12)+"1")
'   if (temp(6) <> (sLocaleDetail(12)+"2")) then warnlog "Split table didn't work! is: "+temp(6)+"; should: "+(sLocaleDetail(12)+"2")

    Call wDokSchreiben "<up>"  ' im in the content of the table
    Sleep 1
    ' -------------check if heading (style)
    Kontext "TextObjectbar"
    if (Vorlage.GetSelText <> sLocaleDetail(1)) then
        Warnlog "tabel heading did not work!is: "+Vorlage.GetSelText+", should sLocaleDetail(1): "+ sLocaleDetail(1)
    endif
    '----------------------------------
    Call wDokSchreiben "<end><shift home>" ' check heading in 'new' table (content)
    EditCopy
    temp(3) = GetClipboardText
    if (temp(2) <> temp(3)) then  warnlog "wrong heading! Is: "+temp(3)+" Should: "+temp(2)
    Call wDokSchreiben "<up><up>"
    if (hGetTableName () <> (temp(1))) then warnlog "Split table didn't work?"
    Call wDokSchreiben "<end><shift home>" ' check heading in 'old' table
    EditCopy
    temp(3) = GetClipboardText
    if (temp(2) <> temp(3)) then  warnlog "wrong heading! is: "+temp(3)+" should: "+temp(2)
    EditUndo
    EditUndo

    Printlog "'///     check 'custom heading (apply style)' ///"
    ' splitting headers doesn't work -> move down 1 line
    temp(2) = temp(1)
    Call wDokSchreiben temp(2)
    ' set some style to verify
    FormatParagraph
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    Vonlinks.SetText "-1"
    VonRechts.SetText "-1"
    temp (4) = Vonlinks.GetText
    temp (5) = Vonrechts.GetText
    TabEinzuegeUndAbstaende.OK
    Call wDokSchreiben "<down>",2
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    EigeneMitVorlage.Check    '<------------- this is the key
    TabelleAuftrennen.OK
    ' check where am i
    temp (6) = hGetTableName ()
    if (temp(6) <> (sLocaleDetail(12)+"1")) then
        warnlog "Split table didn't work! is: "+temp(6)+"; should: "+(sLocaleDetail(12)+"1")
    endif
    ' -------------check if heading
    Kontext "TextObjectbar"
    if (Vorlage.GetSelText <> sLocaleDetail(1)) then
        Warnlog "Table heading did not work!"
        Warnlog "is: "+Vorlage.GetSelText+", should sLocaleDetail(1): "+ sLocaleDetail(1)
        Call wDokSchreiben "<Escape>"
    endif
    '----------------------------------

    FormatParagraph         ' check style
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    '         if ((Vonlinks.GetText <>temp (4) ) OR (Vonrechts.GetText <>temp (5) )) then warnlog "style didn't get inherited. is: "+Vonlinks.GetText+"; should: "+temp (4) +";; is: "+Vonrechts.GetText+"; should: "+temp (5) +";;"
    TabEinzuegeUndAbstaende.OK
    Call wDokSchreiben "<up><up><up>"               ' goto old table
    if (hGetTableName () <> (temp(1))) then warnlog "Split table didn't work? "
    Call wDokSchreiben "<end><shift home>" ' check heading in 'old' table
    EditCopy
    temp(3) = GetClipboardText
    if (temp(2) <> temp(3)) then  warnlog "wrong heading! is: "+temp(3)+"; should: "+temp(2)

    sleep (3)
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase TableSplit_custom_heading
    dim temp(10) as string
    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer

    Call hNewDocument
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Header"
    Call TBOhTabelleEinfuegen (temp (1) ,1,1,0,1,"10",tHeight:="10")  ' insert table
    Printlog "'///     check  'custom heading' ///"
    Call wDokSchreiben "Header"
    FormatStylesCatalog ' set a style to verify
    Kontext "Vorlagenkatalog"
    Ansicht.TypeKeys "<up><up><up><up>"
    temp (4) = Ansicht.GetText
    Vorlagenkatalog.OK
    ' set some style to verify
    FormatParagraph
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    Vonlinks.SetText "-1"
    VonRechts.SetText "-1"
    temp (2) = Vonlinks.GetText
    temp (3) = Vonrechts.GetText
    TabEinzuegeUndAbstaende.OK
    Call wDokSchreiben ("<down>")
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    Eigene.Check                 '<------------- this is the key
    TabelleAuftrennen.OK
    ' check where am i
    temp (5) = hGetTableName ()
    if (temp(5) <> ( sLocaleDetail(12) + "1" )) then warnlog "Split table didn't work! is: "+ temp(5) + "; should: "+(sLocaleDetail(12) + "1")
    ' -------------check if NO heading (would be a custom style...))
    Call wDokSchreiben "<Up>",2
    Call wDokSchreiben "<mod1 a>"
    EditCopy
    temp(6) = GetClipboardText
    FormatParagraph         ' check style
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    if temp (2) <> Vonlinks.GetText then Warnlog "Indent 'Before text' has been changed!"
    if temp (3) <> Vonrechts.GetText then Warnlog "Indent 'After text' has been changed!"
    TabEinzuegeUndAbstaende.OK
    FormatStylesCatalog ' verify
    Kontext "Vorlagenkatalog"
    if Ansicht.Gettext <> temp(4) then Warnlog "Style in Header has been changed!"
    Vorlagenkatalog.Cancel
    if (hGetTableName () <> temp(1)) then warnlog "Split table didn't work? is: "+hGetTableName () +"; should: "+temp(1)
    if (temp(6) <> temp(1)) then  warnlog "wrong heading! is: " + temp(6) + " should: " + temp(1)
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase TableSplit_custom_heading_apply_style
    ' SHOULD BE EASIER TO WORK ON ODIE TOOOOOO
    dim temp(10) as string
    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer

    Call hNewDocument
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Split"
    TBOhTabelleEinfuegen (temp (1) ,1,1,0,1,"10",tHeight:="10")  ' insert table

    Printlog "'/// Splitting Tables & UNDO ///"
    Printlog "'///     check 'custom heading (apply style)' ///"
    temp(2) = temp(1)
    Call wDokSchreiben temp(2)
    ' set some style to verify
    FormatParagraph
    Kontext "TabTabulator"
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    Vonlinks.SetText "-1"
    VonRechts.SetText "-1"
    temp (4) = Vonlinks.GetText
    temp (5) = Vonrechts.GetText
    TabEinzuegeUndAbstaende.OK
    Call wDokSchreiben "<down>",2
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    EigeneMitVorlage.Check    '<------------- this is the key
    TabelleAuftrennen.OK
    ' check where am i
    temp (6) = hGetTableName ()
    if (temp(6) <> (sLocaleDetail(12)+"1")) then
        warnlog "Split table didn't work! is: "+temp(6)+"; should: "+(sLocaleDetail(12)+"1")
    endif
    ' -------------check if heading
    Kontext "TextObjectbar"
    if (Vorlage.GetSelText <> sLocaleDetail(1)) then
        Warnlog "table heading did not work!"
        warnlog "is: "+Vorlage.GetSelText+", should sLocaleDetail(1): "+ sLocaleDetail(1)
        'GetSelText bleibt in der box
        Call wDokSchreiben "<Escape>"
    endif
    '----------------------------------
    FormatParagraph         ' check style
    Kontext "TabTabulator"
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    TabEinzuegeUndAbstaende.OK
    Call wDokSchreiben "<up><up><up>"               ' goto old table
    if (hGetTableName () <> (temp(1))) then warnlog "Split table didn't work? "
    Call wDokSchreiben "<end><shift home>" ' check heading in 'old' table
    EditCopy
    temp(3) = GetClipboardText
    if (temp(2) <> temp(3)) then  warnlog "wrong heading! is: "+temp(3)+"; should: "+temp(2)
    sleep (3)
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase TableSplit_no_heading
    ' SHOULD BE EASIER TO WORK ON ODIE TOOOOOO
    dim temp(10) as string
    dim PAGEWIDTH as double
    dim ac, fc as integer
    dim i as integer

    Call hNewDocument
    Call TBOhTabelleEinfuegen ("dummy" ,0,1,0,1,"1",tHeight:="1")  ' insert table
    Call wDokSchreiben "<mod1 end><mod1 end>"
    temp (1) = "Split"
    Call TBOhTabelleEinfuegen (temp (1) ,1,1,0,1,"10",tHeight:="10")  ' insert table

    Printlog "'/// Splitting Tables & UNDO ///"
    Printlog "'///     check 'no heading' ///"
    temp(2) = "Header"
    temp(3) = "Content"
    Call wDokSchreiben ( temp(2) )
    Call wDokSchreiben ( "<down>" )
    Call wDokSchreiben ( temp(3) )
    Call wDokSchreiben ( "<Home>" )
    ' set some style to verify
    FormatParagraph
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    Vonlinks.SetText "-1"
    VonRechts.SetText "-1"
    temp (4) = Vonlinks.GetText
    temp (5) = Vonrechts.GetText
    TabEinzuegeUndAbstaende.OK
    FormatSplitTable
    Kontext "TabelleAuftrennen"
    Keine.Check
    TabelleAuftrennen.OK
    ' check where am i
    temp (6) = hGetTableName ()
    if (temp(6) <> ( sLocaleDetail(12) + "1" )) then warnlog "Split table didn't work! is: " + temp(6) + "; should: " + (sLocaleDetail(12) + "1" )
    ' -------------check if NO heading (would be a custom style...))
    Kontext "TextObjectbar"
    Call wDokSchreiben "<end><shift home>" ' check heading in 'new' table
    try
        EditCopy
        ' Should be 'Content'
        if (GetClipboardText   <> temp(3)) then  warnlog "wrong content! is: " + GetClipboardText + " should: " + temp(3)
    catch
        Warnlog "Unable to copy content! Maybe not selected!"
    endcatch
    FormatParagraph         ' check style
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Sleep (1)
    Kontext "TabEinzuegeUndAbstaende"
    Sleep (1)
    if ((Vonlinks.GetText <>temp (4) ) OR (Vonrechts.GetText <>temp (5) )) then warnlog "style didn't get inherited"
    TabEinzuegeUndAbstaende.OK
    Call wDokSchreiben "<up><up>"               ' goto header
    if (hGetTableName () <> (temp(1))) then warnlog "Split table didn't work? "
    Call wDokSchreiben "<end><shift home>" ' check heading in 'old' table
    try
        EditCopy
    catch
        Warnlog "Unable to copy content! Maybe not selected!"
    endcatch
    if (GetClipboardText  <> temp(2)) then  warnlog "wrong heading! is: " + GetClipboardText + " should: " + temp(2)
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

testcase sTableMerge
    dim temp(10) as string

    Call hNewDocument
    Call wDokSchreiben "<return><mod1 end><mod1 end>"
    Call wDokSchreiben "<mod1 end><mod1 end>"

    temp(2) = "Arlene"
    temp(3) = "Pooky"
    temp(4) = "Nermal"

    Call TBOhTabelleEinfuegen (temp (2) ,0,1,0,1,"10",tHeight:="7")  ' insert table Arlene
    sleep (3)
    Call wDokSchreiben "<mod1 end><mod1 end>"
    Call TBOhTabelleEinfuegen (temp (3) ,0,1,0,1,"10",tHeight:="7")  ' insert table Pooky
    sleep (3)
    Call wDokSchreiben "<mod1 end><mod1 end>"
    Call TBOhTabelleEinfuegen (temp (4) ,0,1,0,1,"10",tHeight:="7")  ' insert table Nermal
    sleep (3)

    Printlog "'///  Join tables & UNDO///"
    Printlog "'///      insert 3 tables: 'Arlene' 'Pooky' 'Nermal' ///"

    ' usually lowwer to upper one...
    ' update formulars ....
    Printlog "'///     join Nermal with pooky -> Nermal has to be under Arlene -> undo ///"
    FormatMergeTables
    if (hGetTableName () <> temp(4)) then warnlog "Merge table didn't work? 1 "
    Call wDokSchreiben "<mod1 home><up>"
    if (hGetTableName () <> temp(2)) then warnlog "Merge table didn't work? 1+ "
    EditUndo
    Call wDokSchreiben "<up><mod1 home>"

    Printlog "'///     join Nermal with pooky -> choose lowerTable -> Nermal has to be under Arlene again -> undo  ///"
    FormatMergeTables
    Kontext "TabellenVerbinden"
    if TabellenVerbinden.exists (5) <> TRUE then
        warnlog "there is only one table around no question for which table should be connected "
    endif
    MitNachfolgenderTabelleVerbinden.Check
    TabellenVerbinden.OK
    temp (5) = hGetTableName ()
    if (temp (5) <> temp(3)) then warnlog "Merge table didn't work? 2 is:"+temp (5)+" should: "+temp(3)
    Call wDokSchreiben "<up>"
    if (hGetTableName () <> temp(2)) then warnlog "Merge table didn't work? 2+ "
    EditUndo
    Call wDokSchreiben "<up><mod1 home>"

    Printlog "'///     join Pooky with Arlene -> choose upperTable -> Pooky is now above Nermal -> undo  ///"
    FormatMergeTables
    Kontext "TabellenVerbinden"
    MitVorherigerTabelleVerbinden.Check
    TabellenVerbinden.OK
    temp (5) = hGetTableName ()
    if (temp (5) <> temp(3)) then warnlog "Merge table didn't work? 3 is:"+temp (5)+" should: "+temp(3)
    Call wDokSchreiben "<up>"
    if (hGetTableName () <> temp(3)) then warnlog "Merge table didn't work? 3+ "
    EditUndo
    Call wDokSchreiben "<up><mod1 home>"

    Printlog "'///     join Arlene with Pooky -> Pooky is above Nermal -> undo ///"
    FormatMergeTables
    Kontext "TabellenVerbinden"
    if TabellenVerbinden.exists then
        warnlog "tzhere shouldn't be a table connect dialog; yust one table to connect to available "
        TabellenVerbinden.cancel
    endif
    sleep (2)
    temp (5) = hGetTableName ()
    if (temp (5) <> temp(2)) then warnlog "Merge table didn't work? 4 is:"+temp (5)+" should: "+temp(2)
    sleep (2)
    Call wDokSchreiben "<mod1 end><down>"
    sleep (3)
    if (hGetTableName () <> temp(4)) then warnlog "Merge table didn't work? 4+ "
    sleep (3)
    EditUndo
    sleep (3)
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------

function hGetPageWidth() as double
    ' get pagewidth from page  ------------
    try
        FormatPageWriter
    catch
        warnlog ":couldn't get menuentry: FormatPageWriter"
        exit function
    endcatch
    Kontext
    Active.SetPage TabSeite
    Kontext "TabSeite"
    printlog "Test: "+ Breite.GetText +" " +Links.GetText  +" " +Rechts.GetText
    hGetPageWidth = (StrToDouble(Breite.GetText) - ( StrToDouble(Links.GetText) + StrToDouble(Rechts.GetText)) )
    TabSeite.cancel
end function

