# Copyright (C) 2000-2001 The OpenRPG Project
#
#        openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: containers.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: containers.py,v 1.25 2005/06/05 20:12:34 digitalxero Exp $
#
# Description: The file contains code for the container nodehandlers
#


from core import *


##########################
##  base contiainer
##########################

class container_handler(node_handler):
    """ should not be used! only a base class!
    <nodehandler name='?'  module='core' class='container_handler'  />
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.load_children()

    def load_children(self):
        children = self.master_dom._get_childNodes()
        for c in children:
            self.tree.load_xml(c,self.mytree_node)
#     def get_design(self,evt):
#         if self.myeditor == None or self.myeditor.destroyed:
#             title = self.master_dom.getAttribute("name")
#             self.myeditor = wxPFrame(self.frame,title,HOMEPATH + 'images/d20.ico')
#             self.myeditor.panel = self.get_design_panel(self.myeditor)
#             self.myeditor.Show(1)
#         else:
#             self.myeditor.Raise()

#     def on_use(self,evt):
#         if self.myviewer == None or self.myviewer.destroyed:
#             title = self.master_dom.getAttribute("name")
#             self.myviewer = wxPFrame(self.frame,title,HOMEPATH + 'images/d20.ico')
#             self.myviewer.panel = self.get_use_panel(self.myviewer)
#             self.myviewer.Show(1)
#         else:
#             self.myviewer.Raise()

    def map_aware(self):
        aware = 0
        cookie = 0
        try:
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node,cookie)
        except: # If this happens we probably have a newer version of wxPython
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node)
        obj = self.tree.GetPyData(child)

        while obj:
            if hasattr(obj,"map_aware"):
                if obj.map_aware():
                    aware = 1
            child = self.tree.GetNextSibling(child)
            if child.IsOk():
                obj = self.tree.GetPyData(child)
            else:
                obj = 0

        return aware

    def on_send_to_map(self,evt):

        cookie = 0
        try:
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node,cookie)
        except: # If this happens we probably have a newer version of wxPython
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node)
        obj = self.tree.GetPyData(child)

        while obj:
            if hasattr(obj,"map_aware"):
                if obj.map_aware():
                    obj.on_send_to_map(evt)
            child = self.tree.GetNextSibling(child)
            if child.IsOk():
                obj = self.tree.GetPyData(child)
            else:
                return


    def on_drop(self,evt):
        drag_obj = self.tree.drag_obj
        if drag_obj == self or self.tree.is_parent_node(self.mytree_node,drag_obj.mytree_node):
            return
        opt = wxMessageBox("Add node as child?","Container Node",wxYES_NO|wxCANCEL)
        if opt == wxYES:
            xml_dom = self.tree.drag_obj.delete()
            xml_dom = self.master_dom.insertBefore(xml_dom,None)
            self.tree.load_xml(xml_dom, self.mytree_node)
            self.tree.Expand(self.mytree_node)
        elif opt == wxNO:
            node_handler.on_drop(self,evt)

    def tohtml(self):
        cookie = 0
        html_str = "<table border=\"1\" ><tr><td>"
        html_str += "<b>"+self.master_dom.getAttribute("name") + "</b>"
        html_str += "</td></tr>\n"
        html_str += "<tr><td>"
        i = 0
        try:
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node,cookie)
        except: # If this happens we probably have a newer version of wxPython
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node)
        obj = self.tree.GetPyData(child)
        while obj:
            html_str += "<p>" + obj.tohtml()
            child = self.tree.GetNextSibling(child)
            obj = self.tree.GetPyData(child)
        html_str += "</td></tr></table>"
        return html_str

    def get_size_constraint(self):
        return 1


##########################
## group node handler
##########################
class group_handler(container_handler):
    """ group nodehandler to be used as a placeholder for other nodehandlers.
        This handler will continue parsing child xml data.
        <nodehandler name='?'  module='core' class='group_handler'  />
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        container_handler.__init__(self,xml_dom,tree_node,openrpg)

    def load_children(self):
        self.atts = None
        children = self.master_dom._get_childNodes()
        for c in children:
            if c._get_tagName() == "group_atts":
                self.atts = c
            else:
                self.tree.load_xml(c,self.mytree_node)
        if not self.atts:
           elem = minidom.Element('group_atts')
           elem.setAttribute("cols","1")
           elem.setAttribute("border","1")
           self.atts = self.master_dom.appendChild(elem)

    def get_design_panel(self,parent):
        return group_edit_panel(parent,self)

    def on_use(self,evt):
        return

    def tohtml(self):
        cookie = 0
        cols = self.atts.getAttribute("cols")
        border = self.atts.getAttribute("border")
        html_str = "<table border=\""+border+"\" ><tr><td colspan=\""+cols+"\">"
        html_str += "<font size=4>"+self.master_dom.getAttribute("name") + "</font>"
        html_str += "</td></tr>\n"
        cols = int(cols)
        tdatas = []
        for i in range(0,cols):
            tdatas.append("")
        html_str += "<tr>"
        i = 0
        try:
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node,cookie)
        except: # If this happens we probably have a newer version of wxPython
            (child,cookie)=self.tree.GetFirstChild(self.mytree_node)
        obj = self.tree.GetPyData(child)
        while obj:
            tdatas[i] += "<P>" + obj.tohtml()
            child = self.tree.GetNextSibling(child)
            obj = self.tree.GetPyData(child)
            i += 1
            if i == cols:
                i = 0
        for td in tdatas:
            html_str += "<td valign=\"top\" >" + td + "</td>\n";
        html_str += "</tr></table>"
        return html_str

GROUP_COLS = wxNewId()
GROUP_BOR = wxNewId()

class group_edit_panel(wxPanel):
    def __init__(self, parent, handler):
        wxPanel.__init__(self, parent, -1)
        self.handler = handler
        sizer = wxBoxSizer(wxVERTICAL)
        self.text = {   P_TITLE : orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name'))
                      }
        sizer.Add(wxStaticText(self, -1, "Title:"), 0, wxEXPAND)
        sizer.Add(self.text[P_TITLE], 0, wxEXPAND)
        sizer.Add(wxSize(10,10))

        radio_c = wxRadioBox(self, GROUP_COLS, "Columns", choices=["1","2","3","4"])
        cols = handler.atts.getAttribute("cols")
        if cols != "":
           radio_c.SetSelection(int(cols)-1)

        radio_b = wxRadioBox(self, GROUP_BOR, "Border", choices=["no","yes"])
        border = handler.atts.getAttribute("border")
        if border != "":
           radio_b.SetSelection(int(border))

        sizer.Add(radio_c, 0, wxEXPAND)
        sizer.Add(wxSize(10,10))
        sizer.Add(radio_b, 0, wxEXPAND)

        self.sizer = sizer
        self.outline = wxStaticBox(self,-1,"Group")
        self.SetSizer(self.sizer)
        EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, P_TITLE, self.on_text)
        EVT_RADIOBOX(self, GROUP_BOR, self.on_radio_box)
        EVT_RADIOBOX(self, GROUP_COLS, self.on_radio_box)

    def on_radio_box(self,evt):
        id = evt.GetId()
        index = evt.GetInt()
        if id == GROUP_COLS:
            self.handler.atts.setAttribute("cols",str(index+1))
        elif id == GROUP_BOR:
            self.handler.atts.setAttribute("border",str(index))

    def on_text(self,evt):
        id = evt.GetId()
        if id == P_TITLE:
            txt = self.text[id].GetValue()
            if txt != "":
                self.handler.master_dom.setAttribute('name',txt)
                self.handler.rename(txt)

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.sizer.SetDimension(20,20,s[0]-40,s[1]-40)
        self.outline.SetDimensions(5,5,s[0]-10,s[1]-10)



##########################
## tabber node handler
##########################
class tabber_handler(container_handler):
    """ <nodehandler name='?'  module='containers' class='tabber_handler'  />"""

    def __init__(self,xml_dom,tree_node,openrpg):
        container_handler.__init__(self,xml_dom,tree_node,openrpg)
   #  def tohtml(self):
#         html_str = ""
#         return html_str

    def get_design_panel(self,parent):
        return tabbed_panel(parent,self,1)

    def get_use_panel(self,parent):
        return tabbed_panel(parent,self,2)


class tabbed_panel(wxNotebook):
    def __init__(self, parent, handler, mode):
        wxNotebook.__init__(self, parent, -1, size=(400,400))
        self.handler = handler
        self.parent = parent
        tree = self.handler.tree
        max = tree.GetChildrenCount(handler.mytree_node,0)
        #dlg = do_progress_dlg(parent,"Building Editors","",max)
        cookie = 0
        try:
            (child,cookie)=tree.GetFirstChild(handler.mytree_node,cookie)
        except:
            (child,cookie)=tree.GetFirstChild(handler.mytree_node)
        obj = tree.GetPyData(child)
        for m in range(max):
            if mode == 1:
                panel = obj.get_design_panel(self)
            else:
                panel = obj.get_use_panel(self)
            #print panel
            name = obj.master_dom.getAttribute("name")
            #dlg.Update(i, name)
            if panel:
                self.AddPage(panel,name)
                #print "add panel
            if m < max-1:
                child = tree.GetNextSibling(child)
                if child.IsOk():
                    obj = tree.GetPyData(child)
                else:
                    obj = 0
        #dlg.Update(max)
        #dlg.Destroy()

#################################
## Splitter container
#################################

class splitter_handler(container_handler):
    """ <nodehandler name='?'  module='containers' class='splitter_handler'  />"""

    def __init__(self,xml_dom,tree_node,openrpg):
        container_handler.__init__(self,xml_dom,tree_node,openrpg)

  #   def tohtml(self):
#         html_str = ""
#         return html_str

    def get_design_panel(self,parent):
        return build_splitter_wnd(parent,self,1)

    def get_use_panel(self,parent):
        return build_splitter_wnd(parent,self,2)

    def on_drop(self,evt):
        drag_obj = self.tree.drag_obj
        #if self.is_my_child(self.mytree_node,drag_obj.mytree_node):
        #    return
        if self.tree.GetChildrenCount(self.mytree_node,0) >= 2:
            wxMessageBox("Splitters can't have more than 2 nodes")
        else:
            container_handler.on_drop(self,evt)

def build_splitter_wnd(parent,handler,mode):
    splitter = wxSplitterWindow(parent, -1)
    tree = handler.tree
    cookie = 0
    try:
        (child,cookie)=tree.GetFirstChild(handler.mytree_node,cookie)
    except: # If this happens we probably have a newer version of wxPython
        (child,cookie)=tree.GetFirstChild(handler.mytree_node)
    obj1 = tree.GetPyData(child)
    child = tree.GetLastChild(handler.mytree_node)
    obj2 = tree.GetPyData(child)
    if mode==1:
        panel1 = obj1.get_design_panel(splitter)
        panel2 = obj2.get_design_panel(splitter)
    else:
        panel1 = obj1.get_use_panel(splitter)
        panel2 = obj2.get_use_panel(splitter)
    splitter.SplitVertically(panel1,panel2,240)
    #(w,h) = parent.GetClientSizeTuple()
    #splitter.SetSashPosition(w/2)
    return splitter


