from wxPython.wx import *
from os import listdir
import sys #first, to add the plugin directory to the path, and second, to let plugins be re-imported
import plugindb
import orpg.dirpath
import traceback

sys.path.append(orpg.dirpath.dir_struct["plugins"])

about="This is the OpenRPG Plugin Control Panel. Check a plugin to load it. \
The order in which you check each plugin will determine the order in which the \
plugins are loaded. Read the Plugin Info to see what a plugin does and how it \
works.\n\n\
Be sure to go to http://mduo13.no-ip.org/ to download more plugins, request \
new plugins, or comment on the ones you have. \n\n\
Thanks go out to Woody, for making the original plugin patch; to tdb30_, for \
helping me out all the time; to Mercenary, for his support; to \
Sheng Long Gradilla for helping me out getting the imports to work; to \
posterboy for making OpenRPG in the first place, and to all those who've used \
the plugins and encouraged me to improve it.\n\n\
~mDuo13"

class StartupLoader:#This is here so ORPG doesn't try to find these while
    #importing modules and then fail to boot.
    def __init__(self):
        self.enabled_plugins={}
        self.disabled_plugins={}
    def destroy():
        pass

frame=StartupLoader()

#This is the window that asks a user to pick which plugins will be loaded
#the next time he or she loads OpenRPG.
class PluginsOnStart(wxFrame):
    def __init__(self, parent, id, title):
        wxFrame.__init__(self, parent, id, title,
                         wxDefaultPosition, wxSize(250, 300))

        self.parent = parent

        self.stattxt=wxStaticText(self, ID_STATTXT, "Please check the plugins that\n you want loaded on startup.", (20, 10))
        x = self.parent.available_plugins.keys()
        x.sort()
        self.start_plugs=self.plugin_checkbox=wxCheckListBox(self, ID_STARTLIST, (80, 50), (80, 120), x )
        self.parent.start_plugs = self.start_plugs
        self.ok=wxButton(self, ID_OKBTN, "Ok")

        self.sizer = wxBoxSizer(wxVERTICAL)
        self.sizer.Add(self.stattxt, 0)
        self.sizer.Add(self.start_plugs, 1, wxEXPAND)
        self.sizer.Add(self.ok, 0)
        self.SetSizer(self.sizer)
        self.SetAutoLayout(true)

        EVT_BUTTON(self, ID_OKBTN, self.OnClose)

    def OnClose(self, event):
        plugins_to_load = []
        for entry in range(0, len(self.parent.available_plugins.keys() )):
            if self.start_plugs.IsChecked(entry) == true:
                plugins_to_load += [self.start_plugs.GetString(entry)]
        self.parent.plugindb.SetList("plugincontroller", "startup_plugins", plugins_to_load)
        self.Destroy()

#Checklist IDs
ID_CHKLST = wxNewId()
ID_STARTLIST = wxNewId()

#Static Text ID
ID_STATTXT = wxNewId()

#Button IDs
ID_BTN1 = wxNewId()
ID_BTN2 = wxNewId()
ID_BTN3 = wxNewId()
ID_BTN4 = wxNewId()
ID_OKBTN = wxNewId()

#Main menu IDs
ID_RELOAD = wxNewId()
ID_STUPLD = wxNewId()
ID_CLOSE = wxNewId()

#Plugin menu IDs
ID_ENBALL = wxNewId()
ID_DISALL = wxNewId()
ID_ENDEF = wxNewId()

#Help menu IDs
ID_ABOUT = wxNewId()
ID_HELP = wxNewId()
ID_INFO = wxNewId()

#the main plugin window
class PluginFrame(wxFrame):
    def __init__(self, parent, ID):
        title="Plugin Control Panel"
        wxFrame.__init__(self, parent, ID, title,
                         wxDefaultPosition, wxSize(350, 250))

        #Passing items from ORPG to the this class
        #so they can be passed to the plugins
        self.chat = parent.chat
        self.tree = parent.tree
        self.session = parent.myopenrpg.get_component("session")
        self.settings = parent.myopenrpg.get_component('settings')
        self.mainmenu = parent.mainmenu
        self.plugindb = plugindb.PluginDB()
        self.parent = parent
        self.startplugs = self.plugindb.GetList("plugincontroller", "startup_plugins", [])

        #########################
        #Step 1: Create the Menu#
        #########################
        main_menu=wxMenu()#Main menu
        main_menu.Append(ID_RELOAD, "&Update Plugin List")
        main_menu.Append(ID_STUPLD, "Plugins Loaded on &Startup")
        main_menu.Append(ID_CLOSE, "&Close")

        plugin_menu = wxMenu()#Plugin menu
        plugin_menu.Append(ID_ENBALL, "&Enable All")
        plugin_menu.Append(ID_DISALL, "&Disable All")
        plugin_menu.Append(ID_ENDEF, "Enable &Startup Plugins")

        help_menu = wxMenu()#Help menu
        help_menu.Append(ID_ABOUT, "About")
        #help_menu.Append(ID_HELP, "Help")
        help_menu.Append(ID_INFO, "Plugin &Info")

        menubar = wxMenuBar()#menu bar
        menubar.Append(main_menu, "&Main")
        menubar.Append(plugin_menu, "&Plugin")
        menubar.Append(help_menu, "&Help")
        self.SetMenuBar(menubar)

        ################################
        #Step 2: Create the GUI Objects#
        ################################


        #okay, not all of them are GUI objects. So sue me.
        self.available_plugins = {}
        #The entries (second value) are to keep track of
        #whether the plugin is loaded. 1=loaded, 0=not loaded
        #The keys (first value) are the plugins' names

        self.socket = {}
        #this is here to keep track of plugins' information.
        #the keys are the plugins' longnames (because that's what the wxCheckBoxList has)
        #and the data is a list in the form of [filename, author, helptext]

        self.disabled_plugins = {}
        #this contains the actual imported plugins.
        #only the ones that are not currently in use though
        #it's indexed by their filename

        self.enabled_plugins  = {}
        #this contains actual imported plugins also.
        #these are only the ones in use.
        #it's also indexed by filename

        self.plugin_checkbox=wxCheckListBox(self, ID_CHKLST, (80, 50), (80, 120), self.available_plugins.keys() )
        #warn = wxStaticText(self, -1, "Note: Plugins are not created or supported by the OpenRPG dev team. Only use plugins from sources you trust. \nVisit http://mduo13.no-ip.org/ for more information about plugins.\n", style=wxALIGN_CENTRE)

        btn1 = wxButton(self, ID_BTN1, "Enable All")
        btn2 = wxButton(self, ID_BTN2, "Disable All")
        btn3 = wxButton(self, ID_BTN3, "Update List")
        btn4 = wxButton(self, ID_BTN4, "Plugin Info")

        #########################
        #Step 3: Organize Layout#
        #########################

        button_sizer = wxBoxSizer(wxVERTICAL)
        button_sizer.Add(btn1, 1, wxEXPAND)
        button_sizer.Add(btn2, 1, wxEXPAND)
        button_sizer.Add(btn3, 1, wxEXPAND)
        button_sizer.Add(btn4, 1, wxEXPAND)

        main_sizer = wxBoxSizer(wxHORIZONTAL)
        main_sizer.Add(self.plugin_checkbox, 1, wxEXPAND)
        main_sizer.Add(button_sizer, 0, wxEXPAND)

        mainer_sizer = wxBoxSizer(wxVERTICAL)
        mainer_sizer.Add(main_sizer, 1, wxEXPAND)
        #mainer_sizer.Add(warn, 0, wxEXPAND)

        self.SetAutoLayout(true)
        self.SetSizer(mainer_sizer)

        #########################
        #Step 4: List Event Keys#
        #########################

        EVT_MENU(self, ID_RELOAD, self.ReloadPlugins)
        EVT_MENU(self, ID_STUPLD, self.StartUpPlugins)
        EVT_MENU(self, ID_CLOSE, self.CloseWindow)
        #EVT_MENU(self, ID_ENABLE, self.EnablePlugin)
        #EVT_MENU(self, ID_DSABLE, self.DisablePlugin)
        EVT_MENU(self, ID_ENBALL, self.EnableAllPlugins)
        EVT_MENU(self, ID_DISALL, self.DisableAllPlugins)
        EVT_MENU(self, ID_ABOUT, self.About)
        #EVT_MENU(self, ID_HELP, self.Help)
        EVT_MENU(self, ID_INFO, self.PluginInfo)
        EVT_MENU(self, ID_ENDEF, self.StartupPlugs)

        EVT_BUTTON(self, ID_BTN1, self.EnableAllPlugins)
        EVT_BUTTON(self, ID_BTN2, self.DisableAllPlugins)
        EVT_BUTTON(self, ID_BTN3, self.ReloadPlugins)
        EVT_BUTTON(self, ID_BTN4, self.PluginInfo)

        EVT_CHECKLISTBOX(self, ID_CHKLST, self.TogglePlugin)

        EVT_CLOSE(self, self.CloseWindow)

        ############################
        #Step 5: Create Plugin List#
        ############################

        self.ReloadPlugins(1)#the 1 is just there to fill in for "event" since there isn't one in this case

        self.StartupPlugs(1)


    ##############################
    #Step 6: Function Definitions#
    ##############################

    def ReloadPlugins(self, event):
        self.DisableAllPlugins(ID_BTN2)
        list_of_plugin_dir = listdir(orpg.dirpath.dir_struct["plugins"])
        self.available_plugins={}
        for entry in self.disabled_plugins.keys():
            del self.disabled_plugins[entry]
        for entry in self.enabled_plugins.keys():
            del self.enabled_plugins[entry]
        self.socket={}
        for p in list_of_plugin_dir:
            if p[:2].lower()=="xx" and p[-3:]==".py":
                self.ImpPlugin(p[:-3])

        x = self.available_plugins.keys()
        x.sort()
        self.plugin_checkbox.Set( x )

    def StartupPlugs(self, event):
        self.DisableAllPlugins(1)
        #plugs_to_load = filetext.split("\n")
        self.startplugs = self.plugindb.GetList("plugincontroller", "startup_plugins", [])
        for entry in self.startplugs:
            num = self.plugin_checkbox.FindString(entry)
            if num !=-1:
                self.plugin_checkbox.Check(num, 1)
                try:
                    self.plugin_checkbox.SetSelection(num)
                    self.EnablePlugin(ID_CHKLST)
                except:
                    pass

    def ImpPlugin(self, pname):
        try:
            if pname in sys.modules:
                del sys.modules[pname]#to ensure that the newly-imported one will be used correctly. No, reload() is not a better way to do this.
            plugin = __import__(pname)
            plugin.chat=self.chat
            plugin.session=self.session
            plugin.gametree=self.tree
            plugin.openrpg=self.parent
            plugin.plugindb=self.plugindb
            try:
                #A runtime routine for plugins.
                #If they load global settings from the plugindb on startup, or
                #if they change the main OpenRPG window (i.e. its size and position)
                #at runtime, then they do it from this routine.
                #The reason for this is that the chat, session, gametree,
                #openrpg, and plugindb variables won't have been passed to the plugin
                #until now (loose code will run on the __import__ which has to come
                #before those.
                plugin.load(self)
            except Exception, e:
                if str(e) != "'module' object has no attribute 'load'":
                    #print e
                    traceback.print_exc()
                pass
            self.disabled_plugins[pname]=plugin
            self.socket[plugin.name]=[pname, plugin.author, plugin.help]
            self.available_plugins[plugin.name]=0
            #print "ImpPlugin("+pname+"): ", plugin, "with name", plugin.name
            return plugin

        except Exception, e:
            #print e
            traceback.print_exc()


    def StartUpPlugins(self, event):
        dlg = PluginsOnStart(self, -1, "Startup Plugins")
        dlg.Show(true)

    def CloseWindow(self, event):
        self.Show(false)

    def EnablePlugin(self, event):
        if self.plugin_checkbox.GetStringSelection()=="":
            return
        plugname = self.plugin_checkbox.GetStringSelection()
        num = self.plugin_checkbox.GetSelection()
        fname = self.socket[plugname][0]#must come before the socket entry is deleted
        del self.available_plugins[plugname]#delete it in case the longname has changed
        del self.socket[plugname]#same as above
        #print "Enable Plugin: plugname =", plugname
        self.ImpPlugin(fname)
        newname = self.disabled_plugins[fname].name #get the new name now that it's been re-imported
        self.available_plugins[newname] = 1#set it to enabled in this list, for later reference. MUST COME AFTER ImpPlugin()
        self.enabled_plugins[fname] = self.disabled_plugins[fname]#add it to the enabled list
        if plugname != newname:#I have to go through this workaround becaues the wxCheckListBox.SetString() method is broken
            x = self.available_plugins.keys()
            x.sort()
            self.plugin_checkbox.Set( x )#set the checklistbox to have the new data
            self.ReCheckList(newname)#since .Set() unchecks everything, re-check whatever should be checked

    def ReCheckList(self, sselection):
        for plugin in self.available_plugins.keys():
            a = self.plugin_checkbox.FindString(plugin)
            self.plugin_checkbox.Check(a, self.available_plugins[plugin])
            self.plugin_checkbox.SetStringSelection(sselection)

    def DisablePlugin(self, event):
        if self.plugin_checkbox.GetStringSelection()=="":
            return
        plugname = self.plugin_checkbox.GetStringSelection()
        self.available_plugins[plugname] = 0
        fname = self.socket[plugname][0]
        self.disabled_plugins[fname] = self.enabled_plugins[fname]
        del self.enabled_plugins[fname]

    def EnableAllPlugins(self, event):
        for num in range(0,len( self.available_plugins.keys() )):
            self.plugin_checkbox.Check(num, 1)
            try:
                self.plugin_checkbox.SetSelection(num)
                self.EnablePlugin(ID_CHKLST)
            except:
                pass

    def DisableAllPlugins(self, event):
        for num in range(0,len( self.available_plugins.keys() )):
            self.plugin_checkbox.Check(num, 0)
            try:
                self.plugin_checkbox.SetSelection(num)
                self.DisablePlugin(ID_CHKLST)
            except:
                pass

    def About(self, event):
        dlg = wxMessageDialog(None, about,
                      'About the ORPG Plugin Controller', wxOK)
        dlg.ShowModal()
        dlg.Destroy()

    def Help(self, event):
        pass

    def PluginInfo(self, event):
        plugname = self.plugin_checkbox.GetStringSelection()
        fname = self.socket[plugname][0]
        try:
            #info = self.disabled_plugins[fname].help
            info = "Author:\t"+self.socket[plugname][1]+"\n\n"+self.socket[plugname][2]
        except:
            info = self.enabled_plugins[fname].help
        dlg = wxMessageDialog(None, info,
                      'Plugin Information: '+plugname, wxOK)
        dlg.ShowModal()
        dlg.Destroy()

    def TogglePlugin(self, event):
        current_selection = self.plugin_checkbox.GetSelection()
        for plugname in self.available_plugins.keys():
            num = self.plugin_checkbox.FindString(plugname)
            if self.available_plugins[plugname] == 0 and self.plugin_checkbox.IsChecked(num) == 1:
                self.plugin_checkbox.SetSelection(num)
                self.EnablePlugin(ID_CHKLST)
                return#so that the Else does not run
            elif self.available_plugins[plugname] == 1 and self.plugin_checkbox.IsChecked(num) == 0:
                self.available_plugins[plugname] = 0
                self.plugin_checkbox.SetSelection(num)
                self.DisablePlugin(ID_CHKLST)
                return#so that the else does not run
        else:#if it doesn't find an change in the checklist
            print "Enabled and Checked Plugins not matching up..."
            pass
