name="Idle Time"
author="Woody, mDuo13"
help="""When you haven't sent a message to chat for a minute or more, this
plugin sets your status to end with '(* Mins)' where the * is however many
minutes you've been inactive. You can also set a custom message for the timed
idle by typing '/idle status *text*' where *text* is that message."""
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
import os

from random import randint
from time import time
chat=None
session=None
tree=None
openrpg=None

idle_timer_status = ""

class v:
    #basically using this to store all my global type variables
    current_time=time()
    minutes=0

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    v.minutes=0
    v.current_time=time()
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever any message is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    global idle_timer_status
    if text[:12]=="/idle status":
        idle_timer_status = text[13:]
        return 1
    return 0

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    global idle_timer_status
    if idle_timer_status == "":
        idle_timer_status = self.settings.get_setting("IdleStatusAlias")
    mytime=time()
    if mytime-v.current_time >=60:
        v.current_time=mytime
        v.minutes+=1
        if v.minutes==1:
            s=""
        else:
            s="s"
        session.set_text_status(idle_timer_status+" ("+str(v.minutes)+" min"+s+")")
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    pass
