// -*- C++ -*- 
/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef REPORTER_H
#define REPORTER_H

#include "openschedException.h"
#include "project.h"

typedef struct NETWORK_CELL
{
    int isSpace;
    TASK *task;

    struct NETWORK_CELL *prev;
    struct NETWORK_CELL *next;
}
NETWORK_CELL;


class TASKGRAPH
{
public:
    TASKGRAPH(int s, int f, string &fn) : start(s), finish(f), filename(fn) {};
    int start;
    int finish;
    const string filename;
};


class TASKNET
{
public:
    TASKNET(int s, int f, string &fn) : start(s), finish(f), filename(fn) {};
    int start;
    int finish;
    const string filename;
};


class Reporter
{
public:
    
    typedef enum
    {
	TXT_REPORT,
	TEX_REPORT,
	HTML_REPORT
    }
    REPORTTYPE;

# define VARIABLE(AA,BB,CC) AA BB;
#include "reporter.i"

    Reporter();
    void DoReports( Project *project );
    void HTMLReport( Project *project, char *filename);
    void WeeklyReport( Project *project, char *filename, REPORTTYPE rep_type);
    void MonthlyReport( Project *project, char *filename, REPORTTYPE rep_type);
    void UtilGraph( Project *project, char *filename);
    void AddTaskGraph( int d1, int d2, char *fname );
    void AddNetworkDiagram(int c1, int c2, char *fname);
    void checkComplete();
    void SlippageReport( Project *project );
    void TextReport( Project *project, char *filename);
    void XMLReport( Project *project, char *filename);
    void HardSchedule( Project *project, char *filename);
    void TexReport( Project *project, char *filename);
    void PrintResourcePeriod( Project *project,
			      FILE *f, RESOURCE *r, int dayNo, int lastDay,
			      REPORTTYPE rep_type);

private:

    typedef int (Reporter::* Pperfunc)(Project *project, int day, char *name);

    int Wday(time_t t);
    int Mday(time_t t);
    void PrintPeriod(Project *project,
		     FILE *f, int dayNo, int lastDay, char *weekName,
		     REPORTTYPE rep_type);
    void PeriodicReport( Project * project,
			 Pperfunc IsPeriod,
			 char *filename,
			 REPORTTYPE rep_type);
    int IsWeek(Project *project, int dayNo, char *name);
    int IsMonth(Project *project, int dayNo, char *name);

    void Debug(char *fmt, ...);
    void Error(char *fmt, ...);
    void Warning(char *fmt, ...);
    FILE *OpenOutputFile(char *filename);
    char *TeXFix(char *buf, const char *txt);
    char *HTMLFix(char *buf, const char *txt);
    int MapX( Project *project, int dayNo, int start, int finish);
    int Bound(int x, int x1, int x2);
    int Offset(int x, int x1, int x2 );
    FILE *OpenTaskGraph(const char *filename, int x1, int y1, int x2, int y2);
    void TaskGraph( Project *project, int start, int finish, const char *filename);
    FILE *openNetworkDiagram( Project *project, 
			      const char *filename, int llx, int lly, int urx, int ury);
    void write_milestones( Project *project, 
			   FILE *fp, int ax, int bx, int ay, int by);
    void write_chart( Project *project, int start, int finish, const char *filename);
    NETWORK_CELL *findCellInColumn(int x, const char *id);
    void NetworkDiagram( Project *project, int start, int finish, const char *filename);
    // network diagrams
    void constructStartFinish( Project *project );
    int maximumX(Project *project);
    void assignY(Project *project);
    TASK * mStartTask;
    TASK * mFinishTask;
    // cost reports
    void TeXCostReport(Project *project, FILE *f);
    void HTMLCostReport(Project *project, FILE *f);
    void CostReport(Project *project, char *filename, REPORTTYPE rep_type);

    char *monthNames[13];
    int Month(time_t t);
    int Year(time_t t);

    vector<TASKGRAPH *> mTaskGraphs;
    vector<TASKNET *> mTaskNets;
};


class ReporterException 
  : public OpenschedException
{
public:
    ReporterException( string reason );
    ~ReporterException();
};

#endif






