#ifndef ROUTER_H
#define ROUTER_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <inttypes.h>
#include <netinet/in.h>

#include <ber/ber.h>
#include <tinysnmp/manager/snmp.h>

/* if->status values */
#define IF_STATUS_UP				1
#define IF_STATUS_DOWN				2
#define IF_STATUS_TESTING			3
#define IF_STATUS_UNKNOWN			4
#define IF_STATUS_DORMANT			5
#define IF_STATUS_NOTPRESENT		6
#define IF_STATUS_LOWERLAYERDOWN	7

/* if->octets, if->discards, if->errors indexes */
#define IF_PACKET_IN	0
#define IF_PACKET_OUT	1

/* if->status indexes */
#define IF_OPER_STATUS	0
#define IF_ADMIN_STATUS	1

typedef struct interface_r
{
   int idx;										/* interface index */
   char *descr;									/* interface description */
   char *alias;									/* detailed description of interface */
   int valid;									/* are the data below valid? */
   uint32_t octets[2],discards[2],errors[2];	/* interface counters */
   int status[2];								/* indicate whether interface is up/down */
   uint32_t speed;								/* estimated maximum speed of interface */
   struct interface_r *next;
} interface_t;

typedef struct
{
   char *hostname;								/* name of router */
   char *name;									/* short system name */
   interface_t *iface;							/* interface list */
   int ignore_admin_down;						/* if this flag is set, administratively down interfaces are not graphed */
   snmp_agent_t agent;
} router_t;

/*
 * Initialize the router structure used by other functions.
 */
extern int router_open (router_t *router,const char *hostname,const char *service,const char *community,uint32_t timeout,uint32_t retries);

/*
 * Query router and update interface counters.
 */
extern int router_update (router_t *router);

/*
 * Remove the specified interface from the list of router interfaces.
 */
extern int router_purge_interface (router_t *router,const char *descr);

/*
 * Close the connection and free memory allocated by router_open().
 */
extern void router_close (router_t *router);

#endif	/* #ifndef ROUTER_H */
