(* ocaml-units -- a module for handling standard operations on
 *                physical units
 * 
 * Copyright (C) 2004 Paul Pelzl
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Please send feedback, bug reports, patches, etc. to 
 * <pelzlpj@eecs.umich.edu>.
 *)


open Units;;

let avagadro_number              = unit_of_float_string 6.0221367e23 "mol^-1";;
let boltzmann                    = unit_of_float_string 1.380658e-23 "J/K";;
(* HP48 drops the m^3 for the following.  Not sure why. *)
let molar_volume                 = unit_of_float_string 0.0224141 "m^3/mol";;
let universal_gas                = unit_of_float_string 8.31451 "J/mol/K";;
let standard_temperature         = unit_of_float_string 273.15 "K";;
let standard_pressure            = unit_of_float_string 101.325 "kPa";;
let stefan_boltzmann             = unit_of_float_string 5.67051e-8 "W/m^2/K^4";;
let light_speed                  = unit_of_float_string 299792458.0 "m/s";;
let permittivity                 = unit_of_float_string 8.85418781761e-12 "F/m";;
let permeability                 = unit_of_float_string 1.25663706144e-6 "H/m";;
let acceleration_gravity         = unit_of_float_string 9.80665 "m/s^2";;
let newton_gravitation           = unit_of_float_string 6.67259e-11 "m^3/s^2/kg";;
let planck_h                     = unit_of_float_string 6.6260755e-34 "J*s";;
let dirac_hbar                   = unit_of_float_string 1.05457266e-34 "J*s";;
let electron_charge              = unit_of_float_string 1.60217733e-19 "C";;
let electron_mass                = unit_of_float_string 9.1093897e-31 "kg";;
let proton_mass                  = unit_of_float_string 1.6726231e-17 "kg";;
let fine_structure               = unit_of_float_string 0.00729735308 "";;
let magnetic_flux_quantum        = unit_of_float_string 2.06783461e-15 "Wb";;
let faraday                      = unit_of_float_string 96485.309 "C/mol";;
let rydberg                      = unit_of_float_string 10973731.534 "m^-1";;
let bohr_radius                  = unit_of_float_string 0.0529177249 "nm";;
let bohr_magneton                = unit_of_float_string 9.2740154e-24 "J/T";;
let nuclear_magneton             = unit_of_float_string 5.0507866e-27 "J/T";;
let photon_wavelength            = unit_of_float_string 1239.8425 "nm";;
let photon_frequency             = unit_of_float_string 2.4179883e14 "Hz";;
let compton_wavelength           = unit_of_float_string 0.00242631058 "nm";;
let wien                         = unit_of_float_string 0.002897756 "m*K";;
let dielectric_silicon           = unit_of_float_string 11.9 "";;



(* arch-tag: DO_NOT_CHANGE_1c6c88d4-3b57-4b5a-85fc-02372437ea3f *)
