/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import org.javagroups.ChannelException;
import org.javagroups.blocks.TwoPhaseVotingListener;
import org.javagroups.blocks.VoteException;
import org.javagroups.blocks.VotingAdapter;
import org.javagroups.blocks.VotingListener;

public class TwoPhaseVotingAdapter {
    private VotingAdapter voteChannel;

    public void addListener(TwoPhaseVotingListener listener) {
        this.voteChannel.addVoteListener(new TwoPhaseVoteWrapper(listener));
    }

    public void removeListener(TwoPhaseVotingListener listener) {
        this.voteChannel.removeVoteListener(new TwoPhaseVoteWrapper(listener));
    }

    public boolean vote(Object decree, long timeout) throws ChannelException {
        TwoPhaseWrapper wrappedDecree = new TwoPhaseWrapper(decree);
        try {
            if (this.voteChannel.vote(wrappedDecree, timeout / (long)3)) {
                wrappedDecree.commit();
                if (!this.voteChannel.vote(wrappedDecree, timeout / (long)3)) {
                    wrappedDecree.abort();
                    this.voteChannel.vote(wrappedDecree, timeout / (long)3);
                    return false;
                }
                return true;
            }
            wrappedDecree.abort();
            this.voteChannel.vote(wrappedDecree, timeout / (long)3);
            return false;
        }
        catch (ChannelException chex) {
            wrappedDecree.abort();
            this.voteChannel.vote(wrappedDecree, timeout / (long)3);
            throw chex;
        }
    }

    public TwoPhaseVotingAdapter(VotingAdapter voteChannel) {
        this.voteChannel = voteChannel;
    }

    public static class TwoPhaseVoteWrapper
    implements VotingListener {
        private TwoPhaseVotingListener listener;

        public boolean vote(Object decree) throws VoteException {
            if (!(decree instanceof TwoPhaseWrapper)) {
                throw new VoteException("Not my type of decree. Ignore me.");
            }
            TwoPhaseWrapper wrapper = (TwoPhaseWrapper)decree;
            if (wrapper.isPrepare()) {
                return this.listener.prepare(wrapper.getDecree());
            }
            if (wrapper.isCommit()) {
                return this.listener.commit(wrapper.getDecree());
            }
            this.listener.abort(wrapper.getDecree());
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object other) {
            return this.listener.equals(other);
        }

        public TwoPhaseVoteWrapper(TwoPhaseVotingListener listener) {
            this.listener = listener;
        }
    }

    public static class TwoPhaseWrapper
    implements Serializable {
        private static final int PREPARE = 0;
        private static final int COMMIT = 1;
        private static final int ABORT = 2;
        private Object decree;
        private int type;

        public Object getDecree() {
            return this.decree;
        }

        public void setDecree(Object decree) {
            this.decree = decree;
        }

        private final int getType() {
            return this.type;
        }

        private final void setType(int type) {
            this.type = type;
        }

        private final boolean isType(int type) {
            boolean bl = false;
            if (this.type == type) {
                bl = true;
            }
            return bl;
        }

        public boolean isPrepare() {
            return this.isType(0);
        }

        public boolean isCommit() {
            return this.isType(1);
        }

        public boolean isAbort() {
            return this.isType(2);
        }

        public void commit() {
            this.setType(1);
        }

        public void abort() {
            this.setType(2);
        }

        public String toString() {
            return this.decree.toString();
        }

        public TwoPhaseWrapper(Object decree) {
            this.setDecree(decree);
            this.setType(0);
        }
    }
}

