/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javagroups.conf.ClassMap;
import org.javagroups.conf.ClassPathEntityResolver;
import org.javagroups.log.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MagicNumberReader {
    private static boolean xml_debug = false;
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public String mMagicNumberFile;

    public void setFilename(String file) {
        this.mMagicNumberFile = file;
    }

    public ClassMap[] readMagicNumberMapping() {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.mMagicNumberFile);
            if (stream == null) {
                Trace.warn("MagicNumberReader.readMagicNumberMapping()", "failed reading " + this.mMagicNumberFile + ". Please make sure it is in the CLASSPATH. Will continue, but marshalling will be slower");
                return new ClassMap[0];
            }
            return MagicNumberReader.parse(stream);
        }
        catch (Exception x) {
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("MagicNumberReader.readMagicNumberMapping()", error);
            return new ClassMap[0];
        }
    }

    protected static ClassMap[] parse(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new ClassPathEntityResolver());
        Document document = builder.parse(stream);
        NodeList class_list = document.getElementsByTagName("class");
        Vector<ClassMap> v = new Vector<ClassMap>();
        int i = 0;
        while (i < class_list.getLength()) {
            if (class_list.item(i).getNodeType() == 1) {
                v.addElement(MagicNumberReader.parseClassData(class_list.item(i)));
            }
            ++i;
        }
        Object[] data = new ClassMap[v.size()];
        v.copyInto(data);
        return data;
    }

    protected static ClassMap parseClassData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            int pos = 0;
            NodeList children = protocol.getChildNodes();
            String clazzname = null;
            String desc = null;
            String preload = null;
            String magicnumber = null;
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    switch (++pos) {
                        case 1: {
                            desc = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        case 2: {
                            clazzname = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        case 3: {
                            preload = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        case 4: {
                            magicnumber = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                    }
                }
                ++i;
            }
            return new ClassMap(clazzname, desc, Boolean.valueOf(preload), Integer.valueOf(magicnumber));
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("MagicNumberReader.parseClassData()", error);
            throw new IOException(x.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mMagicNumberFile = MAGIC_NUMBER_FILE;
    }

    public MagicNumberReader() {
        this.this();
    }
}

