/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javagroups.conf.ClassPathEntityResolver;
import org.javagroups.conf.ProtocolData;
import org.javagroups.conf.ProtocolParameter;
import org.javagroups.conf.ProtocolStackConfigurator;
import org.javagroups.log.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XmlConfigurator
implements ProtocolStackConfigurator {
    private static boolean xml_debug = true;
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_INHERIT = "inherit";
    public static final String ELMT_PROT_OVERRIDE = "protocol-override";
    public static final String ELMT_PROT = "protocol";
    public static final String ELMT_PROT_NAME = "protocol-name";
    public static final String ELMT_CLASS = "class-name";
    public static final String ELMT_DESCRIPTION = "description";
    public static final String ELMT_PROT_PARAMS = "protocol-params";
    private ArrayList mProtocolStack;
    private String mStackName;

    public static XmlConfigurator getInstance(URL url) throws IOException {
        return XmlConfigurator.getInstance(url.openStream());
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.parse(stream);
    }

    public static XmlConfigurator getInstance(Element el) throws IOException {
        return XmlConfigurator.parse(el);
    }

    public String getProtocolStackString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.mProtocolStack.iterator();
        while (it.hasNext()) {
            ProtocolData d = (ProtocolData)it.next();
            buf.append(d.getProtocolString());
            if (!it.hasNext()) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public ProtocolData[] getProtocolStack() {
        return this.mProtocolStack.toArray(new ProtocolData[this.mProtocolStack.size()]);
    }

    public String getName() {
        return this.mStackName;
    }

    public void override(ProtocolData data) throws IOException {
        int index = this.mProtocolStack.indexOf(data);
        if (index < 0) {
            throw new IOException("You can not override a protocol that doesn't exist");
        }
        ProtocolData source = (ProtocolData)this.mProtocolStack.get(index);
        source.override(data.getParametersAsArray());
    }

    public void add(ProtocolData data) {
        this.mProtocolStack.add(data);
    }

    protected static XmlConfigurator parse(InputStream stream) throws IOException {
        XmlConfigurator configurator = null;
        try {
            boolean isinherited;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ClassPathEntityResolver());
            Document document = builder.parse(stream);
            Element root = (Element)document.getElementsByTagName("protocol-stack").item(0);
            root.normalize();
            String stackname = root.getAttribute(ATTR_NAME);
            String inherit = root.getAttribute(ATTR_INHERIT);
            boolean bl = false;
            if (inherit != null && inherit.length() > 0) {
                bl = true;
            }
            NodeList protocol_list = document.getElementsByTagName((isinherited = bl) ? ELMT_PROT_OVERRIDE : ELMT_PROT);
            Vector<ProtocolData> v = new Vector<ProtocolData>();
            int i = 0;
            while (i < protocol_list.getLength()) {
                if (protocol_list.item(i).getNodeType() == 1) {
                    v.addElement(XmlConfigurator.parseProtocolData(protocol_list.item(i)));
                }
                ++i;
            }
            Object[] protocols = new ProtocolData[v.size()];
            v.copyInto(protocols);
            if (isinherited) {
                URL inheritURL = new URL(inherit);
                configurator = XmlConfigurator.getInstance(inheritURL);
                int i2 = 0;
                while (i2 < protocols.length) {
                    configurator.override((ProtocolData)protocols[i2]);
                    ++i2;
                }
            } else {
                configurator = new XmlConfigurator(stackname, (ProtocolData[])protocols);
            }
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
        return configurator;
    }

    protected static XmlConfigurator parse(Element root) throws IOException {
        XmlConfigurator configurator = null;
        try {
            boolean isinherited;
            Document document = root.getOwnerDocument();
            String stackname = root.getAttribute(ATTR_NAME);
            String inherit = root.getAttribute(ATTR_INHERIT);
            boolean bl = false;
            if (inherit != null && inherit.length() > 0) {
                bl = true;
            }
            NodeList protocol_list = document.getElementsByTagName((isinherited = bl) ? ELMT_PROT_OVERRIDE : ELMT_PROT);
            Vector<ProtocolData> v = new Vector<ProtocolData>();
            int i = 0;
            while (i < protocol_list.getLength()) {
                if (protocol_list.item(i).getNodeType() == 1) {
                    v.addElement(XmlConfigurator.parseProtocolData(protocol_list.item(i)));
                }
                ++i;
            }
            Object[] protocols = new ProtocolData[v.size()];
            v.copyInto(protocols);
            if (isinherited) {
                URL inheritURL = new URL(inherit);
                configurator = XmlConfigurator.getInstance(inheritURL);
                int i2 = 0;
                while (i2 < protocols.length) {
                    configurator.override((ProtocolData)protocols[i2]);
                    ++i2;
                }
            } else {
                configurator = new XmlConfigurator(stackname, (ProtocolData[])protocols);
            }
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
        return configurator;
    }

    protected static ProtocolData parseProtocolData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            boolean isOverride = ELMT_PROT_OVERRIDE.equals(protocol.getNodeName());
            int pos = 0;
            NodeList children = protocol.getChildNodes();
            String name = null;
            String clazzname = null;
            String desc = null;
            ProtocolParameter[] plist = null;
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    if (isOverride && ++pos == 2) {
                        pos = 4;
                    }
                    switch (pos) {
                        case 1: {
                            name = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        case 2: {
                            desc = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        case 3: {
                            clazzname = children.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        case 4: {
                            plist = XmlConfigurator.parseProtocolParameters((Element)children.item(i));
                            break;
                        }
                    }
                }
                ++i;
            }
            if (isOverride) {
                return new ProtocolData(name, plist);
            }
            return new ProtocolData(name, desc, clazzname, plist);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
    }

    protected static ProtocolParameter[] parseProtocolParameters(Element protparams) throws IOException {
        try {
            Vector<ProtocolParameter> v = new Vector<ProtocolParameter>();
            protparams.normalize();
            NodeList parameters = protparams.getChildNodes();
            int i = 0;
            while (i < parameters.getLength()) {
                if (parameters.item(i).getNodeType() == 1) {
                    String pname = parameters.item(i).getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                    String pvalue = parameters.item(i).getAttributes().getNamedItem(ATTR_VALUE).getNodeValue();
                    ProtocolParameter p = new ProtocolParameter(pname, pvalue);
                    v.addElement(p);
                }
                ++i;
            }
            Object[] result = new ProtocolParameter[v.size()];
            v.copyInto(result);
            return result;
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        String input_file = null;
        String output = null;
        int i = 0;
        while (i < args.length) {
            if (!args[i].equals("-url")) {
                XmlConfigurator.help();
                return;
            }
            input_file = args[++i];
            ++i;
        }
        xml_debug = true;
        if (input_file != null) {
            XmlConfigurator conf = XmlConfigurator.getInstance(new URL(input_file));
            output = conf.getProtocolStackString();
            output = XmlConfigurator.replace(output, "org.javagroups.protocols.", "");
            System.out.println("\n" + output);
        } else {
            System.err.println("no input file given");
        }
    }

    public static String replace(String input, String expr, String replacement) {
        StringBuffer sb = new StringBuffer();
        int new_index = 0;
        int index = 0;
        int len = expr.length();
        int input_len = input.length();
        while (true) {
            if ((new_index = input.indexOf(expr, index)) == -1) break;
            sb.append(input.substring(index, new_index));
            sb.append(replacement);
            index = new_index + len;
        }
        sb.append(input.substring(index, input_len));
        return sb.toString();
    }

    static void help() {
        System.out.println("XmlConfigurator [-help] [-url <URL> ]");
    }

    private final /* synthetic */ void this() {
        this.mProtocolStack = new ArrayList();
    }

    protected XmlConfigurator(String stackName, ProtocolData[] protocols) {
        this.this();
        this.mStackName = stackName;
        int i = 0;
        while (i < protocols.length) {
            this.mProtocolStack.add(protocols[i]);
            ++i;
        }
    }

    protected XmlConfigurator(String stackName) {
        this(stackName, new ProtocolData[0]);
    }
}

