/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.GMS;
import org.javagroups.protocols.GmsImpl;
import org.javagroups.protocols.PingRsp;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClientGmsImpl
extends GmsImpl {
    Vector initial_mbrs;
    Object view_installation_mutex;
    boolean joined;

    public void init() {
        this.initial_mbrs.removeAllElements();
        this.joined = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join(Address mbr) {
        Address coord = null;
        while (!this.joined) {
            block13: {
                this.findInitialMembers();
                if (this.joined) {
                    if (!Trace.trace) return;
                    Trace.info("ClientGmsImpl.join()", "joined successfully");
                    return;
                }
                if (this.initial_mbrs.size() == 0) {
                    if (!this.gms.disable_initial_coord) {
                        this.joined = true;
                        this.gms.view_id = new ViewId(mbr);
                        this.gms.members.add(mbr);
                        Event view_evt = new Event(6, this.gms.makeView(this.gms.members.getMembers(), this.gms.view_id));
                        this.gms.passDown(view_evt);
                        this.gms.passUp(view_evt);
                        this.gms.becomeCoordinator();
                        this.gms.passUp(new Event(16));
                        this.gms.passDown(new Event(16));
                        if (!Trace.trace) return;
                        Trace.info("ClientGmsImpl.join()", "created group (first member)");
                        return;
                    }
                    if (!Trace.trace) continue;
                    Trace.info("ClientGmsImpl.join()", "received an initial membership of 0, but cannot become coordinator (disable_initial_coord=" + this.gms.disable_initial_coord + "), will retry fetching the initial membership");
                    continue;
                }
                coord = this.determineCoord(this.initial_mbrs);
                if (coord == null) {
                    Trace.warn("ClientGmsImpl.join()", "could not determine coordinator from responses " + this.initial_mbrs);
                    continue;
                }
                Object object = this.view_installation_mutex;
                synchronized (object) {
                    try {
                        if (Trace.trace) {
                            Trace.info("ClientGmsImpl.join()", "sending handleJoin() to " + coord);
                        }
                        this.gms.callRemoteMethod(coord, "handleJoin", mbr, 6, 0L);
                        this.view_installation_mutex.wait(this.gms.join_timeout);
                    }
                    catch (Exception e) {
                        Trace.error("ClientGmsImpl.join()", "exception is " + e);
                        continue;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 6] lbl44 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (!this.joined) break block13;
                    if (!Trace.trace) return;
                }
                Trace.info("ClientGmsImpl.join()", "joined successfully");
                return;
            }
            if (Trace.trace) {
                Trace.info("ClientGmsImpl.join()", "failed, retrying");
            }
            Util.sleep(this.gms.join_retry_timeout);
        }
    }

    public void leave(Address mbr) {
        this.wrongMethod("leave");
    }

    public void suspect(Address mbr) {
    }

    public void merge(Vector other_coords) {
        this.wrongMethod("merge");
    }

    public boolean handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return false;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleViewChange(ViewId new_view, Vector mems) {
        if (this.gms.local_addr != null && mems != null && mems.contains(this.gms.local_addr)) {
            Object object = this.view_installation_mutex;
            synchronized (object) {
                this.joined = true;
                this.view_installation_mutex.notify();
                this.gms.installView(new_view, mems);
                this.gms.becomeParticipant();
                this.gms.passUp(new Event(16));
                this.gms.passDown(new Event(16));
            }
            object = this.initial_mbrs;
            synchronized (object) {
                this.initial_mbrs.notifyAll();
                return;
            }
        }
        if (!Trace.trace) return;
        Trace.warn("ClientGmsImpl.handleViewChange()", "am not member of " + mems + ", will not install view");
    }

    public View handleMerge(ViewId other_view, Vector other_members) {
        this.wrongMethod("handleMerge");
        return null;
    }

    public void handleSuspect(Address mbr) {
        this.wrongMethod("handleSuspect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 13: {
                Vector tmp = (Vector)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (tmp != null && tmp.size() > 0) {
                        int i = 0;
                        while (i < tmp.size()) {
                            this.initial_mbrs.addElement(tmp.elementAt(i));
                            ++i;
                        }
                    }
                    this.initial_mbrs.notify();
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findInitialMembers() {
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.removeAllElements();
            this.gms.passDown(new Event(12));
            try {
                this.initial_mbrs.wait();
            }
            catch (Exception i) {
                // empty catch block
            }
            int i = 0;
            while (i < this.initial_mbrs.size()) {
                PingRsp ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                if (ping_rsp.own_addr != null && this.gms.local_addr != null && ping_rsp.own_addr.equals(this.gms.local_addr)) {
                    this.initial_mbrs.removeElementAt(i);
                    break;
                }
                ++i;
            }
            return;
        }
    }

    Address determineCoord(Vector mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        Hashtable<Address, Integer> votes = new Hashtable<Address, Integer>();
        int i = 0;
        while (i < mbrs.size()) {
            PingRsp mbr = (PingRsp)mbrs.elementAt(i);
            if (mbr.coord_addr != null) {
                if (!votes.containsKey(mbr.coord_addr)) {
                    votes.put(mbr.coord_addr, new Integer(1));
                } else {
                    count = (Integer)votes.get(mbr.coord_addr);
                    votes.put(mbr.coord_addr, new Integer(count + 1));
                }
            }
            ++i;
        }
        if (Trace.trace) {
            if (votes.size() > 1) {
                Trace.warn("ClientGmsImpl.determineCoord()", "there was more than 1 candidate for coordinator: " + votes);
            } else {
                Trace.info("ClientGmsImpl.determineCoord()", "election results: " + votes);
            }
        }
        int most_votes = 0;
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Address tmp = (Address)e.nextElement();
            count = (Integer)votes.get(tmp);
            if (count <= most_votes) continue;
            winner = tmp;
            ++most_votes;
        }
        votes.clear();
        return winner;
    }

    private final /* synthetic */ void this() {
        this.initial_mbrs = new Vector();
        this.view_installation_mutex = new Object();
        this.joined = false;
    }

    public ClientGmsImpl(GMS g) {
        this.this();
        this.gms = g;
    }
}

