/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Promise;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FD_SOCK
extends Protocol
implements Runnable {
    long get_cache_timeout;
    long get_cache_retry_timeout;
    long suspect_msg_interval;
    int num_tries;
    Vector members;
    boolean srv_sock_sent;
    Vector pingable_mbrs;
    Promise get_cache_promise;
    boolean got_cache_from_coord;
    Address local_addr;
    ServerSocket srv_sock;
    ServerSocketHandler srv_sock_handler;
    IpAddress srv_sock_addr;
    Address ping_dest;
    Socket ping_sock;
    InputStream ping_input;
    Thread pinger_thread;
    Hashtable cache;
    int start_port;
    Promise ping_addr_promise;
    Object sock_mutex;
    TimeScheduler timer;
    BroadcastTask bcast_task;
    boolean regular_sock_close;

    public String getName() {
        return "FD_SOCK";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("get_cache_timeout");
        if (str != null) {
            this.get_cache_timeout = new Long(str);
            props.remove("get_cache_timeout");
        }
        if ((str = props.getProperty("suspect_msg_interval")) != null) {
            this.suspect_msg_interval = new Long(str);
            props.remove("suspect_msg_interval");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = new Integer(str);
            props.remove("num_tries");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.start_port = new Integer(str);
            props.remove("start_port");
        }
        if (props.size() > 0) {
            System.err.println("FD_SOCK.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.srv_sock_handler = new ServerSocketHandler();
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("FD_SOCK.init(): timer == null");
        }
    }

    public void stop() {
        this.bcast_task.removeAll();
        this.stopPingerThread();
        this.stopServerSocket();
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.getHeader(this.getName());
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) break;
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbrs != null) {
                            if (Trace.trace) {
                                Trace.info("FD_SOCK.up()", "[SUSPECT] hdr=" + hdr);
                            }
                            int i = 0;
                            while (i < hdr.mbrs.size()) {
                                this.passUp(new Event(9, hdr.mbrs.elementAt(i)));
                                this.passDown(new Event(9, hdr.mbrs.elementAt(i)));
                                ++i;
                            }
                            break;
                        }
                        Trace.warn("FD_SOCK.up()", "[SUSPECT]: hdr.mbrs == null");
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return;
                        }
                        if (hdr.mbr == null) {
                            Trace.error("FD_SOCK.up(WHO_HAS_SOCK)", "hdr.mbr is null");
                            return;
                        }
                        if (Trace.trace) {
                            Trace.info("FD_SOCK.up()", "who-has-sock " + hdr.mbr);
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                            return;
                        }
                        if (!this.cache.containsKey(hdr.mbr)) break;
                        this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, (IpAddress)this.cache.get(hdr.mbr));
                        break;
                    }
                    case 12: {
                        if (hdr.mbr == null || hdr.sock_addr == null) {
                            Trace.error("FD_SOCK.up()", "[I_HAVE_SOCK]: hdr.mbr is null or hdr.sock_addr == null");
                            return;
                        }
                        this.cache.put(hdr.mbr, hdr.sock_addr);
                        if (Trace.trace) {
                            Trace.info("FD_SOCK.up()", "i-have-sock: " + hdr.mbr + " --> " + hdr.sock_addr + " (cache is " + this.cache + ')');
                        }
                        if (this.ping_dest == null || !hdr.mbr.equals(this.ping_dest)) break;
                        this.ping_addr_promise.setResult(hdr.sock_addr);
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (Trace.trace) {
                                Trace.error("FD_SOCK.up()", "(GET_CACHE): hdr.mbr == null");
                            }
                            return;
                        }
                        hdr = new FdHeader(14);
                        hdr.cache = (Hashtable)this.cache.clone();
                        msg = new Message(hdr.mbr, null, null);
                        msg.putHeader(this.getName(), hdr);
                        this.passDown(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.cache == null) {
                            if (Trace.trace) {
                                Trace.error("FD_SOCK.up()", "(GET_CACHE_RSP): cache is null");
                            }
                            return;
                        }
                        this.get_cache_promise.setResult(hdr.cache);
                        break;
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                this.bcast_task.removeSuspectedMember((Address)evt.getArg());
                return;
            }
            case 2: {
                this.passDown(evt);
                this.srv_sock = Util.createServerSocket(this.start_port);
                this.srv_sock_addr = new IpAddress(this.srv_sock.getLocalPort());
                this.startServerSocket();
                if (this.pinger_thread != null) return;
                this.startPingerThread();
                return;
            }
            case 6: {
                var5_2 = this;
                synchronized (var5_2) {
                    v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    this.passDown(evt);
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.down()", "VIEW_CHANGE received: " + this.members);
                    }
                    if (!this.got_cache_from_coord) {
                        this.getCacheFromCoordinator();
                        this.got_cache_from_coord = true;
                    }
                    if (this.srv_sock_sent) ** GOTO lbl39
                    if (this.srv_sock_addr == null) ** GOTO lbl38
                    this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
                    this.srv_sock_sent = true;
                    ** GOTO lbl39
lbl38:
                    // 1 sources

                    Trace.warn("FD_SOCK.down()", "(VIEW_CHANGE): srv_sock_addr == null");
lbl39:
                    // 3 sources

                    if (this.members != null) {
                        e = this.cache.keys();
                        while (e.hasMoreElements()) {
                            mbr = (Address)e.nextElement();
                            if (this.members.contains(mbr)) continue;
                            this.cache.remove(mbr);
                        }
                    }
                    if (this.members.size() <= 1) ** GOTO lbl57
                    if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
                        tmp_ping_dest = this.determinePingDest();
                        if (this.ping_dest == null) return;
                        if (tmp_ping_dest == null) return;
                        if (this.ping_dest.equals(tmp_ping_dest) != false) return;
                        this.interruptPingerThread();
                    } else {
                        this.startPingerThread();
                    }
                    ** GOTO lbl59
lbl57:
                    // 1 sources

                    this.ping_dest = null;
                    this.stopPingerThread();
lbl59:
                    // 3 sources

                    return;
                }
            }
        }
        this.passDown(evt);
    }

    public void run() {
        int max_fetch_tries = 10;
        while (this.pinger_thread != null) {
            Address tmp_ping_dest = this.determinePingDest();
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "determinePingDest()=" + tmp_ping_dest + ", pingable_mbrs=" + this.pingable_mbrs);
            }
            if (tmp_ping_dest == null) {
                this.ping_dest = null;
                this.pinger_thread = null;
                break;
            }
            this.ping_dest = tmp_ping_dest;
            IpAddress ping_addr = this.fetchPingAddress(this.ping_dest);
            if (ping_addr == null) {
                Trace.error("FD_SOCK.run()", "socket address for " + this.ping_dest + " could not be fetched, retrying");
                if (--max_fetch_tries <= 0) break;
                Util.sleep(2000L);
                continue;
            }
            if (!this.setupPingSocket(ping_addr)) {
                Trace.info("FD_SOCK.run()", "could not create socket to " + this.ping_dest + "; suspecting " + this.ping_dest);
                this.broadcastSuspectMessage(this.ping_dest);
                this.pingable_mbrs.removeElement(this.ping_dest);
                continue;
            }
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "ping_dest=" + this.ping_dest + ", ping_sock=" + this.ping_sock + ", cache=" + this.cache);
            }
            try {
                if (this.ping_input.read() != -1) continue;
                this.handleSocketClose(null);
            }
            catch (IOException ex) {
                this.handleSocketClose(ex);
            }
            catch (Throwable catch_all_the_rest) {
                if (!Trace.trace) continue;
                Trace.info("FD_SOCK.run()", "exception=" + catch_all_the_rest);
            }
        }
        if (Trace.trace) {
            Trace.info("FD_SOCK.run()", "pinger thread terminated");
        }
        this.pinger_thread = null;
    }

    void handleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "peer " + this.ping_dest + " closed socket (" + (ex != null ? ex.getClass().getName() : "eof") + ')');
            }
            this.broadcastSuspectMessage(this.ping_dest);
            this.pingable_mbrs.removeElement(this.ping_dest);
        } else {
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "socket to " + this.ping_dest + " was reset");
            }
            this.regular_sock_close = false;
        }
    }

    void startPingerThread() {
        if (this.pinger_thread == null) {
            this.pinger_thread = new Thread((Runnable)this, "FD_SOCK Ping thread");
            this.pinger_thread.setDaemon(true);
            this.pinger_thread.start();
        }
    }

    void stopPingerThread() {
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.teardownPingSocket();
        }
        this.pinger_thread = null;
    }

    void interruptPingerThread() {
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.teardownPingSocket();
        }
    }

    void startServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.start();
        }
    }

    void stopServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setupPingSocket(IpAddress dest) {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (dest == null) {
                Trace.error("FD_SOCK.setupPingSocket()", "destination address is null");
                return false;
            }
            try {
                this.ping_sock = new Socket(dest.getIpAddress(), dest.getPort());
                this.ping_sock.setSoLinger(true, 1);
                this.ping_input = this.ping_sock.getInputStream();
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void teardownPingSocket() {
        Object object = this.sock_mutex;
        synchronized (object) {
            block8: {
                if (this.ping_sock == null) break block8;
                try {
                    this.ping_sock.shutdownInput();
                    this.ping_sock.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.ping_sock = null;
            }
            if (this.ping_input != null) {
                try {
                    this.ping_input.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ping_input = null;
            }
            return;
        }
    }

    void getCacheFromCoordinator() {
        int attempts = this.num_tries;
        this.get_cache_promise.reset();
        while (attempts > 0) {
            Address coord = this.determineCoordinator();
            if (coord != null) {
                if (coord.equals(this.local_addr)) {
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.getCacheFromCoordinator()", "first member; cache is empty");
                    }
                    return;
                }
                FdHeader hdr = new FdHeader(13);
                hdr.mbr = this.local_addr;
                Message msg = new Message(coord, null, null);
                msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, msg));
                Hashtable result = (Hashtable)this.get_cache_promise.getResult(this.get_cache_timeout);
                if (result != null) {
                    this.cache.putAll(result);
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.getCacheFromCoordinator()", "got cache from " + coord + ": cache is " + this.cache);
                    }
                    return;
                }
                if (Trace.trace) {
                    Trace.error("FD_SOCK.getCacheFromCoordinator()", "received null cache; retrying");
                }
            }
            Util.sleep(this.get_cache_retry_timeout);
            --attempts;
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        if (Trace.trace) {
            Trace.info("FD_SOCK.broadcastSuspectMessage()", "suspecting " + suspected_mbr + " (own address is " + this.local_addr + ')');
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbrs = new Vector();
        hdr.mbrs.addElement(suspected_mbr);
        Message suspect_msg = new Message();
        suspect_msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, suspect_msg));
        this.bcast_task.addSuspectedMember(suspected_mbr);
    }

    void broadcastWhoHasSockMessage(Address mbr) {
        if (Trace.trace && this.local_addr != null && mbr != null) {
            Trace.info("FD_SOCK.broadcastWhoHasSockMessage()", "[" + this.local_addr + "]: who-has " + mbr);
        }
        Message msg = new Message();
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst, null, null);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.sock_addr = addr;
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    IpAddress fetchPingAddress(Address mbr) {
        IpAddress ret = null;
        if (mbr == null) {
            Trace.error("FD_SOCK.fetchPingAddress()", "mbr == null");
            return null;
        }
        ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        Util.sleep(300L);
        ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        this.ping_addr_promise.reset();
        Message ping_addr_req = new Message(mbr, null, null);
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, ping_addr_req));
        ret = (IpAddress)this.ping_addr_promise.getResult(3000L);
        if (ret != null) {
            return ret;
        }
        ping_addr_req = new Message(null, null, null);
        hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, ping_addr_req));
        ret = (IpAddress)this.ping_addr_promise.getResult(3000L);
        return ret;
    }

    Address determinePingDest() {
        if (this.pingable_mbrs == null || this.pingable_mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        int i = 0;
        while (i < this.pingable_mbrs.size()) {
            Address tmp = (Address)this.pingable_mbrs.elementAt(i);
            if (this.local_addr.equals(tmp)) {
                if (i + 1 >= this.pingable_mbrs.size()) {
                    return (Address)this.pingable_mbrs.elementAt(0);
                }
                return (Address)this.pingable_mbrs.elementAt(i + 1);
            }
            ++i;
        }
        return null;
    }

    Address determineCoordinator() {
        return this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
    }

    private final /* synthetic */ void this() {
        this.get_cache_timeout = 3000L;
        this.get_cache_retry_timeout = 500L;
        this.suspect_msg_interval = 5000L;
        this.num_tries = 3;
        this.members = new Vector();
        this.srv_sock_sent = false;
        this.pingable_mbrs = new Vector();
        this.get_cache_promise = new Promise();
        this.got_cache_from_coord = false;
        this.local_addr = null;
        this.srv_sock = null;
        this.srv_sock_handler = null;
        this.srv_sock_addr = null;
        this.ping_dest = null;
        this.ping_sock = null;
        this.ping_input = null;
        this.pinger_thread = null;
        this.cache = new Hashtable();
        this.start_port = 10000;
        this.ping_addr_promise = new Promise();
        this.sock_mutex = new Object();
        this.timer = null;
        this.bcast_task = new BroadcastTask();
        this.regular_sock_close = false;
    }

    public FD_SOCK() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FdHeader
    extends Header {
        static final int SUSPECT = 10;
        static final int WHO_HAS_SOCK = 11;
        static final int I_HAVE_SOCK = 12;
        static final int GET_CACHE = 13;
        static final int GET_CACHE_RSP = 14;
        int type;
        Address mbr;
        IpAddress sock_addr;
        Hashtable cache;
        Vector mbrs;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=" + this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=" + this.sock_addr);
            }
            if (this.cache != null) {
                sb.append(", cache=" + this.cache);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=" + this.mbrs);
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_SOCK";
                }
                case 12: {
                    return "I_HAVE_SOCK";
                }
                case 13: {
                    return "GET_CACHE";
                }
                case 14: {
                    return "GET_CACHE_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.mbr);
            out.writeObject(this.sock_addr);
            out.writeObject(this.cache);
            out.writeObject(this.mbrs);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.mbr = (Address)in.readObject();
            this.sock_addr = (IpAddress)in.readObject();
            this.cache = (Hashtable)in.readObject();
            this.mbrs = (Vector)in.readObject();
        }

        private final /* synthetic */ void this() {
            this.type = 10;
            this.mbr = null;
            this.cache = null;
            this.mbrs = null;
        }

        public FdHeader() {
            this.this();
        }

        public FdHeader(int type) {
            this.this();
            this.type = type;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ServerSocketHandler
    implements Runnable {
        Thread handler;
        Socket client_sock;
        InputStream in;

        void start() {
            if (this.handler == null) {
                this.handler = new Thread((Runnable)this, "ServerSocketHandler thread");
                this.handler.setDaemon(true);
                this.handler.start();
            }
        }

        void stop() {
            if (this.handler != null && this.handler.isAlive()) {
                try {
                    FD_SOCK.this.srv_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.handler = null;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (this.handler != null && FD_SOCK.this.srv_sock != null) {
                try {
                    this.client_sock = FD_SOCK.this.srv_sock.accept();
                    this.in = this.client_sock.getInputStream();
                    try {
                        try {
                            while (this.in.read() != -1) {
                            }
                        }
                        catch (IOException io_ex1) {}
                    }
                    catch (Throwable var1_4) {
                        var2_1 = null;
                        if (this.client_sock != null) {
                            try {
                                this.client_sock.close();
                            }
                            catch (Exception var3_2) {
                                // empty catch block
                            }
                            this.client_sock = null;
                        }
                        throw var1_4;
                    }
                    {
                        block14: {
                            var2_1 = null;
                            if (this.client_sock == null) continue;
                            ** try [egrp 3[TRYBLOCK] [2 : 64->74)] { 
lbl27:
                            // 1 sources

                            this.client_sock.close();
                            break block14;
lbl29:
                            // 1 sources

                            catch (Exception var3_2) {
                                // empty catch block
                            }
                        }
                        this.client_sock = null;
                        continue;
                    }
                }
                catch (IOException io_ex2) {}
                break;
            }
            this.handler = null;
        }

        private final /* synthetic */ void this() {
            this.handler = null;
            this.client_sock = null;
            this.in = null;
        }

        ServerSocketHandler() {
            this.this();
            this.start();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BroadcastTask
    implements TimeScheduler.Task {
        Vector suspected_mbrs;
        boolean stopped;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD_SOCK.this.members.contains(mbr)) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.BroadcastTask.addSuspectedMember()", "mbr=" + mbr + " (size=" + this.suspected_mbrs.size() + ')');
                    }
                }
                if (this.stopped && this.suspected_mbrs.size() > 0) {
                    this.stopped = false;
                    FD_SOCK.this.timer.add(this, true);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (Trace.trace) {
                Trace.info("FD_SOCK.BroadcastTask.removeSuspectedMember()", "member is " + suspected_mbr);
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopped = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void adjustSuspectedMembers(Vector new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                Iterator it = this.suspected_mbrs.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        if (this.suspected_mbrs.size() == 0) {
                            this.stopped = true;
                        }
                        return;
                    }
                    Address suspected_mbr = (Address)it.next();
                    if (new_mbrship.contains(suspected_mbr)) continue;
                    it.remove();
                    if (!Trace.trace) continue;
                    Trace.info("FD_SOCK.BroadcastTask.adjustSuspectedMembers()", "removed " + suspected_mbr + " (size=" + this.suspected_mbrs.size() + ')');
                }
            }
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD_SOCK.this.suspect_msg_interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            FdHeader hdr;
            if (Trace.trace) {
                Trace.info("FD_SOCK.BroadcastTask.run()", "broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_mbrs + "] to group");
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.BroadcastTask.run()", "task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(10);
                hdr.mbrs = (Vector)this.suspected_mbrs.clone();
            }
            Message suspect_msg = new Message();
            suspect_msg.putHeader(FD_SOCK.this.getName(), hdr);
            FD_SOCK.this.passDown(new Event(1, suspect_msg));
            if (Trace.trace) {
                Trace.info("FD_SOCK.BroadcastTask.run()", "task done");
            }
        }

        private final /* synthetic */ void this() {
            this.suspected_mbrs = new Vector();
            this.stopped = false;
        }

        private BroadcastTask() {
            this.this();
        }
    }
}

