/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LOOPBACK
extends Protocol {
    private Address local_addr;
    private String group_addr;
    private Vector members;

    public String toString() {
        return "Protocol LOOPBACK(local address: " + this.local_addr + ')';
    }

    public String getName() {
        return "LOOPBACK";
    }

    public boolean setProperties(Properties props) {
        if (props.size() > 0) {
            System.err.println("LOOPBACK.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.local_addr = new IpAddress("localhost", 10000);
    }

    public void start() throws Exception {
        this.passUp(new Event(8, this.local_addr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        if (Trace.trace) {
            Trace.info("LOOPBACK.down()", "event is " + evt + ", group_addr=" + this.group_addr + ", time is " + System.currentTimeMillis() + ", hdrs: " + Util.printEvent(evt));
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Message rsp = msg.copy();
                Address dest_addr = msg.getDest();
                rsp.setDest(this.local_addr);
                rsp.setSrc(dest_addr != null ? dest_addr : this.local_addr);
                this.passUp(new Event(1, rsp));
                return;
            }
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    int i = 0;
                    while (true) {
                        if (i >= tmpvec.size()) {
                            return;
                        }
                        this.members.addElement(tmpvec.elementAt(i));
                        ++i;
                    }
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                return;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                return;
            }
            case 4: {
                this.passUp(new Event(5));
                return;
            }
            case 47: {
                this.passUp(evt);
                return;
            }
        }
    }

    private final void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    private final /* synthetic */ void this() {
        this.local_addr = null;
        this.group_addr = null;
        this.members = new Vector();
    }

    public LOOPBACK() {
        this.this();
    }
}

