/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.PingRsp;
import org.javagroups.stack.GossipClient;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TCPGOSSIP
extends Protocol {
    Vector members;
    Vector initial_members;
    Address local_addr;
    String group_addr;
    String groupname;
    long timeout;
    long num_initial_members;
    Vector initial_hosts;
    boolean is_server;
    GossipClient gossip_client;
    long gossip_refresh_rate;

    public String getName() {
        return "TCPGOSSIP";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("gossip_refresh_rate")) != null) {
            this.gossip_refresh_rate = new Integer(str).intValue();
            props.remove("gossip_refresh_rate");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (props.size() > 0) {
            System.err.println("TCPGOSSIP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        if (this.initial_hosts == null || this.initial_hosts.size() == 0) {
            Trace.error("TCPGOSSIP.setProperties()", "initial_hosts must contain the address of at least one GossipServer");
            return false;
        }
        this.gossip_client = new GossipClient(this.initial_hosts, this.gossip_refresh_rate);
        return true;
    }

    public void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            Address address = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                            coord = address;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                            return;
                        }
                    }
                }
                Trace.warn("TCPGOSSIP.up()", "got TCPGOSSIP header with unknown type (" + hdr.type + ')');
                return;
            }
            case 3: {
                if (this.group_addr == null || this.local_addr == null) {
                    Trace.error("TCPGOSSIP.up()", "[CONNECT_OK]: group_addr or local_addr is null. cannot register with GossipServer(s)");
                    return;
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.up()", "[CONNECT_OK]: registering " + this.local_addr + " under " + this.group_addr + " with GossipServer");
                }
                this.gossip_client.register(this.group_addr, this.local_addr);
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.initial_members.removeAllElements();
                if (this.group_addr == null) {
                    Trace.error("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS]: group_addr is null, cannot get mbrship");
                    this.passUp(new Event(13, this.initial_members));
                    return;
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.down()", "fetching members from GossipServer(s)");
                }
                if ((tmp_mbrs = this.gossip_client.getMembers(this.group_addr)) == null || tmp_mbrs.size() == 0) {
                    Trace.error("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS]: gossip client found no members");
                    this.passUp(new Event(13, this.initial_members));
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.down()", "consolidated mbrs from GossipServer(s) are " + tmp_mbrs);
                }
                hdr = new PingHeader(1, null);
                msg = new Message(null, null, null);
                msg.putHeader(this.getName(), hdr);
                i = 0;
                while (true) {
                    if (i >= tmp_mbrs.size()) {
                        var11_6 = this.initial_members;
                        // MONITORENTER : var11_6
                        ** try [egrp 0[TRYBLOCK] [2 : 354->419)] { 
lbl24:
                        // 1 sources

                        break;
                    }
                    mbr_addr = (IpAddress)tmp_mbrs.elementAt(i);
                    copy = msg.copy();
                    copy.setDest(mbr_addr);
                    if (Trace.trace) {
                        Trace.info("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS] sending PING request to " + copy.getDest());
                    }
                    this.passDown(new Event(1, copy));
                    ++i;
                }
                {
                    start_time = System.currentTimeMillis();
                    time_to_wait = this.timeout;
                }
lbl36:
                // 1 sources

                catch (Throwable v0) {
                    // MONITOREXIT : var11_6
                    throw v0;
                }
                while (true) {
                    if ((long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L) ** GOTO lbl45
                    // MONITOREXIT : var11_6
                    if (Trace.trace) {
                        break;
                    }
                    ** GOTO lbl53
lbl45:
                    // 1 sources

                    try {
                        this.initial_members.wait(time_to_wait);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    time_to_wait -= System.currentTimeMillis() - start_time;
                }
                Trace.info("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS] initial members are " + this.initial_members);
lbl53:
                // 2 sources

                this.passUp(new Event(13, this.initial_members));
                return;
            }
            case 6: 
            case 15: {
                tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    var14_13 = this.members;
                    // MONITORENTER : var14_13
                    this.members.removeAllElements();
                    i = 0;
                    while (true) {
                        if (i >= tmp.size()) {
                            // MONITOREXIT : var14_13
                            break;
                        }
                        this.members.addElement(tmp.elementAt(i));
                        ++i;
                    }
                }
                this.passDown(evt);
                return;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                return;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                return;
            }
            case 4: {
                this.passDown(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    private final Vector createInitialHosts(String l) {
        Vector<IpAddress> tmp = new Vector<IpAddress>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int port = new Integer(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                IpAddress addr = new IpAddress(host, port);
                tmp.addElement(addr);
            }
            catch (NumberFormatException e) {
                Trace.error("TCPGOSSIP.createInitialHosts()", "exeption is " + e);
            }
        }
        return tmp;
    }

    private final /* synthetic */ void this() {
        this.members = new Vector();
        this.initial_members = new Vector();
        this.local_addr = null;
        this.group_addr = null;
        this.groupname = null;
        this.timeout = 3000L;
        this.num_initial_members = 2;
        this.initial_hosts = null;
        this.is_server = false;
        this.gossip_client = null;
        this.gossip_refresh_rate = 20000L;
    }

    public TCPGOSSIP() {
        this.this();
    }
}

