/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.MessageAcks;
import org.javagroups.protocols.SavedMessages;
import org.javagroups.protocols.TotalRetransmissionThread;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TOTAL_OLD
extends Protocol {
    private static final String PROTOCOL_NAME = "TOTAL_OLD";
    private static final long INIT_SEQ_ID = 10L;
    private Address local_addr;
    private Vector members;
    private long next_seq_id;
    private long next_seq_id_to_assign;
    private SavedMessages queued_messages;
    private MessageAcks ack_history;
    private TotalRetransmissionThread retrans_thread;
    private long last_request_time;

    public String getName() {
        return PROTOCOL_NAME;
    }

    public boolean setProperties(Properties props) {
        if (Trace.trace) {
            System.err.println("TOTAL_OLD layer - trace is on\n");
        }
        if (props.size() > 0) {
            System.err.println("TOTAL_OLD.setProperties(): the following properties are not recognized:");
            props.list(System.err);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.retrans_thread.start();
    }

    public void stop() {
        this.retrans_thread.stopResendRequests();
    }

    public void reset() {
        this.next_seq_id = -1;
        this.queued_messages.clearMessages();
        this.retrans_thread.reset();
    }

    protected long getNextSeqID() {
        return this.next_seq_id;
    }

    protected long getFirstQueuedSeqID() {
        return this.queued_messages.getFirstSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Address) {
                    this.local_addr = (Address)temp_obj;
                    break;
                }
                System.err.println("Error: Total.up() - could not cast local address to an Address object");
                break;
            }
            case 1: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if ((temp_obj = msg.removeHeader(this.getName())) instanceof TotalHeader) {
                        TotalHeader hdr = (TotalHeader)temp_obj;
                        switch (hdr.total_header_type) {
                            case 0: {
                                this.passUp(evt);
                                return;
                            }
                            case 1: {
                                this.handleBCastMessage(msg, hdr.seq_id);
                                return;
                            }
                            case 2: {
                                if (!this.isSequencer()) return;
                                this.handleRequestMessage(msg);
                                return;
                            }
                            case 3: {
                                this.next_seq_id = hdr.seq_id;
                                return;
                            }
                            case 5: {
                                if (!this.isSequencer()) return;
                                temp_obj = msg.getSrc();
                                if (temp_obj instanceof Address) {
                                    this.ack_history.setSeq((Address)temp_obj, hdr.seq_id);
                                    return;
                                }
                                System.err.println("Error: TOTAL_OLD.Up() - could not cast source of message to an Address object (case TotalHeader.TOTAL_CUM_SEQ_ACK)");
                                return;
                            }
                            case 7: {
                                if (!this.isSequencer()) return;
                                this.handleResendRequest(msg, hdr.seq_id);
                                return;
                            }
                            default: {
                                System.err.println("Error: TOTAL_OLD.up() - unrecognized TotalHeader in message - " + hdr.toString());
                                return;
                            }
                        }
                    } else {
                        System.err.println("Error: TOTAL_OLD.up() - could not cast message header to TotalHeader (case Event.MSG)");
                    }
                    return;
                } else {
                    System.err.println("Error: TOTAL_OLD.up() - could not cast argument of Event to a Message (case Event.MSG)");
                }
                return;
            }
            case 6: 
            case 15: {
                System.out.println("View Change event passed up to TOTAL_OLD (debug - mms21)");
                View new_view = (View)evt.getArg();
                this.members = new_view.getMembers();
                if (Trace.trace) {
                    System.out.println("New view members (printed in TOTAL_OLD):");
                    int view_size = this.members.size();
                    int i = 0;
                    while (i < view_size) {
                        System.out.println("  " + this.members.elementAt(i).toString());
                        ++i;
                    }
                }
                this.reset();
                if (!this.isSequencer()) break;
                if (Trace.trace) {
                    System.err.println("TOTAL_OLD.up() - I am the sequencer of this new view");
                }
                this.ack_history = new MessageAcks(this.members);
                this.next_seq_id_to_assign = 10L;
                Message new_view_msg = new Message(null, this.local_addr, null);
                new_view_msg.putHeader(this.getName(), new TotalHeader(3, this.next_seq_id_to_assign));
                this.passDown(new Event(1, new_view_msg));
                break;
            }
        }
        this.passUp(evt);
    }

    private final synchronized int passUpMessages() {
        if (this.next_seq_id < 0L) {
            return 0;
        }
        long lowest_seq_stored = this.queued_messages.getFirstSeq();
        if (lowest_seq_stored < 0L) {
            return 0;
        }
        if (lowest_seq_stored < this.next_seq_id) {
            System.err.println("Error: TOTAL_OLD.passUpMessages() - next expected sequence id (" + this.next_seq_id + ") is greater than the sequence id of a stored message (" + lowest_seq_stored + ')');
            return 0;
        }
        if (this.next_seq_id == lowest_seq_stored) {
            Message msg = this.queued_messages.getFirstMessage();
            if (msg == null) {
                System.err.println("Error: TOTAL_OLD.passUpMessages() - unexpected null Message retrieved from stored messages");
                return 0;
            }
            this.passUp(new Event(1, msg));
            ++this.next_seq_id;
            return 1 + this.passUpMessages();
        }
        return 0;
    }

    private final synchronized void handleBCastMessage(Message msg, long seq) {
        if (seq < this.next_seq_id) {
            return;
        }
        this.queued_messages.insertMessage(msg, seq);
        int num_passed = this.passUpMessages();
        if (num_passed > 1 && Trace.trace) {
            System.err.println("TOTAL_OLD.handleBCastMessage() - " + num_passed + " message(s) passed up the Protocol Stack");
        }
    }

    private final synchronized void handleRequestMessage(Message msg) {
        Header header;
        if (this.next_seq_id_to_assign < 0L) {
            System.err.println("Error: TOTAL_OLD.handleRequestMessage() - cannot handle request... do not know what sequence id to assign");
            return;
        }
        msg.setDest(null);
        msg.setSrc(this.local_addr);
        msg.putHeader(this.getName(), new TotalHeader(1, this.next_seq_id_to_assign));
        Message msg_copy = msg.copy();
        this.ack_history.addMessage(msg_copy, this.next_seq_id_to_assign);
        if (Trace.trace && !((header = msg_copy.getHeader(this.getName())) instanceof TotalHeader)) {
            System.err.println("Error: TOTAL_OLD.handleRequestMessage() - BAD: stored message that did not contain a TotalHeader - " + this.next_seq_id_to_assign);
        }
        ++this.next_seq_id_to_assign;
        this.passDown(new Event(1, msg));
    }

    private final synchronized void handleResendRequest(Message msg, long seq) {
        Header header;
        if (Trace.trace) {
            System.err.println("TOTAL_OLD.handleRequestMessage() - received resend request for message " + seq);
        }
        Address requester = null;
        Message resend_msg = this.ack_history.getMessage(seq);
        if (resend_msg == null) {
            System.err.println("TOTAL_OLD.handleResendRequest() - could not find the message " + seq + " in the history to resend");
            return;
        }
        resend_msg.setDest(requester);
        if (Trace.trace && !((header = resend_msg.getHeader(this.getName())) instanceof TotalHeader)) {
            System.err.println("TOTAL_OLD: resend msg BAD (header is NOT a TotalHeader) - " + seq);
        }
        this.passDown(new Event(1, resend_msg));
        if (Trace.trace) {
            System.err.println("TOTAL_OLD.handleResendRequest() - responded to resend request for message " + seq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                System.err.println("NOTE: VIEW_CHANGE Event going down through TOTAL_OLD");
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    int i;
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        i = 0;
                    }
                    break;
                    while (i < new_members.size()) {
                        this.members.addElement(new_members.elementAt(i));
                        ++i;
                    }
                    break;
                }
            }
            case 1: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if (msg.getDest() == null) {
                        Address sequencer = this.getSequencer();
                        if (sequencer != null) {
                            msg.setDest(sequencer);
                        }
                        msg.putHeader(this.getName(), new TotalHeader(2, -1));
                        break;
                    }
                    msg.putHeader(this.getName(), new TotalHeader(0, -1));
                    break;
                }
                System.err.println("Error: TOTAL_OLD.down() - could not cast argument of Event to a Message (case Event.MSG)");
                break;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean isSequencer() {
        if (this.local_addr == null) {
            System.err.println("TOTAL_OLD.isSequencer() - local address unknown!");
            return false;
        }
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                System.err.println("TOTAL_OLD.isSequencer() - no members!");
                return false;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                Address seq_addr = (Address)temp_obj;
                return this.local_addr.equals(seq_addr);
            }
            System.err.println("Error: TOTAL_OLD.isSequencer() - could not cast element of \"members\" to an Address");
            return false;
        }
    }

    protected Address getLocalAddr() {
        return this.local_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Address getSequencer() {
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                System.err.println("TOTAL_OLD.getSequencer() - no members");
                return null;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                return (Address)temp_obj;
            }
            System.err.println("Error: TOTAL_OLD.getSequencer() - could not cast first element of \"members\" to an Address");
            return null;
        }
    }

    private final /* synthetic */ void this() {
        this.local_addr = null;
        this.members = new Vector();
        this.next_seq_id = -1;
        this.next_seq_id_to_assign = -1;
        this.queued_messages = new SavedMessages();
        this.ack_history = null;
        this.retrans_thread = new TotalRetransmissionThread(this);
        this.last_request_time = -1;
    }

    public TOTAL_OLD() {
        this.this();
    }

    public static class TotalHeader
    extends Header {
        public static final int TOTAL_UNICAST = 0;
        public static final int TOTAL_BCAST = 1;
        public static final int TOTAL_REQUEST = 2;
        public static final int TOTAL_NEW_VIEW = 3;
        public static final int TOTAL_NEW_VIEW_ACK = 4;
        public static final int TOTAL_CUM_SEQ_ACK = 5;
        public static final int TOTAL_SEQ_ACK = 6;
        public static final int TOTAL_RESEND = 7;
        public int total_header_type;
        public long seq_id;

        public String toString() {
            String type = "";
            switch (this.total_header_type) {
                case 0: {
                    type = "TOTAL_UNICAST";
                    break;
                }
                case 1: {
                    type = "TOTAL_BCAST";
                    break;
                }
                case 2: {
                    type = "TOTAL_REQUEST";
                    break;
                }
                case 3: {
                    type = "NEW_VIEW";
                    break;
                }
                case 4: {
                    type = "NEW_VIEW_ACK";
                    break;
                }
                case 5: {
                    type = "TOTAL_CUM_SEQ_ACK";
                    break;
                }
                case 6: {
                    type = "TOTAL_SEQ_ACK";
                    break;
                }
                case 7: {
                    type = "TOTAL_RESEND";
                    break;
                }
                default: {
                    type = "UNKNOWN TYPE (" + this.total_header_type + ')';
                    break;
                }
            }
            return "[ TOTAL_OLD: type=" + type + ", seq=" + this.seq_id + " ]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.total_header_type);
            out.writeLong(this.seq_id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total_header_type = in.readInt();
            this.seq_id = in.readLong();
        }

        public TotalHeader() {
        }

        public TotalHeader(int type, long seq) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.total_header_type = type;
                    break;
                }
                default: {
                    System.err.println("Error: TotalHeader.TotalHeader() - unknown TotalHeader type given: " + type);
                    this.total_header_type = -1;
                    break;
                }
            }
            this.seq_id = seq;
        }
    }
}

