/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.service.lease;

import java.io.Serializable;
import java.util.HashMap;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.Transport;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;
import org.javagroups.service.lease.DenyResponseHeader;
import org.javagroups.service.lease.Lease;
import org.javagroups.service.lease.LeaseDeniedException;
import org.javagroups.service.lease.LeaseFactory;
import org.javagroups.service.lease.LeaseRequestHeader;
import org.javagroups.service.lease.LeaseResponseHeader;
import org.javagroups.service.lease.RecursiveLeaseRequestException;
import org.javagroups.service.lease.UnknownLeaseException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LeaseFactoryClient
implements LeaseFactory {
    private static final String LEASE_CLIENT_RECEIVE_METHOD = "LeaseFactoryClient.ClientMessageListener.receive()";
    private static final String NEW_LEASE_METHOD = "LeaseFactoryClient.newLease()";
    private static final String RENEW_LEASE_METHOD = "LeaseFactoryClient.renewLease()";
    private static final String CANCEL_LEASE_METHOD = "LeaseFactoryClient.cancelLease()";
    public static final int DEFAULT_LEASE_TIMEOUT = 10000;
    public static final int DEFAULT_CANCEL_TIMEOUT = 1000;
    protected Channel clientChannel;
    protected PullPushAdapter clientAdapter;
    protected int leaseTimeout;
    protected int cancelTimeout;
    protected HashMap pendingLeases;
    protected HashMap pendingRenewals;
    protected HashMap pendingCancels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelLease(Lease existingLease) throws UnknownLeaseException {
        if (existingLease == null) {
            throw new UnknownLeaseException("Existing lease cannot be null.", existingLease);
        }
        if (existingLease.isExpired()) {
            throw new UnknownLeaseException("You existing lease has expired. You cannot use this method to obtain new lease.", existingLease);
        }
        ClientLeaseInfo leaseInfo = new ClientLeaseInfo(existingLease.getLeaseTarget(), existingLease.getTenant());
        if (this.pendingCancels.keySet().contains(leaseInfo)) {
            throw new UnknownLeaseException("There's pending cancel request for specified lease target and tenant.", existingLease);
        }
        try {
            Object leaseMutex = new Object();
            this.pendingCancels.put(leaseInfo, leaseMutex);
            try {
                Object object = leaseMutex;
                synchronized (object) {
                    LeaseRequestHeader requestHeader = new LeaseRequestHeader(3, 0L, false, existingLease.getTenant());
                    Message msg = new Message();
                    msg.putHeader("leaseRequestHeader", requestHeader);
                    msg.setObject((Serializable)existingLease.getLeaseTarget());
                    this.clientChannel.send(msg);
                    leaseMutex.wait(this.leaseTimeout);
                }
            }
            catch (InterruptedException ex) {
                throw new UnknownLeaseException("Did not get any reply before the thread was interrupted.", null);
            }
            catch (ChannelNotConnectedException ex) {
                throw new UnknownLeaseException("Unable to send request, channel is not connected " + ex.getMessage(), null);
            }
            catch (ChannelClosedException ex) {
                throw new UnknownLeaseException("Unable to send request, channel is closed " + ex.getMessage(), null);
            }
            if (!(this.pendingCancels.get(leaseInfo) instanceof Message)) {
                Object var4_10 = null;
                this.pendingCancels.remove(leaseInfo);
                return;
            }
            Message reply = (Message)this.pendingCancels.get(leaseInfo);
            DenyResponseHeader denyHeader = (DenyResponseHeader)reply.getHeader("denyResponseHeader");
            if (denyHeader != null) {
                throw new UnknownLeaseException(denyHeader.getDenialReason(), existingLease);
            }
            Object var4_12 = null;
            this.pendingCancels.remove(leaseInfo);
            return;
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            this.pendingCancels.remove(leaseInfo);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lease newLease(Object leaseTarget, Object tenant, long requestedDuration, boolean isAbsolute) throws LeaseDeniedException {
        LocalLease localLease;
        if (leaseTarget == null) throw new LeaseDeniedException("Lease target and tenant should be not null.", leaseTarget);
        if (tenant == null) {
            throw new LeaseDeniedException("Lease target and tenant should be not null.", leaseTarget);
        }
        if (!(leaseTarget instanceof Serializable)) {
            throw new LeaseDeniedException("This lease factory can process only serializable lease targets", leaseTarget);
        }
        if (!(tenant instanceof Serializable)) {
            throw new LeaseDeniedException("This lease factory can process only serializable tenants", leaseTarget);
        }
        ClientLeaseInfo leaseInfo = new ClientLeaseInfo(leaseTarget, tenant);
        if (this.pendingLeases.keySet().contains(leaseInfo)) {
            throw new RecursiveLeaseRequestException("There's pending lease request for specified lease target and tenant.", leaseTarget, tenant);
        }
        try {
            block15: {
                Object leaseMutex = new Object();
                this.pendingLeases.put(leaseInfo, leaseMutex);
                try {
                    if (leaseMutex == null) break block15;
                    Object object = leaseMutex;
                    synchronized (object) {
                        LeaseRequestHeader requestHeader = new LeaseRequestHeader(1, requestedDuration, isAbsolute, tenant);
                        Message msg = new Message();
                        msg.putHeader("leaseRequestHeader", requestHeader);
                        msg.setObject((Serializable)leaseTarget);
                        this.clientChannel.send(msg);
                        leaseMutex.wait(this.leaseTimeout);
                    }
                }
                catch (InterruptedException ex) {
                    throw new LeaseDeniedException((Object)"Did not get any reply before the thread was interrupted.");
                }
                catch (ChannelNotConnectedException ex) {
                    throw new LeaseDeniedException("Unable to send request, channel is not connected " + ex.getMessage(), (Object)null);
                }
                catch (ChannelClosedException ex) {
                    throw new LeaseDeniedException("Unable to send request, channel is closed " + ex.getMessage(), (Object)null);
                }
            }
            if (!(this.pendingLeases.get(leaseInfo) instanceof Message)) {
                throw new LeaseDeniedException("Did not get reply from leasing service within specified timeframe.", leaseTarget);
            }
            Message reply = (Message)this.pendingLeases.get(leaseInfo);
            DenyResponseHeader denyHeader = (DenyResponseHeader)reply.getHeader("denyResponseHeader");
            if (denyHeader != null) {
                throw new LeaseDeniedException(denyHeader.getDenialReason(), reply.getObject());
            }
            LeaseResponseHeader responseHeader = (LeaseResponseHeader)reply.getHeader("leaseResponseHeader");
            localLease = new LocalLease(leaseTarget, tenant, responseHeader.getDuration());
            Object var8_16 = null;
            this.pendingLeases.remove(leaseInfo);
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            this.pendingLeases.remove(leaseInfo);
            throw throwable;
        }
        return localLease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lease renewLease(Lease existingLease, long requestedDuration, boolean isAbsolute) throws LeaseDeniedException {
        LocalLease localLease;
        if (existingLease == null) {
            throw new LeaseDeniedException("Existing lease cannot be null.", (Object)null);
        }
        if (existingLease.isExpired()) {
            throw new LeaseDeniedException("You existing lease has expired. You cannot use this method to obtain new lease.", existingLease.getLeaseTarget());
        }
        ClientLeaseInfo leaseInfo = new ClientLeaseInfo(existingLease.getLeaseTarget(), existingLease.getTenant());
        if (this.pendingLeases.keySet().contains(leaseInfo)) {
            throw new RecursiveLeaseRequestException("There's pending lease request for specified lease target and tenant.", existingLease.getLeaseTarget(), existingLease.getTenant());
        }
        try {
            Object leaseMutex = new Object();
            this.pendingLeases.put(leaseInfo, leaseMutex);
            Trace.debug(RENEW_LEASE_METHOD, "Added lease info for leaseTarget=" + existingLease.getLeaseTarget() + ", tenant=" + existingLease.getTenant());
            try {
                Object object = leaseMutex;
                synchronized (object) {
                    LeaseRequestHeader requestHeader = new LeaseRequestHeader(2, requestedDuration, isAbsolute, existingLease.getTenant());
                    Message msg = new Message();
                    msg.putHeader("leaseRequestHeader", requestHeader);
                    msg.setObject((Serializable)existingLease.getLeaseTarget());
                    this.clientChannel.send(msg);
                    leaseMutex.wait(this.leaseTimeout);
                }
            }
            catch (InterruptedException ex) {
                throw new LeaseDeniedException((Object)"Did not get any reply before the thread was interrupted.");
            }
            catch (ChannelNotConnectedException ex) {
                throw new LeaseDeniedException("Unable to send request, channel is not connected " + ex.getMessage(), (Object)null);
            }
            catch (ChannelClosedException ex) {
                throw new LeaseDeniedException("Unable to send request, channel is closed " + ex.getMessage(), (Object)null);
            }
            if (!(this.pendingLeases.get(leaseInfo) instanceof Message)) {
                throw new LeaseDeniedException("Did not get reply from leasing service within specified timeframe.", (Object)null);
            }
            Message reply = (Message)this.pendingLeases.get(leaseInfo);
            DenyResponseHeader denyHeader = (DenyResponseHeader)reply.getHeader("denyResponseHeader");
            if (denyHeader != null) {
                throw new LeaseDeniedException(denyHeader.getDenialReason(), (Object)null);
            }
            LeaseResponseHeader responseHeader = (LeaseResponseHeader)reply.getHeader("leaseResponseHeader");
            localLease = new LocalLease(existingLease.getLeaseTarget(), existingLease.getTenant(), responseHeader.getDuration());
            Object var7_15 = null;
            this.pendingLeases.remove(leaseInfo);
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            this.pendingLeases.remove(leaseInfo);
            throw throwable;
        }
        return localLease;
    }

    public Address getAddress() {
        return this.clientChannel.getLocalAddress();
    }

    private final /* synthetic */ void this() {
        this.leaseTimeout = 10000;
        this.cancelTimeout = 1000;
        this.pendingLeases = new HashMap();
        this.pendingRenewals = new HashMap();
        this.pendingCancels = new HashMap();
    }

    public LeaseFactoryClient(Channel clientChannel) {
        this(clientChannel, 10000, 1000);
    }

    public LeaseFactoryClient(Channel clientChannel, int leaseTimeout, int cancelTimeout) {
        this.this();
        this.clientChannel = clientChannel;
        this.clientAdapter = new PullPushAdapter((Transport)clientChannel, new ClientMessageListener());
    }

    private class ClientMessageListener
    implements MessageListener {
        public byte[] getState() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void receive(Message msg) {
            ClientLeaseInfo leaseInfo;
            boolean cancelReply;
            HashMap workingMap;
            Object leaseMutex;
            DenyResponseHeader denyHeader = (DenyResponseHeader)msg.getHeader("denyResponseHeader");
            LeaseResponseHeader leaseHeader = (LeaseResponseHeader)msg.getHeader("leaseResponseHeader");
            if (denyHeader == null && leaseHeader == null) {
                return;
            }
            Object leaseTarget = msg.getObject();
            Object tenant = denyHeader != null ? denyHeader.getTenant() : leaseHeader.getTenant();
            boolean bl = false;
            if (denyHeader != null && denyHeader.getType() == 3 || leaseHeader != null && leaseHeader.getType() == 3) {
                bl = true;
            }
            if ((leaseMutex = (workingMap = (cancelReply = bl) ? LeaseFactoryClient.this.pendingCancels : LeaseFactoryClient.this.pendingLeases).get(leaseInfo = new ClientLeaseInfo(leaseTarget, tenant))) == null) {
                workingMap.remove(leaseInfo);
                return;
            }
            Object v = leaseMutex;
            synchronized (v) {
                workingMap.put(leaseInfo, msg);
                leaseMutex.notifyAll();
                return;
            }
        }

        public void setState(byte[] state) {
        }

        private ClientMessageListener() {
        }
    }

    private static class ClientLeaseInfo {
        private Object leaseTarget;
        private Object tenant;

        public Object getLeaseTarget() {
            return this.leaseTarget;
        }

        public Object getTenant() {
            return this.tenant;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClientLeaseInfo)) {
                return false;
            }
            ClientLeaseInfo that = (ClientLeaseInfo)obj;
            boolean bl = false;
            if (that.getLeaseTarget().equals(this.leaseTarget) && that.getTenant().equals(this.tenant)) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.leaseTarget.hashCode() ^ this.tenant.hashCode();
        }

        public ClientLeaseInfo(Object leaseTarget, Object tenant) {
            this.leaseTarget = leaseTarget;
            this.tenant = tenant;
        }
    }

    private class LocalLease
    implements Lease {
        private long expiresAt;
        private long creationTime;
        private Object leaseTarget;
        private Object tenant;

        public long getExpiration() {
            return this.expiresAt;
        }

        public long getDuration() {
            return this.expiresAt > System.currentTimeMillis() ? this.expiresAt - System.currentTimeMillis() : (long)-1;
        }

        public LeaseFactory getFactory() {
            return LeaseFactoryClient.this;
        }

        public Object getLeaseTarget() {
            return this.leaseTarget;
        }

        public boolean isExpired() {
            boolean bl = false;
            if (System.currentTimeMillis() >= this.expiresAt) {
                bl = true;
            }
            return bl;
        }

        public Object getTenant() {
            return this.tenant;
        }

        public LocalLease(Object leaseTarget, Object tenant, long expiresAt) {
            this.leaseTarget = leaseTarget;
            this.tenant = tenant;
            this.expiresAt = expiresAt;
            this.creationTime = System.currentTimeMillis();
        }
    }
}

