/* -*- c++ -*-
*
* Copyright (C) 2004, 2005, 2006 Mekensleep
*
* Mekensleep
* 24 rue vieille du temple
* 75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.
*
* Authors:
*  Loic Dachary <loic@gnu.org>
*
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USE_NPROFILE
#include <nprofile/profile.h>
#else  // USE_NPROFILE
#define NPROFILE_SAMPLE(a)
#endif // USE_NPROFILE

#include <osgCal/Model>
#include <osgCal/SubMeshSoftware>

#include <osgDB/Registry>

//
// OSG interface for inclusion within a .osg file
//
static bool readLocalData(osg::Object &obj, osgDB::Input &fr)
{
  return true;
}

static bool writeLocalData(const osg::Object &obj, osgDB::Output &fw)
{
  const osgCal::SubMeshSoftware* submesh = dynamic_cast<const osgCal::SubMeshSoftware*>(&obj);
  if(submesh) {
    fw.indent() << " name " << submesh->getName() << std::endl;
  }
  return true;
}

static osgDB::RegisterDotOsgWrapperProxy static_OsgCalModel(
                                                            new osgCal::Model,
                                                            "Model",
                                                            "Object Node Geode Model",
                                                            readLocalData,
                                                            writeLocalData
                                                            );

static osgDB::RegisterDotOsgWrapperProxy static_SubMeshSoftware(
                                                                new osgCal::SubMeshSoftware,
                                                                "SubMeshSoftware",
                                                                "Object Drawable Geometry SubMeshSoftware",
                                                                readLocalData,
                                                                writeLocalData
                                                                );


