
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    status.c
**  Date:    March 12, 2002
**  
**  Author:  Brian Wotring
**  Purpose: status handling routines and defines.  These are used
**           by the daemons and the management host.
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include <sys/types.h>

#ifdef WIN32
#include <winsock.h>
#else
#include <netinet/in.h>
#endif

#include "utilities.h"
#include "status.h"

char * get_name_for_daemon_status( int status )
{
    switch( status )
    {
        case DAEMON_STATE_IDLE:
            return DAEMON_STATE_STRING_IDLE;
            break;
            
        case DAEMON_STATE_RECEIVING:
            return DAEMON_STATE_STRING_RECEIVING;
            break;
            
        case DAEMON_STATE_SCANNING:
            return DAEMON_STATE_STRING_SCANNING;
            break;

        default:
            return STATE_UNKNOWN_STRING;
            break;
    }
}

char * get_name_for_config_status( int status )
{
    switch( status )
    {
        case CONFIG_STATE_NULL:
            return CONFIG_STATE_STRING_NULL;
            break;
            
        case CONFIG_STATE_RECEIVING:
            return CONFIG_STATE_STRING_RECEIVING;
            break;
            
        case CONFIG_STATE_VALID:
            return CONFIG_STATE_STRING_VALID;
            break;

        case CONFIG_STATE_INVALID:
            return CONFIG_STATE_STRING_INVALID;
            break;
            
        default:
            return STATE_UNKNOWN_STRING;
            break;
    }
}

void wrap_status( OSI_STATUS *status )
{
    if( status != NULL )
    {
        status->start_time    = htonl( status->start_time );
        status->current_time  = htonl( status->current_time );
        status->config_time   = htonl( status->config_time );
        
        status->config_state  = htons( status->config_state );
        status->daemon_state  = htons( status->daemon_state );
    }
}

void unwrap_status( OSI_STATUS *status )
{
    if( status != NULL )
    {
        status->start_time    = ntohl( status->start_time );
        status->current_time  = ntohl( status->current_time );
        status->config_time   = ntohl( status->config_time );
        
        status->config_state  = ntohs( status->config_state );
        status->daemon_state  = ntohs( status->daemon_state );
    }
}


