<?php

/**
 * setacl.php
 * 
 * Author: Steve Bourgeois <owl@bozzit.com>
 * Project Founder: Chris Vincent <cvincent@project802.net>
 *
 * Copyright (c) 1999-2005 The Owl Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 * 
 * $Id: setacl.php,v 1.4 2006/03/06 17:39:34 b0zz Exp $
 */

require_once(dirname(__FILE__)."/config/owl.php");
require_once($default->owl_fs_root ."/lib/disp.lib.php");
require_once($default->owl_fs_root ."/lib/owl.lib.php");
require_once($default->owl_fs_root ."/lib/security.lib.php");
require_once($default->owl_fs_root ."/phpid3v2/class.id3.php");

$groups = fGetGroups($userid, "SETTINGACL");
$groups[-1][0] = "-1";
$groups[-1][1] = "None";
$aUserList = fGetUserInfoInMyGroups($userid);

$aUserList[0][username] = "everybody";
$aUserList[0][name] = "EVERYBODY";
$aUserList[0][id] = "0";
if($edit == 1)
{
   //if (($action == "file_acl" and fIsFileCreator($id)) or ($action == "file_acl" and fisAdmin()))
   if ($action == "file_acl" and check_auth($id, "file_acl", $userid) == 1)
   {
      $selectedgroups = array(); 
      $qSetAcl = "SELECT * FROM $default->owl_advanced_acl_table where file_id = '$id'";
      $sql = new Owl_DB;
      $sql->query($qSetAcl);
      while ($sql->next_record())
      {
         if($sql->f("group_id") == null )
         {
            $selectedusers[] = $sql->f("user_id");
         }
         else
         {
            $selectedgroups[] = $sql->f("group_id");
         }
      }
   }
   //elseif (($action == "folder_acl" and fIsFolderCreator($id)) or ($action == "folder_acl" and fisAdmin()))
   elseif ($action == "folder_acl" and check_auth($id, "folder_acl", $userid) == 1)
   {
      $fselectedgroups = array(); 
      $qSetAcl = "SELECT * FROM $default->owl_advanced_acl_table where folder_id = '$id'";
      $sql = new Owl_DB;
      $sql->query($qSetAcl);
      while ($sql->next_record())
      {
         if($sql->f("group_id") == null )
         {
            $fselectedusers[] = $sql->f("user_id");
         }
         else
         {
            $fselectedgroups[] = $sql->f("group_id");
         }
      }
   }
   else
   {
      include_once($default->owl_fs_root ."/lib/header.inc");
      include_once($default->owl_fs_root ."/lib/userheader.inc");
      printError($owl_lang->err_nofilemod);
   }
}

include_once($default->owl_fs_root ."/lib/header.inc");
include_once($default->owl_fs_root ."/lib/userheader.inc");
printModifyHeader();
//print("<pre>");
//print_r($selectedusers);
//print("==== ACTION: $action =========================================================================");
//print_r($selectedgroups);
//print("</pre>");

if ($sess == "0" && $default->anon_ro > 0)
{
   printError($owl_lang->err_login);
}

if(!isset($type))
{
   $type = "";
}

// V4B RNG Start
$urlArgs = array();
$urlArgs['sess']      = $sess;
if(!empty($page))
{
   $urlArgs['page']    = $page;
}
$urlArgs['parent']    = $parent;
$urlArgs['expand']    = $expand;
$urlArgs['order']     = $order;
$urlArgs['sortorder'] = $sortorder;
$urlArgs['curview']     = $curview;
// V4B RNG End

if ($action == "folder_acl")
{
   if (check_auth($id, "folder_acl", $userid) == 1)
   {
      $urlArgs2 = $urlArgs;
      $urlArgs2['expand'] = $expand;
      $urlArgs2['id']     = $id;
      $urlArgs2['action']  = "folder_acl";

      if($edit == 1)
      {
         fPrintNavBar($id,$owl_lang->acl_edit_folder);
      }
      else
      {
         fPrintNavBar($id,$owl_lang->acl_adding_folder);
      }


      print("<form action=\"setacl.php\" method=\"post\" name=\"fcombo_box\">\n");
      print fGetHiddenFields ($urlArgs2);

      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"center\" valign=\"top\">");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
      fPrintSectionHeader($owl_lang->acl_heading_folders);
      print("</table>");
      print("</td></tr></table><br />");

      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"center\" valign=\"top\">");
      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\n");
      print("<tr>\n");
      print("<td align=\"center\" valign=\"top\">\n");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
      print("<tr>\n");
      print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_available_groups</td>\n");
      print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">&nbsp;</td>\n");
      print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_selected_groups</td>\n");
      //print("<td class=\"admin3\">&nbsp;</td>\n");
      print("</tr>\n");
      print("<tr>\n");
      print("<td class=\"form1\">\n");
      print("<select multiple=\"multiple\" size=\"10\" name=\"fallgroups[]\" class=\"fpullacl\">\n");
      foreach($groups as $g)
      {
         if ($g[0] == -1)
         {
            continue;
         }
         if (!empty($fselectedgroups))
         {
            if (!(in_array($g[0], $fselectedgroups)))
            {
               print("<option value=\"$g[0]\"");
               print(">$g[1]</option>\n");
            }
         }
         else
         {
            print("<option value=\"$g[0]\"");
            print(">$g[1]</option>\n");
         }
      }
      print("</select>\n</td>\n");

      print("<td class=\"form1\" nowrap=\"nowrap\">");
      print("&nbsp;&nbsp;<input type=\"button\" onclick=\"move(this.form.elements['fselectedgroups[]'],this.form.elements['fallgroups[]'])\" value=\"<--\"></input>\n");
      print("<input type=\"button\" onclick=\"move(this.form.elements['fallgroups[]'],this.form.elements['fselectedgroups[]'])\" value=\"-->\"></input>\n");
      print("<br />");
      print("<input type=\"button\" onclick=\"selectAllGroups(this.form.elements['fselectedgroups[]'],this.form.elements['fallgroups[]'])\" value=\"<<--\"></input>\n");
      print("<input type=\"button\" onclick=\"selectAllGroups(this.form.elements['fallgroups[]'],this.form.elements['fselectedgroups[]'])\" value=\"-->>\"></input>\n");
      print("</td>\n");
      print("<td class=\"form1\">");
      print("<select multiple=\"multiple\" size=\"10\" name=\"fselectedgroups[]\" class=\"fpullacl\">");
      if (!empty($groups))
      {
         foreach($groups as $g)
         {
            if ($g[0] == -1)
            {
               continue;
            }
            if (!empty($fselectedgroups))
            {
               if ((in_array($g[0], $fselectedgroups)))
               {
                  print("<option value=\"$g[0]\"");
                  print(">$g[1]</option>\n");
               }
            }
         }
      }
      print("</select>\n</td>\n");
      print("</tr>\n");
      print("<tr>\n");
      print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_available_users</td>\n");
      print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">&nbsp;</td>\n");
      print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_selected_users</td>\n");
      print("</tr>\n");
      print("<tr>\n");
      print("<td class=\"form1\">\n");
      print("<select multiple=\"multiple\" size=\"10\" name=\"fallusers[]\" class=\"fpullacl\">\n");
      if (!empty($aUserList))
      {
         foreach ($aUserList as $aUsers)
         {
            $sUsername = $aUsers["username"];
            $sId = $aUsers["id"];
            $sName = $aUsers["name"];
            if(!empty($aUsers["email"]))
            {
               $sEmail = " (" . $aUsers["email"] . ")";
            }
            else
            {
               $sEmail = "";
            }
            if (!empty($fselectedusers))
            {
               if (!(in_array($sId, $fselectedusers)))
               {
                  print("<option value=\"$sId\"");
                  print(">" . $sName .  $sEmail . "</option>\n");
               }
            }
            else
            {
               print("<option value=\"$sId\"");
               print(">" . $sName . $sEmail . "</option>\n");
            }
         }
      }
      print("</select>\n");
      print("</td>\n");
      print("<td class=\"form1\" nowrap=\"nowrap\">\n");
      print("&nbsp;&nbsp;<input type=\"button\" onclick=\"move(this.form.elements['fselectedusers[]'],this.form.elements['fallusers[]'])\" value=\"<--\"></input>\n");
      print("<input type=\"button\" onclick=\"move(this.form.elements['fallusers[]'],this.form.elements['fselectedusers[]'])\" value=\"-->\"></input>\n");
      print("<br />");
      print("<input type=\"button\" onclick=\"selectAllUsers(this.form.elements['fselectedusers[]'],this.form.elements['fallusers[]'])\" value=\"<<--\"></input>\n");
      print("<input type=\"button\" onclick=\"selectAllUsers(this.form.elements['fallusers[]'],this.form.elements['fselectedusers[]'])\" value=\"-->>\"></input>\n");
      print("</td>\n");
      print("<td class=\"form1\">\n");
      print("<select multiple=\"multiple\" size=\"10\" name=\"fselectedusers[]\" class=\"fpullacl\">\n");
      if (!empty($aUserList))
      {
         foreach ($aUserList as $aUsers)
         {
            $sUsername = $aUsers["username"];
            $sId = $aUsers["id"];
            $sName = $aUsers["name"];
            if(!empty($aUsers["email"]))
            {
               $sEmail = " (" . $aUsers["email"] . ")";
            }
            else
            {
               $sEmail = "";
            }
            if (!empty($fselectedusers))
            {
               if ((in_array($sId, $fselectedusers)))
               {
                  print("<option value=\"$sId\"");
                  print(">" . $sName . $sEmail . "</option>\n");
               }
            }
         }
      }
      //print("</select>\n");
      print("</select>\n");
      print("</td>\n");
      print("</tr>\n");
      if (!fIsAdmin())
      {
         print("<tr>\n");
         print("<td colspan=\"2\" class=\"form1\">");
         fPrintButtonSpace(1, 1);
         print("</td>\n");
         print("<td class=\"form2\" width=\"100%\">");
         print("<input class=\"fbuttonup1\" type=\"submit\" name=\"submit_button\" value=\"$owl_lang->acl_set_selected\" onclick=\"selectAll(document.fcombo_box.elements['fselectedusers[]']); selectAll(document.fcombo_box.elements['fselectedgroups[]']);\">\n"); 
         print("</td>\n");
         print("</tr>\n");
      }
      print("</table>\n");
      print("</td>\n");
      print("</tr>\n");
      print("</table>\n");
      print("</td>\n");
      print("</tr>\n");
      print("</table>\n");
      if (fIsAdmin())
      {
         fPrintSelectFileUserGroups("admin");
      }
      print("</form>\n");
      print("</td>\n");
      print("</tr>\n");
      print("<tr>\n");
      print("<td align=\"left\" valign=\"top\">\n");
      print("<form action=\"dbmodify.php\" method=\"post\" name=\"set_facl\">\n");
      print fGetHiddenFields ($urlArgs2);

      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"left\" valign=\"top\">");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
      fPrintSectionHeader("$owl_lang->acl_set_folder_permissions");
      print("</table>");
      print("</td></tr></table>");

      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"left\" valign=\"top\">");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
      print("<tr>\n");
      print("<td class=\"title1\" align=\"center\"><b>$owl_lang->acl_heading_folder</b></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlread()\">$owl_lang->acl_folder_read</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlwrite()\">$owl_lang->acl_folder_write</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowldelete()\">$owl_lang->acl_folder_delete</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlcopy()\">$owl_lang->acl_folder_copy</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlmove()\">$owl_lang->acl_folder_move</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlproperties()\">$owl_lang->acl_folder_modify</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlsetacl()\">$owl_lang->acl_folder_set_acl</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:fcheckowlmonitor()\">$owl_lang->acl_folder_monitor</a></td>\n");
      print("</tr>\n");

      $CountLines = 0;
      if(!empty($fselectedgroups)) 
      {
         foreach ($fselectedgroups as $val)
         {
            if($val == -1)
            {
               continue;
            }
            $CountLines++;
            $PrintLines = $CountLines % 2;
            if ($PrintLines == 0)
            {  
               $sTrClass = "file1";
               $sLfList = "lfile1";
            }
            else
            {
               $sTrClass = "file2";
               $sLfList = "lfile2";
            }  
            print("<tr>\n");
            print("<td class=\"$sTrClass\"><a class=\"lnavbar1\" href=\"javascript:checkFG" . $val ."()\">" . group_to_name($val) . "</a></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlread_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlread") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlwrite_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlwrite") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owldelete_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owldelete") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlcopy_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlcopy") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlmove_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlmove") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlproperties_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlproperties") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlsetacl_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlsetacl") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"fgacl_owlmonitor_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlmonitor") . "></input</b></td>\n");
            print("</tr>\n");
	 }
      }
      if(!empty($fselectedusers)) 
      {
         foreach ($fselectedusers as $val)
         {
            $CountLines++;
            $PrintLines = $CountLines % 2;
            if ($PrintLines == 0)
            {  
               $sTrClass = "file1";
               $sLfList = "lfile1";
            }
            else
            {
               $sTrClass = "file2";
               $sLfList = "lfile2";
            }  
            print("<tr>\n");
            print("<td class=\"$sTrClass\"><a class=\"lnavbar1\" href=\"javascript:checkFU" . $val . "()\">" . uid_to_name($val) ."</a></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlread_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlread", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlwrite_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlwrite", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owldelete_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owldelete", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlcopy_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlcopy", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlmove_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlmove", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlproperties_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlproperties", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlsetacl_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlsetacl", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"facl_owlmonitor_" . $val . "\" value=\"" . $val . "\" " . fGetFAclChecked($id, $val, "owlmonitor", "users") . "></input</b></td>\n");
           print("</tr>\n");
	}
     }
     if (!fIsAdmin())
     {
        print("<tr>\n");
        print("<td colspan=\"8\" class=\"form1\" width=\"100%\">");
        fPrintButtonSpace(1, 1);
        print("</td>\n");
        print("<td class=\"form2\" nowrap=\"nowrap\">");
        fPrintSubmitButton($owl_lang->btn_acl_save, $owl_lang->alt_acl_save_folder);
        fPrintSubmitButton($owl_lang->btn_reset, $owl_lang->alt_reset_form, "reset");
        print("</td>\n");
        print("</tr>\n");
     }
     else
     {
        print("<tr>\n");
        print("<td colspan=\"8\" class=\"form1\" width=\"100%\">");
        fPrintButtonSpace(1, 1);
        print("</td>\n");
        print("<td class=\"form1\" nowrap=\"nowrap\">");
        print("<table>\n");
        print("<tr>\n");
        fPrintFormCheckBox($owl_lang->acl_propagate_folders, "folder_propagate", "1");
        print("</tr>\n");
        print("</table>\n");
        print("</td>\n");
        print("</tr>\n");
     }
     print("</table>\n");
     print("</td>\n");
     print("</tr>\n");
     print("</table>\n");

     if (fIsAdmin())
     {
        fPrintSetFileAcl($id, "admin");
     }
     print("</form>\n");
     //print("</td></tr></table>\n");
   }
}
elseif ($action == "file_acl")
{
   if (check_auth($id, "file_acl", $userid) == 1)
   {
      $urlArgs2 = $urlArgs;
      $urlArgs2['expand'] = $expand;
      $urlArgs2['id']     = $id;
      $urlArgs2['action']  = "file_acl";

      if($edit == 1)
      {
         fPrintNavBar($parent,$owl_lang->acl_edit_file, $id);
      }
      else
      {
         fPrintNavBar($parent,$owl_lang->acl_adding_file, $id);
      }

      print("<form action=\"setacl.php\" method=\"post\" name=\"combo_box\">");
      print fGetHiddenFields ($urlArgs2);
      fPrintSelectFileUserGroups();
      print("</form>\n");

      print("</td>\n");
      print("</tr>\n");
      print("<tr>\n");
      print("<td align=\"left\" valign=\"top\">\n");
      print("<form action=\"dbmodify.php\" method=\"post\" name=\"set_acl\">\n");
      print fGetHiddenFields ($urlArgs2);
      fPrintSetFileAcl($id);
      print("</form>\n");
      //print("</td></tr></table>\n");
   }
   else
   {
      printError($owl_lang->err_nofilemod);
   } 
}


fPrintButtonSpace(12, 1);

if ($default->show_prefs == 2 or $default->show_prefs == 3)
{
   fPrintPrefs("infobar2");
}

print("</td></tr></table>\n");
include($default->owl_fs_root ."/lib/footer.inc");

function fPrintSetFileAcl($id, $type = "user")
{
      global $owl_lang, $groups, $selectedgroups, $aUserList, $selectedusers ;
      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"left\" valign=\"top\">");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
      fPrintSectionHeader("$owl_lang->acl_set_file_permissions");
      print("</table>");
      print("</td></tr></table>");
      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"left\" valign=\"top\">");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
      print("<tr>\n");
      print("<td class=\"title1\" align=\"center\"><b>$owl_lang->acl_heading_file</b></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlread()\">$owl_lang->acl_file_read</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlupdate()\">$owl_lang->acl_file_update</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlsetacl()\">$owl_lang->acl_file_set_acl</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowldelete()\">$owl_lang->acl_file_delete</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlcopy()\">$owl_lang->acl_file_copy</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlmove()\">$owl_lang->acl_file_move</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlproperties()\">$owl_lang->acl_file_modify</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlviewlog()\">$owl_lang->acl_file_view_log</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlcomment()\">$owl_lang->acl_file_comment</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlcheckin()\">$owl_lang->acl_file_checkin</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlemail()\">$owl_lang->acl_file_email</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlrelsearch()\">$owl_lang->acl_file_search</a></td>\n");
      print("<td class=\"title1\" align=\"center\"><a class=\"ltitle1\" href=\"javascript:checkowlmonitor()\">$owl_lang->acl_file_monitor</a></td>\n");
      print("</tr>\n");

      $CountLines = 0;
      if(!empty($selectedgroups)) 
      {
         foreach ($selectedgroups as $val)
         {
            if($val == -1)
            {
               continue;
            }
            $CountLines++;
            $PrintLines = $CountLines % 2;
            if ($PrintLines == 0)
            {  
              $sTrClass = "file1";
              $sLfList = "lfile1";
            }
            else
            {
              $sTrClass = "file2";
              $sLfList = "lfile2";
            }  
            print("<tr>\n");
            print("<td class=\"$sTrClass\"><a class=\"lnavbar1\" href=\"javascript:checkG" . $val ."()\">" . group_to_name($val) . "</a></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlread_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlread") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlupdate_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlupdate") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlsetacl_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlsetacl") . "></input</b></td>\n");
            //print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlwrite_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlwrite") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owldelete_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owldelete") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlcopy_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlcopy") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlmove_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlmove") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlproperties_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlproperties") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlviewlog_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlviewlog") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlcomment_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlcomment") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlcheckin_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlcheckin") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlemail_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlemail") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlrelsearch_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlrelsearch") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"gacl_owlmonitor_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlmonitor") . "></input</b></td>\n");
            print("</tr>\n");
	 }
      }
      if(!empty($selectedusers)) 
      {
         foreach ($selectedusers as $val)
         {
            $CountLines++;
            $PrintLines = $CountLines % 2;
            if ($PrintLines == 0)
            {  
               $sTrClass = "file1";
               $sLfList = "lfile1";
            }
            else
            {
               $sTrClass = "file2";
               $sLfList = "lfile2";
            }  
            print("<tr>\n");
            print("<td class=\"$sTrClass\"><a class=\"lnavbar1\" href=\"javascript:checkU" . $val ."()\">" . uid_to_name($val) ."</a></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlread_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlread", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlupdate_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlupdate", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlsetacl_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlsetacl", "users") . "></input</b></td>\n");
            //print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlwrite_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlwrite", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owldelete_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owldelete", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlcopy_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlcopy", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlmove_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlmove", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlproperties_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlproperties", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlviewlog_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlviewlog", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlcomment_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlcomment", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlcheckin_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlcheckin", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlemail_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlemail", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlrelsearch_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlrelsearch", "users") . "></input</b></td>\n");
            print("<td class=\"$sTrClass\" align=\"center\"><b><input type=\"checkbox\" name=\"acl_owlmonitor_" . $val . "\" value=\"" . $val . "\" " . fGetAclChecked($id, $val, "owlmonitor", "users") . "></input</b></td>\n");
            print("</tr>\n");
	 }
      }
      if ($type == "admin")
      {
         print("<tr>\n");
         print("<td colspan=\"13\" class=\"form1\" width=\"100%\">");
         fPrintButtonSpace(1, 1);
         print("</td>\n");
         print("<td class=\"form2\" nowrap=\"nowrap\">");
         print("<table>\n");
         print("<tr>\n");
         fPrintFormCheckBox($owl_lang->acl_propagate_file, "file_propagate", "1");
         print("</tr>\n");
         print("</table>\n");
         print("</td>\n");
         print("</tr>\n");
      }
      print("<tr>\n");
      print("<td colspan=\"13\" class=\"form1\" width=\"100%\">");
      fPrintButtonSpace(1, 1);
      print("</td>\n");
      print("<td class=\"form2\" nowrap=\"nowrap\">");
      fPrintSubmitButton($owl_lang->btn_acl_save, $owl_lang->alt_acl_save_file);
      fPrintSubmitButton($owl_lang->btn_reset, $owl_lang->alt_reset_form, "reset");
      print("</td>\n");
      print("</tr>\n");
      print("</table>\n");
      print("</td>\n");
      print("</tr>\n");
      print("</table>\n");
}

function fPrintSelectFileUserGroups($type = "user")
{
   global $owl_lang, $groups, $selectedgroups, $aUserList, $selectedusers;

      print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
      print("<tr>\n<td align=\"center\" valign=\"top\">");
      print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">");
      fPrintSectionHeader($owl_lang->acl_heading_files);
      print("</table>");
      print("</td></tr></table><br />");
   
   print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
   print("<tr>\n");
   print("<td align=\"center\" valign=\"top\">\n");
   print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
   print("<tr>\n");
   print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_available_groups</td>\n");
   print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">&nbsp;</td>\n");
   print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_selected_groups</td>\n");
   //print("<td class=\"admin3\">&nbsp;</td>\n");
   print("</tr>");

   print("<tr>\n");
   print("<td class=\"form1\">\n");
   print("<select multiple=\"multiple\" size=\"10\" name=\"allgroups[]\" class=\"fpullacl\">\n");

   foreach($groups as $g)
   {
      if ($g[0] == -1)
      {
         continue;
      }
      if (!empty($selectedgroups))
      {
         if (!(in_array($g[0], $selectedgroups)))
         {
            print("<option value=\"$g[0]\"");
            print(">$g[1]</option>\n");
         }
      }
      else
      {
         print("<option value=\"$g[0]\"");
         print(">$g[1]</option>\n");
      }
   }
   print("</select>\n</td>\n");
   print("<td class=\"form1\" nowrap=\"nowrap\">\n");
   print("&nbsp;&nbsp;<input type=\"button\" onclick=\"move(this.form.elements['selectedgroups[]'],this.form.elements['allgroups[]'])\" value=\"<--\"></input>");
   print("<input type=\"button\" onclick=\"move(this.form.elements['allgroups[]'],this.form.elements['selectedgroups[]'])\" value=\"-->\"></input>");
   print("<br />");
   print("<input type=\"button\" onclick=\"selectAllGroups(this.form.elements['selectedgroups[]'],this.form.elements['allgroups[]'])\" value=\"<<--\"></input>");
   print("<input type=\"button\" onclick=\"selectAllGroups(this.form.elements['allgroups[]'],this.form.elements['selectedgroups[]'])\" value=\"-->>\"></input>");
   print("</td>");
   print("<td class=\"form1\">\n");
   print("<select multiple=\"multiple\" size=\"10\" name=\"selectedgroups[]\" class=\"fpullacl\">");
   if (!empty($groups))
   {
      foreach($groups as $g)
      {
         if ($g[0] == -1)
         {
            continue;
         }
         if (!empty($selectedgroups))
         {
            if ((in_array($g[0], $selectedgroups)))
            {
               print("<option value=\"$g[0]\"");
               print(">$g[1]</option>\n");
            }
         }
      }
   }
   print("</select>\n</td>\n\n");
   //print("<td class=\"form1\" width=\"100%\">&nbsp;</td>");
   print("</tr>\n");
   print("<tr>\n");
   print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_available_users</td>\n");
   print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">&nbsp;</td>\n");
   print("<td class=\"admin3\" align=\"center\" nowrap=\"nowrap\">$owl_lang->acl_selected_users</td>\n");
   print("</tr>");
   print("<tr>\n");
   print("<td class=\"form1\">");
   print("<select multiple=\"multiple\" size=\"10\" name=\"allusers[]\" class=\"fpullacl\">");
   if (!empty($aUserList))
   {
      foreach ($aUserList as $aUsers)
      {
         $sUsername = $aUsers["username"];
         $sId = $aUsers["id"];
         $sName = $aUsers["name"];
         if(!empty($aUsers["email"]))
         {
            $sEmail = " (" . $aUsers["email"] . ")";
         }
         else
         {
            $sEmail = "";
         }

         if (!empty($selectedusers))
         {
            if (!(in_array($sId, $selectedusers)))
            {
               print("<option value=\"$sId\"");
               print(">" . $sName .  $sEmail . "</option>\n");
            }
         }
         else
         {
            print("<option value=\"$sId\"");
            print(">" . $sName . $sEmail . "</option>\n");
         }
      }
   }
   print("</select>\n");
   print("</td>\n");
	   print("<td class=\"form1\" nowrap=\"nowrap\">\n");
   print("&nbsp;&nbsp;<input type=\"button\" onclick=\"move(this.form.elements['selectedusers[]'],this.form.elements['allusers[]'])\" value=\"<--\"></input>\n");
   print("<input type=\"button\" onclick=\"move(this.form.elements['allusers[]'],this.form.elements['selectedusers[]'])\" value=\"-->\"></input>\n");
   print("<br />");
   print("<input type=\"button\" onclick=\"selectAllUsers(this.form.elements['selectedusers[]'],this.form.elements['allusers[]'])\" value=\"<<--\"></input>\n");
   print("<input type=\"button\" onclick=\"selectAllUsers(this.form.elements['allusers[]'],this.form.elements['selectedusers[]'])\" value=\"-->>\"></input>\n");
   print("</td>\n");
   print("<td class=\"form1\">\n");
   print("<select multiple=\"multiple\" size=\"10\" name=\"selectedusers[]\" class=\"fpullacl\">\n");
   if (!empty($aUserList))
   {
      foreach ($aUserList as $aUsers)
      {
         $sUsername = $aUsers["username"];
         $sId = $aUsers["id"];
         $sName = $aUsers["name"];
         if(!empty($aUsers["email"]))
         {
            $sEmail = " (" . $aUsers["email"] . ")";
         }
         else
         {
            $sEmail = "";
         }
         if (!empty($selectedusers))
         {
            if ((in_array($sId, $selectedusers)))
            {
               print("<option value=\"$sId\"");
               print(">" . $sName . $sEmail . "</option>\n");
            }
         }
      }
   }
   //print("</select>\n");
   print("</select>\n");
   print("</td>\n");
   print("</tr>\n");
   print("<tr>\n");
   print("<td colspan=\"2\" class=\"form1\">");
   fPrintButtonSpace(1, 1);
   print("</td>\n");
   print("<td class=\"form2\">");
 
   if ($type == "admin")
   {
      print("<input class=\"fbuttonup1\" type=\"submit\" name=\"submit_button\" value=\"$owl_lang->acl_set_selected\" onclick=\"selectAll(document.fcombo_box.elements['selectedusers[]']); selectAll(document.fcombo_box.elements['selectedgroups[]']); selectAll(document.fcombo_box.elements['fselectedusers[]']); selectAll(document.fcombo_box.elements['fselectedgroups[]']);\">\n"); 
   }
   else
   {
      print("<input class=\"fbuttonup1\" type=\"submit\" name=\"submit_button\" value=\"$owl_lang->acl_set_selected\" onclick=\"selectAll(document.combo_box.elements['selectedusers[]']); selectAll(document.combo_box.elements['selectedgroups[]']);\">");  
   }


   print("</td>\n");
   print("</tr>\n");
   print("</table>\n");
   print("</td>\n");
   print("</tr>\n");
   print("</table>\n");
}
?>
