#ifndef __INFORMATIONPLUGIN_H_2004_06_21
#define __INFORMATIONPLUGIN_H_2004_06_21

#include <string>

#include <qstring.h>

class QWidget;

#include "plugin.h"

namespace NPlugin
{

/**
  * @author Benjamin Mesing
  */
class InformationPlugin : virtual public Plugin 
{
public:
	/**
	  * @returns a widget where the information offered by this plugin is shown, 
	  * 0 if no information widget is available for this plugin.
	  */
	virtual QWidget* informationWidget() const = 0;
	/**
	  * @returns the title of the informationWidget.
	  */
	virtual QString informationWidgetTitle() const = 0;
	/**
	  * @brief This shows the information available for the handed package, in 
 	  * the informationWidget.
	  *
	  * @param packageID the handle of the package to be shown.
	  */
	virtual void updateInformationWidget(const string& package) = 0;
	/**
	  * @brief This clears the content of the information widget.
	  */
	virtual void clearInformationWidget() = 0;
	/** @brief Returns if this plugin offers information which should be shown in
          * the details section of the search windows result view.
	  */
	virtual bool offersInformationText() const = 0;
	/**
	  * @returns the information text for the given package
	  * @see offersInformationText
	  * @param packageID the handle of the package the information shall be returned
	  */
	virtual QString informationText (const string& package) = 0;
	/** @brief Returns the priority of this information plugin. 
	  * 
	  * Lower values mean that the plugins output will be shown most visible (e.g. on top). */
	virtual uint informationPriority() const = 0;
};


}	// namespace NPlugin

#endif //	__INFORMATIONPLUGIN_H_2004_06_21

