/* This is the worst code you have ever seen written on purpose.... this code is just a big hack to test
out the functionality of the library */

#include "../mycrypt.h"

int null_setup(const unsigned char *key, int keylen, int num_rounds, symmetric_key *skey)
{
   return CRYPT_OK;
}

void null_ecb_encrypt(const unsigned char *pt, unsigned char *ct, symmetric_key *key)
{
   memcpy(ct, pt, 8);
}

void null_ecb_decrypt(const unsigned char *ct, unsigned char *pt, symmetric_key *key)
{
   memcpy(pt, ct, 8);
}

int null_test(void)
{
   return CRYPT_OK;
}

int null_keysize(int *desired_keysize)
{
   return CRYPT_OK;
} 

const struct _cipher_descriptor null_desc =
{
    "memcpy()",
    255,
    8, 8, 8, 1,
    &null_setup,
    &null_ecb_encrypt,
    &null_ecb_decrypt,
    &null_test,
    &null_keysize
};


#ifdef GBA
#include <gba.h>
#include <stdarg.h>
#define printf _aprint

void _aprint(const char *fmt, ...)
{
  va_list ap;
  char buf[512], *bp;
  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);

  bp = buf;
  while (*bp) {
      if (*bp == '\n') wait(CLOCKS_PER_SEC/2);
      modetxt_putc((u8 *)vfb, *bp, 1);
      ++bp;
  }
  va_end(ap);
}

#define clock() clocks

#endif

prng_state prng;

void store_tests(void) 
{
 unsigned char buf[8];
 unsigned long L;
 ulong64 LL;

 printf("LOAD32/STORE32 tests\n");
 L = 0x12345678UL;
 STORE32L(L, &buf[0]);
 L = 0;
 LOAD32L(L, &buf[0]);
 if (L != 0x12345678UL) printf("LOAD/STORE32 Little don't work\n");
 LL = CONST64(0x01020304050607);
 STORE64L(LL, &buf[0]);
 LL = 0;
 LOAD64L(LL, &buf[0])
 if (LL != CONST64(0x01020304050607)) printf("LOAD/STORE64 Little don't work\n");

 L = 0x12345678UL;
 STORE32H(L, &buf[0]);
 L = 0;
 LOAD32H(L, &buf[0]);
 if (L != 0x12345678UL) printf("LOAD/STORE32 High don't work\n");
 LL = CONST64(0x01020304050607);
 STORE64H(LL, &buf[0]);
 LL = 0;
 LOAD64H(LL, &buf[0])
 if (LL != CONST64(0x01020304050607)) printf("LOAD/STORE64 High don't work\n");
}

void cipher_tests(void) {
   int x;

   printf("Ciphers compiled in\n");
 for (x = 0; cipher_descriptor[x].name != NULL; x++) {
     printf(" %12s (%2d) Key Size: %4ld to %4ld, Block Size: %3ld, Default # of rounds: %2ld\n", cipher_descriptor[x].name,
            cipher_descriptor[x].ID,
            cipher_descriptor[x].min_key_length*8,cipher_descriptor[x].max_key_length*8,
            cipher_descriptor[x].block_length*8, cipher_descriptor[x].default_rounds);
 }

}

void ecb_tests(void)
{
 int x;

 printf("ECB tests\n");
 for (x = 0; cipher_descriptor[x].name != NULL; x++) {
#ifdef GBA
     printf("%s: ",
#else
     printf(" %12s: ",
#endif
           cipher_descriptor[x].name);
     if (cipher_descriptor[x].test() == CRYPT_ERROR)
        printf(" **failed** Reason: %s\n", crypt_error);
     else 
        printf("passed\n");
 }
}

#ifdef CBC
void cbc_tests(void)
{
 symmetric_CBC cbc;
 int x, y;
 unsigned char blk[32], ct[32], key[32], IV[32];
 const unsigned char test[] = { 0XFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

 printf("CBC tests\n");
 /* ---- CBC ENCODING ---- */
 /* make up a block and IV */
 for (x = 0; x < 32; x++) blk[x] = IV[x] = x;

 /* now lets start a cbc session */
 if (cbc_start(find_cipher("blowfish"), IV, key, 16, 0, &cbc) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets encode 32 bytes */
 for (x = 0; x < 4; x++)
    cbc_encrypt(blk+8*x, ct+8*x, &cbc);

 zeromem(blk, sizeof(blk));

 /* ---- CBC DECODING ---- */
 /* make up a IV */
 for (x = 0; x < 32; x++) IV[x] = x;

 /* now lets start a cbc session */
 if (cbc_start(find_cipher("blowfish"), IV, key, 16, 0, &cbc) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets decode 32 bytes */
 for (x = 0; x < 4; x++)
    cbc_decrypt(ct+8*x, blk+8*x, &cbc);

 /* print output */
 for (x = y = 0; x < 32; x++) if (blk[x] != x) y = 1;
 printf("  %s\n", y?"failed":"passed");

 /* lets actually check the bytes */
 memset(IV, 0, 8); IV[0] = 0xFF;              /* IV  = FF 00 00 00 00 00 00 00 */
 memset(blk, 0, 32); blk[8] = 0xFF;           /* BLK = 00 00 00 00 00 00 00 00 FF 00 00 00 00 00 00 00 */
 cbc_start(find_cipher("memcpy()"), IV, key, 8, 0, &cbc);
 cbc_encrypt(blk, ct, &cbc);                  /* expect: FF 00 00 00 00 00 00 00 */
 cbc_encrypt(blk+8, ct+8, &cbc);              /* expect: 00 00 00 00 00 00 00 00 */
 if (memcmp(ct, test, 16)) {
    printf("CBC failed logical testing.\n");
    for (x = 0; x < 16; x++) printf("%02x ", ct[x]);
    printf("\n");
 } else {
    printf("CBC passed logical testing.\n");
 }
}
#else
void cbc_tests(void) { printf("CBC not compiled in\n"); }
#endif

#ifdef OFB
void ofb_tests(void)
{
 symmetric_OFB ofb;
 int x, y;
 unsigned char blk[32], ct[32], key[32], IV[32];

 printf("OFB tests\n");
 /* ---- ofb ENCODING ---- */
 /* make up a block and IV */
 for (x = 0; x < 32; x++) blk[x] = IV[x] = x;

 /* now lets start a ofb session */
 if (ofb_start(find_cipher("blowfish"), IV, key, 16, 0, &ofb) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets encode 32 bytes */
 for (x = 0; x < 4; x++)
    ofb_encrypt(blk+8*x, ct+8*x, 8, &ofb);

 zeromem(blk, sizeof(blk));

 /* ---- ofb DECODING ---- */
 /* make up a IV */
 for (x = 0; x < 32; x++) IV[x] = x;

 /* now lets start a ofb session */
 if (ofb_start(find_cipher("blowfish"), IV, key, 16, 0, &ofb) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets decode 32 bytes */
 for (x = 0; x < 4; x++)
    ofb_decrypt(ct+8*x, blk+8*x, 8, &ofb);

 /* print output */
 for (x = y = 0; x < 32; x++) if (blk[x] != x) y = 1;
 printf("  %s\n", y?"failed":"passed");
}
#else
void ofb_tests(void) { printf("OFB not compiled in\n"); }
#endif

#ifdef CFB
void cfb_tests(void)
{
 symmetric_CFB cfb;
 int x, y;
 unsigned char blk[32], ct[32], key[32], IV[32];

 printf("CFB tests\n");
 /* ---- cfb ENCODING ---- */
 /* make up a block and IV */
 for (x = 0; x < 32; x++) blk[x] = IV[x] = x;

 /* now lets start a cfb session */
 if (cfb_start(find_cipher("blowfish"), IV, key, 16, 0, &cfb) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets encode 32 bytes */
 for (x = 0; x < 4; x++)
    cfb_encrypt(blk+8*x, ct+8*x, 8, &cfb);

 zeromem(blk, sizeof(blk));

 /* ---- cfb DECODING ---- */
 /* make up ahash_descriptor[prng->yarrow.hash].hashsize IV */
 for (x = 0; x < 32; x++) IV[x] = x;

 /* now lets start a cfb session */
 if (cfb_start(find_cipher("blowfish"), IV, key, 16, 0, &cfb) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets decode 32 bytes */
 for (x = 0; x < 4; x++)
    cfb_decrypt(ct+8*x, blk+8*x, 8, &cfb);

 /* print output */
 for (x = y = 0; x < 32; x++) if (blk[x] != x) y = 1;
 printf("  %s\n", y?"failed":"passed");
}
#else
void cfb_tests(void) { printf("CFB not compiled in\n"); }
#endif

#ifdef CTR
void ctr_tests(void)
{
 symmetric_CTR ctr;
 int x, y;
 unsigned char blk[32], ct[32], key[32], count[32];
 const unsigned char test[] = { 0xFF, 0, 0, 0, 0, 0, 0, 0,  0, 3, 0, 0, 0, 0, 0, 0 };

 printf("CTR tests\n");
 /* ---- CTR ENCODING ---- */
 /* make up a block and IV */
 for (x = 0; x < 32; x++) blk[x] = count[x] = x;

 /* now lets start a ctr session */
 if (ctr_start(find_cipher("rijndael"), count, key, 16, 0, &ctr) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets encode 32 bytes */
 for (x = 0; x < 4; x++)
    ctr_encrypt(blk+8*x, ct+8*x, 8, &ctr);

 zeromem(blk, sizeof(blk));

 /* ---- CTR DECODING ---- */
 /* make up a IV */
 for (x = 0; x < 32; x++) count[x] = x;

 /* now lets start a cbc session */
 if (ctr_start(find_cipher("rijndael"), count, key, 16, 0, &ctr) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* now lets decode 32 bytes */
 for (x = 0; x < 4; x++)
    ctr_decrypt(ct+8*x, blk+8*x, 8, &ctr);

 /* print output */
 for (x = y = 0; x < 32; x++) if (blk[x] != x) y = 1;
 printf("  %s\n", y?"failed":"passed");

 /* lets actually check the bytes */
 memset(count, 0, 8); count[0] = 0xFF;        /* IV  = FF 00 00 00 00 00 00 00 */
 memset(blk, 0, 32); blk[9] = 2;              /* BLK = 00 00 00 00 00 00 00 00 00 02 00 00 00 00 00 00 */
 ctr_start(find_cipher("memcpy()"), count, key, 8, 0, &ctr);
 ctr_encrypt(blk, ct, 8, &ctr);               /* expect: FF 00 00 00 00 00 00 00 */
 ctr_encrypt(blk+8, ct+8, 8, &ctr);           /* expect: 00 03 00 00 00 00 00 00 */
 if (memcmp(ct, test, 16)) {
    printf("CTR failed logical testing.\n");
    for (x = 0; x < 16; x++) printf("%02x ", ct[x]);
    printf("\n");
 } else {
    printf("CTR passed logical testing.\n");
 }

}
#else
void ctr_tests(void) { printf("CTR not compiled in\n"); }
#endif

void hash_tests(void)
{
 int x;
 printf("Hash tests\n");
 for (x = 0; hash_descriptor[x].name != NULL; x++) {
     printf(" %10s (%2d) ", hash_descriptor[x].name, hash_descriptor[x].ID);
     if (hash_descriptor[x].test() == CRYPT_ERROR)
        printf("**failed** Reason: %s\n", crypt_error);
     else 
        printf("passed\n");
 }
}

#ifdef MRSA
void pad_test(void)
{
 unsigned char in[100], out[100];
 unsigned long x, y;
  
 /* make a dummy message */
 for (x = 0; x < 16; x++) in[x] = (unsigned char)x;

 /* pad the message so that random filler is placed before and after it */
 y = 100;
 if (rsa_pad(in, 16, out, &y, find_prng("yarrow"), &prng) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* depad the message to get the original content */
 memset(in, 0, sizeof(in));
 x = 100;
 if (rsa_depad(out, y, in, &x) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* check outcome */
 printf("rsa_pad: ");
 if (x != 16) { printf("Failed.  Wrong size.\n"); return; }
 for (x = 0; x < 16; x++) if (in[x] != x) { printf("Failed.  Expected %02lx and got %02x.\n", x, in[x]); return; }
 printf("passed.\n");
}

void rsa_test(void)
{
 unsigned char in[4096], out[4096];
 unsigned long x, y, z;
 int stat;
 rsa_key key;
 clock_t t;

 /* ---- SINGLE ENCRYPT ---- */
 /* encrypt a short 8 byte string */
 if (rsa_make_key(&prng, find_prng("yarrow"), 1024/8, 65537, &key) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }
 for (x = 0; x < 8; x++) in[x] = (unsigned char)(x+1);
 y = sizeof(in);
 if (rsa_exptmod(in, 8, out, &y, PK_PUBLIC, &key) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* decrypt it */
 zeromem(in, sizeof(in));
 x = sizeof(out);
 if (rsa_exptmod(out, y, in, &x, PK_PRIVATE, &key) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }

 /* compare */
 printf("RSA    : ");
 for (x = 0; x < 8; x++) if (in[x] != (x+1)) { printf("Failed.  x==%02lx, in[%ld]==%02x\n", x, x, in[x]); }
 printf("passed.\n");

 /* ---- BLOCK ENCRYPT ---- */
 /* now lets test rsa_encrypt() */
 for (x = 0; x < 8; x++) in[x] = (unsigned char)x;
 x = sizeof(out);
 if (rsa_encrypt(in, 8, out, &x, &prng, find_prng("yarrow"), find_cipher("rijndael"), &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }

 /* test rsa_decrypt() */
 zeromem(in, sizeof(in));
 y = sizeof(in);
 if (rsa_decrypt(out, x, in, &y, &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("rsa_encrypt()/rsa_decrypt(): ");
 for (y = 0; y < 8; y++) if (in[y] != y) { printf("failed.\n"); return; }
 printf("Passed.\n");

 /* ---- SIGNATURES ---- */
 x = sizeof(in);
 if (rsa_sign("hello", 5, in, &x, find_hash("md5"), &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 if (rsa_verify(in, "hello", 5, &stat, &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("RSA Signatures: %s, ", (stat==1)?"pass":"fail");
 if (rsa_verify(in, "abcde", 5, &stat, &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("%s\n", (stat==0)?"pass":"fail");

 /* ---- EXPORT/IMPORT ---- */
 x = sizeof(out);
 if (rsa_export(out, &x, PK_PRIVATE_OPTIMIZED, &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("RSA Export takes %ld bytes\n", x);
 rsa_free(&key);
 if (rsa_import(out, &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("RSA Import: ");
 if (rsa_verify(in, "hello", 5, &stat, &key) == CRYPT_ERROR) { 
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("%s, ", (stat==1)?"pass":"fail");
 if (rsa_verify(in, "abcde", 5, &stat, &key) == CRYPT_ERROR) { 
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("%s\n", (stat==0)?"pass":"fail");
 rsa_free(&key);

 /* test the rsa_encrypt_key functions */
 rsa_make_key(&prng, find_prng("yarrow"), 128, 65537, &key);
 for (x = 0; x < 16; x++) in[x] = x;
 y = sizeof(out);
 if (rsa_encrypt_key(in, 16, out, &y, &prng, find_prng("yarrow"), &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 zeromem(in, sizeof(in));
 x = sizeof(in);
 if (rsa_decrypt_key(out, y, in, &x, &key) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("RSA en/de crypt key routines: ");
 if (x != 16) { printf("Failed (length)\n"); return; }
 for (x = 0; x < 16; x++) if (in[x] != x) { printf("Failed (contents)\n"); return; }
 printf("Passed\n");

 /* make a RSA key */
 for (z = 1024; z <= 1024; z += 512) {
    t = clock();
    if (rsa_make_key(&prng, find_prng("yarrow"), z/8, 65537, &key) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }
    t = clock() - t;
    printf("Took %.0f ms to make a %ld-bit RSA key.\n", 1000.0 * ((double)t / (double)CLOCKS_PER_SEC), z);

    /* time encryption */
    y = sizeof(in);
    t = clock();
    if (rsa_exptmod(in, 8, out, &y, PK_PUBLIC, &key) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }
    t = clock() - t;
    printf("Took %.0f ms to encrypt with a %ld-bit RSA key.\n", 1000.0 * ((double)t / (double)CLOCKS_PER_SEC), z);

    /* time decryption */
    x = sizeof(out);
    t = clock();
    if (rsa_exptmod(out, y, in, &x, PK_PRIVATE, &key) == CRYPT_ERROR) { printf("Error: %s\n", crypt_error); return; }
    t = clock() - t;
    printf("Took %.0f ms to decrypt with a %ld-bit RSA key.\n", 1000.0 * ((double)t / (double)CLOCKS_PER_SEC), z);
    rsa_free(&key);
 }

}
#else
void pad_test(void) { printf("MRSA not compiled in\n"); }
void rsa_test(void) { printf("MRSA not compiled in\n"); }
#endif

#ifdef BASE64
void base64_test(void)
{
   unsigned char buf[2][100];
   unsigned long x, y;

   printf("Base64 tests\n");
   zeromem(buf, sizeof(buf));
   for (x = 0; x < 16; x++) buf[0][x] = (unsigned char)x;

   x = 100;
   if (base64_encode(buf[0], 16, buf[1], &x) == CRYPT_ERROR) {
      printf("  error: %s\n", crypt_error);
      return;
   }
   printf("  encoded 16 bytes to %ld bytes...[%s]\n", x, buf[1]);
   memset(buf[0], 0, 100);
   y = 100;
   if (base64_decode(buf[1], x, buf[0], &y) == CRYPT_ERROR) {
      printf("  error: %s\n", crypt_error);
      return;
   }
   printf("  decoded %ld bytes to %ld bytes\n", x, y);
   for (x = 0; x < 16; x++) if (buf[0][x] != x) { 
      printf(" **failed**\n"); 
      return; 
   }
   printf("  passed\n");
}
#else
void base64_test(void) { printf("Base64 not compiled in\n"); }
#endif

#ifdef GBA
   #define ITERS   100
#else
   #define ITERS   250000
#endif

void time_hash(void)
{
    clock_t t1;
    int x, y;
    unsigned long z;
    unsigned char input[4096], out[MAXBLOCKSIZE];
    printf("Hash Time Trials (4KB blocks):\n");
    for (x = 0; hash_descriptor[x].name != NULL; x++) {
        t1 = clock();
        z = sizeof(out);
        for (y = 0; y < ITERS; y++) {
            hash_memory(x, input, 4096, out, &z);
        }
        t1 = clock() - t1;
#ifdef GBA
        printf("%s:%5.2f\n", hash_descriptor[x].name,
               ((8.0 * 4096.0) * ((double)ITERS / ((double)t1 / (double)CLOCKS_PER_SEC))) / 1000.0);
#else
        printf("%-20s: Hash at %5.2f Mbit/sec\n", hash_descriptor[x].name,
               ((8.0 * 4096.0) * ((double)ITERS / ((double)t1 / (double)CLOCKS_PER_SEC))) / 1000000.0);
#endif
    }
}

#undef  ITERS

#ifdef GBA
   #define ITERS   200
#else
   #define ITERS   5000000
#endif

void time_ecb(void)
{
    clock_t t1, t2;
    int x, y;
    unsigned char pt[32], key[32];
    symmetric_key skey;
    void (*enc)(const unsigned char *, unsigned char *, symmetric_key *);
    void (*dec)(const unsigned char *, unsigned char *, symmetric_key *);

    printf("ECB Time Trials for the Symmetric Ciphers:\n");
    for (x = 0; cipher_descriptor[x].name != NULL; x++) {
        cipher_descriptor[x].setup(key, cipher_descriptor[x].min_key_length, 0, &skey);

        enc = cipher_descriptor[x].ecb_encrypt;
        dec = cipher_descriptor[x].ecb_decrypt;

        t1 = clock();
        for (y = 0; y < ITERS; y++)
            enc(pt, pt, &skey);
        t1 = clock() - t1;
        t2 = clock();
        for (y = 0; y < ITERS; y++)
            dec(pt, pt, &skey);
        t2 = clock() - t2;
#ifdef GBA
        printf("%s:%5.2f/%5.2f\n",
               cipher_descriptor[x].name,
               ((8.0 * (double)cipher_descriptor[x].block_length) * ((double)ITERS / ((double)t1 / (double)CLOCKS_PER_SEC))) / 1000.0,
               ((8.0 * (double)cipher_descriptor[x].block_length) * ((double)ITERS / ((double)t2 / (double)CLOCKS_PER_SEC))) / 1000.0);
#else
        printf("%-20s: Encrypt at %5.2f Mbit/sec and Decrypt at %5.2f Mbit/sec\n",
               cipher_descriptor[x].name,
               ((8.0 * (double)cipher_descriptor[x].block_length) * ((double)ITERS / ((double)t1 / (double)CLOCKS_PER_SEC))) / 1000000.0,
               ((8.0 * (double)cipher_descriptor[x].block_length) * ((double)ITERS / ((double)t2 / (double)CLOCKS_PER_SEC))) / 1000000.0);
#endif
    }
}

#ifdef MDH
void dh_tests(void)
{
   unsigned char buf[3][4096];
   unsigned long x, y, z;
   int low, high, stat, stat2;
   dh_key usera, userb;
   clock_t t1;

//   if (dh_test() == CRYPT_ERROR) printf("DH Error: %s\n", crypt_error);

   dh_sizes(&low, &high);
   printf("DH Keys from %d to %d supported.\n", low*8, high*8);

   /* make up two keys */
   if (dh_make_key(96, &prng, find_prng("yarrow"), &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   if (dh_make_key(96, &prng, find_prng("yarrow"), &userb) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   /* make the shared secret */
   x = 4096;
   if (dh_shared_secret(&usera, &userb, buf[0], &x) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   y = 4096;
   if (dh_shared_secret(&userb, &usera, buf[1], &y) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   if (y != x) { printf("DH Shared keys are not same size.\n"); return; }
   if (memcmp(buf[0], buf[1], x)) { printf("DH Shared keys not same contents.\n"); return; }

   /* now export userb */
   y = 4096;
   if (dh_export(buf[1], &y, PK_PUBLIC, &userb) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   dh_free(&userb);

   /* import and make the shared secret again */
   if (dh_import(buf[1], &userb) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   z = 4096;
   if (dh_shared_secret(&usera, &userb, buf[2], &z) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   printf("DH routines: ");
   if (z != x) { printf("failed.  Size don't match?\n"); return; }
   if (memcmp(buf[0], buf[2], x)) { printf("Failed.  Content didn't match.\n"); return; }
   printf("Passed\n");
   dh_free(&usera);
   dh_free(&userb);

/* time stuff */
   t1 = clock();
   dh_make_key(96, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make dh-768 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   dh_free(&usera);

   t1 = clock();
   dh_make_key(128, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make dh-1024 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   dh_free(&usera);

   t1 = clock();
   dh_make_key(192, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make dh-1536 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   dh_free(&usera);

   t1 = clock();
   dh_make_key(256, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make dh-2048 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   dh_free(&usera);

   t1 = clock();
   dh_make_key(320, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make dh-2560 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   dh_free(&usera);

/* try dh packet stuff */
   for (x = 0; x < 16; x++) buf[0][x] = (unsigned char)x;
   dh_make_key(24, &prng, find_prng("yarrow"), &usera);

   x = 4096;
   if (dh_encrypt(buf[0], 16, buf[1], &x, &prng, find_prng("yarrow"), find_cipher("rijndael"),
                   find_hash("sha1"), &usera) == CRYPT_ERROR) {
      printf("dh_encrypt says %s\n", crypt_error);
      return;
   }
   printf("dh encrypted 16 bytes into %ld bytes!\n", x);

   y = 4096;
   if (dh_decrypt(buf[1], x, buf[2], &y, &usera) == CRYPT_ERROR) {
      printf("dh_decrypt says %s\n", crypt_error);
      return;
   }

   printf("dh packet: ");
   if (16 != y) { printf("Failed: Sizes different! 16 vs %ld\n", y); return; }
   if (memcmp(buf[0], buf[2], 16)) { printf("Failed; Content mismatch.\n"); return; }
   printf("Passed!\n");
   dh_free(&usera);

/* try dh signatures */
   dh_make_key(96, &prng, find_prng("yarrow"), &usera);
   x = 4096;
   if (dh_sign("hello", 5, buf[0], &x, find_hash("sha1"), &prng, find_prng("yarrow"), &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   printf("dh-768 Signature took %ld bytes\n", x);

   if (dh_verify(buf[0], "hello", 5, &stat, &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   if (dh_verify(buf[0], "hellp", 5, &stat2, &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   printf("dh Signatures: %s (%d,%d)\n", ((stat==1)&&(stat2==0))?"passed":"failed", stat,stat2);
   dh_free(&usera);

/* test encrypt_key */
 dh_make_key(96, &prng, find_prng("yarrow"), &usera);
 for (x = 0; x < 16; x++) buf[0][x] = x;
 y = sizeof(buf[1]);
 if (dh_encrypt_key(buf[0], 16, buf[1], &y, &prng, find_prng("yarrow"), find_hash("md5"), &usera) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 zeromem(buf[0], sizeof(buf[0]));
 x = sizeof(buf[0]);
 if (dh_decrypt_key(buf[1], y, buf[0], &x, &usera) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("DH en/de crypt key routines: ");
 if (x != 16) { printf("Failed (length)\n"); return; }
 for (x = 0; x < 16; x++) if (buf[0][x] != x) { printf("Failed (contents)\n"); return; }
 printf("Passed (size %lu)\n", y);

}
#else
void dh_tests(void) { printf("MDH not compiled in\n"); }
#endif

int callback_x = 0;
void callback(void)
{ 
   printf("%c\x08", "-\\|/"[++callback_x & 3]); fflush(stdout);
}

void rng_tests(void)
{
   unsigned char buf[20];
#ifdef YARROW
   prng_state prng;
#endif
   clock_t t1;
   int x, y;

   printf("RNG tests\n");
   t1 = clock();
   x = rng_get_bytes(buf, sizeof(buf), &callback);
   t1 = clock() - t1;
   printf("  %f bytes per second...",
         (double)x / ((double)t1 / (double)CLOCKS_PER_SEC));
   printf("read %d bytes.\n  ", x);
   for (y = 0; y < x; y++)
       printf("%02x ", buf[y]);
   printf("\n");

#ifdef YARROW
   if (rng_make_prng(128, find_prng("yarrow"), &prng, &callback) == CRYPT_ERROR) {
       printf(" starting yarrow error: %s\n", crypt_error);
       return;
   }
#endif
}

#ifdef MECC
void ecc_tests(void)
{
   unsigned char buf[4][4096];
   unsigned long x, y, z;
   int stat, stat2, low, high;
   ecc_key usera, userb;
   clock_t t1;

   if (ecc_test() == CRYPT_ERROR) printf("ecc Error: %s\n", crypt_error);

   ecc_sizes(&low, &high);
   printf("ecc Keys from %d to %d supported.\n", low*8, high*8);

   /* make up two keys */
   if (ecc_make_key(24, &prng, find_prng("yarrow"), &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   if (ecc_make_key(24, &prng, find_prng("yarrow"), &userb) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   /* make the shared secret */
   x = 4096;
   if (ecc_shared_secret(&usera, &userb, buf[0], &x) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   y = 4096;
   if (ecc_shared_secret(&userb, &usera, buf[1], &y) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   if (y != x) { printf("ecc Shared keys are not same size.\n"); return; }

   if (memcmp(buf[0], buf[1], x)) { printf("ecc Shared keys not same contents.\n"); return; }

   /* now export userb */
   y = 4096;
   if (ecc_export(buf[1], &y, PK_PUBLIC, &userb) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   ecc_free(&userb);
   printf("ECC-192 export took %ld bytes\n", y);

   /* import and make the shared secret again */
   if (ecc_import(buf[1], &userb) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   z = 4096;
   if (ecc_shared_secret(&usera, &userb, buf[2], &z) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   printf("ecc routines: ");
   if (z != x) { printf("failed.  Size don't match?\n"); return; }
   if (memcmp(buf[0], buf[2], x)) { printf("Failed.  Content didn't match.\n"); return; }
   printf("Passed\n");
   ecc_free(&usera);
   ecc_free(&userb);

/* time stuff */
   t1 = clock();
   ecc_make_key(24, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make ECC-192 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   ecc_free(&usera);

   t1 = clock();
   ecc_make_key(32, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make ECC-256 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   ecc_free(&usera);

   t1 = clock();
   ecc_make_key(48, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make ECC-384 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   ecc_free(&usera);

   t1 = clock();
   ecc_make_key(65, &prng, find_prng("yarrow"), &usera);
   t1 = clock() - t1;
   printf("Make ECC-521 key took %f msec\n", 1000.0 * ((double)t1 / (double)CLOCKS_PER_SEC));
   ecc_free(&usera);

/* try ECC packet stuff */
   for (x = 0; x < 16; x++) buf[0][x] = (unsigned char)x;
   ecc_make_key(24, &prng, find_prng("yarrow"), &usera);

   x = 4096;
   if (ecc_encrypt(buf[0], 16, buf[1], &x, &prng, find_prng("yarrow"), find_cipher("rijndael"),
                   find_hash("tiger"), &usera) == CRYPT_ERROR) {
      printf("ecc_encrypt says %s\n", crypt_error);
      return;
   }
   printf("Ecc encrypted 16 bytes into %ld bytes!\n", x);

   y = 4096;
   if (ecc_decrypt(buf[1], x, buf[2], &y, &usera) == CRYPT_ERROR) {
      printf("ecc_decrypt says %s\n", crypt_error);
      return;
   }

   printf("ECC packet: ");
   if (16 != y) { printf("Failed: Sizes different! 16 vs %ld\n", y); return; }
   if (memcmp(buf[0], buf[2], 16)) { printf("Failed; Content mismatch.\n"); return; }
   printf("Passed!\n");
   ecc_free(&usera);

/* try ECC signatures */
   ecc_make_key(24, &prng, find_prng("yarrow"), &usera);
   x = 4096;
   if (ecc_sign("hello", 5, buf[0], &x, find_hash("sha1"), &prng, find_prng("yarrow"), &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   printf("ECC-192 Signature took %ld bytes\n", x);

   if (ecc_verify(buf[0], "hello", 5, &stat, &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }
   if (ecc_verify(buf[0], "hellp", 5, &stat2, &usera) == CRYPT_ERROR) {
      printf("Error: %s\n", crypt_error);
      return;
   }

   printf("ECC Signatures: %s (%d,%d)\n", ((stat==1)&&(stat2==0))?"passed":"failed", stat,stat2);
   ecc_free(&usera);

/* test encrypt_key */
 ecc_make_key(24, &prng, find_prng("yarrow"), &usera);
 for (x = 0; x < 16; x++) buf[0][x] = x;
 y = sizeof(buf[1]);
 if (ecc_encrypt_key(buf[0], 16, buf[1], &y, &prng, find_prng("yarrow"), find_hash("md5"), &usera) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 zeromem(buf[0], sizeof(buf[0]));
 x = sizeof(buf[0]);
 if (ecc_decrypt_key(buf[1], y, buf[0], &x, &usera) == CRYPT_ERROR) {
    printf("Error: %s\n", crypt_error);
    return;
 }
 printf("ECC en/de crypt key routines: ");
 if (x != 16) { printf("Failed (length)\n"); return; }
 for (x = 0; x < 16; x++) if (buf[0][x] != x) { printf("Failed (contents)\n"); return; }
 printf("Passed (size: %lu)\n", y);
}
#else
void ecc_tests(void) { printf("MECC not compiled in\n"); }
#endif

#ifdef GF
void gf_tests(void)
{
   gf_int a, b, c, d;
   int n;
   unsigned char buf[1024];

   printf("GF tests\n");
   gf_zero(a);gf_zero(b);gf_zero(c);gf_zero(d);

   /* a == 0x18000000b */
   a[1] = 1;
   a[0] = 0x8000000bUL;

   /* b == 0x012345678 */
   b[0] = 0x012345678UL;

   /* find 1/b mod a */
   gf_invmod(b,a,c);

   /* find 1/1/b mod a */
   gf_invmod(c,a,d);

   /* display them */
   printf("  %08lx %08lx\n", c[0], d[0]);

   /* store as binary string */
   n = gf_size(a);
   printf("  a takes %d bytes\n", n);
   gf_toraw(a, buf);
   gf_readraw(a, buf, n);
   printf("  a == %08lx%08lx\n", a[1], a[0]);

   /* primality testing */
   gf_zero(a);
   a[0] = 0x169;
   printf("  GF prime: %s, ", gf_is_prime(a)?"passed":"failed");
   a[0] = 0x168;
   printf("  %s\n", gf_is_prime(a)?"failed":"passed");

   /* test sqrt code */
   gf_zero(a);
   a[1] = 0x00000001;
   a[0] = 0x8000000bUL;
   gf_zero(b);
   b[0] = 0x12345678UL;

   gf_sqrt(b, a, c);
   gf_mulmod(c, c, a, b);
   printf("  (%08lx)^2 = %08lx (mod %08lx%08lx) \n", c[0], b[0], a[1], a[0]);
}
#else
void gf_tests(void) { printf("GF not compiled in\n"); }
#endif

#ifdef GZIP
void test_zlib(void)
{
   unsigned char buf[2][1024];
   unsigned long x, y;

   printf("ZLIB tests\n");
   /* clear buf */
   zeromem(buf, sizeof(buf));

   /* compress first 512 bytes of buf[0] */
   x = sizeof(buf[1]); 
   if (pack_buffer(buf[0], 512, buf[1], &x) == CRYPT_ERROR) {
      printf("Failed!");
      return;
   }
   printf("  compressed 512 bytes to %lu bytes\n", x);

   /* decompress */
   y = sizeof(buf[0]);
   if (unpack_buffer(buf[1], x, buf[0], &y) == CRYPT_ERROR) {
      printf("Failed!");
      return ;
   }
   printf("  decompressed to %lu bytes\n", y);
}
#else
void test_zlib(void) { printf("ZLIB not compiled in\n"); }
#endif

#ifdef MPI
void test_prime(void)
{
   unsigned char buf[1024];
   mp_int a;
   int x;
  
   /* make a 1024 bit prime */
   mp_init(&a);
   rand_prime(&a, 128, &prng, find_prng("yarrow"));

   /* dump it */
   mp_todecimal(&a, buf);
   printf("1024-bit prime:\n");
   for (x = 0; x < (int)strlen(buf); ) {
       printf("%c", buf[x]);
       if (!(++x % 60)) printf("\\ \n");
   }
   printf("\n\n");

   mp_clear(&a);
}
#else
void test_prime(void) { printf("MPI not compiled in\n"); }
#endif

void register_all_algs(void)
{
   register_cipher(&blowfish_desc);
   register_cipher(&xtea_desc);
   register_cipher(&rc5_desc);
   register_cipher(&rc6_desc);
   register_cipher(&saferp_desc);
   register_cipher(&serpent_desc);
   register_cipher(&rijndael_desc);
   register_cipher(&twofish_desc);
   register_cipher(&safer_k64_desc);
   register_cipher(&safer_sk64_desc);
   register_cipher(&safer_k128_desc);
   register_cipher(&safer_sk128_desc);
   register_cipher(&rc2_desc);
   register_cipher(&des_desc);
   register_cipher(&des3_desc);
   register_cipher(&null_desc);

   register_hash(&sha256_desc);
   register_hash(&tiger_desc);
   register_hash(&sha1_desc);
   register_hash(&md5_desc);
   register_hash(&sha384_desc);
   register_hash(&sha512_desc);
   register_hash(&md4_desc);

   register_prng(&yarrow_desc);
   register_prng(&sprng_desc);
}

#ifdef GBA
int cc_main(void)
#else
int main(void)
#endif
{
#ifdef GBA
 install_common();
 modetxt_init();
#endif

 register_all_algs();

 printf(crypt_build_settings);

 yarrow_start(&prng);
 yarrow_add_entropy("hello", 5, &prng);
 yarrow_ready(&prng);


#ifdef HMAC
  printf("HMAC: %s\n", hmac_test() == CRYPT_OK ? "passed" : "failed");
#endif

 store_tests();
 cipher_tests();
 hash_tests();

 ecb_tests();
 cbc_tests();
 ctr_tests();
 ofb_tests();
 cfb_tests();

#ifndef GBA
 rng_tests();
 test_prime();
#endif
 rsa_test();
 pad_test();
 ecc_tests();
 dh_tests();

 gf_tests();
 base64_test();
 test_zlib();

 time_ecb();
 time_hash();

#ifdef GBA
 for (;;);
#endif

 return 0;
}
