/*
**  CWPOP3CacheManager.m
**
**  Copyright (c) 2001-2005
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/CWPOP3CacheManager.h>

#include <Pantomime/CWConstants.h>
#include <Pantomime/CWPOP3CacheObject.h>

#include <Foundation/NSArchiver.h>
#include <Foundation/NSException.h>


//
//
//
@implementation CWPOP3CacheManager

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: _cache];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super initWithPath: nil];

  [self setCache: [theCoder decodeObject]];

  return self;
}


//
//
//
- (CWPOP3CacheObject *) cacheObjectWithUID: (NSString *) theUID
{
  CWPOP3CacheObject *aCacheObject;
  int i, count;

  count = [_cache count];

  for (i = 0; i < count; i++)
    {
      aCacheObject = [_cache objectAtIndex: i];
      
      if ([[aCacheObject UID] isEqualToString: theUID])
	{
	  return aCacheObject;
	}
    }
  
  return nil;
}



//
// class methods
//
+ (id) cacheWithPath: (NSString *) thePath;
{
  id o;

  o = [super cacheWithPath: thePath];

  if (!o)
    {
      o = AUTORELEASE([[CWPOP3CacheManager alloc] initWithPath: thePath]);
    }

  return o;
}

@end
