#ifndef INCLUDE_COLOUREDLABEL_H
#define INCLUDE_COLOUREDLABEL_H

#include "Connection.h"

class ColouredLabel {

 public:
  ColouredLabel(Connection *);
  ColouredLabel(Connection *, char *);
  ~ColouredLabel();

  void createWidget();
  void setText(char *);
  GtkWidget * getWidget();

  void redraw();

 private:

  void init();
  void printPrompt(char *, char *);
  void printPrompt(char *, int);
  char * parseVTCode(char *);
  char * parseBracketVTCode(char *);
  char * parsePlainVTCode(char *);
  void setPapayaColour(char *);
  void resetPapayaColour();
  void setColour(char *);
  void setActualColour(char *);

  char * widget_text;
  GtkWidget * widget;
  Connection * conn;

  int prompt_index;
  bool papaya_colour;
  bool span;

  GdkColor color;
  GdkColor background_color;
  GdkColormap * color_map;

  bool background_color_default, foreground_color_default, flashing;
  int fg, bg;
  bool bold;
  bool redrawn;

  int x_offset;

  char plain_text[16384];

  int old_width, old_height;

#ifdef USE_GTK_2
  PangoLayout * layout;
#endif

};

#endif // INCLUDE_COLOUREDLABEL_H
