#ifndef INCLUDE_PREFERENCE_HANDLER_H
#define INCLUDE_PREFERENCE_HANDLER_H

#include <glade/glade.h>

#include <list>
#include <algorithm>

#include "papaya/Preference.h"
#include "Prefs.h"
#include "MUD.h"

struct prefs_interface_data {
  Category category;
  char * tab_name; // The name of the tab this belongs to
  char * child_frame; // NULL if not a child pane
};

class PreferenceHandler {

public:

  PreferenceHandler();
  ~PreferenceHandler();

  void addPreferenceEditor(Preference *);
  void removePreferenceEditor(Preference *);

  void createWindow(MUD *);
  void destroyWindow();
  void apply();
private:

  void removeDisplayWidgets(Preference *);
  void addDisplayWidgets(Preference *);
  GtkWidget * getNotebookPage(Category *, bool);
  struct prefs_interface_data * findPrefsInterfaceData(Category);
  GtkWidget * findNotebookPageByName(char * name, bool);

  typedef std::list<Preference *> PreferenceEditorList;
  std::list<Preference *> editors;

  GladeXML * xml;
  MUD * mud;
};

#endif // INCLUDE_PREFERENCE_HANDLER_H
