#ifndef INCLUDE_PREFS_H
#define INCLUDE_PREFS_H

#include <stdio.h>

class SystemColour;
class MUD;

struct pref_data {
  char * name;
  char * data;
  struct pref_data * next;
};

class Prefs {

 public:
  Prefs(MUD *);
  ~Prefs();

  void setPreference(char * key, char * value);
  void setPreferenceInteger(char * key, int value);
  void setPreferenceLong(char * key, unsigned long value);
  void setPreferenceBoolean(char * key, bool value);
  char * getPreference(char * key);
  int getPreferenceInteger(char * key);
  unsigned long getPreferenceLong(char * key);
  bool getPreferenceBoolean(char * key);
  
  bool save(MUD *);
  bool save(char *);
 private:
  void initialiseDefaults();
  struct pref_data * findPreference(char * key);
  void savePrefs(FILE *);
  bool parseLine(FILE *);
  bool load(MUD *);

  struct pref_data * pref_list;

};


#endif // INCLUDE_PREFS_H
