#ifndef INCLUDE_VT_H
#define INCLUDE_VT_H

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

typedef enum {
  VTLineMode,
  VTCharacterMode
} VTMode;

#define ENTER 65293
#define KP_ENTER 65421
#define UP_ARROW 65362
#define DOWN_ARROW 65364
#define P 112
#define N 110

gint on_window_keypress (GtkWidget * widget, GdkEventKey * event);

class Connection;
class VT {
  
 public:

  VT(Connection *);
  virtual ~VT();

  virtual void append(char *);
  virtual void scroll(); // public since we might want to ask to scroll only 
                         // when no more data arriving.
  virtual void preInsert();

  virtual GtkWidget * getOutput();
  virtual GtkWidget * getInput(); // Used at least by tab history completion
  virtual void setInput(char *); // So that callbacks can clear the input area.
  virtual void focus(); // Tells the VT to set the focus on its input widget.
  virtual void use(); // Tells the VT to do stuff like sets its background.

  virtual void prefsUpdated(); // Informs the VT of a preferences update

  GtkWidget * getMainWindow();

  virtual void setMode(VTMode);
  VTMode getMode();

  void addToTray(GtkWidget *, GtkWidget **);
  void removeFromTray(GtkWidget *, GtkWidget *);
  void removeFromTray(GtkWidget *);

  virtual void hideCommands(); // Called by line mode connections to asterisk the input
  virtual void showCommands(); // typically used by MUDs requesting a password.
  virtual bool showingCommands();

  virtual int width();
  virtual int height();

  void sizeChanged();

  virtual void scrollUp();
  virtual void scrollDown();

  virtual void keypressEvent(GtkWidget *, GdkEventKey *);

  virtual struct colour_table * getColourTable();
  virtual void initialise();

 protected:
  GtkWidget * box;

  // The connection we are the GUI for.
  Connection * conn;

 private:

  // Is this VT in line or character mode.
  VTMode mode;
  GtkWidget * tray;
  GtkWidget * hbox1;

};

#endif // INCLUDE_VT_H
