#include "ProxyPreference.h"
#include "mudclient.h"

#include <gmodule.h>

extern PreferenceHandler * preferenceHandler;
static ProxyPreference * proxyPreference;

ProxyPreference::ProxyPreference() {
  proxyPreference = this;
  xml = NULL;

  // Initialise the list of available preferences.
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ProxySocks", "socks_radio", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ProxyTurfHTTPd", "turf_radio", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ProxyConnect", "connect_radio", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ProxySocks4", "socks_four_radio", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HTTPProxy", "http_proxy_checkbutton", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HttpProxyHost", "webcache_host_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HttpProxyPort", "webcache_port_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SocksHost", "socks_host_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SocksPort", "socks_port_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SocksUser", "socks_username_entry", WidgetEntry));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("SocksPass", "socks_password_entry", WidgetEntry));

}

ProxyPreference::~ProxyPreference() {
  if (xml)
    g_object_unref(xml);
  proxyPreference = NULL;
}

GtkWidget * ProxyPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/proxypreferences.glade", getPrefix());

  // Cache the xml object between calls.
  if (!xml) {
    xml = glade_xml_new(buf, "vbox", NULL);
    glade_xml_signal_autoconnect(xml);
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    gtk_widget_show(vbox);
    return vbox;
  }

  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  return vbox;
}

void ProxyPreference::destroyWidget() {
  g_object_unref(xml);
  xml = NULL;
}


Category * ProxyPreference::getCategories() {
  return (Category *)proxy_categories;
}

extern "C" G_MODULE_EXPORT gint on_http_proxy_checkbutton_toggled(GtkWidget * widget, gpointer data) {
  proxyPreference->setHttpProxyWidgetState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_direct_radio_toggled(GtkWidget * widget, gpointer data) {
  proxyPreference->setSocksWidgetState(false);
  proxyPreference->setHttpProxyChooserState(false);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_socks_radio_toggled(GtkWidget * widget, gpointer data) {
  proxyPreference->setSocksWidgetState(true);
  proxyPreference->setHttpProxyChooserState(false);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_turf_radio_toggled(GtkWidget * widget, gpointer data) {
  proxyPreference->setSocksWidgetState(false);
  proxyPreference->setSocksFiveWidgetState(false);

  proxyPreference->setHttpProxyChooserState(true);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_connect_radio_toggled(GtkWidget * widget, gpointer data) {
  proxyPreference->setSocksWidgetState(false);
  proxyPreference->setHttpProxyChooserState(true);
  proxyPreference->setHttpProxyChooserEnabled(true);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_socks_five_radio_toggled(GtkWidget * widget, gpointer data) {
  proxyPreference->setSocksFiveWidgetState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  return 1;
}


void ProxyPreference::setSocksWidgetState(bool enable) {
  GtkWidget * label = glade_xml_get_widget(xml, "socks_five_radio");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_four_radio");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_host_label");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_port_label");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_host_entry");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_port_entry");
  gtk_widget_set_sensitive(label, enable);

  if (!enable) {
    setSocksFiveWidgetState(false);
    return;
  }

  GtkWidget * socks_five_toggle_button = glade_xml_get_widget(xml, "socks_five_radio");
  setSocksFiveWidgetState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(socks_five_toggle_button)));

}

void ProxyPreference::setSocksFiveWidgetState(bool enable) {
  GtkWidget *label = glade_xml_get_widget(xml, "socks_username_entry");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_password_entry");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_password_label");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "socks_username_label");
  gtk_widget_set_sensitive(label, enable);
}

void ProxyPreference::setHttpProxyWidgetState(bool enable) {
  GtkWidget * label = glade_xml_get_widget(xml, "proxy_host_label");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "proxy_port_label");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "webcache_host_entry");
  gtk_widget_set_sensitive(label, enable);
  label = glade_xml_get_widget(xml, "webcache_port_entry");
  gtk_widget_set_sensitive(label, enable);
}

void ProxyPreference::setHttpProxyChooserState(bool enable) {
  GtkWidget * http_proxy_checkbutton = glade_xml_get_widget(xml, "http_proxy_checkbutton");

  gtk_widget_set_sensitive(http_proxy_checkbutton, enable);

  if (enable) {
    GtkWidget * http_proxy_checkbutton = glade_xml_get_widget(xml, "http_proxy_checkbutton");
    setHttpProxyWidgetState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(http_proxy_checkbutton)));
    return;
  }

  setHttpProxyWidgetState(false);
}

void ProxyPreference::setHttpProxyChooserEnabled(bool enable) {
  GtkWidget * http_proxy_checkbutton = glade_xml_get_widget(xml, "http_proxy_checkbutton");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(http_proxy_checkbutton), enable);
}
