#include <string.h>
#include "papaya/system.h"
#include "Connection.h"
#include "SquidSocket.h"

SquidSocket::SquidSocket(Connection * c) : Socket(c) {
  dest_host = NULL;
  dest_port = 0;
}

SquidSocket::~SquidSocket() {
  free(dest_host);
}

int SquidSocket::create(char * host, int port) {

  if(dest_host)
    free(dest_host);
  dest_host = strdup(host);

  dest_port = port;

  if (!conn->queryPreferences()->getPreference("HttpProxyHost"))
    return -1;

  if (!conn->queryPreferences()->getPreference("HttpProxyPort"))
    return -1;


  int res = Socket::create(conn->queryPreferences()->getPreference("HttpProxyHost"),
			   conn->queryPreferences()->getPreferenceInteger("HttpProxyPort"));

  return res;
}

int SquidSocket::connected() {

  // Check this before asking the Socket class to see as otherwise we'll
  // send the CONNECT request all the time.
  if (is_connected)
    return 1;

  int res = Socket::connected();
  if (res == 1) {
    char buf[1024];

    snprintf(buf, 1024, "CONNECT %s:%d HTTP/1.0\nHost = %s:%d\n\n",
	     dest_host, dest_port, dest_host, dest_port);

    write(buf);
  }

  return res;
}
