#include <gdk/gdk.h>
#include <string.h>
#include "SystemColour.h"

#ifdef WIN32
#include <memory.h>
#else
#include <unistd.h>
#endif

#include "Prefs.h"
#include "mudclient.h"

// This class MUST be instantiated AFTER preferences

// This is the default colour table used by SystemColour class

struct colour_table ctable[] = {
  { color_black, 0, 0, 0, "black" },
  { color_red, 0xcccc, 0x0000, 0x0000, "red" },
  { color_green, 0, 0xcccc, 0, "green" },
  { color_yellow, 0xcccc, 0xcccc, 0x0000, "yellow" },
  { color_blue, 0, 0, 0xcccc, "blue" },
  { color_magenta, 0xcccc, 0, 0xcccc, "magenta" },
  { color_cyan, 0, 0xcccc, 0xcccc, "cyan" },
  { color_white, 0xcccc, 0xcccc, 0xcccc, "white" },

  { color_bold_black, 0, 0, 0, "bold black" },
  { color_bold_red, 0xffff, 0x0000, 0x0000, "bold red" },
  { color_bold_green, 0, 0xffff, 0, "bold green" },
  { color_bold_yellow, 0xffff, 0xffff, 0x0000, "bold yellow" },
  { color_bold_blue, 0, 0, 0xffff, "bold blue" },
  { color_bold_magenta, 0xffff, 0, 0xffff, "bold magenta" },
  { color_bold_cyan, 0, 0xffff, 0xffff, "bold cyan" },
  { color_bold_white, 0xffff, 0xffff, 0xffff, "bold white" },
  { 0, 0, 0, 0, "" }
};

SystemColour::SystemColour(Prefs * prefs) {
  memcpy(&table, &ctable, sizeof(colour_table) * 17);

  // Retrieve default values from the preferences.
  update(prefs);
}

SystemColour::~SystemColour() {

}

struct colour_table * SystemColour::getColourTable() {
  return table;
}

void StringToRGB(char *, gushort *, gushort *, gushort *);

void SystemColour::update(Prefs * prefs) {

  // Normal colours
  StringToRGB(prefs->getPreference("Black_RGB"),
	      &(table[0].red), &(table[0].green), &(table[0].blue));
  StringToRGB(prefs->getPreference("Red_RGB"),
	      &(table[1].red), &(table[1].green), &(table[1].blue));
  StringToRGB(prefs->getPreference("Green_RGB"),
	      &(table[2].red), &(table[2].green), &(table[2].blue));
  StringToRGB(prefs->getPreference("Yellow_RGB"),
	      &(table[3].red), &(table[3].green), &(table[3].blue));
  StringToRGB(prefs->getPreference("Blue_RGB"),
	      &(table[4].red), &(table[4].green), &(table[4].blue));
  StringToRGB(prefs->getPreference("Magenta_RGB"),
	      &(table[5].red), &(table[5].green), &(table[5].blue));
  StringToRGB(prefs->getPreference("Cyan_RGB"),
	      &(table[6].red), &(table[6].green), &(table[6].blue));
  StringToRGB(prefs->getPreference("White_RGB"),
	      &(table[7].red), &(table[7].green), &(table[7].blue));

  // Bold Colours
  StringToRGB(prefs->getPreference("Black_Bold_RGB"),
	      &(table[8].red), &(table[8].green), &(table[8].blue));
  StringToRGB(prefs->getPreference("Red_Bold_RGB"),
	      &(table[9].red), &(table[9].green), &(table[9].blue));
  StringToRGB(prefs->getPreference("Green_Bold_RGB"),
	      &(table[10].red), &(table[10].green), &(table[10].blue));
  StringToRGB(prefs->getPreference("Yellow_Bold_RGB"),
	      &(table[11].red), &(table[11].green), &(table[11].blue));
  StringToRGB(prefs->getPreference("Blue_Bold_RGB"),
	      &(table[12].red), &(table[12].green), &(table[12].blue));
  StringToRGB(prefs->getPreference("Magenta_Bold_RGB"),
	      &(table[13].red), &(table[13].green), &(table[13].blue));
  StringToRGB(prefs->getPreference("Cyan_Bold_RGB"),
	      &(table[14].red), &(table[14].green), &(table[14].blue));
  StringToRGB(prefs->getPreference("White_Bold_RGB"),
	      &(table[15].red), &(table[15].green), &(table[15].blue));


}
