/**
 * Biff checks for new mail, and notifies you if you have some.
 *
 * Biff uses code taken from util.c in tinyfugue to determine if the user
 * has new mail.  (http://www.tcp.com/~hawkeye/tf)
 *
 * The rest of Biff was written by Catherine Allen (mango@turf.org).
 *
 * Biff is released under the terms of the GNU Public License (GPL) details
 * of which can be found in the file COPYING.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include "Win32PluginAPI.cpp"
#include "Biff.h"

static Biff * biff;

#define MAJOR "1"
#define MINOR "0"

extern "C" void plugin_init(void) {
  biff = new Biff();
}

extern "C" void plugin_cleanup(void) {
  delete biff;
}

extern "C" char * plugin_query_name() {
  return "Biff";
}

extern "C" char * plugin_query_description() {
  static char buf[1024];
  snprintf(buf, 1024, _("Biff periodically checks %s/%s for new mail and prints a message when you have new mail."),
	   BIFF_MAIL_PREFIX,
	   getenv("USER"));

  return buf;
}

extern "C" char * plugin_query_major() {
  return MAJOR;
}

extern "C" char * plugin_query_minor() {
  return MINOR;
}

int biff_timeout(gpointer data) {
  Biff * b = (Biff *)data;

  // Do we have new email?
  b->checkMail();
  return 1;
}

Biff::Biff() {
  version = 1.0;
  name = strdup("Biff");

  // This MUST be done after all variable initialisation as it can cause
  // onEvent(Event *, Connection *) to be called.

  register_plugin(this, VERSION);
  timeout = gtk_timeout_add(60000, biff_timeout, this);

  mail = (struct mail_info *)NULL;
  checkMail();
}

Biff::~Biff() {
  free(name);

  gtk_timeout_remove(timeout);
  free(mail);

  unregister_plugin(this);
}

void Biff::checkMail() {

  struct stat stat_buf;
  char fname[1024];
  
  if (!mail) {
    mail = (struct mail_info *)malloc(sizeof(struct mail_info));
    mail->size = -1;
    mail->mtime = 0;
    mail->flag = 1;
  }

  snprintf(fname, 1024, "%s/%s", BIFF_MAIL_PREFIX, getenv("USER"));
  if (stat(fname, &stat_buf) == -1) {
    mail->mtime = 0;
    mail->size = -2;
    mail->flag = 0;
    //    printf(_("Unable to find mailbox %s/%s, will not check for mail."), BIFF_MAIL_PREFIX, getenv("USER"));
    return;
  }
  
  time_t atime = stat_buf.st_atime;
  time_t mtime = stat_buf.st_mtime;

  if (stat_buf.st_size == 0) {
    mail->flag = 0;
  } else {
    if (mail->size == -2) {
      mail->flag = 0;
    } else {
      if (mtime > atime) {
	mail->flag = 1;
	if (mtime > mail->mtime) {
	  char mail_msg[1024];
	  
	  snprintf(mail_msg, 1024, _("%% You have new mail in %s/%s.\n"), BIFF_MAIL_PREFIX, getenv("USER"));
	  
	  if (main_window_get_current_connection(get_main_window())) {
	    vt_append(connection_get_vt(main_window_get_current_connection(get_main_window())), mail_msg);
	    vt_scroll(connection_get_vt(main_window_get_current_connection(get_main_window())));
	  }
//	  else
//	    new Message("Information", mail_msg, NULL);
	  
	}
      } else {
	if (mail->size < 0 && mtime == atime) {
	  mail->flag = 1;
	  char mail_msg[1024];
	  
	  snprintf(mail_msg, 1024, _("%% You have new mail in %s/%s.\n"), BIFF_MAIL_PREFIX, getenv("USER"));
	  
	  if (main_window_get_current_connection(get_main_window())) {
	    vt_append(connection_get_vt(main_window_get_current_connection(get_main_window())), mail_msg);
	    vt_scroll(connection_get_vt(main_window_get_current_connection(get_main_window())));
	  }
//	  else
//	    new Message("Information", mail_msg, NULL);
	} else {
	  if (mtime > mail->mtime || mtime < atime) {
	    mail->flag = 0;
	  }
	}
      }
    }
  }

  mail->mtime = mtime;
  mail->size = stat_buf.st_size;
}
