#include <gtk/gtk.h>
#include "papaya/Plugin.h"

#include <list>
#include <algorithm>

class Fade;

struct fraction_data {
  gboolean hl_complete;
  Fade * fade;
  GtkWidget * hl_c_check;
  Connection * connection;
};

class G_MODULE_EXPORT Fraction : public Plugin {

 public:

  Fraction();
  ~Fraction();

  void output(Connection *, char *);
  GtkWidget * getPrefsWidget(MUD *);
  void onPrefsOk(MUD *);
  void onPrefsApply(MUD *);
  void onPrefsCancel(MUD *);
  void onEvent(Event *, Connection *);



 private:

  char * pattern;
  regex_t regexp;
  struct fraction_data prefs_scratch;

  struct fraction_data * setupConnection(Connection *);
  void resetConnection(MUD * m, struct fraction_data * fdata);

  struct fraction_data * find_data(Connection *);
  void add_data(struct fraction_data *);
  void remove_data(struct fraction_data *);

  typedef std::list<struct fraction_data *> FractionDataList;
  std::list<struct fraction_data *> fractionList;


};
