#include "Mapper.h"

struct directions direction_table[] = {
  { 0, "north", "n", 0, -1, 0 },
  { 1, "east", "e", 1, 0, 0 },
  { 2, "south", "s", 0, 1, 0 },
  { 3, "west", "w", -1, 0, 0 },
  { 4, "up", "u", 0, 0, 1 },
  { 5, "down", "d", 0, 0, -1 },
  { 6, "northeast", "ne", 1, -1, 0 },
  { 7, "southeast", "se", 1, 1, 0 },
  { 8, "southwest", "sw", -1, 1, 0 },
  { 9, "northwest", "nw", -1, -1, 0 },
  { -1, NULL, NULL, 0, 0, 0 }
};

Mapper::Mapper() {
  areaList = new PapayaList();
  
  area = new Area();
  areaList->newEntry((void *)area);
}

Mapper::~Mapper() {
  for (PapayaListElement * tmp = areaList->firstElement; tmp; tmp = tmp->getNext()) {
    delete (Area *)tmp->getData();
    tmp->setData(NULL);
  }

  delete areaList;
}

void Mapper::newRoom(struct mapper_data * data) {
  if (!area) {
    printf("Cannot create new room - no current area.\n");
    return;
  }

  area->newRoom(data);
}

void Mapper::save() {

  for (PapayaListElement * tmp = areaList->firstElement; tmp; tmp = tmp->getNext()) {
    Area * a = (Area *)tmp->getData();
    a->exportArea();
  }

}
