#ifndef INCLUDE_PROMPT_PLUGIN_H
#define INCLUDE_PROMPT_PLUGIN_H

#define MAX_BARS 8

#include "papaya/Plugin.h"

#include <list>
#include <algorithm>

class Fade;

struct vtPrompt {

  int curr[MAX_BARS];
  int max[MAX_BARS];
  int bars;
  GtkWidget * widget;
  GtkWidget * frame;
  GtkWidget * event_box;
  Fade * fade;
  GtkTooltips * tooltips;
  Connection * connection;
};

class PromptPlugin : public Plugin {

 public:

  PromptPlugin();
  ~PromptPlugin();

  void prompt(Connection *, char *);
  void onEvent(Event *, Connection *);

#if 0
  GtkWidget * getPrefsWidget(MUD *);
  void onPrefsOk(MUD *);
  void onPrefsApply(MUD *);
  void onPrefsCancel(MUD *);
#endif

 private:
  vtPrompt prefs_scratch;

  char * findBar(char *, int *, int *);
  int convert(char *);
  int calculate(char *);
  struct vtPrompt * findPrompt(Connection *);
  struct vtPrompt * newPrompt(Connection *);
  void loadColours(struct vtPrompt *, MUD *);

  struct vtPrompt * find_data(Connection *);
  void add_data(struct vtPrompt *);
  void remove_data(struct vtPrompt *);

  typedef std::list<struct vtPrompt *> PromptDataList;
  std::list<struct vtPrompt *> promptList;

};

#endif




