##
# Simple Python plugin for Papaya to convert output from the MUD to sane
# text, and optionally to convert user input to sane text.
# By default user input is NOT converted as it doesn't distinguish between
# commands such as 'r' for 'rest' and words.  (Some MUDs assume all input
# is speech unless prefixed by / or similar character.)
#
# Plugin released into the public domain April 24th 2003.  Original author
# Catherine Allen (mango@turf.org).
##

import papaya
import re

wordfetch = re.compile("\w+")

def abbrev_output(output):
    return wordfetch.sub(fix_abbrevs, output)

def abbrev_input(output):
    return wordfetch.sub(fix_abbrevs, output)

def fix_abbrevs(match):
    word = match.group(0)
    if word == "r":
        return "are"
    if word == "u":
        return "you"
    if word == "ur":
        return "your"
    if word == "l8r":
        return "later"
    if word == "2":
        return "to"
    if word ==  "h8s":
        return "hates"
    return word
    
papaya.output_add("abbrev_output")
## Uncomment to get input de-abbreviated
#papaya.input_add("abbrev_input")
