#define MAX_SPELLS 100
#define SPELL_DEFAULT_FILE "spells.dat"

#include "papaya/Preference.h"
#include "papaya/Plugin.h"

#include <list>
#include <algorithm>

class Connection;

class SpellsPreference : public Preference {
 public:
  SpellsPreference();
  ~SpellsPreference();

  GtkWidget * getWidget();
  void destroyWidget();

  Category * getCategories();

  void loadPreferences(Prefs *);
  void applyPreferences(Prefs *);
};

const Category spells_categories[] = {
  CategoryPlugins,
  CategoryLast
};

struct spell_data {
  int seen[MAX_SPELLS];
  char * spell[MAX_SPELLS];
  Connection * connection;
};

class G_MODULE_EXPORT Spells : public Plugin {

 public:

  Spells();
  ~Spells();

  void input(Connection *, char *);
  void getSpellData(FILE *, struct spell_data *);
  void getSpellData(char *, struct spell_data *);

  struct spell_data * find_entry(Connection *);

 private:

  struct spell_data * create_new_entry(Connection *);

  typedef std::list<struct spell_data *> SpellDataList;
  std::list<struct spell_data *> spellData;

  SpellsPreference * spellsPreference;

};

