#!/usr/bin/perl

# Create an associative array of source and destination for the files
# that need to be installed, including whole directories

# $SRC_PREFIX is prepended to all source files.
# $DST_PREFIX is prepended to all destination files.

$SRC_PREFIX = '/home/allenc/papaya';
$DST_PREFIX = '/home/allenc/papaya-mine';

%base_files = ( 
	       'po/es.UTF-8.gmo' , 'locale/es/LC_MESSAGES/papaya.mo',
	       'share/papaya-logo-newbie-mine.xpm' , 'papaya-logo-newbie.xpm',
	       'share/splash-mine.xpm' , 'splash.xpm',
	       'share/mcw.dat-mine' , 'mcw.dat',
	       'share/gtkrc' , 'gtkrc',
	       'share/papayarc-mine' , 'papayarc',
	       'share/papayarc-mine-2', 'prefs/mine',
	       'share/plugins.conf', 'plugins.conf'
	      );

%binary_files = (
		 'win32/Release/papaya.exe' , 'papaya.exe',
		 'win32/BSX/Release/BSX.dll' , 'plugins/',
		 'win32/Clock/Release/Clock.dll' , 'plugins/',
		 'win32/ConnectionTimer/Release/ConnectionTimer.dll' , 'plugins/',
		 'win32/Fraction/Release/Fraction.dll' , 'plugins/',
		 'win32/Friends/Release/Friends.dll' , 'plugins/',
		 'win32/GrepFilter/Release/GrepFilter.dll' , 'plugins/',
		 'win32/LagIndicator/Release/LagIndicator.dll' , 'plugins/',
		 'win32/MudLog/Release/MudLog.dll' , 'plugins/',
		 'win32/Multi/Release/Multi.dll' , 'plugins/',
		 'win32/PromptPlugin/Release/PromptPlugin.dll' , 'plugins/',
		 'win32/Python/Release/Python.dll' , 'plugins/',
		 'win32/Speedwalk/Release/Speedwalk.dll' , 'plugins/',
		 'win32/SpellStacker/Release/SpellStacker.dll' , 'plugins/',
		 'win32/Spells/Release/Spells.dll' , 'plugins/',
		 'win32/TurfProtocol/Release/TurfProtocol.dll' , 'plugins/',
		 'win32/required_files/*' , ''
		);

%doc_files = (
	      'doc/manual/manual.pdf' , 'doc/manual.pdf'
	     );

%extra_files = (
		'share/mudlist.txt' , 'mudlist.txt'
	       );

@doc_make = ( "cd $SRC_PREFIX/doc/manual && pdflatex manual.tex" );
@po_make = ( "cd $SRC_PREFIX/po && make" );

foreach $doc (@doc_make) {
#  system("$doc");
}

foreach $po (@po_make) {
#  system("$po");
}

system("rm -rf $DST_PREFIX");
mkdir($DST_PREFIX);

foreach $key (keys %base_files) {
  $src = "$SRC_PREFIX/$key";
  $dst = "$DST_PREFIX/$base_files{$key}";

  # If $dst has a / in it, attempt to make the directory up to the last /
  $index = rindex($dst, '/');
  if ($index != -1) {
    $directory = substr($dst, 0, $index);
    system ("mkdir -p $directory");
  }
  
  system("cp -a $src $dst");
}

foreach $key (keys %binary_files) {
  $src = "$SRC_PREFIX/$key";
  $dst = "$DST_PREFIX/$binary_files{$key}";

  # If $dst has a / in it, attempt to make the directory up to the last /
  $index = rindex($dst, '/');
  if ($index != -1) {
    $directory = substr($dst, 0, $index);
    system ("mkdir -p $directory");
  }
  
  system("cp -a $src $dst");
}

foreach $key (keys %doc_files) {
  $src = "$SRC_PREFIX/$key";
  $dst = "$DST_PREFIX/$doc_files{$key}";

  # If $dst has a / in it, attempt to make the directory up to the last /
  $index = rindex($dst, '/');
  if ($index != -1) {
    $directory = substr($dst, 0, $index);
    system ("mkdir -p $directory");
  }
  
  system("cp -a $src $dst");
}

foreach $key (keys %extra_files) {
  $src = "$SRC_PREFIX/$key";
  $dst = "$DST_PREFIX/$extra_files{$key}";

  # If $dst has a / in it, attempt to make the directory up to the last /
  $index = rindex($dst, '/');
  if ($index != -1) {
    $directory = substr($dst, 0, $index);
    system ("mkdir -p $directory");
  }
  
  system("cp -a $src $dst");
}
