/*
 * pensuite.h - for the pensuite program by Kevin Sisson <kjsisson@bellsouth.net>
 *
 * Originally based on pencam 0.1 (C) Copyright 2001 by Bart Hartgers
 *
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define PENCAM_TIMEOUT 1000
#define MAX_CAMERAS 4

/* This is taken from the stv680 webcam driver, removing some items that 
   are not necessary or useful here */
typedef struct   
{
	int                   SupportedModes; 
	int                   CIF;           /* 352x288 (0) */
	int                   VGA;           /* 640x480 (1) */
	int                   QCIF;          /* 176x144 (2) */
	int                   QVGA;          /* 320x240 (3) */
	int                   origMode;      /* original camera mode */
	int                   currentMode;   
	int                   cwidth;	     /* camera width */
	int                   cheight;	     /* camera height */
	int                   maxwidth;      /* max video width */
	int                   maxheight;     /* max video height */
	int                   vwidth;        /* current width for video window */
	int                   vheight;       /* current height for video window */
	unsigned long int     rawbufsize;
	unsigned long int     maxframesize;  /* rawbufsize * 3 for RGB */
	int                   num_pics;
	int                   pic_no;        /* current picture number */
	int                   FineExp;
	int                   CoarseExp;
	int                   AvgPixVal;     /* average pixel value for image */
	int                   origGain;
	int                   CLKDIV;
	float                 FW;            /* Firmware revision */
	float                 ASICrev;       /* asic revision */
	int                   SensorID;
	int                   SensorIDrev;
	char                  bus_dirname[10];
	char                  dev_filename[10];

    /*  pencam variables  */	     	
	char                  pathname[100];
	char                  basename[50];
	int                   light_type;
	float                 brightness; 
	unsigned int          chgbright;
	int                   saturate_toggle;
	int                   saturation_data;
	int                   lightness_data;
	int                   hue_data;
	int                   sharp_toggle;  
	int                   sharpen_percent;
	double                unsharpen_radius;
	double                unsharpen_amount;
	int                   unsharpen_threshold;

    /*  pensnap variables  */
	int                   beep_yes;
	int                   time_delay;
	int                   overwrite;
	char                  pathname_ps[100];
	char                  basename_ps[50];
	int                   light_type_ps;
	float                 brightness_ps; 
	unsigned int          chgbright_ps;
	int                   saturate_toggle_ps;
	int                   saturation_data_ps;
	int                   lightness_data_ps;
	int                   hue_data_ps;
	int                   sharp_toggle_ps; 
	int                   sharpen_percent_ps;
	double                unsharpen_radius_ps;
	double                unsharpen_amount_ps;
	int                   unsharpen_threshold_ps;
	int                   annotate_ps;         /* annotate pensnap pics? */
	char                  picmsg_ps[50];
	int                   ssMode;         /* snapshot mode */
	int                   convert;        /* convert ppm to ..  */
	char                  convert_path[160];  /* command and path  */
} usb_stv;


usb_dev_handle *pencam_open(usb_stv *stv680);


typedef struct 
{
    char   bus_dirname[MAX_CAMERAS+1][10];
    char   dev_filename[MAX_CAMERAS+1][10];
    int    in_use[MAX_CAMERAS+1];
} camera_count;


/*  pencam2-misc  */
void    bad_value (void);
double  get_val   (float fmin, float fmax);
int     kbhit   (void);
int     readch  (void);
char    get_key (void);
void    clr_lines (int cnt);
char    common_menu (usb_dev_handle *pc, usb_stv *stv680, char *cam_snap);
int     pencam_read_config  (usb_dev_handle *pc, usb_stv *stv680);
int     pencam_write_config (usb_dev_handle *pc, usb_stv *stv680);
int     pencam_set_mode (usb_dev_handle *pc, usb_stv *stv680, int mode);
int     pencam_get_mode (usb_dev_handle *pc, usb_stv *stv680);
void    menu_header (usb_dev_handle *pc, usb_stv *stv680, int num_cams, 
		     camera_count *camera_addr);
int     pencam_get_num_pics (usb_dev_handle *pc, usb_stv *stv680);
int     common_get_picture  (usb_dev_handle *pc, int pic_no, const char *outpath, 
                             usb_stv *stv680, char *cam_snap);
int     common_image_process (usb_dev_handle *pc, usb_stv *stv680,  
			      unsigned char *raw, unsigned char *pic, 
                    	      char *cam_snap);
void    common_do_function (usb_dev_handle *pc, usb_stv *stv680, 
			    char *cam_snap, char choice);
int     common_save_image  (usb_stv *stv680, int pic_no, unsigned char *pic, 
			    char *cam_snap);

/*  pencam2  */
usb_dev_handle *pencam_open (usb_stv *stv680);
int   count_cameras(camera_count *camera_addr, int cnt);
usb_dev_handle *pencam_open_all (usb_stv *stv680, char *cam_bus_dirname, char *cam_dev_filename);
int   pencam_vendor (int set, usb_dev_handle *pc, int type, int size, int value, unsigned char *buffer);
int   pencam_configuration (usb_dev_handle *pc, int conf, int i, int a );
int   pencam_init (usb_dev_handle *pc, usb_stv *stv680);
int   clear_all_images (usb_dev_handle *pc, usb_stv *stv680);
void  pencam_do_function (usb_dev_handle *pc, usb_stv *stv680, char choice);
int   get_pictures (usb_dev_handle *pc, usb_stv *stv680, int first_pic, 
		    int last_pic);
int   pencam_get_picture (usb_dev_handle *pc, usb_stv *stv680, int pic_no);
int   execute_script (int argc, char *argv[], usb_dev_handle *pc, 
		      usb_stv *stv680);

/*  pensnap2  */
void  pensnap_do_function (usb_dev_handle *pc, usb_stv *stv680, char choice);
int   pensnap_get_picture (usb_dev_handle *pc, usb_stv *stv680, int pic_no);
int   get_snapshot (usb_dev_handle *pc, usb_stv *stv680);
void  add_text (unsigned char *image, int width, int height, char *msg);

/*  bayer  */
void  bayer_unshuffle (unsigned char *raw, unsigned char *output, usb_stv *stv680);
void  bayer_demosaic  (usb_stv *stv680, unsigned char *output);
void  light_enhance   (usb_stv *stv680, unsigned char *output, char *cam_snap);
void  light_enhance2  (usb_stv *stv680, unsigned char *output, char *cam_snap);

/*  sharpen & saturate  */
void  hue_saturation (unsigned char *input, unsigned char *output, usb_stv *stv680, char *cam_snap);
void  sharpen (unsigned char *src_region, unsigned char *dest_region, 
		usb_stv *stv680, char *cam_snap);


#include "demosaic_sharpen.h"

void  demosaic_sharpen (const int width, const int height,
 		        const unsigned char * const src_region, 
		        unsigned char * const dest_region, 
		        const int alpha, const BayerTile bt);

