/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : fildlg.c 
 * date    : 2000-08-20
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <gtk/gtk.h>

#include "../../share/xptype.h"
#include "../../share/ifdef.h"
#include "../libif/pentapi.h"
#include "../libapp/avifunc.h"



/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
GtkWidget *sip_entry;
GtkWidget *sip_listbox;
GtkWidget *g_sel_widget = NULL;
GtkWidget *apply_button;
extern str_pid_data g_pid_data;
extern str_ip_data g_sip_data;
extern str_ip_data g_dip_data;
extern char g_dev_name[100];

extern int g_if_count;
extern struct ifreq g_if_list[100];


  
/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/*
 * Func : fd_close_dialog
 * Context :
 */
void fd_close_dialog (GtkWidget *widget, gpointer data)
{
    	gtk_grab_remove (GTK_WIDGET (widget));    
}


/*
 * Func : lb_select_event
 * Context :
 */
void lb_select_event(GtkList *list, GtkWidget *widget, gpointer ud)
{
	g_sel_widget = widget;    
}


/*
 * Func : lb_unselect_event
 * Context :
 */
void lb_unselect_event(GtkList *list, GtkWidget *widget, gpointer ud)
{
	g_sel_widget = NULL;
}


/*
 * Func : fd_signal_apply
 * Context :
 */
void fd_signal_apply(GtkWidget *widget, gpointer data)
{
    	int i;
    	unsigned long laddr;
   	struct sockaddr_in *psock_in;

	sm_filter_ip_clear(g_dev_name);

	for(i = 0; i < g_if_count; i++){
    	    	psock_in = (struct sockaddr_in*) &g_if_list[i].ifr_addr;
		laddr = ntohl(psock_in->sin_addr.s_addr);
		sm_filter_ip_add(g_dev_name, laddr);
	}
	for(i = 0; i < g_sip_data.count; i++){
	    	laddr = g_sip_data.ip[i];
		sm_filter_ip_add(g_dev_name, laddr);
	}
	
	sm_filter_ip_active(g_dev_name);
	
	gtk_widget_set_sensitive(apply_button, FALSE);    
    
}


/*
 * Func : fd_signal_close
 * Context :
 */
void fd_signal_close(GtkWidget *widget, gpointer data)
{
    	gtk_widget_destroy (GTK_WIDGET (data));    
}


/*
 * Func : fd_add_pid_event
 * Context :
 */
void fd_add_pid_event( GtkWidget *widget, gpointer data)
{
	char *pstr;
	int i;
	GtkWidget *item;
	unsigned long sip;
	struct in_addr inaddr;
    
    	pstr = gtk_entry_get_text (GTK_ENTRY (sip_entry));
    	sip = inet_addr(pstr);
    
    	if(g_sip_data.count >= 100) return;
    	for(i = 0;  i < g_sip_data.count; i++){
		if(sip == g_sip_data.ip[i]) return;
    	}
   
   	inaddr.s_addr = sip; 
     	pstr = inet_ntoa(inaddr);
	
    	item = gtk_list_item_new_with_label (pstr);
    	gtk_container_add (GTK_CONTAINER (sip_listbox), item);
	gtk_widget_show (item);
	
	g_sip_data.ip[g_sip_data.count] = sip;
	g_sip_data.count++;

}


/*
 * Func : fd_delete_pid_event
 * Context :
 */
void fd_delete_pid_event( GtkWidget *widget, gpointer data)
{
	int i,j;
       
	if(g_sel_widget == NULL) return;
	
	i = gtk_list_child_position(GTK_LIST(sip_listbox),g_sel_widget);
    
    	gtk_list_clear_items (GTK_LIST(sip_listbox),i,i+1);
	
	g_sip_data.count--;
	for(j = i; j < g_sip_data.count;j++){
	    g_sip_data.ip[j] = g_sip_data.ip[j+1];
	    
	}
}


/*
 * Func : fd_delete_all_pid_event
 * Context :
 */
void fd_delete_all_pid_event( GtkWidget *widget, gpointer data)
{
    	gtk_list_clear_items (GTK_LIST(sip_listbox),0,-1);
	g_sip_data.count = 0;
	    
}


/*
 * Func : draw_fildialog
 * Context :
 */
void draw_fildialog( void )
{
	int i;
	char *pstr;
	GtkWidget *dialog_window;
	GtkWidget *button;
	GtkWidget *entry;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *scrolled_window;
	GtkWidget *listbox;
	GtkWidget *item;

	char sbuf[256];
	int xoptions, yoptions;
	struct in_addr inaddr;
	struct sockaddr_in *psock_in; 

	xoptions = GTK_FILL | GTK_EXPAND;
	yoptions = GTK_FILL | GTK_EXPAND;
    
	/* Create a new window */
	dialog_window = gtk_dialog_new ();

	gtk_signal_connect(GTK_OBJECT(dialog_window), "destroy", GTK_SIGNAL_FUNC(fd_close_dialog), &dialog_window);

	gtk_window_set_title(GTK_WINDOW(dialog_window), "Filter Information");

	gtk_container_border_width(GTK_CONTAINER(dialog_window),5);

	frame = gtk_frame_new (" Device list ");
	gtk_box_pack_start( GTK_BOX (GTK_DIALOG (dialog_window)->vbox), frame, TRUE, TRUE, 0);
	gtk_widget_show (frame);
 
   
	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add( GTK_CONTAINER( frame), scrolled_window);
	gtk_widget_show(scrolled_window);

	listbox = gtk_list_new();
	    
	for(i=0;i<g_if_count;i++){
		psock_in = (struct sockaddr_in*) &g_if_list[i].ifr_addr;
		pstr = inet_ntoa((struct in_addr)psock_in->sin_addr);	
		sprintf(sbuf,"%s -> %s",g_if_list[i].ifr_name,pstr);
		item = gtk_list_item_new_with_label(sbuf);
		gtk_container_add(GTK_CONTAINER(listbox), item);
		gtk_widget_show(item);
	}

	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window),listbox);
	gtk_widget_show(listbox);

	frame = gtk_frame_new (" Static IP ");
	gtk_box_pack_start( GTK_BOX (GTK_DIALOG (dialog_window)->vbox), frame, TRUE, TRUE, 0);
	gtk_widget_show (frame);

	table = gtk_table_new ( 4, 2, FALSE);
	gtk_container_set_border_width ( GTK_CONTAINER(table), 10);
	gtk_container_add( GTK_CONTAINER( frame), table);
	gtk_widget_show(table);

   
    
	xoptions = GTK_FILL | GTK_EXPAND;
	yoptions = GTK_FILL | GTK_EXPAND; 

	entry = gtk_entry_new_with_max_length (15);
	gtk_entry_set_text (GTK_ENTRY (entry),"0.0.0.0");
	gtk_table_attach_defaults (GTK_TABLE (table), entry, 0, 1, 0, 1); 
	gtk_widget_show(entry);
	sip_entry = entry;

	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_table_attach_defaults (GTK_TABLE (table), scrolled_window, 0, 1, 1, 5); 
	gtk_widget_show(scrolled_window);

	listbox = gtk_list_new();
	gtk_list_set_selection_mode(GTK_LIST(listbox),GTK_SELECTION_SINGLE);
	   
    
	for(i = 0; i < g_sip_data.count;i++){
		inaddr.s_addr = g_sip_data.ip[i];
		pstr = inet_ntoa(inaddr);	
		item = gtk_list_item_new_with_label(pstr);
		gtk_container_add(GTK_CONTAINER(listbox), item);
		gtk_widget_show(item);
	}
    
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window),listbox);
	gtk_signal_connect(GTK_OBJECT (listbox),"select-child", GTK_SIGNAL_FUNC (lb_select_event), (gpointer)"select");

	gtk_signal_connect(GTK_OBJECT (listbox),"unselect-child", GTK_SIGNAL_FUNC (lb_unselect_event), (gpointer)"unselect");

	gtk_widget_show(listbox);
	sip_listbox = listbox;
    
    
	button = gtk_button_new_with_label ("Add");
	gtk_signal_connect(GTK_OBJECT (button),"clicked", GTK_SIGNAL_FUNC (fd_add_pid_event), (gpointer)"add");
	gtk_table_attach (GTK_TABLE (table), button, 1, 2, 0, 1, xoptions,yoptions,6,6); 
	gtk_widget_set_usize( button, 60, 20);
	gtk_widget_show (button);

	button = gtk_button_new_with_label ("Delete");
	gtk_signal_connect(GTK_OBJECT (button),"clicked", GTK_SIGNAL_FUNC (fd_delete_pid_event), (gpointer)"delete");
	gtk_table_attach (GTK_TABLE (table), button, 1, 2, 1, 2, xoptions,yoptions,6,6); 
	gtk_widget_set_usize( button, 60, 20);
	gtk_widget_show (button);

	button = gtk_button_new_with_label ("Delete all");
	gtk_signal_connect(GTK_OBJECT (button),"clicked", GTK_SIGNAL_FUNC (fd_delete_all_pid_event), (gpointer)"delete all");
	gtk_table_attach (GTK_TABLE (table), button, 1, 2, 2, 3, xoptions,yoptions,6,6); 
	gtk_widget_set_usize( button, 60, 20);
	gtk_widget_show (button);


	button = gtk_button_new_with_label("Apply");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(fd_signal_apply), dialog_window);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog_window)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_show (button);
	apply_button = button;

	button = gtk_button_new_with_label ("Close");
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (fd_signal_close), dialog_window);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_grab_default (button);
	gtk_widget_show (button);

	gtk_widget_show (dialog_window);

	gtk_grab_add (dialog_window);
}


/*
 * Func : filter_dialog
 * Context :
 */
void filter_dialog( void )
{
    	g_if_count = 0;
        get_if_list();
 	draw_fildialog();   
}
